Program HerdingIPX;
{Elephant Herding IPX
Herd Elephants into the cage. Two player game over IPX-network

Programmed by Sebastiaan Jansen using TP7
http://thandor.net}
Uses crt, dos, ipx;

Const
 Gametime = 0.80;

Type {IPX}
 Packet = record
 ecb  : ECBType;
 IPX  : IPXheader;
 data : string;
 end;

Type
 PlayerType = Record
 x, y : ShortInt;
 end;

 ElephantType = Record
 x, y : ShortInt;
 InCage : Boolean;
 end;

var
 Quit, Server, Debug : Boolean;
 Player : Array [0..1] of PlayerType;
 Elephant : Array [0..10] of ElephantType;
 Start, Endtime : real;
 i : integer;
 MaxElephants, ElephantX, ElephantY, Number : ShortInt;
 send,receive : Packet; {IPX}
 ElephantIPX, line : string;
 Tics : integer;

 {Timer for the game tics}
Function timer:real;
var
 Hour, Minute, Second, Sec100 : word;
begin
 gettime(hour,minute,second,sec100);
 timer:=(hour*3600.0+minute*60.0+second+sec100/100);
end;

Procedure HideCursor; Assembler;
 Asm
  mov   ax, 0100h
  mov   cx, 2607h
  int   10h
 end;  {HideCursor}

Procedure ShowCursor; Assembler;
 Asm
  mov   ax, 0100h
  mov   cx, 0506h
  int   10h
 end;  {ShowCursor}

Function Str2Int(s:string):word;
var
 i, code : word;
begin
 val (s, i, code);
 if code <> 0 then Str2Int:=0 else Str2Int:=i;
end;

Function Int2Str(L : LongInt) : string;
var
 s : string;
begin
 Str(L, S);
 Int2Str:=s;
end;

{Timo Salmi FAQ}
function ReadASCII (column, row : byte) : char;
 var regs : registers;
  videocolumns : byte;
  videobase : word;
  offset : word;
 begin
  { Get the video base address }
  FillChar (regs, SizeOf(regs), 0);
  regs.ah := $0F;  Intr ($10, regs);
  if regs.al = 7 then videobase := $B000 else videobase := $B800;
  { Get the screen width }
  FillChar (regs, SizeOf(regs), 0);
  regs.ah := $0F;
  Intr ($10, regs);
  videocolumns := regs.ah;
  { Get the character }
  offset := (((row-1)*videocolumns)+(column-1))*2;
  ReadASCII := chr(mem[videobase:offset]);
 end;

Procedure SendData(Data : string); {Send network data}
begin
 send.data:=Data;
 with send.ecb do
  for i:=1 to 6 do
   ImmedAddr[i]:=$ff;
 repeat
 until send.ecb.inuse=0;
 IPXsendPacket(send.ecb);
end;
 
Function CheckMovement(x,y : ShortInt) : Boolean; {if player/elephant bumps into a certain character it should be blocked}
begin
 CheckMovement:=TRUE;
 if (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') then CheckMovement:=FALSE;
end;

Function ElephantLeft(Number : ShortInt) : Boolean; {Move elephant to the left}
begin
 ElephantLeft:=FALSE;
 if (CheckMovement(Elephant[Number].x-1, Elephant[Number].y) = TRUE) and (Elephant[Number].x > 12) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].x:=Elephant[Number].x-1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantLeft:=TRUE;
   {Send Elephant data over IPX}
   if Server=TRUE then SendData('El/'+Int2Str(Elephant[Number].x)+'/'+Int2Str(Elephant[Number].y)+'/'+Int2Str(Number));
  end;
end;

Function ElephantRight(Number : ShortInt) : Boolean;
begin
 ElephantRight:=FALSE;
 if (CheckMovement(Elephant[Number].x+1, Elephant[Number].y) = TRUE) and (Elephant[Number].x < 68) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].x:=Elephant[Number].x+1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantRight:=TRUE;
   if Server=TRUE then SendData('El/'+Int2Str(Elephant[Number].x)+'/'+Int2Str(Elephant[Number].y)+'/'+Int2Str(Number));
  end;
end;

Function ElephantUp(Number : ShortInt) : Boolean;
begin
 ElephantUp:=FALSE;
 if (CheckMovement(Elephant[Number].x, Elephant[Number].y-1) = TRUE) and (Elephant[Number].y > 4) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].y:=Elephant[Number].y-1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantUp:=TRUE;
   if Server=TRUE then SendData('El/'+Int2Str(Elephant[Number].x)+'/'+Int2Str(Elephant[Number].y)+'/'+Int2Str(Number));
  end;
end;

Function ElephantDown(Number : ShortInt) : Boolean;
begin
 ElephantDown:=FALSE;
 if (CheckMovement(Elephant[Number].x, Elephant[Number].y+1) = TRUE) and (Elephant[Number].y < 18) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].y:=Elephant[Number].y+1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantDown:=TRUE;
   if Server=TRUE then SendData('El/'+Int2Str(Elephant[Number].x)+'/'+Int2Str(Elephant[Number].y)+'/'+Int2Str(Number));
  end;
end;

Procedure ElephantMovement; {Calculates Elephant movement}
var
 i : ShortInt;
 Distance0, Distance1, ClosestPlayer : ShortInt;
 ElephantMoved : Boolean;
begin
 TextColor(7);
 for i:=0 to MaxElephants do
  begin
  ElephantMoved:=FALSE; {Keep track wether Elephant moved or not}
   {Determine which player is closest to Elephant}
   if (Player[0].x > Elephant[i].x) then
      Distance0:=Player[0].x - Elephant[i].x else
      Distance0:=Elephant[i].x - Player[0].x;
  if (Player[1].x > Elephant[i].x) then
      Distance1:=Player[1].x - Elephant[i].x else
      Distance1:=Elephant[i].x - Player[1].x;
  if Distance1 > Distance0 then ClosestPlayer:=0 else ClosestPlayer:=1;

   if (Elephant[i].x < Player[ClosestPlayer].x) then
    begin
     if (ElephantLeft(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if (Elephant[i].x > Player[ClosestPlayer].x) then
    begin
     if (ElephantRight(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   {Determine which player is closest to Elephant}
   if (Player[0].y > Elephant[i].y) then
      Distance0:=Player[0].y - Elephant[i].y else
      Distance0:=Elephant[i].y - Player[0].y;
   if (Player[1].y > Elephant[i].y) then
      Distance1:=Player[1].y - Elephant[i].y else
      Distance1:=Elephant[i].y - Player[1].y;
   if Distance1 > Distance0 then ClosestPlayer:=0 else ClosestPlayer:=1;

   if (Elephant[i].y < Player[ClosestPlayer].y) then
    begin
     if (ElephantUp(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if (Elephant[i].y > Player[ClosestPlayer].y) then
    begin
     if (ElephantDown(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if ((ElephantMoved=FALSE) and (Server=TRUE)) then {Elephant didn't move; try random panic move to get un-stuck}
    begin                                            {Only for server; client never moves Elephants}
     Distance0:=Random(4);
     Case Distance0 of
      0: ElephantLeft(i);
      1: ElephantRight(i);
      2: ElephantUp(i);
      3: ElephantDown(i);
     end;
    end;

  end;
end;

Procedure MoveUp(Number : ShortInt); {Move player up}
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x, Player[Number].y-1) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].y:=Player[Number].y-1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
   if Server=TRUE then SendData('Pl/'+Int2Str(Player[Number].x)+'/'+Int2Str(Player[Number].y)+'/'+Int2Str(Number));
  end;
end;

Procedure MoveLeft(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x-1, Player[Number].y) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].x:=Player[Number].x-1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
   if Server=TRUE then SendData('Pl/'+Int2Str(Player[Number].x)+'/'+Int2Str(Player[Number].y)+'/'+Int2Str(Number));
  end;
end;

Procedure MoveRight(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x+1, Player[Number].y) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].x:=Player[Number].x+1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
   if Server=TRUE then SendData('Pl/'+Int2Str(Player[Number].x)+'/'+Int2Str(Player[Number].y)+'/'+Int2Str(Number));
  end;
end;

Procedure MoveDown(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x, Player[Number].y+1) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].y:=Player[Number].y+1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
   if Server=TRUE then SendData('Pl/'+Int2Str(Player[Number].x)+'/'+Int2Str(Player[Number].y)+'/'+Int2Str(Number));
  end;
end;

Procedure ProcessKeys(Key : char); {Read the keys and send the appropriate data}
begin
 if Server=TRUE then
  begin
   case Key of
    'H': SendData('H'); {Normal version would have MoveUp(0) here but now we send the up-character over network}
    'K': SendData('K');
    'M': SendData('M');
    'P': SendData('P');
    'Q': Quit:=TRUE;
    'q': Quit:=TRUE;
    #27: Quit:=TRUE;
	#59: Debug:=TRUE;
   end;
  end;

 if Server=FALSE then
  begin
   case Key of
    'H': SendData('W');
    'K': SendData('A');
    'M': SendData('D');
    'P': SendData('S');
    'Q': Quit:=TRUE;
    'q': Quit:=TRUE;
    #27: Quit:=TRUE;
	#59: Debug:=TRUE;
   end;
  end;
end;

Procedure GenerateElephants; {Generate the Elephants without random}
var
 Number : ShortInt;
begin
 {Define Elephants}
 for i:=0 to MaxElephants do
 begin
{  Number:=Random(3);} {No random because random can be different on server or client}
  Elephant[i].x:=i+36{+Number};
  Elephant[i].y:=13{+Number};
  Elephant[i].InCage:=FALSE;
  TextColor(7);
  GotoXY(Elephant[i].x, Elephant[i].y);
  Write('');
 end;
end;

Procedure DefinePlayers; {Place the players onto the screen}
begin
 {Clear players}
 GotoXY(Player[0].x, Player[0].y);
 Write(' ');
 GotoXY(Player[1].x, Player[1].y);
 Write(' ');

 {Define Players}
 Player[0].x:=13;
 Player[0].y:=4;
 Player[1].x:=67;
 Player[1].y:=18;
 TextColor(14);
 GotoXY(Player[0].x, Player[0].y);
 Write('');
 TextColor(15);
 GotoXY(Player[1].x, Player[1].y);
 Write('');
end;

Procedure NextLevel; {Play a sound, empty the cage and go to the next level}
begin
 {Play a sound!}
 Sound(500);
 Delay(100);
 Sound(700);
 Delay(150);
 Sound(600);
 Delay(200);
 NoSound;
 {Clear the cage}
 GotoXY(38,9);
 Write('     ');
 GotoXY(38,10);
 Write('     ');
 GotoXY(38,11);
 Write('     ');
 MaxElephants:=MaxElephants+1;
 GenerateElephants;
 DefinePlayers;
 if (Server=TRUE) then SendData('NextLevel');
end;

Procedure CheckCage; {Check if the elephants are within the cage and move on to next level if they are}
var
 i : ShortInt;
 AllInCage : Boolean;
begin
 AllInCage:=TRUE;
 for i:=0 to MaxElephants do
  begin
   Elephant[i].InCage:=FALSE;
   if ((Elephant[i].x > 37) and (Elephant[i].x < 43)) and ((Elephant[i].y > 9) and (Elephant[i].y < 12)) then
    begin
     Elephant[i].InCage:=TRUE;
    end else AllInCage:=FALSE;
  end;

 if AllInCage=TRUE then NextLevel;
end;

begin
{Init}
TextColor(7);
Writeln('Make sure you have IPX functionality.');
Writeln('Elephant Herding Network Version will not work if you do not have IPX.');

if IPXopenSocket(0,MYSOCKET)=0 then {IPX}
 begin
  InitIPX;
  with send do
   InitSendPacket(ecb,ipx,sizeof(String),MYSOCKET);
  with receive do
   InitReceivePacket(ecb,ipx,sizeof(String),MYSOCKET);
 end;
Writeln('IPX successfully loaded.');
ClrScr;
{Show menu to choose the server/client-role}
Server:=FALSE; 

{Draw menu border}
TextColor(8);
for i:=10 to 70 do
 begin
  GotoXY(i,2);
  Write('');
  GotoXY(i,20);
  Write('');
 end;

for i:=3 to 19 do
 begin
  GotoXY(10,i);
  Write('');
  GotoXY(70,i);
  Write('');
 end;

TextColor(14);
GotoXY(23,4);
writeln(' Elephant Herding Network Version ');
TextColor(15);
GotoXY(24,4);
writeln(' Elephant Herding Network Version ');
GotoXY(13,6);
Writeln('Instructions:');
GotoXY(13,7);
Writeln('Use the arrow keys to move your player. Try to push the');
GotoXY(13,8);
Writeln('elephants into the cage in the center of the map.');
GotoXY(13,10);
writeln('Press 1 to act as server');
GotoXY(13,11);
writeln('Press any other key to act as client');
GotoXY(13,17);
Writeln('Written by Sebastiaan Jansen, 2015');
GotoXY(13,18);
Writeln('http://thandor.net');
{GotoXY(13,10);
writeln('Acting as server will calculate the Elephant movement');
GotoXy(13,11);
writeln('and send all the changes to the client.');}
if Readkey = '1' then Server:=TRUE;

{Game-code}
Debug:=FALSE;
Randomize;
HideCursor;
Quit:=FALSE;
ClrScr;
DefinePlayers;
MaxElephants:=0;
if Server=TRUE then GenerateElephants; {Only Generate elephants when server is true}
{Draw map border}
TextColor(8);
for i:=10 to 70 do
 begin
  GotoXY(i,2);
  Write('');
  GotoXY(i,20);
  Write('');
 end;

for i:=3 to 19 do
 begin
  GotoXY(10,i);
  Write('');
  GotoXY(70,i);
  Write('');
 end;
{Draw Cage}
TextColor(6);
GotoXY(37,9);
Write('');
GotoXY(37,10);
Write('');
GotoXY(37,11);
Write('');
GotoXY(37,12);
Write('');
GotoXY(38,12);
Write('');
GotoXY(39,12);
Write('');
GotoXY(40,12);
Write('');
GotoXY(41,12);
Write('');
GotoXY(42,12);
Write('');
GotoXY(43,12);
Write('');
GotoXY(43,10);
Write('');
GotoXY(43,11);
Write('');
GotoXY(43,9);
Write('');

repeat
 if KeyPressed then ProcessKeys(Readkey);
 Tics:=Tics+1;
 if (timer >= endtime) and (Server=TRUE) then
  begin
  if (DEBUG = TRUE) then
    begin
     TextColor(15);
     gotoxy(1,25);
     write('Server Gametics: ',tics,' ');
    end;
   start:=timer;
   endtime:=start+gametime;
   ElephantMovement;
   CheckCage;
   if MaxElephants=10 then Quit:=TRUE; {Exit}
   tics:=0;
  end;
  
 
  
  {IPX}
 if receive.ecb.inuse=0 then	{Data is being received}
  begin
   line:=receive.data;
   ElephantIPX:=Copy(line,0,2);
   
   if (DEBUG = TRUE) then
    begin
     TextColor(15);
     gotoxy(1,23);
     write(ElephantIPX);
    end;
  
   if line = 'H' then MoveUp(0); {The normal version would do MoveUp(0) when 'H' (up-arrow key) is pressed}
   if line = 'K' then MoveLeft(0); {The network version will move players around on received commands}
   if line = 'M' then MoveRight(0);
   if line = 'P' then MoveDown(0);
   if line = 'W' then MoveUp(1);
   if line = 'A' then MoveLeft(1);
   if line = 'D' then MoveRight(1);
   if line = 'S' then MoveDown(1);
   if line = 'NextLevel' then NextLevel;

 	if (ElephantIPX = 'Pl') then {We are dealing with player code}
    begin
	
	if (DEBUG = TRUE) then
    begin
     TextColor(15);
     gotoxy(1,24);
     write(ElephantIPX);
    end;
	
     {Break down the received string}
     ElephantIPX:=Int2Str(Pos('/',Line));
     Delete(Line, 1, Pos('/',Line)); {Cut off 'El'}
     ElephantIPX:=Copy(Line, 0, Pos('/',Line)-1);
     ElephantX:=Str2Int(ElephantIPX); {X-axis}
   
     Delete(Line, 1, Pos('/',Line)); {Cut off 'X-axis'}
     ElephantIPX:=Copy(Line, 0, Pos('/',Line)-1);
     ElephantY:=Str2Int(ElephantIPX); {Y-axis'}
   
     Delete(Line, 1, Pos('/',Line)); {Cut off 'Y-axis'}
     Number:=Str2Int(Line); {Player number}
  
     if Number=0 then TextColor(14) else TextColor(15);
     GotoXY(Player[Number].x, Player[Number].y);
     write(' '); {Remove old elephant}
     GotoXY(ElephantX, ElephantY);
	 if Number=0 then write('') else Write('');
     
     Player[Number].x:=ElephantX; {Update clients' player information}
     Player[Number].y:=ElephantY;
    end;
	
   if (Server=FALSE) then {Only client should keep up with drawing Elephants}
    begin
  {   line:=receive.data;
     ElephantIPX:=Copy(line,0,2);} {Copy the received data into a variable for manipulation. I.e. El16390 which means}
                              {El = Elephant data, 16 and 39 are new coordinates and 0 is the elephant ID for the array}


    if (ElephantIPX = 'El') then {We are dealing with elephant code; the first two characters are 'El'}
    begin
		if (DEBUG = TRUE) then
      begin
       TextColor(15);
       gotoxy(1,23);
       write('Client El data received:', line);
      end;
	  
     {Break down the received string}
     ElephantIPX:=Int2Str(Pos('/',Line));
     Delete(Line, 1, Pos('/',Line)); {Cut off 'El'}
	 
     ElephantIPX:=Copy(Line, 0, Pos('/',Line)-1);
     ElephantX:=Str2Int(ElephantIPX); {X-axis}
 
     Delete(Line, 1, Pos('/',Line)); {Cut off 'X-axis'}
     ElephantIPX:=Copy(Line, 0, Pos('/',Line)-1);
     ElephantY:=Str2Int(ElephantIPX); {Y-axis}
 
     Delete(Line, 1, Pos('/',Line)); {Cut off 'Y-axis'}
    
     Number:=Str2Int(Line); {Elephant number}
 
	 { Alternative code to above but doesn't seem to be faster and needs specific 
	 optimizing in the 'line' that will be send over the network
	 ElephantX:=Str2Int(Copy(Line, 4, 2));
	 ElephantY:=Str2Int(Copy(Line, 7, 2));
	 Number:=Str2Int(Copy(Line, 10, 1));
	 }
 
     TextColor(7);
     GotoXY(Elephant[Number].x, Elephant[Number].y);
     write(' '); {Remove old elephant}
     GotoXY(ElephantX, ElephantY);
     write(''); {Draw new elephant}
     Elephant[Number].x:=ElephantX; {Update clients' elephant information}
     Elephant[Number].y:=ElephantY;
    end;
   end;

  if IPXlistenForPacket(receive.ecb)<>0 then
   begin
    writeln(#7,'ERROR TRYING TO receive A PACKET!');
    halt(2);
   end;
 end;

until Quit=TRUE;
IPXcloseSocket(MYSOCKET); {IPX}
TextColor(7);
ClrScr;
WriteLn('Thanks for playing Elephant Herding Network Version!');
ShowCursor;
end.