DECLARE SUB resetRoomData (row%, column%)
DECLARE SUB showItemInfo (itemNum%)
DECLARE SUB showMap ()
DECLARE SUB loadMap ()
DECLARE SUB drawWallSpots (wallSpotNum%)
DECLARE SUB checkCollisionWithWallSpots (i%)
DECLARE SUB roomExit (direction%)
DECLARE SUB checkCollisionWithWall ()
DECLARE SUB clearKBbuffer ()
DECLARE FUNCTION checkCollision% (badGuyNum%)
DECLARE SUB setRoomData (row%, column%)
DECLARE FUNCTION getItem% (badNumber%, set%)
DECLARE SUB drawCrate (crateNum%)
DECLARE SUB calculateStats ()
DECLARE SUB LevelPlayer ()
DECLARE SUB display ()
DECLARE SUB saveAndChain ()
DECLARE SUB drawReturnSpell ()
DECLARE SUB drawHealSpell ()
DECLARE SUB drawDarkSpell (direction%)
DECLARE SUB drawIceSpell (direction%)
DECLARE SUB castSpell (spellType$)
DECLARE SUB usePotion (potionType$)
DECLARE SUB showDetailedInventory ()
DECLARE SUB showSpell (spellName$)
DECLARE SUB showFireSpell ()
DECLARE SUB untargetBadGuy (badGuyNum%)
DECLARE FUNCTION targetBadGuy% (i%, type$)
DECLARE SUB showStats ()
DECLARE SUB loadPlayerData ()
DECLARE SUB movePlayer (direction%)
DECLARE SUB maskBadGuy (badGuyNumber%, maskBg%, maskMarker%)
DECLARE SUB timingControl (speed%)
DECLARE SUB moveBadGuy (badGuyNumber%)
DECLARE SUB drawBadGuy (badNumber%)
DECLARE SUB debugInfo ()
DECLARE FUNCTION checkEvents% (targetReq%, attackReq%, strongAttackReq%, frme%)
DECLARE FUNCTION setData% ()
DECLARE SUB init ()
DECLARE FUNCTION drawArea% (row%, column%)

'Hellbent version 1.2 (again from scratch!)
'started 6/30/06

'basic fighting system and such.

'bad guy struct
TYPE ENEMY
  x AS INTEGER
  y AS INTEGER
  hp AS INTEGER
  atp AS INTEGER
  dfp AS INTEGER
  range AS INTEGER
  inRange AS INTEGER
  badType AS INTEGER
  move AS INTEGER
  currentMove AS INTEGER
  gfxImg AS STRING * 1
  gfxColor AS INTEGER
  alive AS INTEGER
  expToGive AS INTEGER
  opened AS INTEGER
  talkText AS STRING * 40
  chanceTime AS INTEGER
END TYPE

TYPE WALL
  x AS INTEGER
  y AS INTEGER
  range AS INTEGER
  gfxImg AS STRING * 1
  gfxColor AS INTEGER
  wallType AS INTEGER
END TYPE

'player's inventory.
TYPE STORAGE
  occupied AS INTEGER
  handle AS STRING * 30
  atp AS INTEGER
  dfp AS INTEGER
  mst AS INTEGER
  range AS INTEGER
  speed AS INTEGER
  hp AS INTEGER
  mp AS INTEGER
  stars AS INTEGER 'for rarity
  sellPrice AS INTEGER
  classID AS INTEGER 'what class can equip.
  typeID AS INTEGER
  atpReq AS INTEGER
  mstReq AS INTEGER
  lvlReq AS INTEGER
  description AS STRING * 200
  equiped AS INTEGER
END TYPE

TYPE PLAYER    'yeah the player has a lot of stats. :P
  handle AS STRING * 12
  x AS INTEGER
  y AS INTEGER
  gfx AS STRING * 1
  badGuyTargeted AS INTEGER
  range AS INTEGER
  rangeBase AS INTEGER
  hp AS INTEGER
  maxHP AS INTEGER
  mp AS INTEGER
  maxMP AS INTEGER
  atp AS INTEGER
  atpBase AS INTEGER
  dfp AS INTEGER
  dfpBase AS INTEGER
  mst AS INTEGER
  mstBase AS INTEGER
  speed AS INTEGER
  speedBase AS INTEGER
  coin AS INTEGER
  hasReturn AS INTEGER
  fire AS INTEGER
  ice AS INTEGER
  dark AS INTEGER
  heal AS INTEGER
  alive AS INTEGER
  lvl AS INTEGER
  weaponName AS STRING * 25
  weaponRare AS INTEGER
  armorName AS STRING * 25
  armorRare AS INTEGER
  weaponHPBonus AS INTEGER
  weaponMPBonus AS INTEGER
  weaponATPBonus AS INTEGER
  armorHPBonus AS INTEGER
  armorMPBonus AS INTEGER
  armorDFPBonus AS INTEGER
  weaponMSTBonus AS INTEGER
  weaponRNGBonus AS INTEGER
  armorMSTBonus AS INTEGER
  armorSPDBonus AS INTEGER
  class AS STRING * 8
  classID AS INTEGER
  hpPotions AS INTEGER
  mpPotions AS INTEGER
  expToLevel AS INTEGER
  expCurrent AS INTEGER
  speedAugmentation AS INTEGER
  exitedRoomDirection AS INTEGER
  status AS INTEGER

  'for location in grand scheme of things.
  mapX AS INTEGER
  mapY AS INTEGER
END TYPE

TYPE AREA
  bgColor AS INTEGER
  numBadGuys AS INTEGER
  numWallSpots AS INTEGER
  x AS INTEGER      'location in level grid
  y AS INTEGER
  drawn AS INTEGER
  set AS INTEGER
  inArea AS INTEGER
  hasExitTop AS INTEGER
  hasExitBottom AS INTEGER
  hasExitLeft AS INTEGER
  hasExitRight AS INTEGER
  borderTop AS INTEGER
  borderBottom AS INTEGER
  borderLeft AS INTEGER
  borderRight AS INTEGER
  roomType AS INTEGER
  explored AS INTEGER
END TYPE

'request type for movement & collision detection.
TYPE REQUEST
  flagged AS INTEGER
  direction AS INTEGER
END TYPE

DEFINT A-Z
RANDOMIZE TIMER

CLS
SCREEN 9

CONST TRUE = 1
CONST FALSE = 0
CONST NONE = -1
CONST MAXBADGUYS = 25
CONST MAXWALLSPOTS = 25
CONST MAXITEMS = 19
CONST CRATE = 99
CONST NPC = 100
CONST WALL1 = 101
CONST WALL2 = 102
CONST WEAPON = 1
CONST ARMOR = 2
CONST ANTIDOTEPOTION = 3
CONST RETURNPOTION = 4

CONST FIGHTER = 1
CONST ARCHER = 2
CONST MAGE = 3
CONST ALL = 4

CONST FINE = 0
CONST POISONED = 1

CONST LEFT = 0
CONST RIGHT = 1
CONST UP = 2
CONST DOWN = 3

DIM SHARED badGuy(0 TO MAXBADGUYS) AS ENEMY
DIM SHARED wallSpot(0 TO MAXWALLSPOTS) AS WALL
DIM SHARED p AS PLAYER
DIM SHARED inventory(0 TO MAXITEMS) AS STORAGE
DIM SHARED room(0 TO 8, 0 TO 8)  AS AREA
DIM SHARED moveRequest AS REQUEST
DIM SHARED difficulty AS INTEGER
DIM SHARED speed AS INTEGER

DIM game AS INTEGER
DIM eventsChecked AS INTEGER
DIM targetRequest AS INTEGER 'requests game to target an enemy
DIM attackRequest AS INTEGER 'requests game to attack an enemy
DIM strongAttackRequest AS INTEGER
DIM keyIn AS INTEGER 'keyboard input.

CALL init           'set up global variables

'set up local variables
game = TRUE
eventsChecked = FALSE
speed = 1
targetRequest = FALSE
attackRequest = FALSE
strongAttackRequest = FALSE
frame = 0

CALL loadPlayerData
CALL calculateStats
CALL loadMap        'needed or setData will fail!

WHILE game = TRUE

  'if the area data isn't set, set it and flag to true
  IF room(p.mapY, p.mapX).set = FALSE THEN
    room(p.mapY, p.mapX).set = setData%
  END IF
  
  'changing areas, .: not drawn yet.
  room(p.mapY, p.mapX).drawn = FALSE
  room(p.mapY, p.mapX).inArea = TRUE

  WHILE room(p.mapY, p.mapX).inArea = TRUE

    'if the area isn't drawn, draw it and set the flag to true
    IF room(p.mapY, p.mapX).drawn = FALSE THEN
      room(p.mapY, p.mapX).drawn = drawArea%(p.mapY, p.mapX)
    END IF

    eventsChecked = FALSE   'check events every loop

    CALL debugInfo
    CALL display 'draws everything necessary

                'player input area
    '<----------------------------------------------->
    keyIn = INP(&H60)    'read current keystate from kb i/o port
    CALL clearKBbuffer   'clear the kb buffer

    SELECT CASE keyIn
   
      'quit either q or esc key
      CASE 16
      CASE 1
        game = FALSE
        room(p.mapY, p.mapX).inArea = FALSE
   
      'cast return spell ("r" key)
      CASE 19
        IF p.hasReturn = TRUE THEN
          CALL castSpell("return")
        END IF

      'target enemy ("t" key)
      CASE 20
        targetRequest = TRUE
  
      'cast ice spell ("i" key)
      CASE 23
        IF p.ice > 0 THEN
          CALL castSpell("ice")
        END IF

      'use health potion ("p" key)
      CASE 25
        IF p.hpPotions > 0 THEN
          CALL usePotion("health")
        END IF

      'enter hit (for stats)
      CASE 28
        CALL showStats
        room(p.mapY, p.mapX).drawn = FALSE 'needs a redraw after that full page blowout!

      'strong attack requested (CTRL key)
      CASE 29
        strongAttackRequest = TRUE

      'cast dark spell ("d" key)
      CASE 32
        IF p.dark > 0 THEN
          CALL castSpell("dark")
        END IF

      'cast fire spell ("f" key)
      CASE 33
        IF p.fire > 0 THEN
          CALL castSpell("fire")
       END IF
     
      'cast heal spell ("h" key)
      CASE 35
        IF p.heal > 0 THEN
          CALL castSpell("heal")
        END IF

      'use magic potion ("m" key)
      CASE 50
        IF p.mpPotions > 0 THEN
          CALL usePotion("magic")
        END IF

      'space bar hit for attack
      CASE 57
        attackRequest = TRUE
   
      'up movement
      CASE 72
        moveRequest.flagged = TRUE
        moveRequest.direction = UP

      'left movement
      CASE 75
        moveRequest.flagged = TRUE
        moveRequest.direction = LEFT
   
      'right movement
      CASE 77
        moveRequest.flagged = TRUE
        moveRequest.direction = RIGHT

      'down movement
      CASE 80
        moveRequest.flagged = TRUE
        moveRequest.direction = DOWN

    END SELECT

    'control the speed of the game so it's playable.
    'CALL timingControl(speed)
   
    
    'check for any type of game event
    IF eventsChecked = FALSE THEN
      eventsChecked = checkEvents%(targetRequest, attackRequest, strongAttackRequest, frame)
      targetRequest = FALSE
      attackRequest = FALSE
      strongAttackRequest = FALSE
    END IF


  WEND 'current area loop
WEND  'game loop
                                  
'if editing, will return to IDE, if uses batch file, will exit to OS.
SYSTEM

SUB calculateStats

'this sub is called when weapons or armor are changed and the players
'stats need to be changed. (not base, but bonuses on top of base)

'will calculate to same stats if called when not needed.

p.atp = p.atpBase + p.weaponATPBonus
p.mst = p.mstBase + p.weaponMSTBonus + p.armorMSTBonus
p.dfp = p.dfpBase + p.armorDFPBonus
p.range = p.rangeBase + p.weaponRNGBonus
p.speed = p.speedBase + p.armorSPDBonus
p.maxHP = p.maxHP + p.weaponHPBonus + p.armorHPBonus
p.maxMP = p.maxMP + p.weaponMPBonus + p.armorMPBonus

END SUB

SUB castSpell (spellType$)

'this casts a spell based on what spell type is passed in via param.

DIM spellDamage AS INTEGER
DIM spellCost AS INTEGER

  '<-----------FIRE SPELL----------------->
  IF spellType$ = "fire" THEN
    spellCost = (p.fire + 2)

    'make sure they have MP to be casting with!
    IF p.mp >= spellCost THEN
     
      IF p.fire < 7 THEN
        spellDamage = (p.mst + p.fire) \ 2
      ELSEIF p.fire >= 7 AND p.fire < 10 THEN
        spellDamage = (p.mst + p.fire)
      ELSEIF p.fire >= 10 THEN
        spellDamage = (p.mst + p.fire) * 2
      END IF
   
      'make sure they've targeted someone!
      IF p.badGuyTargeted > NONE THEN
        IF badGuy(p.badGuyTargeted).badType <= CRATE THEN
          IF p.fire < 7 THEN
            badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - spellDamage
            dmgToBadGuy% = spellDamage
            spellColor = 4
            spellGfx$ = "_"

          ELSEIF p.fire >= 7 AND p.fire < 10 THEN
            badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - (spellDamage * 2)
            dmgToBadGuy% = spellDamage * 2
            spellColor = 6
            spellGfx$ = ""
     
          ELSEIF p.fire >= 10 THEN
            badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - (spellDamage * 3)
            dmgToBadGuy% = spellDamage * 3
            spellColor = 4
            spellGfx$ = ""
     
          END IF
     
          LOCATE 1, 50
          COLOR 15, room(p.mapY, p.mapX).bgColor
          PRINT "You cast for "; dmgToBadGuy%; " damage!   "

          LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$

        END IF
      END IF

      p.mp = p.mp - spellCost 'in anycase you're losing MP.

    END IF
 
  '<------------ICE SPELL------------------->
  ELSEIF spellType$ = "ice" THEN
   
    spellCost = (p.ice + 10)

    'make sure they have MP to be casting with!
    IF p.mp >= spellCost THEN
     
      IF p.ice < 7 THEN
        spellDamage = (p.mst + p.ice)
      ELSEIF p.ice >= 7 AND p.ice < 10 THEN
        spellDamage = (p.mst + p.ice) * 2
      ELSEIF p.ice >= 10 THEN
        spellDamage = (p.mst + p.ice) * 3
      END IF

      CALL drawIceSpell(1) 'draw expanding
     
      'check to see if any bad guys are in damage radius before
      'shrinking spell
      FOR i% = 0 TO room(p.mapY, p.mapX).numBadGuys
        distance% = SQR((badGuy(i%).x - p.x) ^ 2 + (badGuy(i%).y - p.y) ^ 2)

        'hurt them if they're in ice damage radius
        IF distance% <= p.ice + 1 AND badGuy(i%).badType <= CRATE THEN
          LOCATE badGuy(i%).y, badGuy(i%).x
          COLOR 4, room(p.mapY, p.mapX).bgColor
          PRINT ""
          
          IF p.ice < 7 THEN
            dmgToBadGuy% = spellDamage
          ELSEIF p.ice >= 7 AND p.ice < 10 THEN
            dmgToBadGuy% = spellDamage * 2
          ELSEIF p.ice >= 10 THEN
            dmgToBadGuy% = spellDamage * 3
          END IF
         
          badGuy(i%).hp = badGuy(i%).hp - dmgToBadGuy%

          LOCATE 1, 50
          COLOR 15, room(p.mapY, p.mapX).bgColor
          PRINT "You cast for "; dmgToBadGuy%; " damage!   "

          'check to see if anything died from radius
          IF badGuy(i%).hp <= 0 THEN
            badGuy(i%).alive = FALSE
            p.expCurrent = p.expCurrent + badGuy(i%).expToGive
            badGuy(i%).opened = getItem(i%, TRUE)
          END IF

        END IF
      NEXT i%

      CALL drawIceSpell(0) ' draw collapsing
  
      'charge them for the spell use
      p.mp = p.mp - spellCost

    END IF
     
  '<----------DARK SPELL----------------->
  ELSEIF spellType$ = "dark" THEN

    spellCost = (p.dark + 20)

    'make sure they have MP to be casting with!
    IF p.mp >= spellCost THEN

      IF p.badGuyTargeted > NONE THEN
        IF badGuy(p.badGuyTargeted).badType <= CRATE THEN
     
          'bonus for "rare" spell
          IF p.dark < 7 THEN
            spellDamage = (p.mst + p.dark) * 2
          ELSEIF p.dark >= 7 AND p.dark < 10 THEN
            spellDamage = (p.mst + p.dark) * 3
          ELSEIF p.dark >= 10 THEN
            spellDamage = (p.mst + p.dark) * 5
          END IF
         
          'draw spell expanding...
          CALL drawDarkSpell(1)

          'check to see if any bad guys are in damage radius before
          'shrinking spell
          FOR i% = 0 TO room(p.mapY, p.mapX).numBadGuys
            distance% = SQR((badGuy(i%).x - badGuy(p.badGuyTargeted).x) ^ 2 + (badGuy(i%).y - badGuy(p.badGuyTargeted).y) ^ 2)

            'hurt them if they're in dark damage radius
            IF distance% <= p.dark AND badGuy(i%).badType <= CRATE THEN
              LOCATE badGuy(i%).y, badGuy(i%).x
              COLOR 4, room(p.mapY, p.mapX).bgColor
              PRINT ""
              LOCATE 1, 50
              COLOR 15, room(p.mapY, p.mapX).bgColor
              PRINT "You cast for "; spellDamage; " damage!   "

              badGuy(i%).hp = badGuy(i%).hp - spellDamage
         
              'check to see if anything died from radius
              IF badGuy(i%).hp <= 0 THEN
                badGuy(i%).alive = FALSE
                p.expCurrent = p.expCurrent + badGuy(i%).expToGive
                badGuy(i%).opened = getItem(i%, TRUE)
              END IF

            END IF
          NEXT i%

          'bad guy in center gets 2x damage
          IF badGuy(p.badGuyTargeted).badType <= CRATE AND p.badGuyTargeted >= 0 THEN
            LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x
            COLOR 4, room(p.mapY, p.mapX).bgColor
            PRINT ""
            badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - (spellDamage * 2)
          END IF

          'draw spell collapsing..
          CALL drawDarkSpell(0)

        END IF
      END IF

      'charge them for the spell use
      p.mp = p.mp - spellCost

    END IF

  '<--------HEAL SPELL---------------->
  ELSEIF spellType$ = "heal" THEN
    spellCost = p.heal + (p.lvl * 2)

    'make sure they have MP to be casting with!
    IF p.mp >= spellCost THEN

      CALL drawHealSpell
       
      IF p.heal < 7 THEN
        spellDamage = p.mst + (p.heal * 3)
      ELSEIF p.heal >= 7 AND p.heal < 10 THEN
        spellDamage = p.mst + (p.heal * 9)
      ELSEIF p.heal >= 10 THEN
        spellDamage = p.maxHP
      END IF

      p.hp = p.hp + spellDamage
      p.mp = p.mp - spellCost
   
      'IF p.hp > p.maxHP THEN
      '  p.hp = p.maxHP
      'END IF
    END IF

  '<-----------RETURN SPELL---------------->
  ELSEIF spellType$ = "return" THEN
    spellCost = 5

    'make sure they have MP to be casting with!
    IF p.mp >= spellCost THEN
      CALL drawReturnSpell
      CALL saveAndChain
    END IF
  END IF

'check to see if you killed anything targeted.
IF p.badGuyTargeted >= 0 THEN              'make sure someone's targetted!
  IF badGuy(p.badGuyTargeted).hp <= 0 THEN
    badGuy(p.badGuyTargeted).alive = FALSE
    p.expCurrent = p.expCurrent + badGuy(p.badGuyTargeted).expToGive
    badGuy(p.badGuyTargeted).opened = getItem(p.badGuyTargeted, TRUE)
  END IF
END IF

'we don't want any negative numbers here!
IF p.mp < 0 THEN p.mp = 0

END SUB

FUNCTION checkCollision% (badGuyNum%)

'collision detection to see if player is going to walk into something.
'this is called from the check events sub.

'returns false and cancels move request if there's going to be a collision.

'calculates if the difference between the two objects in question is greater
'than that of the players single step. If it is, player can't walk.

DIM distance AS INTEGER

SELECT CASE moveRequest.direction

  CASE LEFT
    distance = (p.x - badGuy(badGuyNum%).x)

    IF distance <= p.speed AND distance > 1 AND p.y = badGuy(badGuyNum%).y THEN
      checkCollision = TRUE
      p.speedAugmentation = distance - 1 'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.y = badGuy(badGuyNum%).y THEN
      checkCollision% = FALSE
   
    ELSE
      checkCollision% = TRUE
    END IF
 
  CASE RIGHT
    distance = (badGuy(badGuyNum%).x - p.x)
   
    IF distance <= p.speed AND distance > 1 AND p.y = badGuy(badGuyNum%).y THEN
      checkCollision = TRUE
      p.speedAugmentation = distance - 1 'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.y = badGuy(badGuyNum%).y THEN
      checkCollision% = FALSE
  
    ELSE
      checkCollision% = TRUE
    END IF
   

  CASE UP
    distance = (p.y - badGuy(badGuyNum%).y)

    IF distance <= p.speed AND distance > 1 AND p.x = badGuy(badGuyNum%).x THEN
      checkCollision = TRUE
      p.speedAugmentation = distance - 1'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.x = badGuy(badGuyNum%).x THEN
      checkCollision% = FALSE
 
    ELSE
      checkCollision% = TRUE
    END IF

  CASE DOWN
    
    distance = (badGuy(badGuyNum%).y - p.y)

    IF distance <= p.speed AND distance > 1 AND p.x = badGuy(badGuyNum%).x THEN
      checkCollision = TRUE
      p.speedAugmentation = distance - 1'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.x = badGuy(badGuyNum%).x THEN
      checkCollision% = FALSE

    ELSE
      checkCollision% = TRUE
    END IF
  

END SELECT

END FUNCTION

SUB checkCollisionWithWall

'checks if player is going to collide with a wall. Adjusts step if they
'are. Also sets the exit direction in which the player has left the room.

SELECT CASE moveRequest.direction

  'test top wall
  CASE UP
  IF p.y - p.speed <= room(p.mapY, p.mapX).borderTop THEN
    IF p.x >= 30 AND p.x < 50 AND room(p.mapY, p.mapX).hasExitTop THEN
      p.exitedRoomDirection = UP
    END IF
    p.speedAugmentation = p.y - room(p.mapY, p.mapX).borderTop
  END IF

  'test bottom wall
  CASE DOWN
  IF p.y + p.speed >= room(p.mapY, p.mapX).borderBottom THEN
    IF p.x >= 30 AND p.x < 50 AND room(p.mapY, p.mapX).hasExitBottom THEN
      p.exitedRoomDirection = DOWN
    END IF
    p.speedAugmentation = room(p.mapY, p.mapX).borderBottom - p.y
  END IF

  'test left wall
  CASE LEFT
  IF p.x - p.speed <= room(p.mapY, p.mapX).borderLeft THEN
    IF p.y >= 10 AND p.y < 16 AND room(p.mapY, p.mapX).hasExitLeft THEN
      p.exitedRoomDirection = LEFT
    END IF
    p.speedAugmentation = p.x - room(p.mapY, p.mapX).borderLeft
  END IF

  'test right wall
  CASE RIGHT
  IF p.x + p.speed >= room(p.mapY, p.mapX).borderRight THEN
    IF p.y >= 10 AND p.y < 16 AND room(p.mapY, p.mapX).hasExitRight THEN
      p.exitedRoomDirection = RIGHT
    END IF
    p.speedAugmentation = room(p.mapY, p.mapX).borderRight - p.x
  END IF
END SELECT

END SUB

SUB checkCollisionWithWallSpots (i%)

DIM distance AS INTEGER

SELECT CASE moveRequest.direction
 
  'test top wall
  CASE UP
    distance = (p.y - wallSpot(i%).y)

    IF distance <= p.speed AND distance > 1 AND p.x = wallSpot(i%).x THEN
      p.speedAugmentation = distance - 1'place them at walking limit
     
    ELSEIF distance >= 1 AND distance >= 0 AND p.x = wallSpot(i%).x THEN
      p.speedAugmentation = 0
    END IF

  'test bottom wall
  CASE DOWN
    distance = (wallSpot(i%).y - p.y)
    IF distance <= p.speed AND distance > 1 AND p.x = wallSpot(i%).x THEN
      p.speedAugmentation = distance - 1'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.x = wallSpot(i%).x THEN
      p.speedAugmentation = 0
    END IF

  'test left wall
  CASE LEFT
    distance = (p.x - wallSpot(i%).x)
    IF distance <= p.speed AND distance > 1 AND p.y = wallSpot(i%).y THEN
      p.speedAugmentation = distance - 1 'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.y = wallSpot(i%).y THEN
      p.speedAugmentation = 0
    END IF

  CASE RIGHT
    distance = (wallSpot(i%).x - p.x)
    IF distance <= p.speed AND distance > 1 AND p.y = wallSpot(i%).y THEN
      p.speedAugmentation = distance - 1 'place them at walking limit

    ELSEIF distance <= 1 AND distance >= 0 AND p.y = wallSpot(i%).y THEN
      p.speedAugmentation = 0
    END IF

END SELECT

END SUB

FUNCTION checkEvents% (targetReq%, attackReq%, strongAttackReq%, frme%)

'checks for any type of non-player controlled interaction in the game
'ex: bad guys actions and if they're in range of attack or not.

'<--------------CHECK IF PLAYER NEEDS TO LEVEL--------->
IF p.expCurrent >= p.expToLevel THEN
  CALL LevelPlayer
  CALL calculateStats
END IF

'<---------------check if player is alive------------>
IF p.hp <= 0 OR p.alive = FALSE THEN 'incase of trap death
 
  LOCATE p.y, p.x
  COLOR 4, room(p.mapY, p.mapX).bgColor
  PRINT ""

  DO
    FOR i% = 1 TO 15 STEP 1
      LOCATE p.y - 1, p.x - 4
      COLOR i%, room(p.mapY, p.mapX).bgColor
      PRINT "YOU DIED!"
    NEXT i%
  LOOP WHILE INKEY$ = ""

  CALL saveAndChain 'save their stats and throw them back in town

END IF

'<----------CHECK ENEMY RELATED STUFF-------------->
FOR i% = 0 TO room(p.mapY, p.mapX).numBadGuys

  '<-----------CHECK IF ENEMY'S DEAD AND NOT OPENED------------------>
  IF (badGuy(i%).alive = FALSE OR badGuy(i%).hp <= 0) AND badGuy(i%).opened = TRUE THEN
    badGuy(i%).alive = FALSE 'incase they got here by the OR method
   
    CALL drawBadGuy(i%)  'so displays correctly.
   
    'untarget the dead guy
    CALL untargetBadGuy(i%)
   
  '<----------DISTANCE REQUIRED ACTIONS----------------->
  ELSE  'we're good to test

    'check distance between bad guys and player using the standard
    'distance formula.
    distance% = ((badGuy(i%).x - p.x) ^ 2 + (badGuy(i%).y - p.y) ^ 2) ^ .5
    'also could use SQR((bad.x-p.x)^2)+(bady-p.y)^2)
   
    '<----------CHECK ENEMY HURTING PLAYER---------->
    '<------------AND MAKE SURE THEY'RE NOT A CRATE OR OTHER---->
    IF distance% <= 1 AND badGuy(i%).badType < CRATE AND badGuy(i%).alive = TRUE THEN
      badGuyAttack% = badGuy(i%).atp - p.dfp 'check if doing damage

      IF badGuyAttack% > 0 THEN
        'let player know they're getting hurt
        COLOR 4, room(p.mapY, p.mapX).bgColor
        LOCATE p.y, p.x
        PRINT ""
       
        'show damage to player
        LOCATE 1, 50
        COLOR 15, room(p.mapY, p.mapX).bgColor
        PRINT "You're hit for "; badGuyAttack%; " damage!"

        p.hp = p.hp - (badGuy(i%).atp - p.dfp)
        IF p.hp < 0 THEN p.hp = 0   'i don't like negatives.
       
        IF badGuy(i%).badType = 4 THEN 'if creeper...
          p.status = POISONED
          LOCATE 2, 50
          COLOR 4, room(p.mapY, p.mapX).bgColor
          PRINT "You've been poisoned!"
        END IF
     
      ELSE
        'show damage to player
        LOCATE 2, 50
        COLOR 15, room(p.mapY, p.mapX).bgColor
        PRINT "Enemy's attack MISSES you! "
      END IF
    END IF

    '<---------CHECK IF BADGUY IN PLAYERS RANGE--------------------->
    'set bad guy to be in range for playerif so and not if not.
    IF distance% <= p.range THEN
      badGuy(i%).inRange = TRUE

      '<---------CHECK IF PLAYER WILL COLLIDE WITH BAD GUY----------->
      '<-----------WHEN MOVE SUB IS CALLED--------------------------->
      IF moveRequest.flagged = TRUE THEN
        moveRequest.flagged = checkCollision(i%) 'cancels request if collision.
      END IF
     
      '<---------TARGET ENEMY IF REQUEST FLAG SENT FROM MAIN--------->
      IF targetReq% = TRUE AND badGuy(i%).badType <= NPC THEN
        targetReq% = targetBadGuy(i%, "manual")
      END IF


    '<----------IF OUT OF PLAYER RANGE, UNTARGET BADGUY------------>
    ELSE
      'not in range. remove the target!
      CALL untargetBadGuy(i%)
      badGuy(i%).inRange = FALSE
    END IF
  
    '<--------CHECK IF PLAYER IN BADGUYS RANGE----------->
    IF distance% <= badGuy(i%).range AND badGuy(i%).alive = TRUE THEN
      badGuy(i%).inRange = TRUE

      'auto target bad guy in range. Returns meaningless info.
      IF distance% <= p.range THEN
        bah% = targetBadGuy%(i%, "auto")
      END IF

      'move bad guy towards player if not a crate or NPC
      IF badGuy(i%).badType <> CRATE AND badGuy(i%).badType <> NPC THEN
        CALL moveBadGuy(i%)
      END IF
      
 
    ELSE 'distance% > badGuy(i%).range THEN
      'not in range.Untargeting handled by player range below.
      'badGuy(i%).inRange = FALSE
    END IF
 
    CALL drawBadGuy(i%)  'draw bad guy incase they're a static one.

  END IF 'end of alive if block
NEXT i%

'<----------ATTACK ENEMY IF REQUEST FLAG SENT FROM MAIN--------->
IF attackReq% = TRUE THEN
  'make sure someone is targeted.
  IF p.badGuyTargeted > NONE THEN
    '<--------------IF TARGETTING AN ALIVE BAD GUY------------------->
    IF badGuy(p.badGuyTargeted).badType <= CRATE AND badGuy(p.badGuyTargeted).alive = TRUE THEN
      dmgToBadGuy% = p.atp - badGuy(p.badGuyTargeted).dfp
      badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - dmgToBadGuy%

      'show damage to player
      LOCATE 1, 50
      COLOR 15, room(p.mapY, p.mapX).bgColor
      IF dmgToBadGuy% > 0 THEN
        PRINT "You attack for "; dmgToBadGuy%; " damage!"
        LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x
        COLOR 4, room(p.mapY, p.mapX).bgColor
        PRINT ""
      ELSE
        PRINT "You MISS in your attack!   "
      END IF

      'set enemy to dead if necessary and give exp.
      IF badGuy(p.badGuyTargeted).hp <= 0 THEN

        badGuy(p.badGuyTargeted).alive = FALSE
        p.expCurrent = p.expCurrent + badGuy(p.badGuyTargeted).expToGive
        badGuy(p.badGuyTargeted).opened = getItem(p.badGuyTargeted, TRUE)

        'exp is checked out of this if block.
        'and so is getting items from dead things.
      END IF
   
    '<-----GET ITEM FROM DEAD ENEMY-------------------------->
    ELSEIF badGuy(p.badGuyTargeted).badType <= CRATE AND badGuy(p.badGuyTargeted).alive = FALSE THEN
      'get any items the bad guy might have had..
      IF badGuy(p.badGuyTargeted).opened = FALSE THEN
        badGuy(p.badGuyTargeted).opened = getItem(p.badGuyTargeted, FALSE)
      END IF

   
   
    '<------TALK TO NPC IF THEY ARE ONE, DON'T ATTACK---------->
    ELSEIF badGuy(p.badGuyTargeted).badType = NPC THEN
      LOCATE 23, 5
      COLOR 15, room(p.mapY, mapX).bgColor
      PRINT badGuy(p.badGuyTargeted).talkText
    END IF

    attackReq% = FALSE 'so they can't hit everyone in range.
  END IF
END IF

'<--------DO STRONG ATTACK IF REQUEST IS PASSED FROM MAIN------------->
IF strongAttackReq% = TRUE THEN
  'make sure someone is targeted.
  IF p.badGuyTargeted > NONE AND badGuy(p.badGuyTargeted).badType <= CRATE THEN

    hit% = (RND * 5) + 1 '1 - 5 chance

    'if they hit them...
    IF hit% = 3 THEN
      'do 2x damage in hard attack
      dmgToBadGuy% = (p.atp + p.atp) - badGuy(p.badGuyTargeted).dfp
      badGuy(p.badGuyTargeted).hp = badGuy(p.badGuyTargeted).hp - dmgToBadGuy%

      'show damage to player
      LOCATE 1, 50
      COLOR 15, room(p.mapY, p.mapX).bgColor
      IF dmgToBadGuy% > 0 THEN
        PRINT "You attack for "; dmgToBadGuy%; " damage!"
        LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x
        COLOR 4, room(p.mapY, p.mapX).bgColor
        PRINT ""
      ELSE
        PRINT "You're attack does nothing! "
      END IF

    'and if they miss..
    ELSE
      LOCATE 1, 50
      COLOR 15, room(p.mapY, p.mapX).bgColor
      PRINT "You MISS in your attack!   "
    END IF

    'set enemy to dead if necessary and give exp.
    IF badGuy(p.badGuyTargeted).hp <= 0 THEN

      badGuy(p.badGuyTargeted).alive = FALSE
      p.expCurrent = p.expCurrent + badGuy(p.badGuyTargeted).expToGive
      badGuy(p.badGuyTargeted).opened = getItem(p.badGuyTargeted, TRUE)
     
      'exp is checked out of this if block.
      'and so is getting items from dead things.
    END IF

    strongAttackReq% = FALSE 'so they can't hit everyone in range.
  END IF
END IF


'<------------------MOVE PLAYER IF MOVE REQUEST PASSED TEST------------>
IF moveRequest.flagged = TRUE THEN
 
  'check collisions with wall spots.
  FOR i% = 0 TO room(p.mapY, p.mapX).numWallSpots
    distance1% = ((wallSpot(i%).x - p.x) ^ 2 + (wallSpot(i%).y - p.y) ^ 2) ^ .5
    IF distance1% <= p.speed THEN
      CALL checkCollisionWithWallSpots(i%)
    END IF
  NEXT i%


  'check if they're going to walk into a wall before the move.
  CALL checkCollisionWithWall

  CALL movePlayer(moveRequest.direction)
  moveRequest.flagged = FALSE 'end the request here.
END IF

'set events checked

'<----------CHECK IF PLAYER LEFT THE ROOM---------------------------->
IF p.exitedRoomDirection >= LEFT THEN     'that's left as in direction
  CALL roomExit(p.exitedRoomDirection)
  p.exitedRoomDirection = NONE
END IF

checkEvents% = TRUE

END FUNCTION

SUB clearKBbuffer

'clears the keyboard buffer so that it doesn't over flow when user
'attempts to throw more than it's max onto buffer stack.

DEF SEG = &H40           'set current segment address
  POKE &H1C, PEEK(&H1A)  'write buffer back to begining.
DEF SEG


END SUB

SUB debugInfo

COLOR 15, room(p.mapY, p.mapX).bgColor
LOCATE 5, 45
PRINT p.badGuyTargeted

LOCATE 6, 45
PRINT p.y

END SUB

SUB display

'displays player name & basic stats.

IF p.status = POISONED THEN
  COLOR 10, room(p.mapY, p.mapX).bgColor
  LOCATE 1, 2
  PRINT ""
  LOCATE 1, 3
  COLOR 4, room(p.mapY, p.mapX).bgColor
  PRINT p.handle
ELSE
  LOCATE 1, 1
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT p.handle
END IF


LOCATE 2, 1
COLOR 15, room(p.mapY, p.mapX).bgColor
PRINT "HP: "; p.hp; "/"; p.maxHP
LOCATE 3, 1
PRINT "MP: "; p.mp; "/"; p.maxMP

'display info of what's targetted at the bottom.
IF p.badGuyTargeted >= 0 THEN
  LOCATE 23, 50
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT "Targeted:"

  LOCATE 23, 60
  COLOR 15, room(p.mapY, p.mapX).bgColor

  IF badGuy(p.badGuyTargeted).alive = TRUE THEN
    SELECT CASE badGuy(p.badGuyTargeted).badType
      CASE 0 ' zombie
        PRINT "Zombie          "

      CASE 1 'Maf Zombie
        PRINT "Maf Zombie      "

      CASE 2
        PRINT "Gran Zombie     "

      CASE 3
        PRINT "Ghoul           "

      CASE 4
        PRINT "Creeper         "

      CASE CRATE
        PRINT "Crate           "

      CASE NPC
        PRINT "NPC             "

      CASE ELSE
        PRINT "???             "

    END SELECT

  ELSEIF badGuy(p.badGuyTargeted).opened = FALSE THEN
    SELECT CASE badGuy(p.badGuyTargeted).chanceTime
      CASE 0
        PRINT "Coin            "

      CASE 1
        PRINT "HP Potion       "

      CASE 2
        PRINT "MP Potion       "

      CASE 3
        PRINT "Wooden Dagger   "

      CASE 4
        PRINT "Copper Dagger   "

      CASE 5
        PRINT "Iron Dagger     "

      CASE 6
        PRINT "Wooden Sh. Sword"

      CASE 7
        PRINT "Copper Sh. Sword"

      CASE 8
        PRINT "Iron Short Sword"

      CASE 9
        PRINT "Wooden Partizan "

      CASE 10
        PRINT "Copper Partizan "

      CASE 11
        PRINT "Iron Partizan   "

      CASE 12
        PRINT "Wooden Staff    "

      CASE 13
        PRINT "Copper Staff    "

      CASE 14
        PRINT "Iron Staff      "

      CASE 15
        PRINT "Wooden Wand     "

      CASE 16
        PRINT "Copper Wand     "

      CASE 17
        PRINT "Iron Wand       "

      CASE 18
        PRINT "Wooden Crossbow "

      CASE 19
        PRINT "Copper Crossbow "

      CASE 20
        PRINT "Iron Crossbow   "

      CASE 21
        PRINT "Wooden Bow      "

      CASE 22
        PRINT "Copper Bow      "

      CASE 23
        PRINT "Iron Bow        "

      CASE 24
        PRINT "Antidote Potion "

      CASE 25
        PRINT "Return Potion   "

      CASE 26
        PRINT "Cloth Armor     "

      CASE 27
        PRINT "L. Leather Armor"

      CASE 28
        PRINT "Leather Armor   "

      CASE 29
        PRINT "Cloth Robe      "

      CASE 30
        PRINT "Heavy Cloth Robe"

      CASE 31
        PRINT "Light Magic Robe"


      CASE ELSE
        COLOR 11, room(p.mapY, p.mapX).bgColor
        PRINT "?SPECIAL WEAPON?"
    END SELECT
  END IF

ELSE
  LOCATE 23, 50
  COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
  PRINT "Targeted: whatever I feel like!"

END IF
END SUB

DEFSNG A-Z
FUNCTION drawArea% (row%, column%)

'this takes the area's room type and draws the correct room. It also places
'initial bad guys, player, and wall sprites.

DIM errorHappened AS INTEGER
errorHappened = FALSE

CLS 'reset the screen to pop-n-freshness

SELECT CASE room(p.mapY, p.mapX).roomType

  CASE 1
    COLOR 10, room(p.mapY, p.mapX).bgColor
    PRINT
    PRINT
    PRINT ""
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    COLOR 8, room(p.mapY, p.mapX).bgColor
    PRINT "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"
  
  CASE 2
    COLOR 8, room(p.mapY, p.mapX).bgColor
    PRINT
    PRINT
    PRINT "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"
    COLOR 10, room(p.mapY, p.mapX).bgColor
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    COLOR 8, room(p.mapY, p.mapX).bgColor
    PRINT "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"

  CASE 8, 9, 12
    COLOR 10, room(p.mapY, p.mapX).bgColor
    PRINT
    PRINT
    PRINT ""
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT "                                                                            "
    PRINT ""


  CASE 3, 4, 5, 6, 7, 10, 11, 13
    COLOR 8, room(p.mapY, p.mapX).bgColor
    PRINT
    PRINT
    PRINT "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UU                                                                            UU"
    PRINT "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"


    CASE ELSE
      errorHappened = TRUE

END SELECT


'show problem if error happened
IF errorHappened = TRUE THEN
  LOCATE 1, 1
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT "ERROR: Cannot read room data!"
END IF

'draw initial player and bad guys
 
  'display player
  LOCATE p.y, p.x
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT p.gfx

  'display bad guys
  FOR i% = 0 TO room(p.mapY, p.mapX).numBadGuys
    CALL drawBadGuy(i%)
  NEXT i%

  'display wall spots
  FOR i% = 0 TO room(p.mapY, p.mapX).numWallSpots
    CALL drawWallSpots(i%)
  NEXT i%


'draw area exits if they exist
  IF room(p.mapY, p.mapX).hasExitTop = TRUE THEN
    LOCATE 3, 30
    COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
    PRINT "                    "
  END IF

  IF room(p.mapY, p.mapX).hasExitBottom = TRUE THEN
    LOCATE 22, 30
    COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
    PRINT "                    "
  END IF
 
  IF room(p.mapY, p.mapX).hasExitLeft = TRUE THEN
    COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
    FOR y% = 10 TO 15
      LOCATE y%, 1
      PRINT "  "
    NEXT y%

  END IF
 
  IF room(p.mapY, p.mapX).hasExitRight = TRUE THEN
    COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
    FOR y% = 10 TO 15
      LOCATE y%, 79
      PRINT "  "
    NEXT y%
  END IF


'set the return to true
drawArea% = TRUE

END FUNCTION

DEFINT A-Z
SUB drawBadGuy (badNumber%)

'this draws a bad guy at it's current location based on it's number and
'it's type
'
'NOTE: THIS DOES NOT MASK OLD LOCATION!!! That is handled by the mask func


'locate bad guys POS
LOCATE badGuy(badNumber%).y, badGuy(badNumber).x

'draw graphic depending on if they're alive or dead.
IF badGuy(badNumber%).alive = TRUE THEN
  COLOR badGuy(badNumber%).gfxColor, room(p.mapY, p.mapX).bgColor
  PRINT badGuy(badNumber%).gfxImg

ELSEIF badGuy(badNumber%).alive = FALSE AND badGuy(badNumber%).opened = FALSE THEN
  SELECT CASE badGuy(badNumber%).chanceTime
    CASE 0 'coin
      COLOR 14, room(p.mapY, p.mapX).bgColor
      PRINT ""

    CASE 1, 2, 24, 25 'potions
      COLOR 10, room(p.mapY, p.mapX).bgColor
      PRINT ""

    'weapons
    CASE 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23
      COLOR 6, room(p.mapY, p.mapX).bgColor
      PRINT ""

    CASE 26, 27, 28, 29, 30, 31 'armor
      COLOR 1, room(p.mapY, p.mapX).bgColor
      PRINT ""

    CASE ELSE 'rare!
      COLOR 4, room(p.mapY, p.mapX).bgColor
      PRINT ""
  END SELECT

ELSE
  IF badGuy(badNumber%).badType = 99 THEN 'if they're a crate.
    COLOR 8, room(p.mapY, p.mapX).bgColor                 'don't draw blood!
  ELSE
    COLOR 4, room(p.mapY, p.mapX).bgColor
  END IF

  PRINT ""
END IF
  

'draw "in range & targeted" indicator (aka an arrow) if so.
IF p.badGuyTargeted = badNumber% THEN
  LOCATE badGuy(badNumber%).y - 1, badGuy(badNumber%).x
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT ""
END IF

END SUB

SUB drawDarkSpell (direction%)

'draws the dark spell. Basically the same algorythme (wow spelling anyone?)
'as the ice spell except expands from target point.

  'expanding
  IF direction% = 1 THEN
     spellColorStr% = 8
     spellColorDiag% = 8

     FOR i% = 1 TO p.dark
       
        'just a little eye candy for higher level spells
        IF p.dark >= 10 THEN
          spellColorStr% = 8
          IF spellColorDiag% = 4 THEN
            spellColorDiag% = 14
          ELSE
            spellColorDiag% = 4
          END IF

        ELSEIF p.dark >= 7 AND p.dark < 10 THEN
          spellColorDiag% = 8
          IF spellColorStr% = 6 THEN
            spellColorStr% = 8
          ELSE
            spellColorStr% = 6
          END IF
        END IF
     
        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x
          COLOR spellColorStr%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
 
        IF badGuy(p.badGuyTargeted).y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x
          COLOR spellColorStr%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
 
        IF badGuy(p.badGuyTargeted).x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x - i%
          COLOR spellColorStr%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
 
        IF badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x + i%
          COLOR spellColorStr%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop AND badGuy(p.badGuyTargeted).x - i% > room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x - i%
          COLOR spellColorDiag%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
      
        IF badGuy(p.badGuyTargeted).y + i% <= room(p.mapY, p.mapX).borderBottom AND badGuy(p.badGuyTargeted).x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x - i%
          COLOR spellColorDiag%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop AND badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x + i%
          COLOR spellColorDiag%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y + i% < room(p.mapY, p.mapX).borderBottom AND badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x + i%
          COLOR spellColorDiag%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        CALL timingControl(speed)
      NEXT i%

  'if it's collapsing...
  ELSEIF direction% = 0 THEN
      FOR i% = p.dark TO 1 STEP -1
        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y, badGuy(p.badGuyTargeted).x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop AND badGuy(p.badGuyTargeted).x - i% > room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF badGuy(p.badGuyTargeted).y + i% <= room(p.mapY, p.mapX).borderBottom AND badGuy(p.badGuyTargeted).x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y - i% >= room(p.mapY, p.mapX).borderTop AND badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y - i%, badGuy(p.badGuyTargeted).x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF badGuy(p.badGuyTargeted).y + i% < room(p.mapY, p.mapX).borderBottom AND badGuy(p.badGuyTargeted).x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE badGuy(p.badGuyTargeted).y + i%, badGuy(p.badGuyTargeted).x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        CALL timingControl(speed)
      NEXT i%
  END IF

END SUB

SUB drawHealSpell

'just to declutter the cast spell sub...
   
    spellColor% = 12
    spellGfx$ = ""
   
    FOR i% = 3 TO 1 STEP -1
      
      'rare spell eye candy...
      IF p.heal >= 10 THEN
        IF spellColor% = 12 THEN
          spellColor% = 13
          spellGfx$ = ""
        ELSEIF spellColor = 13 THEN
          spellColor = 5
          spellGfx$ = ""
        ELSE
          spellColor% = 12
          spellGfx$ = ""
        END IF
     
      ELSEIF p.heal >= 7 AND p.heal < 10 THEN
        IF spellColor = 13 THEN
          spellColor = 5
        ELSE
          spellColor% = 13
        END IF

      END IF

      'top
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
        LOCATE p.y - i%, p.x
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - (i% + 1) >= room(p.mapY, p.mapX).borderTop AND p.x + (i% + 1) <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y - (i% + 1), p.x + (i% + 1)
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF
    
      'top left
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y - i%, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
        LOCATE p.y - i%, p.x
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'left
      IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y - i%, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom left
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y + i%, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
        LOCATE p.y + i%, p.x
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y + i%, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom right
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y + i%, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
        LOCATE p.y + i%, p.x
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'right
      IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y + i%, p.x + i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'top right
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y - i%, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y, p.x + i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      CALL timingControl(speed)
    NEXT i%

    'clean up.
      LOCATE p.y - 1, p.x + 1
      COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
      PRINT ""


END SUB

SUB drawIceSpell (direction%)

'this draws the ice spell. The cast sub was getting way to cluttered for
'my liking. :P

spellColor% = 1

'if they want to draw the expanding...
  IF direction% = 1 THEN
      
      FOR i% = 1 TO p.ice + 1
      
        'just a little eye candy for higher level spells
        IF p.ice >= 10 THEN
          spellColor% = i% + 3
        ELSEIF p.ice > 7 THEN
          IF spellColor% = 11 THEN
            spellColor% = 1
          ELSEIF spellColor = 1 THEN
            spellColor = 11
          END IF
        END IF
      
       
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE p.y - i%, p.x
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
  
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE p.y + i%, p.x
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
 
        IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y - i%, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y + i%, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y - i%, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
      
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y + i%, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        CALL timingControl(speed)
      NEXT i%

  'if they want to draw it collapsing...
  ELSEIF direction% = 0 THEN
      FOR i% = (p.ice + 1) TO 1 STEP -1

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE p.y - i%, p.x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
        
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE p.y + i%, p.x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y - i%, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y + i%, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y - i%, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
     
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y + i%, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        CALL timingControl(speed)
      NEXT i%
  END IF
END SUB

SUB drawReturnSpell

' yeah, this is probably the most graphically "intense" spell. Taking up
' way more space than I want it to, but it looks cool!

spellColor% = 5
spellGfx$ = ""
   
    FOR i% = 3 TO 0 STEP -1
      IF spellColor% = 5 THEN
        spellColor% = 13
      ELSE
        spellColor% = 5
      END IF

      'top
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
        LOCATE p.y - i%, p.x
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - (i% + 1) >= room(p.mapY, p.mapX).borderTop AND p.x + (i% + 1) <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y - (i% + 1), p.x + (i% + 1)
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF
   
      'top left
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y - i%, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
        LOCATE p.y - i%, p.x
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'left
      IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y - i%, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom left
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y + i%, p.x - i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
        LOCATE p.y + i%, p.x
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
        LOCATE p.y + i%, p.x - i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'bottom right
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y + i%, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
        LOCATE p.y + i%, p.x
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'right
      IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y + i%, p.x + i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF

      'top right
      IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y - i%, p.x + i%
        COLOR spellColor%, room(p.mapY, p.mapX).bgColor
        PRINT spellGfx$
      END IF
      IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
        LOCATE p.y, p.x + i%
        COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
        PRINT ""
      END IF
     
      CALL timingControl(speed)

    NEXT i%

    'clean up.
      LOCATE p.y - 1, p.x + 1
      COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
      PRINT ""


'now for explosion
      FOR i% = 1 TO 5
     
        'just a little eye candy for higher level spells
        IF spellColor% = 13 THEN
          spellColor% = 5
        ELSE
          spellColor% = 13
        END IF
     
      
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE p.y - i%, p.x
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF
 
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE p.y + i%, p.x
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF
      
        IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF

        IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y - i%, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF

        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y + i%, p.x - i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y - i%, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF
     
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y + i%, p.x + i%
          COLOR spellColor%, room(p.mapY, p.mapX).bgColor
          PRINT spellGfx$
        END IF
        CALL timingControl(speed)
      NEXT i%

  'draw it collapsing...
  
      FOR i% = 5 TO 1 STEP -1

        IF p.y - i% >= room(p.mapY, p.mapX).borderTop THEN
          LOCATE p.y - i%, p.x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
       
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom THEN
          LOCATE p.y + i%, p.x
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
   
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y - i%, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x - i% >= room(p.mapY, p.mapX).borderLeft THEN
          LOCATE p.y + i%, p.x - i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.y - i% >= room(p.mapY, p.mapX).borderTop AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y - i%, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
    
        IF p.y + i% <= room(p.mapY, p.mapX).borderBottom AND p.x + i% <= room(p.mapY, p.mapX).borderRight THEN
          LOCATE p.y + i%, p.x + i%
          COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
          PRINT ""
        END IF
        CALL timingControl(speed)
      NEXT i%

END SUB

SUB drawWallSpots (wallSpotNum%)

'draws any wall spots in the level.

COLOR wallSpot(wallSpotNum%).gfxColor, room(p.mapY, p.mapX).bgColor
LOCATE wallSpot(wallSpotNum%).y, wallSpot(wallSpotNum%).x
PRINT wallSpot(wallSpotNum%).gfxImg

END SUB

FUNCTION getItem% (badNumber%, set%)

'this is called when enemy is killed to set the type so the game displays
'the correct item box on the screen. It is called again when the player
'requests to take the item box.

'returns if the enemy is opened or not. (if they could take the item.)

DIM coinAmount AS INTEGER
DIM enemyType AS STRING
DIM flagged AS INTEGER
DIM foundSpot AS INTEGER
DIM slot AS INTEGER
DIM text AS STRING * 27
DIM looping AS INTEGER

flagged = FALSE

IF set% = TRUE THEN
  'set item dropped randomly.
  badGuy(badNumber%).chanceTime = INT(RND * 39)
  getItem% = FALSE

ELSE
  'crate or bad guy dropped the stuff.
  IF badGuy(badNumber%).badType = CRATE THEN
    enemyType = "crate "
  ELSE
    enemyType = "enemy"
  END IF

  '<-------------locate a spot in inventory---------------------->
  IF badGuy(badNumber%).chanceTime > 2 THEN
    foundSpot = FALSE
    slot = -1
    looping = TRUE

    WHILE foundSpot = FALSE AND looping = TRUE
      slot = slot + 1
     
      IF slot > MAXITEMS THEN
        slot = -1
        looping = FALSE
      END IF
   
      IF looping = TRUE THEN
        IF inventory(slot).occupied = FALSE THEN
          foundSpot = TRUE
        END IF
      END IF
    WEND
  END IF

  IF foundSpot = FALSE AND badGuy(badNumber%).chanceTime > 2 THEN
    LOCATE 2, 50
    COLOR 15, room(p.mapY, p.mapX).bgColor
    PRINT "NO ROOM IN YOUR INVENTORY!!!   "
    getItem% = FALSE
  END IF

  '<------------THE ACTUAL AQUIRING OF ITEMS--------------------->
  SELECT CASE badGuy(badNumber%).chanceTime

    CASE 0  'random amount of coin.
      coinAmount = INT(RND * (57 * (difficulty + 1))) + 1
      p.coin = p.coin + coinAmount
   
      LOCATE 2, 50
      COLOR 15, room(p.mapY, p.mapX).bgColor
      PRINT "Got "; coinAmount; " coin!      "
      getItem% = TRUE
      flagged = TRUE

    CASE 1 'hp potion
      IF p.hpPotions < 10 THEN
        p.hpPotions = p.hpPotions + 1
        text = "Got HP Potion!"
        getItem% = TRUE
        flagged = TRUE
      ELSE
        LOCATE 2, 50
        COLOR 15, room(p.mapY, p.mapX).bgColor
        text = "Already have max HP Potions!"
        getItem% = FALSE
      END IF

    CASE 2 'mp potion
      IF p.mpPotions < 10 THEN
        p.mpPotions = p.mpPotions + 1
        text = "Got MP Potion!"
        getItem% = TRUE
        flagged = TRUE
      ELSE
        text = "Already have max MP Potions! "
        getItem% = FALSE
      END IF
   
     

  END SELECT

  IF flagged = TRUE AND badGuy(badNumber%).chanceTime >= 1 THEN
    LOCATE 2, 50
    COLOR 15, room(p.mapY, p.mapX).bgColor
    PRINT text
  END IF

  IF flagged = TRUE THEN
    badGuy(badNumber%).chanceTime = -1 'reset it after used.
  END IF

END IF
END FUNCTION

SUB init

'initializes important global variables


difficulty = 1

'set up default room info

FOR x% = 0 TO 8
  FOR y% = 0 TO 8

    IF difficulty = 3 THEN
      room(y%, x%).bgColor = 2 + difficulty
    ELSE
      room(y%, x%).bgColor = 2
    END IF

    room(y%, x%).drawn = FALSE
    room(y%, x%).set = FALSE
    room(y%, x%).inArea = FALSE
    room(y%, x%).x = 4
    room(y%, x%).y = 0
    room(y%, x%).borderTop = 4
    room(y%, x%).borderBottom = 21
    room(y%, x%).borderLeft = 3
    room(y%, x%).borderRight = 78
    room(y%, x%).hasExitTop = TRUE
    room(y%, x%).hasExitBottom = TRUE
    room(y%, x%).hasExitLeft = TRUE
    room(y%, x%).hasExitRight = TRUE
    room(y%, x%).explored = FALSE
  NEXT y%
NEXT x%

'set move request to nothing.
moveRequest.flagged = FALSE
moveRequest.direction = -1

'set up basic player stats
p.handle = "ERROR!"
p.mapX = 3
p.mapY = 0
p.x = 15
p.y = 15
p.gfx = ""
p.badGuyTargeted = -1
p.range = 15
p.maxHP = 100
p.hp = p.maxHP
p.maxMP = 50
p.mp = p.maxMP
p.atp = 25
p.dfp = 15
p.mst = 10
p.speed = 2
p.coin = 100
p.hasReturn = TRUE  'no level on this bad boy.
p.fire = 0   'spell levels
p.ice = 0    'spell levels
p.dark = 0   'spell levels
p.heal = 0
p.alive = TRUE 'it better be!
p.lvl = 1
p.weaponName = "Enchanted Short Bow"
p.weaponRare = FALSE
p.armorName = "Archer's Leather Armor"
p.armorRare = FALSE
p.weaponATPBonus = 5
p.armorDFPBonus = 5
p.weaponMSTBonus = 5
p.weaponRNGBonus = 10
p.armorMSTBonus = 2
p.armorSPDBonus = 1
p.class = "Archer"
p.hpPotions = 5
p.mpPotions = 3
p.expToLevel = 500
p.expCurrent = 100
p.speedAugmentation = 0
p.exitedRoomDirection = -1
p.status = FINE

'initialize base inventory.
FOR i% = 0 TO MAXITEMS
  inventory(i%).occupied = TRUE
  inventory(i%).handle = ""
  inventory(i%).atp = 0
  inventory(i%).dfp = 0
  inventory(i%).mst = 0
  inventory(i%).range = 0
  inventory(i%).speed = 0
  inventory(i%).hp = 0
  inventory(i%).mp = 0
  inventory(i%).stars = 0
  inventory(i%).sellPrice = 0
  inventory(i%).classID = 0
  inventory(i%).typeID = WEAPON
  inventory(i%).atpReq = 0
  inventory(i%).mstReq = 0
  inventory(i%).description = ""
  equiped = FALSE
NEXT i%

numBadGuys = MAXBADGUYS

'set up default bad guy stats
FOR i% = 0 TO MAXBADGUYS
  badGuy(i%).x = 10
  badGuy(i%).y = 5
  badGuy(i%).hp = 50
  badGuy(i%).atp = 10
  badGuy(i%).dfp = 5
  badGuy(i%).range = 10
  badGuy(i%).inRange = FALSE
  badGuy(i%).badType = 0
  badGuy(i%).move = 5    'moves every 5 game ticks
  badGuy(i%).currentMove = 0
  badGuy(i%).gfxImg = CHR$(0)
  badGuy(i%).gfxColor = 10
  badGuy(i%).alive = TRUE
  badGuy(i%).expToGive = 10
  badGuy(i%).chanceTime = -1
NEXT i%

FOR i% = 0 TO MAXWALLSPOTS
  wallSpot(i%).y = 1
  wallSpot(i%).x = 1
NEXT i%

END SUB

SUB LevelPlayer

'called from the check events sub. This levels up the player when
'need be.

DIM hpUp AS INTEGER
DIM mpUp AS INTEGER
DIM atpUp AS INTEGER
DIM dfpUp AS INTEGER
DIM mstUp AS INTEGER

'different classes get different stats on level up.
IF p.classID = FIGHTER THEN
    hpUp = 5
    mpUp = 1
    atpUp = 5
    dfpUp = 4
    mstUp = 1

ELSEIF p.classID = ARCHER THEN
    hpUp = 3
    mpUp = 2
    atpUp = 3
    dfpUp = 5
    mstUp = 2

ELSEIF p.classID = MAGE THEN
    hpUp = 2
    mpUp = 5
    atpUp = 1
    dfpUp = 2
    mstUp = 5
END IF
   
'adding to their stats...
p.maxHP = p.maxHP + hpUp
p.maxMP = p.maxMP + mpUp
p.atpBase = p.atpBase + atpUp
p.dfpBase = p.dfpBase + dfpUp
p.mstBase = p.mstBase + mstUp
p.lvl = p.lvl + 1

'filling health and magic.
p.hp = p.maxHP
p.mp = p.maxMP

'setting next level up.
p.expToLevel = (p.expToLevel + (p.expToLevel \ 2)) * 2
p.expCurrent = 0

'the actual leveling up display.
  LOCATE 2, 20
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT "HP +"; hpUp; "MP +"; mpUp; "ATP +"; atpUp; "DFP +"; dfpUp; "MST +"; mstUp; "                      "
 
  'flashy-ness to catch players attention.
  DO
    FOR i% = 1 TO 15 STEP 1
      LOCATE 1, 22
      COLOR i%, room(p.mapY, p.mapX).bgColor
      PRINT "CONGRADULATIONS, LEVEL UP!                               "
    NEXT i%
  LOOP WHILE INKEY$ = ""
  p.expCurrent = 0

  LOCATE 1, 22
  COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
  PRINT "THIS IS A MAST OF WHAT WAS ONCE"
  LOCATE 2, 10
  PRINT "THIS IS A MASK OF WHAT WILL ONCE AGAIN COME BACK TO BE WHAT IT WAS"


END SUB

SUB loadMap

  OPEN "r11.map" FOR INPUT AS #1
    INPUT #1, room(0, 0).roomType, room(0, 1).roomType, room(0, 2).roomType, room(0, 3).roomType, room(0, 4).roomType, room(0, 5).roomType, room(0, 6).roomType, room(0, 7).roomType
    INPUT #1, room(1, 0).roomType, room(1, 1).roomType, room(1, 2).roomType, room(1, 3).roomType, room(1, 4).roomType, room(1, 5).roomType, room(1, 6).roomType, room(1, 7).roomType
    INPUT #1, room(2, 0).roomType, room(2, 1).roomType, room(2, 2).roomType, room(2, 3).roomType, room(2, 4).roomType, room(2, 5).roomType, room(2, 6).roomType, room(2, 7).roomType
    INPUT #1, room(3, 0).roomType, room(3, 1).roomType, room(3, 2).roomType, room(3, 3).roomType, room(3, 4).roomType, room(3, 5).roomType, room(3, 6).roomType, room(3, 7).roomType
    INPUT #1, room(4, 0).roomType, room(4, 1).roomType, room(4, 2).roomType, room(4, 3).roomType, room(4, 4).roomType, room(4, 5).roomType, room(4, 6).roomType, room(4, 7).roomType
    INPUT #1, room(5, 0).roomType, room(5, 1).roomType, room(5, 2).roomType, room(5, 3).roomType, room(5, 4).roomType, room(5, 5).roomType, room(5, 6).roomType, room(5, 7).roomType
    INPUT #1, room(6, 0).roomType, room(6, 1).roomType, room(6, 2).roomType, room(6, 3).roomType, room(6, 4).roomType, room(6, 5).roomType, room(6, 6).roomType, room(6, 7).roomType
    INPUT #1, room(7, 0).roomType, room(7, 1).roomType, room(7, 2).roomType, room(7, 3).roomType, room(7, 4).roomType, room(7, 5).roomType, room(7, 6).roomType, room(7, 7).roomType

  CLOSE #1


END SUB

SUB loadPlayerData

'loads player data from the temp file to be used in the level

  OPEN "temp.dat" FOR INPUT AS #1
    INPUT #1, p.gfx, p.rangeBase, p.maxHP, p.maxMP
    INPUT #1, p.atpBase, p.dfpBase, p.mstBase, p.speedBase
    INPUT #1, p.coin, p.hasReturn, p.fire, p.ice
    INPUT #1, p.dark, p.heal, p.alive, p.handle
    INPUT #1, p.hp, p.mp, p.lvl, p.weaponName
    INPUT #1, p.weaponRare, p.armorName, p.armorRare
    INPUT #1, p.weaponATPBonus, p.armorDFPBonus
    INPUT #1, p.weaponMSTBonus, p.weaponRNGBonus
    INPUT #1, p.armorMSTBonus, p.armorSPDBonus
    INPUT #1, p.weaponHPBonus, p.weaponMPBonus
    INPUT #1, p.armorMPBonus, p.armorMPBonus
    INPUT #1, p.class, p.classID, p.hpPotions, p.mpPotions
    INPUT #1, p.expToLevel, p.expCurrent, p.status
  CLOSE #1

'loads inventory from seperate file (seperate data structure)
   
  OPEN "inventry.dat" FOR INPUT AS #2
    FOR i% = 0 TO MAXITEMS
      INPUT #2, inventory(i%).occupied, inventory(i%).handle
      INPUT #2, inventory(i%).atp, inventory(i%).dfp, inventory(i%).mst
      INPUT #2, inventory(i%).range, inventory(i%).speed
      INPUT #2, inventory(i%).hp, inventory(i%).mp
      INPUT #2, inventory(i%).stars, inventory(i%).sellPrice
      INPUT #2, inventory(i%).classID, inventory(i%).typeID
      INPUT #2, inventory(i%).atpReq, inventory(i%).mstReq, inventory(i%).lvlReq
      INPUT #2, inventory(i%).description, inventory(i%).equiped
    NEXT i%
  CLOSE #2
   



END SUB

SUB maskBadGuy (badGuyNumber%, maskBg%, maskMarker%)

'mask current locale.
IF maskBg% = TRUE THEN
  LOCATE badGuy(badGuyNumber%).y, badGuy(badGuyNumber%).x
  COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
  PRINT "U"
END IF

'mask head marker if any
IF maskMarker% = TRUE THEN
  LOCATE badGuy(badGuyNumber%).y - 1, badGuy(badGuyNumber%).x
  COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
  PRINT "U"
END IF

END SUB

SUB moveBadGuy (badGuyNumber%)

'moves the bad guy specified by the param. Calls mask sub in begining and
'draw sub in end.
'
' will only move bad guy if it's his turn to move. (Specified by the move
' stats built into the ENEMY type.)

'first make sure they're even alive...
IF badGuy(badGuyNumber%).alive = TRUE THEN

  'if it's his turn to move...
  IF badGuy(badGuyNumber%).currentMove >= badGuy(badGuyNumber%).move THEN

    'mask old locale.
    CALL maskBadGuy(badGuyNumber%, TRUE, TRUE)

    'move him on the X plane
    IF badGuy(badGuyNumber%).x > p.x THEN
      badGuy(badGuyNumber%).x = badGuy(badGuyNumber%).x - 1
      IF badGuy(badGuyNumber%).x = p.x THEN
        badGuy(badGuyNumber%).x = badGuy(badGuyNumber%).x + 1
      END IF
    ELSEIF badGuy(badGuyNumber%).x < p.x THEN
      badGuy(badGuyNumber%).x = badGuy(badGuyNumber%).x + 1
      IF badGuy(badGuyNumber%).x = p.x THEN
        badGuy(badGuyNumber%).x = badGuy(badGuyNumber%).x - 1
      END IF
    END IF

    'move him on the Y plane
    IF badGuy(badGuyNumber%).y > p.y THEN
      badGuy(badGuyNumber%).y = badGuy(badGuyNumber%).y - 1
      IF badGuy(badGuyNumber%).y = p.y THEN
        badGuy(badGuyNumber%).y = badGuy(badGuyNumber%).y + 1
      END IF

    ELSEIF badGuy(badGuyNumber%).y < p.y THEN
      badGuy(badGuyNumber%).y = badGuy(badGuyNumber%).y + 1
      IF badGuy(badGuyNumber%).y = p.y THEN
        badGuy(badGuyNumber%).y = badGuy(badGuyNumber%).y - 1
      END IF
    END IF

    'draw badguy in new location
    CALL drawBadGuy(badGuyNumber%)

    'reset enemy's current move number back to zero
    badGuy(badGuyNumber%).currentMove = 0

  'if it's not the bad guys turn to move. increase his current move number so
  'that he has to wait.
  ELSE
    badGuy(badGuyNumber%).currentMove = badGuy(badGuyNumber%).currentMove + 1
  END IF
END IF

END SUB

SUB movePlayer (direction%)

'masks and moves player in the passed direction.

  'mask current location
  LOCATE p.y, p.x
  COLOR room(p.mapY, p.mapX).bgColor, room(p.mapY, p.mapX).bgColor
  PRINT p.gfx

  SELECT CASE direction%
 
    'left movement
    CASE LEFT
      IF p.speedAugmentation >= 0 THEN
        p.x = p.x - p.speedAugmentation
      ELSE
        p.x = p.x - p.speed
      END IF

    CASE RIGHT
      IF p.speedAugmentation >= 0 THEN
        p.x = p.x + p.speedAugmentation
      ELSE
        p.x = p.x + p.speed
      END IF

    CASE UP
      IF p.speedAugmentation >= 0 THEN
        p.y = p.y - p.speedAugmentation
      ELSE
        p.y = p.y - p.speed
      END IF

    CASE DOWN
      IF p.speedAugmentation >= 0 THEN
        p.y = p.y + p.speedAugmentation
      ELSE
        p.y = p.y + p.speed
      END IF

    CASE ELSE
      LOCATE 4, 1
      COLOR 15, room(p.mapY, p.mapX).bgColor
      PRINT "ERROR READING PLAYER DIRECTION!"

  END SELECT

  'draw character at new location
  LOCATE p.y, p.x
  COLOR 15, room(p.mapY, p.mapX).bgColor
  PRINT p.gfx

  IF p.speedAugmentation >= 0 THEN
    p.speedAugmentation = -1
  END IF

  'they get hurt walking if they're poisoned.
  IF p.status = POISONED THEN
    p.hp = p.hp - 1
  END IF

END SUB

SUB resetRoomData (row%, column%)


'resets the room the player is about to enter so that it doesn't get all
'funky from other room's variables.


  room(row%, column%).numBadGuys = NONE
  room(row%, column%).numWallSpots = NONE
  
  
  




END SUB

SUB roomExit (direction%)

'so it resets the area
room(p.mapY, p.mapX).inArea = FALSE

SELECT CASE direction%
  
  CASE LEFT
    p.x = 78
    p.mapX = p.mapX - 1

  CASE RIGHT
    p.x = 4
    p.mapX = p.mapX + 1

  CASE UP
    p.y = 21
    p.mapY = p.mapY - 1

  CASE DOWN
    p.y = 4
    p.mapY = p.mapY + 1


END SELECT

END SUB

SUB saveAndChain

'this saves the players current stats and such. It then continues to chain
'the game back to the main village. It is used by the return spell and the
'end of level return.

'for now it's just player.dat, it will be temp.dat again after this area
'source is complete.

  OPEN "player.dat" FOR OUTPUT AS #2
    WRITE #2, p.gfx, p.range, p.maxHP, p.maxMP
    WRITE #2, p.atp, p.dfp, p.mst, p.speed
    WRITE #2, p.coin, p.hasReturn, p.fire, p.ice
    WRITE #2, p.dark, p.heal, p.alive, p.handle
    WRITE #2, p.hp, p.mp, p.lvl, p.weaponName
    WRITE #2, p.weaponRare, p.armorName, p.armorRare, p.weaponATPBonus
    WRITE #2, p.weaponATPBonus, p.armorDFPBonus
    WRITE #2, p.weaponMSTBonus, p.weaponRNGBonus
    WRITE #2, p.armorMSTBonus, p.armorSPDBonus
    WRITE #2, p.class, p.hpPotions, p.mpPotions
    WRITE #2, p.expToLevel, p.expCurrent
  CLOSE #2

'not chaining until area source complete
'CHAIN "village.hb"

COLOR 7, 0
CLS
END  'for now it just exits

END SUB

FUNCTION setData%
  'Set data handles the generics that are for all rooms, the child sub
  '"setRoomData(y,x)" handles room specifics.


  DIM errorHappened AS INTEGER
  errorHappened = FALSE

  CALL resetRoomData(p.mapY, p.mapX) 'make it fresh!
  CALL setRoomData(p.mapY, p.mapX)

  'set enemy stats depending on type selected above.
  IF room(p.mapY, p.mapX).numBadGuys > NONE THEN
    FOR i% = 0 TO room(p.mapY, p.mapX).numBadGuys

      SELECT CASE badGuy(i%).badType
   
        CASE 0   'zombie
          badGuy(i%).hp = 20
          badGuy(i%).atp = 30
          badGuy(i%).dfp = 15
          badGuy(i%).range = 35
          badGuy(i%).move = 5      'moves every 5 game ticks
          badGuy(i%).expToGive = 5 * (difficulty * 2)
          IF difficulty = 3 THEN
            badGuy(i%).gfxColor = 10 + difficulty
          ELSE
            badGuy(i%).gfxColor = 10
          END IF
          badGuy(i%).gfxImg = CHR$(2)
     
        CASE 1   'harder zombie
          badGuy(i%).hp = 30
          badGuy(i%).atp = 35
          badGuy(i%).dfp = 17
          badGuy(i%).range = 35
          badGuy(i%).move = 4
          badGuy(i%).expToGive = 7 * (difficulty * 2)
          IF difficulty = 3 THEN
            badGuy(i%).gfxColor = 10 + difficulty
          ELSE
            badGuy(i%).gfxColor = 10
          END IF
          badGuy(i%).gfxImg = CHR$(1)
    
        CASE 2   'hardest zombie
          badGuy(i%).hp = 40
          badGuy(i%).atp = 40
          badGuy(i%).dfp = 18
          badGuy(i%).range = 35
          badGuy(i%).move = 3
          badGuy(i%).expToGive = 10 * (difficulty * 2)
          IF difficulty = 3 THEN
            badGuy(i%).gfxColor = 8 + difficulty
          ELSE
            badGuy(i%).gfxColor = 8
          END IF
          badGuy(i%).gfxImg = CHR$(1)

        CASE 3   'ghoul
          badGuy(i%).hp = 50
          badGuy(i%).atp = 50
          badGuy(i%).dfp = 20
          badGuy(i%).range = 30
          badGuy(i%).move = 1
          badGuy(i%).expToGive = 13 * (difficulty * 2)
          IF difficulty = 3 THEN
            badGuy(i%).gfxColor = 4 + difficulty
          ELSE
            badGuy(i%).gfxColor = 4
          END IF
          badGuy(i%).gfxImg = ""

        CASE 4   'creeper
          badGuy(i%).hp = 15
          badGuy(i%).atp = 25
          badGuy(i%).dfp = 15
          badGuy(i%).range = 50
          badGuy(i%).move = 1
          badGuy(i%).expToGive = 3 * (difficulty * 2)
          IF difficulty = 3 THEN
            badGuy(i%).gfxColor = 14 + difficulty
          ELSE
            badGuy(i%).gfxColor = 14
          END IF
          badGuy(i%).gfxImg = ""


        CASE CRATE   'crate
          badGuy(i%).hp = 1
          badGuy(i%).atp = 0
          badGuy(i%).dfp = 0
          badGuy(i%).range = p.range
          badGuy(i%).move = 0
          badGuy(i%).expToGive = 0
          badGuy(i%).gfxColor = 8
          badGuy(i%).gfxImg = ""
 
        CASE NPC
          badGuy(i%).hp = 1000
          badGuy(i%).atp = 0
          badGuy(i%).dfp = 0
          badGuy(i%).range = p.range
          badGuy(i%).move = 0
          badGuy(i%).expToGive = 0
          badGuy(i%).gfxColor = 15
          badGuy(i%).gfxImg = ""
          badGuy(i%).talkText = "Lost Villager: I'M SCARED!!!"
       
     
        CASE ELSE 'unknown enemy type entered
          LOCATE 4, 1
          COLOR 15, bgColor
          PRINT "ERROR: UNKNOWN ENEMY TYPE!"
      END SELECT
   
      'all enemy's start at move zero.
      badGuy(i%).currentMove = 0
      badGuy(i%).alive = TRUE
      badGuy(i%).opened = FALSE
    NEXT i%
  END IF

  IF room(p.mapY, p.mapX).numWallSpots > NONE THEN
    FOR i% = 0 TO room(p.mapY, p.mapX).numWallSpots
      SELECT CASE wallSpot(i%).wallType

        CASE WALL1
          wallSpot(i%).range = p.speed
          wallSpot(i%).gfxColor = 8
          wallSpot(i%).gfxImg = "U"

        CASE WALL2
          wallSpot(i%).range = p.speed
          wallSpot(i%).gfxColor = 10
          wallSpot(i%).gfxImg = ""
      END SELECT
    NEXT i%
  END IF

  'set the return to true
  setData% = TRUE

END FUNCTION

SUB setRoomData (row%, column%)

'called from the set data sub. This sets the exits of rooms based on their
'type. The type is set by the map file loaded in at area entrance.

'based on the room type, there's a set number of bad guys and wall spots.
'this is also set here. This basically sets information to be further set
'up by the setData sub.

SELECT CASE room(row%, column%).roomType
  CASE 0 'void space
    LOCATE 15, 15
    COLOR 15, room(row%, column%).bgColor
    PRINT "YOU'VE ENTERED VOID SPACE! MAP FILE IS MOST LIKELY CORRUPT!"
 

  CASE 1  'start room bottom exit room surrounded by trees.
    room(p.mapY, p.mapX).bgColor = 2
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = FALSE
    room(p.mapY, p.mapX).numBadGuys = 3     'one less b/c array starts at zero.
    room(p.mapY, p.mapX).numWallSpots = 1
    badGuyLoopType% = 1 '(0 - 1 bad Guy types)
    numOfRandomBadGuys% = 0

    wallSpot(0).x = 29
    wallSpot(0).y = 21
    wallSpot(0).wallType = WALL1
  
    wallSpot(1).x = 50
    wallSpot(1).y = 21
    wallSpot(1).wallType = WALL1

    badGuy(1).x = 60
    badGuy(1).y = 20
    badGuy(1).badType = CRATE

    badGuy(2).x = 62
    badGuy(2).y = 20
    badGuy(2).badType = CRATE

    badGuy(3).x = 20
    badGuy(3).y = 10
    badGuy(3).badType = NPC


  CASE 2  'bottom & top exit room, trees.
    room(p.mapY, p.mapX).bgColor = 2
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = FALSE
    room(p.mapY, p.mapX).numBadGuys = 5
    room(p.mapY, p.mapX).numWallSpots = 3
    badGuyLoopType% = 2
    numOfRandomBadGuys% = 3
   
    wallSpot(0).x = 29
    wallSpot(0).y = 4
    wallSpot(0).wallType = WALL1
   
    wallSpot(1).x = 50
    wallSpot(1).y = 4
    wallSpot(1).wallType = WALL1

    wallSpot(2).x = 29
    wallSpot(2).y = 21
    wallSpot(2).wallType = WALL1

    wallSpot(3).x = 50
    wallSpot(3).y = 21
    wallSpot(3).wallType = WALL1

    badGuy(4).x = 10
    badGuy(4).y = 20
    badGuy(4).badType = CRATE

    badGuy(5).x = 60
    badGuy(5).y = 20
    badGuy(5).badType = CRATE

  CASE 3  'three way inside room. left, up, right
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = TRUE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 4  'inside room with left and right exits
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = TRUE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 5  'inside room with left and bottom exits
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = TRUE
    room(p.mapY, p.mapX).hasExitRight = FALSE

  CASE 6  'inside room w/ exits top and bottom.
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = FALSE

  CASE 7  'inside 4 direction room.
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = TRUE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 8  'outside room with only exit to right.
    room(p.mapY, p.mapX).bgColor = 2
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 9  'outside room with only exit on top.
    room(p.mapY, p.mapX).bgColor = 2
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = FALSE
 
  CASE 10  'inside room with two exits, bottom and right.
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = TRUE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 11  'inside room w/ exits top and right
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = TRUE

  CASE 12  'outside room with exit on top.
    room(p.mapY, p.mapX).bgColor = 2
    room(p.mapY, p.mapX).hasExitTop = TRUE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = FALSE
    room(p.mapY, p.mapX).hasExitRight = FALSE

  CASE 13  'inside room with left exit only
    room(p.mapY, p.mapX).bgColor = 7
    room(p.mapY, p.mapX).hasExitTop = FALSE
    room(p.mapY, p.mapX).hasExitBottom = FALSE
    room(p.mapY, p.mapX).hasExitLeft = TRUE
    room(p.mapY, p.mapX).hasExitRight = FALSE

END SELECT

'randomly set bad guy data
FOR i% = 0 TO numOfRandomBadGuys%
  badGuy(i%).x = INT(RND * 70) + 4
  badGuy(i%).y = INT(RND * 17) + 4
  badGuy(i%).badType = INT(RND * badGuyLoopType%)
NEXT i%

'set the current area to explored for player's map.
room(p.mapY, p.mapX).explored = TRUE

END SUB

SUB showDetailedInventory

'displays what the player has in their inventory, weapons and such. At
'this screen they can access another item specific information screen
'where they can equip/unequip/use and drop items. This screen also displays
'the area map.

DIM dWaiting AS INTEGER
DIM dInLoop AS INTEGER
DIM cursorPOS AS INTEGER

dInLoop = TRUE
cursorPOS = 4

WHILE dInLoop = TRUE

CLS

'show map on right side.
CALL showMap

'actual inventory part of the screen.

COLOR 15, 7
LOCATE 20, 5
PRINT "Press Q or B to go back."
LOCATE 21, 5
PRINT "Press ENTER to equip/view item"

LOCATE 2, 40
COLOR 1, 7
PRINT "INVENTORY"
LOCATE 3, 39
PRINT ""

FOR i% = 0 TO MAXITEMS
  LOCATE i% + 4, 43
  IF inventory(i%).occupied = TRUE THEN
    IF inventory(i%).equiped = TRUE THEN
      COLOR 9, 7
    ELSE
      COLOR 1, 7
    END IF
    PRINT inventory(i%).handle
  ELSE
    COLOR 1, 7
    PRINT "---"
  END IF
NEXT i%


'draw initial cursor
LOCATE cursorPOS, 40
COLOR 4, 7
PRINT "-"


  dWaiting = TRUE
  
  DO
    f$ = INKEY$
    IF f$ = CHR$(0) + CHR$(72) THEN 'down arrow pressed
   
      'mask
      LOCATE cursorPOS, 40
      COLOR 7, 7
      PRINT "-"
   
      'move
      cursorPOS = cursorPOS - 1
      IF cursorPOS < 4 THEN cursorPOS = 4
   
      'redraw
      LOCATE cursorPOS, 40
      COLOR 4, 7
      PRINT "-"
    END IF

    IF f$ = CHR$(0) + CHR$(80) THEN
      'mask
      LOCATE cursorPOS, 40
      COLOR 7, 7
      PRINT "-"
  
      'move
      cursorPOS = cursorPOS + 1
      IF cursorPOS > MAXITEMS + 4 THEN cursorPOS = MAXITEMS + 4
  
      'redraw
      LOCATE cursorPOS, 40
      COLOR 4, 7
      PRINT "-"
    END IF

    IF f$ = CHR$(13) THEN
      IF inventory(cursorPOS - 4).occupied = TRUE THEN
        dWaiting = FALSE
        CALL showItemInfo(cursorPOS - 4) 'sends inventory item #
      END IF
    END IF

    IF f$ = "q" OR f$ = "Q" OR f$ = "b" OR f$ = "B" THEN
      dWaiting = FALSE
      dInLoop = FALSE
    END IF

  LOOP WHILE dWaiting = TRUE

WEND 'exit stats

END SUB

SUB showItemInfo (itemNum%)

'this is called from the detailed inventory screen. (quite a nested sub
'if you ask me) and displays even more detailed information about the
'selected item.

DIM newATP AS INTEGER
DIM newDFP AS INTEGER
DIM newMST AS INTEGER
DIM newRANGE AS INTEGER
DIM newSPEED AS INTEGER
DIM itemLoop AS INTEGER
DIM doneHere AS INTEGER
DIM selected AS INTEGER

doneHere = FALSE
selected = FALSE

'Item attrib legend.
'-------------------
'ATP -> Weapon
'DFP -> Armor
'MST -> Weapon + Armor
'RNG -> Weapon
'SPD -> ARMOR

WHILE doneHere = FALSE

itemLoop = TRUE

IF inventory(itemNum%).typeID = WEAPON AND inventory(itemNum%).equiped = FALSE THEN
  newATP = p.atpBase + inventory(itemNum%).atp
  newDFP = p.dfp
  newMST = p.mstBase + inventory(itemNum%).mst + p.armorMSTBonus
  newRANGE = p.rangeBase + inventory(itemNum%).range
  newSPEED = p.speed
ELSEIF inventory(itemNum%).typeID = WEAPON AND inventory(itemNum%).equiped = TRUE THEN
  newATP = p.atpBase
  newDFP = p.dfp
  newMST = p.mstBase + p.armorMSTBonus
  newRANGE = p.rangeBase
  newSPEED = p.speed

ELSEIF inventory(itemNum%).typeID = ARMOR AND inventory(itemNum%).equiped = FALSE THEN
  newATP = p.atp
  newDFP = p.dfpBase + inventory(itemNum%).dfp
  newMST = p.mstBase + inventory(itemNum%).mst + p.weaponMSTBonus
  newRANGE = p.range
  newSPEED = p.speedBase + inventory(itemNum%).speed

ELSEIF inventory(itemNum%).typeID = ARMOR AND inventory(itemNum%).equiped = TRUE THEN
  newATP = p.atp
  newDFP = p.dfpBase
  newMST = p.mstBase + p.weaponMSTBonus
  newRANGE = p.range
  newSPEED = p.speedBase

END IF

CLS

COLOR 1, 7
LOCATE 2, 30
PRINT "ITEM INFO"
LOCATE 3, 29
PRINT ""

IF inventory(itemNum%).typeID >= ANTIDOTEPOTION THEN
  LOCATE 4, 9
  COLOR 1, 7
  PRINT "Name:"
  LOCATE 4, 15
  COLOR 15, 7
  PRINT inventory(itemNum%).handle
 
  LOCATE 5, 3
  COLOR 1, 7
  PRINT "Sell Price:"
  LOCATE 5, 14
  COLOR 15, 7
  PRINT inventory(itemNum%).sellPrice
 
  LOCATE 6, 2
  COLOR 1, 7
  PRINT "Description: "
  LOCATE 7, 2
  COLOR 15, 7
  PRINT inventory(itemNum%).description

ELSE

LOCATE 4, 10
COLOR 1, 7
PRINT "Name:"
LOCATE 4, 16
COLOR 15, 7
PRINT inventory(itemNum%).handle


LOCATE 5, 9
COLOR 1, 7
PRINT "Class: "
LOCATE 5, 16
COLOR 15, 7
SELECT CASE inventory(itemNum%).classID
  CASE FIGHTER
    PRINT "Fighter"
  CASE ARCHER
    PRINT "Archer"
  CASE MAGE
    PRINT "Mage"
  CASE ALL
    PRINT "All"
END SELECT

LOCATE 6, 12
COLOR 1, 7
PRINT "HP: "
LOCATE 6, 15
IF inventory(itemNum%).equiped = TRUE THEN
  IF inventory(itemNum%).hp >= 0 THEN
    COLOR 15, 7
    PRINT "-"; inventory(itemNum%).hp
  ELSE
    COLOR 4, 7
    PRINT -(inventory(itemNum%).hp)
  END IF
ELSE
  IF inventory(itemNum%).hp >= 0 THEN
    COLOR 15, 7
    PRINT "+"; inventory(itemNum%).hp
  ELSE
    COLOR 4, 7
    PRINT inventory(itemNum%).hp
  END IF
END IF

LOCATE 7, 12
COLOR 1, 7
PRINT "MP: "
LOCATE 7, 15
IF inventory(itemNum%).equiped = TRUE THEN
  IF inventory(itemNum%).mp >= 0 THEN
    COLOR 15, 7
    PRINT "-"; inventory(itemNum%).mp
  ELSE
    COLOR 4, 7
    PRINT -(inventory(itemNum%).mp)
  END IF
ELSE
  IF inventory(itemNum%).mp >= 0 THEN
    COLOR 15, 7
    PRINT "+"; inventory(itemNum%).mp
  ELSE
    COLOR 4, 7
    PRINT inventory(itemNum%).mp
  END IF
END IF

LOCATE 8, 4
COLOR 1, 7
PRINT "Sell Price: "
LOCATE 8, 16
COLOR 15, 7
PRINT inventory(itemNum%).sellPrice

LOCATE 9, 8
COLOR 1, 7
PRINT "Rarity: "
COLOR 15, 7
FOR i% = 0 TO (inventory(itemNum%).stars - 1)
  LOCATE 9, 17 + i%
  IF i% < 3 THEN
    COLOR 15, 7
  ELSEIF i% >= 3 AND i% < 6 THEN
    COLOR 14, 7
  ELSEIF i% >= 6 AND i% < 9 THEN
    COLOR 6, 7
  ELSE
    COLOR 4, 7
  END IF
  PRINT ""
NEXT i%


'top right side information
LOCATE 4, 45
COLOR 1, 7
PRINT "ATP:"
LOCATE 4, 51
IF newATP < p.atp THEN
  COLOR 11, 7
ELSEIF newATP > p.atp THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.atp; "("; p.atpBase; ") - "; newATP; "("; p.atpBase; ")"


LOCATE 5, 45
COLOR 1, 7
PRINT "DFP:"
LOCATE 5, 51
IF newDFP < p.dfp THEN
  COLOR 11, 7
ELSEIF newDFP > p.dfp THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.dfp; "("; p.dfpBase; ") - "; newDFP; "("; p.dfpBase; ")"


LOCATE 6, 45
COLOR 1, 7
PRINT "MST:"
LOCATE 6, 51
IF newMST < p.mst THEN
  COLOR 11, 7
ELSEIF newMST > p.mst THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.mst; "("; p.mstBase; ") - "; newMST; "("; p.mstBase; ")"


LOCATE 7, 45
COLOR 1, 7
PRINT "RNG:"
LOCATE 7, 51
IF newRANGE < p.range THEN
  COLOR 11, 7
ELSEIF newRANGE > p.range THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.range; "("; p.rangeBase; ") - "; newRANGE; "("; p.rangeBase; ")"

LOCATE 8, 45
COLOR 1, 7
PRINT "SPD:"
LOCATE 8, 51
IF newSPEED < p.speed THEN
  COLOR 11, 7
ELSEIF newSPEED > p.speed THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.speed; "("; p.speedBase; ") - "; newSPEED; "("; p.speedBase; ")"

LOCATE 9, 36
COLOR 1, 7
IF inventory(itemNum%).typeID = WEAPON THEN
  IF inventory(itemNum%).classID = MAGE THEN
    PRINT "MST Required:"
  ELSE
    PRINT "ATP Required:"
  END IF
  LOCATE 9, 51
  COLOR 15, 7
  IF inventory(itemNum%).classID = MAGE THEN
    PRINT inventory(itemNum%).mstReq
  ELSE
    PRINT inventory(itemNum%).atpReq
  END IF

ELSEIF inventory(itemNum%).typeID = ARMOR THEN
  PRINT "Lvl Required:"
  LOCATE 9, 51
  COLOR 15, 7
  PRINT inventory(itemNum%).lvlReq

END IF


LOCATE 10, 41
COLOR 1, 7
PRINT "Equiped:"
LOCATE 10, 52
COLOR 15, 7
IF inventory(itemNum%).equiped = TRUE THEN
  PRINT "Yes"
ELSE
  PRINT "No"
END IF

LOCATE 11, 3
COLOR 1, 7
PRINT "Description:"
LOCATE 12, 3
COLOR 15
PRINT inventory(itemNum%).description

END IF 'for weapon / armor typeID display
'info menu
COLOR 4, 7
LOCATE 18, 35

IF inventory(itemNum%).typeID = WEAPON OR inventory(itemNum%).typeID = ARMOR THEN
  IF inventory(itemNum%).equiped = FALSE THEN
    PRINT "(E)quip"
  ELSE
    PRINT "(U)nequip"
  END IF
ELSE
  PRINT "(U)se"
END IF

LOCATE 19, 35
PRINT "(D)rop"
LOCATE 20, 35
PRINT "(B)ack"

DO
  a$ = INKEY$

  'unequiped an equiped weapon.
  IF (a$ = "U" OR a$ = "u") AND inventory(itemNum%).typeID <= ARMOR AND inventory(itemNum%).equiped = TRUE THEN
   
    IF inventory(itemNum%).typeID = WEAPON THEN
      p.weaponHPBonus = 0
      p.weaponMPBonus = 0
      p.weaponATPBonus = 0
      p.weaponMSTBonus = 0
      p.weaponRNGBonus = 0
      p.weaponName = "-"
      p.weaponRare = FALSE


    ELSEIF inventory(itemNum%).typeID = ARMOR THEN
      p.armorHPBonus = 0
      p.armorMPBonus = 0
      p.armorDFPBonus = 0
      p.armorMSTBonus = 0
      p.armorSPDBonus = 0
      p.armorName = "-"
      p.armorRare = FALSE
    
    END IF

    inventory(itemNum%).equiped = FALSE
    itemLoop = FALSE
    doneHere = FALSE
    selected = TRUE
    CALL calculateStats
  END IF

  'equip an unequiped weapon
  IF (a$ = "E" OR a$ = "e") AND inventory(itemNum%).typeID = WEAPON AND inventory(itemNum%).equiped = FALSE THEN
    IF inventory(itemNum%).classID < ALL AND inventory(itemNum%).classID <> p.classID THEN
      LOCATE 10, 10
      COLOR 15, 7
      PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      LOCATE 11, 10
      PRINT "   You CAN NOT equip this! It is not of your class!   "
      LOCATE 12, 10
      PRINT "                  Press any Key...                    "
      LOCATE 13, 10
      PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      DO
      LOOP WHILE INKEY$ = ""
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
   
    ELSEIF inventory(itemNum%).classID = MAGE AND inventory(itemNum%).mstReq > p.mstBase THEN
      LOCATE 10, 10
      COLOR 15, 7
      PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      LOCATE 11, 10
      PRINT "        More MST is needed to equip this item!        "
      LOCATE 12, 10
      PRINT "                  Press any Key...                    "
      LOCATE 13, 10
      PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      DO
      LOOP WHILE INKEY$ = ""
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
   
    ELSEIF inventory(itemNum%).classID <> MAGE AND inventory(itemNum%).atpReq > p.atpBase THEN
      LOCATE 10, 10
      COLOR 15, 7
      PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      LOCATE 11, 10
      PRINT "        More ATP is needed to equip this item!        "
      LOCATE 12, 10
      PRINT "                  Press any Key...                    "
      LOCATE 13, 10
      PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      DO
      LOOP WHILE INKEY$ = ""
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE

    ELSE
      'set any other weapon equiped to false.
      FOR i% = 0 TO MAXITEMS
        IF inventory(i%).typeID = WEAPON THEN
          IF inventory(i%).equiped = TRUE THEN
            inventory(i%).equiped = FALSE
          END IF
        END IF
      NEXT i%
     
      p.weaponHPBonus = inventory(itemNum%).hp
      p.weaponMPBonus = inventory(itemNum%).mp
      p.weaponATPBonus = inventory(itemNum%).atp
      p.weaponMSTBonus = inventory(itemNum%).mst
      p.weaponRNGBonus = inventory(itemNum%).range
      p.weaponName = inventory(itemNum%).handle
      IF inventory(itemNum%).stars >= 9 THEN
        p.weaponRare = TRUE
      ELSE
        p.weaponRare = FALSE
      END IF

      inventory(itemNum%).equiped = TRUE
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
      CALL calculateStats
    END IF
    

  'equip ARMOR
  ELSEIF (a$ = "E" OR a$ = "e") AND inventory(itemNum%).typeID = ARMOR AND inventory(itemNum%).equiped = FALSE THEN
    IF inventory(itemNum%).classID < ALL AND inventory(itemNum%).classID <> p.classID THEN
      LOCATE 10, 10
      COLOR 15, 7
      PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      LOCATE 11, 10
      PRINT "   You CAN NOT equip this! It is not of your class!   "
      LOCATE 12, 10
      PRINT "                  Press any Key...                    "
      LOCATE 13, 10
      PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      DO
      LOOP WHILE INKEY$ = ""
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
  
    ELSEIF inventory(itemNum%).lvlReq > p.lvl THEN
      LOCATE 10, 10
      COLOR 15, 7
      PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      LOCATE 11, 10
      PRINT "      Not high enough level to equip this item!       "
      LOCATE 12, 10
      PRINT "                  Press any Key...                    "
      LOCATE 13, 10
      PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
      DO
      LOOP WHILE INKEY$ = ""
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
  

    ELSE
      'set all any other armor equiped to false.
      FOR i% = 0 TO MAXITEMS
        IF inventory(i%).typeID = ARMOR THEN
          IF inventory(i%).equiped = TRUE THEN
            inventory(i%).equiped = FALSE
          END IF
        END IF
      NEXT i%

      p.armorHPBonus = inventory(itemNum%).hp
      p.armorMPBonus = inventory(itemNum%).mp
      p.armorDFPBonus = inventory(itemNum%).dfp
      p.armorMSTBonus = inventory(itemNum%).mst
      p.armorSPDBonus = inventory(itemNum%).speed
      p.armorName = inventory(itemNum%).handle
      IF inventory(itemNum%).stars >= 9 THEN
        p.armorRare = TRUE
      ELSE
        p.armorRare = FALSE
      END IF

      inventory(itemNum%).equiped = TRUE
      itemLoop = FALSE
      doneHere = FALSE
      selected = TRUE
      CALL calculateStats
    END IF


  END IF


  IF (a$ = "U" OR a$ = "u") AND inventory(itemNum%).typeID = ANTIDOTEPOTION THEN
    LOCATE 10, 10
    COLOR 15, 7
    PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    LOCATE 11, 10
    PRINT "          Are you SURE you want to do this?           "
    LOCATE 12, 10
    PRINT "                      (Y/N)                           "
    LOCATE 13, 10
    PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    selected = FALSE
    DO
      abc$ = INKEY$
      IF abc$ = "Y" OR abc$ = "y" THEN
        itemLoop = FALSE
        doneHere = TRUE
        selected = TRUE
        inventory(itemNum%).occupied = FALSE
        p.status = FINE
      ELSEIF abc$ = "N" OR abc$ = "n" THEN
        itemLoop = FALSE
        doneHere = FALSE
        selected = TRUE
      END IF
    LOOP WHILE selected = FALSE
  END IF

  IF (a$ = "U" OR a$ = "u") AND inventory(itemNum%).typeID = RETURNPOTION THEN
    LOCATE 10, 10
    COLOR 15, 7
    PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    LOCATE 11, 10
    PRINT " WARNING: Doing this you will return straight to town "
    LOCATE 12, 10
    PRINT "          Are you SURE you want to do this?           "
    LOCATE 13, 10
    PRINT "                      (Y/N)                           "
    LOCATE 14, 10
    PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    LOCATE 11, 12
    COLOR 4, 7
    PRINT "WARNING:"
    selected = FALSE
    DO
      abc$ = INKEY$
      IF abc$ = "Y" OR abc$ = "y" THEN
        itemLoop = FALSE
        doneHere = TRUE
        selected = TRUE
        inventory(itemNum%).occupied = FALSE
        CALL saveAndChain
      ELSEIF abc$ = "N" OR abc$ = "n" THEN
        itemLoop = FALSE
        doneHere = FALSE
        selected = TRUE
      END IF
    LOOP WHILE selected = FALSE
  END IF

  IF a$ = "D" OR a$ = "d" THEN
    LOCATE 10, 10
    COLOR 15, 7
    PRINT "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    LOCATE 11, 10
    PRINT " WARNING: Doing this you will lose this item FOREVER! "
    LOCATE 12, 10
    PRINT "          Are you SURE you want to do this?           "
    LOCATE 13, 10
    PRINT "                      (Y/N)                           "
    LOCATE 14, 10
    PRINT "EIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII"
    LOCATE 11, 12
    COLOR 4, 7
    PRINT "WARNING:"
    selected = FALSE
    DO
      abc$ = INKEY$
      IF abc$ = "Y" OR abc$ = "y" THEN
        itemLoop = FALSE
        doneHere = TRUE
        selected = TRUE
        inventory(itemNum%).occupied = FALSE
      ELSEIF abc$ = "N" OR abc$ = "n" THEN
        itemLoop = FALSE
        doneHere = FALSE
        selected = TRUE
      END IF
    LOOP WHILE selected = FALSE
  END IF

  IF a$ = "B" OR a$ = "b" THEN
    itemLoop = FALSE
    doneHere = TRUE
  END IF
LOOP WHILE itemLoop = TRUE
WEND
END SUB

SUB showMap

'map area of the screen.
COLOR 1, 7
LOCATE 2, 8
PRINT "MAP"
LOCATE 3, 7
PRINT ""

'display the explored map.
FOR y% = 0 TO 8
  FOR x% = 0 TO 8
    IF room(y%, x%).explored = FALSE THEN
      COLOR 6, 7
    ELSE
      COLOR 15, 7
    END IF

    LOCATE y% + 4, x% + 5
    PRINT "U"
  NEXT x%
NEXT y%

'display current location.
LOCATE p.mapY + 4, p.mapX + 5
COLOR 14, 7
PRINT "U"

COLOR 1, 7
LOCATE 14, 6
PRINT "LEGEND"
LOCATE 15, 5
PRINT ""
COLOR 6, 7
LOCATE 16, 5
PRINT "Orange"
COLOR 15, 7
LOCATE 17, 5
PRINT "White"
COLOR 14, 7
LOCATE 18, 5
PRINT "Yellow"

COLOR 15, 7
LOCATE 16, 12
PRINT "- Unexplored"
LOCATE 17, 12
PRINT "- Explored"
LOCATE 18, 12
PRINT "- Current Position"

END SUB

SUB showSpell (spellName$)

'this sub is a sub-sub from the "ShowStats" sub. It's used to display
'information on current spells that the player may have.

DIM spellLevel AS INTEGER
DIM spellDamage AS INTEGER
DIM spellMP AS INTEGER

CLS
COLOR 1, 7
LOCATE 2, 30
PRINT "SPELL INFORMATION"
LOCATE 3, 29
PRINT ""


IF spellName$ = "fire" THEN
  LOCATE 4, 4
  COLOR 4, 7
  PRINT "FIRE:"
  LOCATE 5, 5
  COLOR 15, 7
  PRINT "The fire spell attacks a single enemy at a time. You target them just"
  LOCATE 6, 5
  PRINT "as if you were targeting to do a physical attack. This is the most"
  LOCATE 7, 5
  PRINT "simple attack, therefore uses the least MP to cast. Damage done by"
  LOCATE 8, 5
  PRINT "this spell increases as it's spell level increases. Able to be"
  LOCATE 9, 5
  PRINT "cast by all classes."

  spellLevel = p.fire
  spellMP = (p.fire + 2)
     
  IF p.fire < 7 THEN
    spellDamage = (p.mst + p.fire) \ 2
  ELSEIF p.fire >= 7 AND p.fire < 10 THEN
    spellDamage = (p.mst + p.fire)
  ELSEIF p.fire >= 10 THEN
    spellDamage = (p.mst + p.fire) * 2
  END IF


ELSEIF spellName$ = "ice" THEN
  LOCATE 4, 4
  COLOR 11, 7
  PRINT "ICE:"
  LOCATE 5, 5
  COLOR 15, 7
  PRINT "Ice attack is a medium difficulty spell to preform. It also hits"
  LOCATE 6, 5
  PRINT "muliple bad guys around you. It's an area attack based on your"
  LOCATE 7, 5
  PRINT "current location. The higher the spell level, the larger the area"
  LOCATE 8, 5
  PRINT "in which you attack, also the greater the damage you do to your"
  LOCATE 9, 5
  PRINT "offending foes. Able to be cast by Mages and Archers only."

  spellLevel = p.ice
  spellMP = (p.ice + 10)
 
  IF p.ice < 7 THEN
    spellDamage = (p.mst + p.ice)
  ELSEIF p.ice >= 7 AND p.ice < 10 THEN
    spellDamage = (p.mst + p.ice) * 2
  ELSEIF p.ice >= 10 THEN
    spellDamage = (p.mst + p.ice) * 3
  END IF


ELSEIF spellName$ = "dark" THEN
  LOCATE 4, 4
  COLOR 8, 7
  PRINT "DARK:"
  LOCATE 5, 5
  COLOR 15, 7
  PRINT "The Dark spell is the hardest spell in the game to perform, it"
  LOCATE 6, 5
  PRINT "is also the most powerful (by far). The Dark spell does an area"
  LOCATE 7, 5
  PRINT "attack similar to the ice spell but is based around the bad guy"
  LOCATE 8, 5
  PRINT "in which you've targeted. You are not the center point of this"
  LOCATE 9, 5
  PRINT "area attack, your enemy is. As it's level increases the area"
  LOCATE 10, 5
  PRINT "in which you hit does too, along with attack damage. Please be"
  LOCATE 11, 5
  PRINT "forewarned that this attack costs A LOT OF MP to do, so cast"
  LOCATE 12, 5
  PRINT "sparingly. Able to be cast by Mages only."
 
  spellLevel = p.dark
  spellMP = (p.dark + 20)

  IF p.dark < 7 THEN
    spellDamage = (p.mst + p.dark) * 2
  ELSEIF p.dark >= 7 AND p.dark < 10 THEN
    spellDamage = (p.mst + p.dark) * 3
  ELSEIF p.dark >= 10 THEN
    spellDamage = (p.mst + p.dark) * 5
  END IF


ELSEIF spellName$ = "heal" THEN
  LOCATE 4, 4
  COLOR 5, 7
  PRINT "HEAL:"
  LOCATE 5, 5
  COLOR 15, 7
  PRINT "This spell heals your character when it's casted. The amount of"
  LOCATE 6, 5
  PRINT "HP regained from casting the spell depends on your character's"
  LOCATE 7, 5
  PRINT "MST and the level of the spell. It basically works the same as"
  LOCATE 8, 5
  PRINT "using a heal potion without needing to keep the inventory."
  LOCATE 9, 5
  PRINT "Able to be cast by all classes. (Though Mages get the get the"
  LOCATE 10, 5
  PRINT "largest health boost from it)."

  spellLevel = p.heal
  spellMP = p.heal + (p.lvl * 2)

  IF p.heal < 7 THEN
    spellDamage = p.mst + (p.heal * 3)
  ELSEIF p.heal >= 7 AND p.heal < 10 THEN
    spellDamage = p.mst + (p.heal * 9)
  ELSEIF p.heal >= 10 THEN
    spellDamage = p.maxHP
  END IF
  spellDamage = -(spellDamage)

ELSEIF spellName$ = "return" THEN
  LOCATE 4, 4
  COLOR 5, 7
  PRINT "RETURN:"
  LOCATE 5, 5
  COLOR 15, 7
  PRINT "This spell returns you to the center village of the game"
  LOCATE 6, 5
  PRINT "regardless of current location within the area you are currently"
  LOCATE 7, 5
  PRINT "located in. You player stats and everything remains the same but"
  LOCATE 8, 5
  PRINT "the area will be reset when you return. Think of it as an area"
  LOCATE 9, 5
  PRINT "escape. Able to be cast by all classes."

  spellLevel = p.hasReturn
  spellDamage = 0
  spellMP = 5


ELSE
  COLOR 15, 7
  PRINT "ERROR: INVALID SPELL PASSED!"
END IF

COLOR 1, 7
LOCATE 13, 30
PRINT "SPELL STATS:"

COLOR 15, 7
LOCATE 14, 31
PRINT "Level: "; spellLevel
LOCATE 15, 30
PRINT "Damage: "; spellDamage
LOCATE 16, 26
PRINT "MP to cast: "; spellMP

LOCATE 20, 35
COLOR 4, 7
PRINT "Press ANY KEY to return to stats screen."

DO
LOOP WHILE INKEY$ = ""


END SUB

SUB showStats

DIM atpBonus AS INTEGER
DIM dfpBonus AS INTEGER
DIM mstBonus AS INTEGER
DIM rngBonus AS INTEGER
DIM spdBonus AS INTEGER
DIM inStats AS INTEGER
DIM waiting AS INTEGER

atpBonus = p.weaponATPBonus
dfpBonus = p.armorDFPBonus
mstBonus = p.weaponMSTBonus + p.armorMSTBonus
rngBonus = p.weaponRNGBonus
spdBonus = p.armorSPDBonus
inStats = TRUE


WHILE inStats = TRUE
waiting = TRUE  'so it doesn't blink like a mofo

CLS

COLOR 1, 7
LOCATE 2, 30
PRINT "STATISTICS"
LOCATE 3, 29
PRINT ""

LOCATE 4, 10
COLOR 1, 7
PRINT "Name:"
LOCATE 4, 16
COLOR 15, 7
PRINT p.handle; " ("; p.gfx; ")"

LOCATE 5, 9
COLOR 1, 7
PRINT "Class: "
LOCATE 5, 16
COLOR 15, 7
PRINT p.class


LOCATE 6, 12
COLOR 1, 7
PRINT "HP: "
LOCATE 6, 15
COLOR 15, 7
PRINT p.hp; "/"; p.maxHP

LOCATE 7, 12
COLOR 1, 7
PRINT "MP: "
LOCATE 7, 15
COLOR 15, 7
PRINT p.mp; "/"; p.maxMP

LOCATE 8, 12
COLOR 1, 7
PRINT "Lv: "
LOCATE 8, 15
COLOR 15, 7
PRINT p.lvl

LOCATE 9, 10
COLOR 1, 7
PRINT "Coin: "
LOCATE 9, 15
COLOR 15, 7
PRINT p.coin

LOCATE 10, 8
COLOR 1, 7
PRINT "Status: "
LOCATE 10, 16
IF p.status = POISONED THEN
  COLOR 10, 7
  PRINT "POISONED!"
ELSE
  COLOR 15, 7
  PRINT "Well"
END IF


'top right side information
LOCATE 4, 45
COLOR 1, 7
PRINT "ATP:"
LOCATE 4, 51
COLOR 15, 7
PRINT p.atp; "("; p.atpBase; ")"

LOCATE 5, 45
COLOR 1, 7
PRINT "DFP:"
LOCATE 5, 51
COLOR 15, 7
PRINT p.dfp; "("; p.dfpBase; ")"


LOCATE 6, 45
COLOR 1, 7
PRINT "MST:"
LOCATE 6, 51
COLOR 15, 7
PRINT p.mst; "("; p.mstBase; ")"


LOCATE 7, 45
COLOR 1, 7
PRINT "RNG:"
LOCATE 7, 51
COLOR 15, 7
PRINT p.range; "("; p.rangeBase; ")"

LOCATE 8, 45
COLOR 1, 7
PRINT "SPD:"
LOCATE 8, 51
COLOR 15, 7
PRINT p.speed; "("; p.speedBase; ")"

LOCATE 9, 45
COLOR 1, 7
PRINT "EXP:"
LOCATE 9, 51
COLOR 15, 7
PRINT (p.expToLevel - p.expCurrent)

'bottom left
LOCATE 11, 12
COLOR 4, 7
PRINT "SPELLS:"

LOCATE 12, 10
IF p.fire = 0 THEN
  COLOR 8, 7
ELSE
  COLOR 15, 7
END IF
PRINT "(F)ire  Lv"; p.fire

LOCATE 13, 10
IF p.ice = 0 THEN
  COLOR 8, 7
ELSE
  COLOR 15, 7
END IF
PRINT "(I)ce   Lv"; p.ice

LOCATE 14, 10
IF p.dark = 0 THEN
  COLOR 8, 7
ELSE
  COLOR 15, 7
END IF
PRINT "(D)ark  Lv"; p.dark

LOCATE 15, 10
IF p.heal = 0 THEN
  COLOR 8, 7
ELSE
  COLOR 15, 7
END IF
PRINT "(H)eal  Lv"; p.heal

LOCATE 16, 10
IF p.hasReturn = 0 THEN
  COLOR 8, 7
ELSE
  COLOR 15, 7
END IF
PRINT "(R)eturn"

'bottom right
LOCATE 11, 42
COLOR 4, 7
PRINT "INVENTORY:"

LOCATE 12, 40
COLOR 1, 7
PRINT "Weapon:"
LOCATE 12, 49
IF p.weaponRare = TRUE THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.weaponName

LOCATE 13, 41
COLOR 1, 7
PRINT "Armor:"
LOCATE 13, 49
IF p.armorRare = TRUE THEN
  COLOR 14, 7
ELSE
  COLOR 15, 7
END IF
PRINT p.armorName

LOCATE 14, 30
COLOR 1, 7
PRINT "Health (P)otions:"
LOCATE 14, 48
COLOR 15, 7
PRINT p.hpPotions

LOCATE 15, 31
COLOR 1, 7
PRINT "(M)agic Potions:"
LOCATE 15, 48
COLOR 15, 7
PRINT p.mpPotions


LOCATE 18, 14
COLOR 15, 7
PRINT "Press F1 for detailed inventory information"
LOCATE 19, 16
PRINT "Press FIRST LETTER OF SPELL for details"
LOCATE 20, 17
PRINT "Press BRACKETED LETTER to use potions"

LOCATE 22, 35
COLOR 4, 7
PRINT "Press ENTER to return to game."

DO
  in$ = INKEY$

  IF in$ = CHR$(13) THEN
    waiting = FALSE
    inStats = FALSE
  END IF

  IF (in$ = "f" OR in$ = "F") AND p.fire > 0 THEN
    CALL showSpell("fire")
    waiting = FALSE
  END IF

  IF (in$ = "i" OR in$ = "I") AND p.ice > 0 THEN
    CALL showSpell("ice")
    waiting = FALSE
  END IF

  IF (in$ = "d" OR in$ = "D") AND p.dark > 0 THEN
    CALL showSpell("dark")
    waiting = FALSE
  END IF

  IF (in$ = "h" OR in$ = "H") AND p.heal > 0 THEN
    CALL showSpell("heal")
    waiting = FALSE
  END IF

  IF (in$ = "r" OR in$ = "R") AND p.hasReturn = TRUE THEN
    CALL showSpell("return")
    waiting = FALSE
  END IF

  IF in$ = "p" OR in$ = "P" THEN
    CALL usePotion("health")
    waiting = FALSE
  END IF
 
  IF in$ = "m" OR in$ = "M" THEN
    CALL usePotion("magic")
    waiting = FALSE
  END IF


  'F1 pressed
  IF in$ = CHR$(0) + CHR$(59) THEN
    CALL showDetailedInventory
    waiting = FALSE
  END IF

LOOP WHILE waiting = TRUE

WEND 'exit stats

END SUB

FUNCTION targetBadGuy% (i%, type$)

'this sub is used to either autotarget enemys approaching or manually
'target enemies as they come and attack. It is called from checkEvents
   
DIM foundTarget AS INTEGER

foundTarget = FALSE

'auto target
IF type$ = "auto" THEN
  IF p.badGuyTargeted = NONE THEN 'if no enemy is targeted currently
     
    'set new target to current.
    p.badGuyTargeted = i%
    CALL drawBadGuy(i%) 'to draw the target.

    'end the target request
    targetBadGuy% = FALSE
  
  ELSE
    targetBadGuy% = TRUE

  END IF
END IF

'manual targeting
IF type$ = "manual" THEN
   
  'mask any previous target, if there was one
  IF p.badGuyTargeted > NONE THEN
    CALL maskBadGuy(p.badGuyTargeted, FALSE, TRUE)
  END IF
 
  '<----LOOPS THROUGH POSSIBLE TARGETS AND SELECTS NEXT POSSIBLE ONE---->
  i% = p.badGuyTargeted
  WHILE foundTarget = FALSE
    i% = i% + 1
   
    IF i% > room(p.mapY, p.mapX).numBadGuys THEN
      i% = 0
    END IF

    IF i% = p.badGuyTargeted THEN
      foundTarget = TRUE
      p.badGuyTargeted = -1
    END IF

    IF badGuy(i%).inRange = TRUE AND badGuy(i%).opened = FALSE THEN
      IF p.badGuyTargeted <> i% THEN
        p.badGuyTargeted = i%
        foundTarget = TRUE
      END IF
    END IF
  WEND
  
  CALL drawBadGuy(p.badGuyTargeted) 'to draw the target.

  'end the target request
  targetBadGuy% = FALSE

END IF


END FUNCTION

SUB timingControl (speed%)
'regulates the game speed. The speed parameter recieves and argument
'that determines how fast the game runs.
'
'  1 = Fast (slow computer)
'  2 = Medium (average computer)
'  3 = Slow (fast computer)
'
SELECT CASE speed%

  CASE 1:   'fast game .: slow computer
    gameSpeed! = 2

  CASE 2:   'medium game .: medium computer
    gameSpeed! = 1.5

  CASE 3:   'slow game .: fast computer
    gameSpeed! = 1

END SELECT

FOR i! = 1 TO gameSpeed!     'the closer the numbers, the quicker the prog
  t! = TIMER               't represents the timer
  WHILE t! = TIMER         'while this is true
    WAIT &H3DA, 8         'waits for an 8 bit (1byte) reply from time
'    WAIT &H3DA, 8, 8      'same but uses XOR to make sure
  WEND                    'wend=loop while true
NEXT i!                    'incriment the for loop


END SUB

SUB untargetBadGuy (badGuyNum%)

'is called to untarget players current bad guy. This is used from check
'events sub to remove targeted opponents when they are either out of
'range of player or themselves.
 
  
  IF p.badGuyTargeted > NONE THEN   'make sure something is targeted
    IF p.badGuyTargeted = badGuyNum% THEN 'make sure they guy is even targeted
      CALL maskBadGuy(p.badGuyTargeted, FALSE, TRUE)
      p.badGuyTargeted = NONE   'no target!
    END IF
  END IF

END SUB

SUB usePotion (potionType$)

'this sub uses the selected potion type and removes one from the players
'inventory. It is selected either in game or via stats menu

IF potionType$ = "health" AND p.hpPotions > 0 THEN
  COLOR 13, room(p.mapY, p.mapX).bgColor
  LOCATE 2, 1
  PRINT "HP: "; p.hp; "/"; p.maxHP

  p.hp = p.maxHP
  p.hpPotions = p.hpPotions - 1

ELSEIF potionType$ = "magic" AND p.mpPotions > 0 THEN
  COLOR 11, room(p.mapY, p.mapX).bgColor
  LOCATE 3, 1
  PRINT "MP: "; p.mp; "/"; p.maxMP

  p.mp = p.maxMP
  p.mpPotions = p.mpPotions - 1
END IF

END SUB

