'
'
'        XXXXX XX                      XX
'        XX XX XX                      XX
'        XX XX XX  XX XX  XXXXXXXX     XX  XX XX  XXXXXXXX  XXXXX
'        XX XX XX  XX XX  XX XX XX  XX XX  XX XX  XX XX XX  XX XX
'        XX XXXXX  XXXXX  XX XX XX  XXXXX  XXXXX  XX XX XX  XXXXX
'                                                           XX
'                                                           XX
'                   
'                        Press Shift+F5 to play!
'
'
'   This program was written in 2017 on an LTE 5100 laptop using
'   the original QBasic. If you run it on more modern systems,
'   some effects may be really fast, but it won't affect the game.
'
'
'
'
'
'
'

DECLARE SUB die ()
DECLARE SUB drawending ()
DECLARE SUB drawlevel ()
DECLARE SUB drawtitle ()
DECLARE SUB goal ()
DECLARE SUB move ()
DECLARE SUB supereffect ()

'''First init
init:
SCREEN 7
gamestate% = 0 '''0=Title 1=Game 2=Ending
soundon% = 1 '''Sound FX
level% = 1 '''Current level
gold% = 0 ''Current gold
goldprev% = gold% '''Gold when entering level
dots% = 0 '''Current dots
dotsprev% = 0 '''Dots when entering level

'''Retry init
retry:
REDIM SHARED map$(40, 20) '''Map array
REDIM SHARED maps$(20) '''Strings for map array
beamcycle% = 2 '''Beam cycle
goaltype% = 0 '''0=Normal 1=Gold
quipped% = 0 '''Near-death quip
jump% = 0 '''Height or width of current jump
jumpstate% = 0 '''0=Standing 1=Jumping 2=Sideways 3=Falling 4=dead/goal
jumpmax% = 2 '''Max jump height
pchr% = 1 '''Player's sprite (chr$)
movedir% = 0 '''0=Right 1=Up 2=Left 3=Down
x% = 1 '''Player x position
y% = 1 '''Player y position
xprev% = x% '''Player previous x position
yprev% = y% '''Player previous y position
cheatcode% = 0 '''Level skip code

'''Draw the screen
IF gamestate% = 0 THEN
 drawtitle
ELSEIF gamestate% = 1 THEN
 drawlevel
ELSEIF gamestate% = 2 THEN
 drawending
END IF


'''Gameplay loop
DO

 '''Main menu
 IF gamestate% = 0 THEN
  DO
  LET k$ = INKEY$
  LOOP UNTIL k$ <> ""
  SELECT CASE LCASE$(k$)
   '''Quit
   CASE "q"
    COLOR 15
    END
   '''Sound
   CASE "s"
    IF soundon% = 0 THEN
     soundon% = 1
     COLOR 15
    ELSE
     soundon% = 0
     COLOR 7
    END IF
    LOCATE 21, 35
    PRINT "(S)nd"
   '''Start
   CASE " "
    gamestate% = 1
    level% = 1
    GOTO retry
  END SELECT

 '''Game and input
 ELSEIF gamestate% = 1 THEN
 DO
  LET k$ = INKEY$
  IF k$ = "Y" OR k$ = "Q" OR k$ = "S" THEN
   k$ = LCASE$(k$)
  END IF
  LOOP UNTIL k$ <> ""
  SELECT CASE k$
   '''Cheat code
   CASE "y"
    cheatcode% = cheatcode% + 1
    IF cheatcode% = 3 THEN
     cheatcode% = 0
     IF level% < 7 THEN
      jumpstate% = 4
      level% = level% + 1
      goldprev% = gold%
      dotsprev% = dots%
      goaltype% = 0
      goal
     ELSE
      LOCATE 23, 1
      COLOR 15
      PRINT " That code doesn't seem to work here... "
     END IF
    END IF
   '''Quit
   CASE "q"
    COLOR 15
    END
   '''Sound
   CASE "s"
    cheatcode% = 0
    IF soundon% = 0 THEN
     soundon% = 1
     COLOR 15
    ELSE
     soundon% = 0
     COLOR 7
    END IF
    LOCATE 21, 35
    PRINT "(S)nd"
   '''Move right
   CASE CHR$(0) + CHR$(77)
    cheatcode% = 0
    movedir% = 0
    move
   '''Move up
   CASE CHR$(0) + CHR$(72)
    cheatcode% = 0
    movedir% = 1
    move
   '''Move left
   CASE CHR$(0) + CHR$(75)
    cheatcode% = 0
    movedir% = 2
    move
   '''Move down
   CASE CHR$(0) + CHR$(80)
    cheatcode% = 0
    movedir% = 3
    move
  END SELECT
  '''Player wants to reload level
  IF jumpstate% = 4 THEN
   GOTO retry
  END IF

 '''Ending
 ELSEIF gamestate% = 2 THEN
  DO
  LET k$ = INKEY$
  IF level% = 9 THEN
   supereffect
  END IF
  LOOP UNTIL k$ <> ""
  SELECT CASE LCASE$(k$)
   '''Quit
   CASE "q"
    COLOR 15
    END
   '''Sound
   CASE "s"
    IF soundon% = 0 THEN
     soundon% = 1
     COLOR 15
    ELSE
     soundon% = 0
     COLOR 7
    END IF
    LOCATE 21, 35
    PRINT "(S)nd"
   '''Restart
   CASE " "
    gamestate% = 0
    level% = 0
    gold% = 0
    goldprev% = 0
    dots% = 0
    dotsprev% = 0
    GOTO retry
  END SELECT
 END IF

'''End of gameplay loop
LOOP

SUB die
SHARED soundon%, beamcycle%, x%, y%

'''Paint the level red
COLOR 12
FOR i% = 1 TO 40 STEP 1
 LOCATE 1, i%
 PRINT CHR$(219)
NEXT i%
FOR j% = 2 TO 19 STEP 1
 LOCATE j%, 1
 PRINT CHR$(219)
 FOR i% = 2 TO 39 STEP 1
  IF map$(i%, j%) = "1" THEN '''Wall
   LOCATE j%, i%
   PRINT CHR$(219)
  ELSEIF map$(i%, j%) = "2" THEN '''Gold
   LOCATE j%, i%
   PRINT CHR$(36)
  ELSEIF map$(i%, j%) = "4" THEN '''Powerup
   LOCATE j%, i%
   PRINT CHR$(4)
  ELSEIF map$(i%, j%) = "5" THEN '''Goal
   LOCATE j%, i%
   PRINT CHR$(64)
  ELSEIF map$(i%, j%) = "8" THEN '''Lazer switch
   LOCATE j%, i%
   PRINT CHR$(254)
  ELSEIF map$(i%, j%) = "9" THEN '''Gold door
   LOCATE j%, i%
   PRINT CHR$(186)
  END IF
 NEXT i%
 LOCATE j%, 40
 PRINT CHR$(219)
NEXT j%
LOCATE 20, 1
FOR i% = 1 TO 40 STEP 1
 LOCATE 20, i%
 PRINT CHR$(223)
NEXT i%
PRINT " XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX "
FOR i% = 1 TO 40 STEP 1
 LOCATE 22, i%
 PRINT CHR$(196)
NEXT i%

'''Draw circle effects
FOR i% = 1 TO 20 STEP 1
 IF i% MOD 4 = 0 AND soundon% = 1 THEN
  SOUND 437 - (i% * 20), 1
 END IF
 CIRCLE (x% * 8 - 4, y% * 8 - 4), i%
NEXT i%

'''Draw message
LOCATE 23, 1
PRINT " You died! Press Spacebar to try again. "

'''Dripping effect until key is pressed
DO
 'tryx% = x% * 8 - 8 - 4 + INT(RND * 16)
 'tryy% = y% * 8 - 8 - 8 + INT(RND * 200)
 tryx% = INT(RND * 320)
 tryy% = INT(RND * 171)
 IF POINT(tryx%, tryy%) = 12 THEN
  LINE (tryx%, tryy%)-(tryx%, tryy% + 1), 12
 END IF
LOOP UNTIL INKEY$ = CHR$(32)

END SUB

SUB drawending
SHARED soundon%, level%, gold%

CLS

IF level% = 7 THEN
 maps$(1) = "   79  79    7979  7889                 "
 maps$(2) = "   44  44    4444  47919                "
 maps$(3) = "   44794478894444  44194788978897889    "
 maps$(4) = "   44444447944444  44734479447944794    "
 maps$(5) = "   41313441834444  41373413444444183    "
 maps$(6) = "   18888318831313  1883 188313131883    "
ELSEIF level% = 8 THEN
 maps$(1) = " 788979  797889788978897888897889797979 "
 maps$(2) = " 479444  444783478347944797944783444444 "
 maps$(3) = " 41344479444189418944444444444189444444 "
 maps$(4) = " 47944444444783189444444413444783131313 "
 maps$(5) = " 444441313441897834413444  444189797979 "
 maps$(6) = " 131318888318831883188313  131883131313 "
ELSE
 maps$(1) = " 78897889788979788979797889797979797889 "
 maps$(2) = " 47834783479444479444444783444444441894 "
 maps$(3) = " 4189418941834444444444418944413444 734 "
 maps$(4) = " 1894478347944444444444189444197313 183 "
 maps$(5) = " 7834418944444441344134783441944 79 79  "
 maps$(6) = " 1883188313131318831883188318313 13 13  "
END IF

'''Put the strings into the map array
FOR j% = 1 TO 6 STEP 1
 FOR i% = 1 TO 40 STEP 1
  map$(i%, j%) = MID$(maps$(j%), i%, 1)
 NEXT i%
NEXT j%

'''Print numbers as correct objects
toffset% = 1
FOR j% = 1 TO 6 STEP 1
 COLOR 11
 IF j% = 1 OR j% = 6 THEN
  COLOR 3
 ELSEIF j% = 3 OR j% = 4 THEN
  COLOR 15
 END IF
 FOR i% = 1 TO 40 STEP 1
  IF map$(i%, j%) = "1" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(200)
  ELSEIF map$(i%, j%) = "3" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(188)
  ELSEIF map$(i%, j%) = "4" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(186)
  ELSEIF map$(i%, j%) = "7" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(201)
  ELSEIF map$(i%, j%) = "8" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(205)
  ELSEIF map$(i%, j%) = "9" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(187)
  END IF
 NEXT i%
NEXT j%

'''Draw text
LOCATE 10, 1
COLOR 15
IF level% = 7 THEN
 PRINT "  After striking the alien leader in    "
 PRINT "  its weak point, it stopped its        "
 PRINT "  relentless attack and promised not    "
 PRINT "  to invade any more planets! But what  "
 PRINT "  of the enigmatic tower? Some          "
 PRINT "  mysteries are yet unsolved...         "
ELSEIF level% = 8 THEN
 PRINT "  You stopped the invasion, made the    "
 PRINT "  alien leader promise not to attack    "
 PRINT "  any more planets, found all the gold  "
 PRINT "  and even beat the secret level!       "
 PRINT "  But what of the eight secret dots?    "
 PRINT "  HINT: Press 'yyy' while playing!      "
ELSE
 PRINT "  You stopped the invasion, made the    "
 PRINT "  alien leader promise not to attack    "
 PRINT "  any more planets, found all the       "
 PRINT "  gold, beat the secret level, got all  "
 PRINT "  eight secret dots and beat the        "
 PRINT "  supersecret level! Are you serious!?  "
END IF
LOCATE 18, 1
COLOR 14: PRINT "            Final gold:                 "
IF gold% < 10 THEN
 LOCATE 18, 25
ELSE
 LOCATE 18, 24
END IF
PRINT gold%

'''Draw HUD
LOCATE 21, 1
COLOR 15
PRINT " Press spacebar to retry!  (Q)uit (S)nd "
IF soundon% = 0 THEN
 LOCATE 21, 35
 COLOR 7
 PRINT "(S)nd"
END IF

END SUB

SUB drawlevel
SHARED soundon%, level%, gold%, beamcycle%, pchr%, x%, y%, xprev%, yprev%

''''''Note: for aesthetic purposes, this game always draws
''''''characters from top to bottom, then left to right.
'''1 = Wall
'''2 = Gold
'''3 = Spike
'''4 = Powerup
'''5 = Goal
'''6 = Off lazer barrier
'''7 = On lazer barrier
'''8 = Lazer switch
'''9 = Gold door
'''0 = Start
'''a = Beam
'''b = Secret dot
'''c = Collected dot

IF level% = 1 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1111111111111111111111111111111111111111"
 maps$(3) = "1111111111111111111111111111111111111111"
 maps$(4) = "1111111111111111111111111111111111111111"
 maps$(5) = "1111111111111111111111111111111111111111"
 maps$(6) = "11111111111111111b         1111111111111"
 maps$(7) = "11111111111111111        5 1111111111111"
 maps$(8) = "11111111111122     22 111111111111111111"
 maps$(9) = "11111111111111     11   2211111111111111"
maps$(10) = "11111111111111          1111111111111111"
maps$(11) = "11111111111111 0 222       1111111111111"
maps$(12) = "111111111111111111111      1111111111111"
maps$(13) = "1111111111111111111111   4 1111111111111"
maps$(14) = "1111111111111111111111 2 1 1111111111111"
maps$(15) = "1111111111111111111111 1   1111111111111"
maps$(16) = "1111111111111111111111     1111111111111"
maps$(17) = "1111111111111111111111111111111111111111"
maps$(18) = "1111111111111111111111111111111111111111"
maps$(19) = "1111111111111111111111111111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Use the arrow keys to move and jump.   "

ELSEIF level% = 2 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1111111111111111111111111111111111111111"
 maps$(3) = "1111111111111    11111111111111111111111"
 maps$(4) = "1111111111111  5b11111111111111111111111"
 maps$(5) = "1111111111111 11111111111111111111111111"
 maps$(6) = "1111111111                    1111111111"
 maps$(7) = "1111111111 11111111111 111111    1111111"
 maps$(8) = "111111111  1      1111 1111111     11111"
 maps$(9) = "11111   1 11                   2 1 11111"
maps$(10) = "11111                 4        1 1 11111"
maps$(11) = "11112    2       2               1 11111"
maps$(12) = "111111   1       1         22 1331 11111"
maps$(13) = "111111                 0 3111 1111 11111"
maps$(14) = "111111 2  2  11333331 11111      1 11111"
maps$(15) = "111111 1  1  11111111            1 11111"
maps$(16) = "11111133333331111111111111  2 2    11111"
maps$(17) = "11111111111111111111111111  131111111111"
maps$(18) = "1111111111111111111111111131111111111111"
maps$(19) = "1111111111111111111111111111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Beware the spikes...                   "

ELSEIF level% = 3 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1111111111111111111111111111111111111111"
 maps$(3) = "1111111111111111111111111111111111111111"
 maps$(4) = "1111111111111111111111111111111111111111"
 maps$(5) = "1111111111111            7    7    11111"
 maps$(6) = "1111111111111 22 18  222   7       11111"
 maps$(7) = "111         1 11 111 111   b7  7     111"
 maps$(8) = "111  2      1         4  7  2        111"
 maps$(9) = "111 66 7    1        111111 111 111  111"
maps$(10) = "111 11      11                       111"
maps$(11) = "111      11                          111"
maps$(12) = "111     1111       2                1111"
maps$(13) = "111    111111    11111     2 2       111"
maps$(14) = "111    1    1       6   11 1 1 11    111"
maps$(15) = "111    1    1     1 6  111 1 1 111   111"
maps$(16) = "11133331 5  7 0     6 111131413111133111"
maps$(17) = "1111111111111111177111111111111111111111"
maps$(18) = "1111111111111111177111111111111111111111"
maps$(19) = "1111111111111111111111111111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Find the lazer switch!                 "

ELSEIF level% = 4 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "11111       8   11     11b  8  7    1111"
 maps$(3) = "11     1    1   11     11666666111  1111"
 maps$(4) = "11     6        11 111 11      111  1221"
 maps$(5) = "11   1 6 111    11     11      7    6221"
 maps$(6) = "116171 111      77     66  1   1    1111"
 maps$(7) = "1121 1         1111   1111 8 1113   8111"
 maps$(8) = "112141        1111     11111111111111111"
 maps$(9) = "111111111111111111     11       11111111"
maps$(10) = "111111111111    11 111 11  161  11111111"
maps$(11) = "111111111111    11     11  181  11111111"
maps$(12) = "111111111111 0             171  11111111"
maps$(13) = "1111111111111111111   1111     111111111"
maps$(14) = "111      68786  11     11111111111111111"
maps$(15) = "111 5    6 7 6  11     11     46    2 11"
maps$(16) = "111111771627 6  11 111 11     11   31 11"
maps$(17) = "111      6 6 6  11     11   1 6  2    11"
maps$(18) = "11183  2 6 6 6  66     66  31 7  11  811"
maps$(19) = "1111111111313111111111111111181111131111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Enter the machine...                   "

ELSEIF level% = 5 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1                                      1"
 maps$(3) = "1      11111111111111111111111111      1"
 maps$(4) = "1     118   81 8   4  12   1 87 11     1"
 maps$(5) = "1    111777771 1   1171661 1771 111    1"
 maps$(6) = "1   1187 333 6 166612      18 121411   1"
 maps$(7) = "1  11  14111 1 1     1117771661 1  11  1"
 maps$(8) = "1 112  1 7 7   1 2     2        11 211 1"
 maps$(9) = "1  11  6 7211  1 1  8  1    111 1  11  1"
maps$(10) = "1   11 6 7  6  7   666    1 626 7 11   1"
maps$(11) = "1    116 1661  7 1     1  7 111 711b   1"
maps$(12) = "1     11 6 27  7 6  11 6  7     11     1"
maps$(13) = "1      11111111111161111111111111      1"
maps$(14) = "1                  6                   1"
maps$(15) = "1                  1                   1"
maps$(16) = "1                                      1"
maps$(17) = "111111111111111  11131 11111111111111111"
maps$(18) = "111111111111111  11111 11111111111111111"
maps$(19) = "1111111111111111  015  11111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Alien invasion! Infiltrate the UFO!    "

ELSEIF level% = 6 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1                                      1"
 maps$(3) = "1                                      1"
 maps$(4) = "1                          3     3     1"
 maps$(5) = "1                         31aaaaa13    1"
 maps$(6) = "1                         11     11    1"
 maps$(7) = "1                         1133 3311    1"
 maps$(8) = "1                         1111 1111    1"
 maps$(9) = "1aaaaaaaaaaaaaaaaaa111   1111  11111   1"
maps$(10) = "1     4              11  1761 117611   1"
maps$(11) = "1    111      11      11 1661 516611   1"
maps$(12) = "1aaaaaaaaaaaaaaaaaa11111 16711116711   1"
maps$(13) = "1 4                  b11 11111111111   1"
maps$(14) = "1 11     11          111  11     11    1"
maps$(15) = "1aaaaaaaaaaaaaaaaaa111 1   11   11     1"
maps$(16) = "1     4                1               1"
maps$(17) = "1    111               13  1111111  33 1"
maps$(18) = "1                      11 111111111 11 1"
maps$(19) = "1 11  0                11 111111111 11 1"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " The alien leader appears!              "

ELSEIF level% = 7 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1111111111111111111111111111111111111111"
 maps$(3) = "1                                      1"
 maps$(4) = "1                                      1"
 maps$(5) = "1                           3 3 3 3    1"
 maps$(6) = "1                           1111111    1"
 maps$(7) = "1                           1 111 1    1"
 maps$(8) = "1                           1111111    1"
 maps$(9) = "1                           1111111    1"
maps$(10) = "1                           1 111 1    1"
maps$(11) = "1                           1111111    1"
maps$(12) = "1   8   8                   1111111    1"
maps$(13) = "1   11111                   1 111 1    1"
maps$(14) = "1   6 7b6                   1111111    1"
maps$(15) = "1   6 5 6                   9111111    1"
maps$(16) = "1   6 7 6               1111111111111111"
maps$(17) = "1   11111      0      111111111111111111"
maps$(18) = "1111111111111111111111111111111111111111"
maps$(19) = "1111111111111111111111111111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " The portal awaits. A tower looms...    "

ELSEIF level% = 8 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1111111111111111111111111111111111111111"
 maps$(3) = "111111111111118    812222211111111111111"
 maps$(4) = "11111111111111      72222211111111111111"
 maps$(5) = "111111111111117771 111111111111111111111"
 maps$(6) = "111111111111118     8     11111111111111"
 maps$(7) = "11111111111111     1716 7 11111111111111"
 maps$(8) = "11111111111111 166 184  7 11111111111111"
 maps$(9) = "111111111111118    1811 7 11111111111111"
maps$(10) = "11111111111111b    8      11111111111111"
maps$(11) = "11111111111111 3 363 3  1 11111111111111"
maps$(12) = "11111111111111 1 11161  3 11111111111111"
maps$(13) = "11111111111111   8 888  3 11111111111111"
maps$(14) = "11111111111111 37331 1777711111111111111"
maps$(15) = "11111111111111711111 13 8111111111111111"
maps$(16) = "1111111111111187   6 1116611111111111111"
maps$(17) = "1111111111111111 446    8 11111111111111"
maps$(18) = "1111111111111190 1111  31 11111111111111"
maps$(19) = "1111111111111111111111111111111111111111"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " It's the secret tower of gold!         "

ELSEIF level% = 9 THEN
 maps$(1) = "1111111111111111111111111111111111111111"
 maps$(2) = "1                                      1"
 maps$(3) = "1 111111                               1"
 maps$(4) = "1 1    6           0                   1"
 maps$(5) = "1 1    1        171111                 1"
 maps$(6) = "1 1 8771        1 1  7                 1"
 maps$(7) = "1 1  6 1        1 8  1          116661 1"
 maps$(8) = "1 1 76 1        118  1          1 8881 1"
 maps$(9) = "1 1 4  1        1 8  1    11711 167 71 1"
maps$(10) = "1 1 1  7        1    1111 1   6 6    1 1"
maps$(11) = "1 1   11        1    78 6 6 111 1 7161 1"
maps$(12) = "1 18   7        1333111 1 1 1 7 7 61 1 1"
maps$(13) = "1 1 8  1 11761  1       1 1 1 1 1  4 1 1"
maps$(14) = "1 1 8  6 6   7 86 1111611 1   1 111171 1"
maps$(15) = "1 1 8  1 1   1  111     1 111 1 12   1 1"
maps$(16) = "1 1  8 1 1   1  166 8   7 7 1 1 121111 1"
maps$(17) = "1 1    1 11761  1       1 1 1 1 121521 1"
maps$(18) = "1 166611 1   1  1777  1 1 1 111 121121 1"
maps$(19) = "1317771131   133188836  131  41312222131"
maps$(20) = "1111111111111111111111111111111111111111"
levelinfo$ = " Got 8 secret dots! Supersecret level!  "
END IF

'''Print level base
CLS
LOCATE 1, 1
IF level% = 8 THEN
 COLOR 14
ELSE
 COLOR 15
END IF
FOR i% = 1 TO 40 STEP 1
 LOCATE 1, i%
 PRINT CHR$(219)
NEXT i%
FOR i% = 2 TO 19 STEP 1
 LOCATE i%, 1
 PRINT CHR$(219)
 LOCATE i%, 40
 PRINT CHR$(219)
NEXT i%
LOCATE 20, 1
IF level% = 8 THEN
 COLOR 14
ELSE
 COLOR 15
END IF
FOR i% = 1 TO 40 STEP 1
 LOCATE 20, i%
 PRINT CHR$(223)
NEXT i%

'''Put the strings into the map array
FOR j% = 1 TO 20 STEP 1
 FOR i% = 1 TO 40 STEP 1
  map$(i%, j%) = MID$(maps$(j%), i%, 1)
 NEXT i%
NEXT j%

'''Print numbers as correct objects
FOR j% = 2 TO 19 STEP 1
 IF soundon% = 1 AND level% = 6 THEN
  SOUND 37 + (j% * 2), 1
 ELSEIF soundon% = 1 AND j% MOD 2 = 1 THEN
  SOUND 40 + (j% * 20), 1
 END IF
 FOR i% = 2 TO 39 STEP 1
  IF map$(i%, j%) = "1" THEN '''Wall
   LOCATE j%, i%
   IF level% = 8 THEN
    COLOR 14
   ELSE
    COLOR 15
   END IF
   PRINT CHR$(219)
  ELSEIF map$(i%, j%) = "2" THEN '''Gold
   LOCATE j%, i%
   COLOR 14
   PRINT CHR$(36)
  ELSEIF map$(i%, j%) = "3" THEN '''Spike
   LOCATE j%, i%
   COLOR 12
   PRINT CHR$(127)
  ELSEIF map$(i%, j%) = "4" THEN '''Powerup
   LOCATE j%, i%
   COLOR 11
   PRINT CHR$(4)
  ELSEIF map$(i%, j%) = "5" THEN '''Goal
   LOCATE j%, i%
   COLOR 10
   PRINT CHR$(64)
  ELSEIF map$(i%, j%) = "6" THEN '''Off lazer barrier
   LOCATE j%, i%
   COLOR 12
   PRINT CHR$(176)
  ELSEIF map$(i%, j%) = "7" THEN '''On lazer barrier
   LOCATE j%, i%
   COLOR 12
   PRINT CHR$(178)
  ELSEIF map$(i%, j%) = "8" THEN '''Lazer switch
   LOCATE j%, i%
   COLOR 13
   PRINT CHR$(254)
  ELSEIF map$(i%, j%) = "9" THEN '''Gold door
   LOCATE j%, i%
   COLOR 6
   PRINT CHR$(186)
  ELSEIF map$(i%, j%) = "0" THEN '''Start
   x% = i%
   y% = j%
   xprev% = x%
   yprev% = y%
   LOCATE y%, x%
   COLOR 10
   PRINT CHR$(pchr%)
  ELSEIF map$(i%, j%) = "a" THEN '''Beam
   IF (i% + j% + beamcycle%) MOD 5 > 1 THEN
    LOCATE j%, i%
    COLOR 12
    PRINT CHR$(205)
   ELSE
    LOCATE j%, i%
    COLOR 7
    PRINT CHR$(250)
   END IF
  ELSEIF map$(i%, j%) = "b" THEN  '''Secret dot
   LOCATE j%, i%
   COLOR 8
   PRINT CHR$(250)
  ELSE '''Nothing
   LOCATE j%, i%
   COLOR 7
   PRINT CHR$(250)
  END IF
 NEXT i%
NEXT j%

'''Draw HUD
 '''Level
COLOR 10
LOCATE 21, 2
PRINT "Level"; level%
 '''Jump
COLOR 11
LOCATE 21, 11
PRINT "Jump 2"
 '''Gold
COLOR 14
LOCATE 21, 19
PRINT "Gold"
IF gold% < 10 THEN
 LOCATE 21, 24
ELSE
 LOCATE 21, 23
END IF
PRINT gold%
 '''Quit
COLOR 15
LOCATE 21, 28
PRINT "(Q)uit"
 '''Sound
IF soundon% = 1 THEN
 COLOR 15
ELSE
 COLOR 7
END IF
LOCATE 21, 35
PRINT "(S)nd"
 '''Divider
COLOR 15
FOR i% = 1 TO 40 STEP 1
 LOCATE 22, i%
 PRINT CHR$(196)
NEXT i%
 '''Levelinfo
LOCATE 23, 1
PRINT levelinfo$

END SUB

SUB drawtitle
SHARED soundon%

CLS

toffset% = 5
drawhelp% = 0
IF drawhelp% = 1 THEN
 toffset% = 3
 LOCATE 16, 1
 COLOR 15
 PRINT " a=You  a=Gold  a=Jump  a=Spike  a=Goal "
 PRINT ""
 PRINT "    a=Lazer barrier  a=Lazer switch     "
 LOCATE 16, 2: COLOR 10: PRINT CHR$(1)
 LOCATE 16, 9: COLOR 14: PRINT CHR$(36)
 LOCATE 16, 17: COLOR 11: PRINT CHR$(4)
 LOCATE 16, 25: COLOR 12: PRINT CHR$(127)
 LOCATE 16, 34: COLOR 10: PRINT CHR$(64)
 LOCATE 18, 5: COLOR 12: PRINT CHR$(178)
 LOCATE 18, 22: COLOR 13: PRINT CHR$(254)
END IF

maps$(1) = "   788979            79                 "
maps$(2) = "   479444            44                 "
maps$(3) = "   4444447979788889  4479797888897889   "
maps$(4) = "   4444444444479794794444444797944794   "
maps$(5) = "   4441344134444444413441344444444134   "
maps$(6) = "   1318831883131313188318831313134783   "
maps$(7) = "                                 44     "
maps$(8) = "                                 13     "

'''Put the strings into the map array
FOR j% = 1 TO 8 STEP 1
 FOR i% = 1 TO 40 STEP 1
  map$(i%, j%) = MID$(maps$(j%), i%, 1)
 NEXT i%
NEXT j%

'''Print numbers as correct objects
FOR j% = 1 TO 8 STEP 1
 COLOR 10
 IF j% <= 1 OR j% >= 6 THEN
  COLOR 2
 ELSEIF j% = 3 OR j% = 4 THEN
  COLOR 15
 END IF
 FOR i% = 1 TO 40 STEP 1
  IF map$(i%, j%) = "1" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(200)
  ELSEIF map$(i%, j%) = "3" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(188)
  ELSEIF map$(i%, j%) = "4" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(186)
  ELSEIF map$(i%, j%) = "7" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(201)
  ELSEIF map$(i%, j%) = "8" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(205)
  ELSEIF map$(i%, j%) = "9" THEN
   LOCATE j% + toffset%, i%
   PRINT CHR$(187)
  END IF
 NEXT i%
NEXT j%

'''Draw credits
LOCATE 8 + toffset%, 5
COLOR 7
PRINT "Remar Games 2017"

'''Draw HUD
LOCATE 21, 1
COLOR 15
PRINT " Press spacebar to start!  (Q)uit (S)nd "
IF soundon% = 0 THEN
 LOCATE 21, 35
 COLOR 7
 PRINT "(S)nd"
END IF

END SUB

SUB goal
SHARED soundon%, level%, beamcycle%, goaltype%, x%, y%

'''Paint the level
IF goaltype% = 0 THEN
 drawcol% = 10
ELSE
 drawcol% = 14
END IF
COLOR drawcol%
FOR i% = 1 TO 40 STEP 1
 LOCATE 1, i%
 PRINT CHR$(219)
NEXT i%
FOR j% = 2 TO 19 STEP 1
 LOCATE j%, 1
 PRINT CHR$(219)
 FOR i% = 2 TO 39 STEP 1
  IF map$(i%, j%) = "1" THEN '''Wall
   LOCATE j%, i%
   PRINT CHR$(219)
  ELSEIF map$(i%, j%) = "2" THEN '''Gold
   LOCATE j%, i%
   PRINT CHR$(36)
  ELSEIF map$(i%, j%) = "3" THEN '''Spike
   LOCATE j%, i%
   PRINT CHR$(127)
  ELSEIF map$(i%, j%) = "4" THEN '''Powerup
   LOCATE j%, i%
   PRINT CHR$(4)
  ELSEIF map$(i%, j%) = "5" THEN '''Goal
   LOCATE j%, i%
   PRINT CHR$(64)
  ELSEIF map$(i%, j%) = "6" THEN '''Off lazer barrier
   LOCATE j%, i%
   PRINT CHR$(176)
  ELSEIF map$(i%, j%) = "7" THEN '''On lazer barrier
   LOCATE j%, i%
   PRINT CHR$(178)
  ELSEIF map$(i%, j%) = "8" THEN '''Lazer switch
   LOCATE j%, i%
   PRINT CHR$(254)
  ELSEIF map$(i%, j%) = "9" THEN '''Gold door
   LOCATE j%, i%
   PRINT CHR$(186)
  ELSEIF map$(i%, j%) = "a" THEN '''Beam
   IF (i% + j% + beamcycle%) MOD 5 > 1 THEN
    LOCATE j%, i%
    PRINT CHR$(205)
   END IF
  END IF
 NEXT i%
 LOCATE j%, 40
 PRINT CHR$(219)
NEXT j%
LOCATE 20, 1
FOR i% = 1 TO 40 STEP 1
 LOCATE 20, i%
 PRINT CHR$(223)
NEXT i%
FOR i% = 2 TO 39 STEP 1
 LOCATE 21, i%
 PRINT CHR$(1)
NEXT i%
FOR i% = 1 TO 40 STEP 1
 LOCATE 22, i%
 PRINT CHR$(196)
NEXT i%

'''Draw circle effects
FOR i% = 1 TO 28 STEP 1
 IF i% MOD 4 = 0 AND soundon% = 1 THEN
  IF goaltype% = 0 THEN
   SOUND 37 + (i% * 30), 1
  ELSE
   SOUND 37 + (i% * 50), 1
  END IF
 END IF
 CIRCLE (x% * 8 - 4, y% * 8 - 4), i%
NEXT i%

'''Draw message
LOCATE 23, 1
IF goaltype% = 0 THEN
 PRINT " Goal! Press Spacebar to continue!      "
ELSE
 IF level% = 7 THEN
  PRINT " You have 50 gold! The door opens!      "
 ELSE
  PRINT " You have 60 gold! The exit opens!      "
 END IF
END IF

'''Effect until key is pressed
DO
' tryx% = INT(RND * 320)
' tryy% = INT(RND * 172)
' IF goaltype% = 0 THEN
'  COLOR 10
' ELSE
'  COLOR 14
' END IF
' LINE (tryx%, tryy%)-(tryx%, tryy%)
' tryx% = INT(RND * 320)
' tryy% = INT(RND * 172)
' IF goaltype% = 0 THEN
'  COLOR 2
' ELSE
'  COLOR 6
' END IF
' LINE (tryx%, tryy%)-(tryx%, tryy%)
LOOP UNTIL INKEY$ = CHR$(32)
END SUB

SUB move
SHARED gamestate%, soundon%, level%, gold%, goldprev%, dots%, dotsprev%
SHARED beamcycle%, goaltype%, quipped%, jump%, jumpstate%
SHARED jumpmax%, pchr%, movedir%, x%, y%, xprev%, yprev%

'''Print over the current position
LOCATE y%, x%
IF map$(x%, y%) = "6" THEN '''Off lazer barrier
 COLOR 12
 PRINT CHR$(176)
ELSEIF map$(x%, y%) = "8" THEN '''Lazer switch
 COLOR 13
 PRINT CHR$(254)
ELSEIF map$(x%, y%) = "9" THEN '''Gold door
 COLOR 6
 PRINT CHR$(186)
ELSEIF map$(x%, y%) = "c" THEN '''Collected dot
 COLOR 7
 PRINT CHR$(250)
ELSE
 COLOR 7
 PRINT CHR$(250)
END IF

'''Move up / Jump
IF movedir% = 1 AND y% > 2 THEN
 IF map$(x%, y% + 1) = "1" AND map$(x%, y% - 1) <> "1" THEN '''Begin a new jump
  y% = y% - 1
  jump% = 1
  jumpstate% = 1
  pchr% = 48 + jump%
 ELSEIF jump% < jumpmax% AND jumpstate% = 1 AND map$(x%, y% - 1) <> "1" THEN '''Keep jumping upwards
  jump% = jump% + 1
  IF jump% = jumpmax% THEN '''Go to sideways state
   jumpstate% = 2
  END IF
  y% = y% - 1
  pchr% = 48 + jump%
 END IF

'''Move right
ELSEIF movedir% = 0 AND x% < 39 THEN
 IF map$(x% + 1, y%) <> "1" THEN
  IF jumpstate% = 0 AND map$(x% + 1, y% + 1) = "1" THEN '''Walk on ground
   x% = x% + 1
  ELSEIF jumpstate% = 0 AND map$(x% + 1, y% + 1) <> "1" THEN '''Walk off edge
   x% = x% + 1
   jumpstate% = 3
   pchr% = 25
  ELSEIF jumpstate% = 1 OR jumpstate% = 2 THEN '''From jump to sideways
   x% = x% + 1
   jumpstate% = 2
   jump% = jump% - 1
   IF jump% = 0 THEN '''From sideways to fall
    jumpstate% = 3
    pchr% = 25
    IF map$(x%, y% + 1) = "1" THEN '''Hit ground
     jumpstate% = 0
     pchr% = 1
    END IF
   ELSE
    pchr% = 48 + jump%
   END IF
  END IF
 END IF

'''Move left
ELSEIF movedir% = 2 AND x% > 1 THEN
 IF map$(x% - 1, y%) <> "1" THEN
  IF jumpstate% = 0 AND map$(x% - 1, y% + 1) = "1" THEN '''Walk on ground
   x% = x% - 1
  ELSEIF jumpstate% = 0 AND map$(x% - 1, y% + 1) <> "1" THEN '''Walk off edge
   x% = x% - 1
   jumpstate% = 3
   pchr% = 25
  ELSEIF jumpstate% = 1 OR jumpstate% = 2 THEN '''From jump to sideways
   x% = x% - 1
   jumpstate% = 2
   jump% = jump% - 1
   IF jump% = 0 THEN '''From sideways to fall
    jumpstate% = 3
    pchr% = 25
    IF map$(x%, y% + 1) = "1" THEN '''Hit ground
     jumpstate% = 0
     pchr% = 1
    END IF
   ELSE
    pchr% = 48 + jump%
   END IF
  END IF
 END IF

'''Move down
ELSEIF movedir% = 3 AND y% < 19 THEN
 IF map$(x%, y% + 1) <> "1" THEN '''Fall
  jumpstate% = 3
  y% = y% + 1
  pchr% = 25
  IF map$(x%, y% + 1) = "1" THEN '''Hit ground while falling
   jumpstate% = 0
   pchr% = 1
  END IF
 ELSEIF map$(x%, y% + 1) = "1" THEN '''Hit ground
  jumpstate% = 0
  pchr% = 1
 END IF
END IF

'''Update beams
IF level% = 6 AND (x% <> xprev% OR y% <> yprev%) THEN
 beamcycle% = beamcycle% + 1
 IF beamcycle% = 5 THEN
  beamcycle% = 0
 END IF
 FOR j% = 5 TO 15
  FOR i% = 1 TO 39
   IF map$(i%, j%) = "a" THEN
    LOCATE j%, i%
    IF (i% + j% + beamcycle%) MOD 5 > 1 THEN
     COLOR 12
     PRINT CHR$(205)
    ELSE
     COLOR 7
     PRINT CHR$(250)
    END IF
   END IF
  NEXT i%
 NEXT j%
END IF

'''Pick up gold
IF map$(x%, y%) = "2" THEN
 map$(x%, y%) = "0"
 gold% = gold% + 1
 LOCATE 23, 1
 COLOR 15
 IF gold% = goldprev% + 10 THEN
  PRINT " You found all the gold in the level!   "
 ELSE
  PRINT " Gold!                                  "
 END IF
 IF gold% < 10 THEN
  LOCATE 21, 24
 ELSE
  LOCATE 21, 23
 END IF
 COLOR 14
 PRINT gold%
 IF soundon% = 1 THEN
  IF gold% = goldprev% + 10 THEN
   SOUND 200, 1
   SOUND 300, 1
   SOUND 400, 1
   SOUND 500, 1
  ELSE
   SOUND 100, 1
   SOUND 200, 1
  END IF
 END IF

'''Touched a spike or lazer barrier
ELSEIF map$(x%, y%) = "3" OR map$(x%, y%) = "7" THEN
 die
 jumpstate% = 4
 gold% = goldprev%
 dots% = dotsprev%

'''Pick up powerup
ELSEIF map$(x%, y%) = "4" THEN
 map$(x%, y%) = "0"
 jumpmax% = jumpmax% + 1
 LOCATE 23, 1
 COLOR 15
 PRINT " Jump power +1!                         "
 COLOR 11
 LOCATE 21, 15
 PRINT jumpmax%
 IF soundon% = 1 THEN
  SOUND 200, 1
  SOUND 400, 1
 END IF

'''Touched the goal
ELSEIF map$(x%, y%) = "5" THEN
 goaltype% = 0
 goal
 jumpstate% = 4
 IF level% = 7 THEN
  gamestate% = 2
 ELSEIF level% = 9 THEN
  gamestate% = 2
 ELSE
  level% = level% + 1
 END IF
 goldprev% = gold%
 dotsprev% = dots%

'''Touched a lazer switch
ELSEIF map$(x%, y%) = "8" AND (x% <> xprev% OR y% <> yprev%) THEN
 FOR j% = 2 TO 19 STEP 1
  FOR i% = 2 TO 39 STEP 1
   IF map$(i%, j%) = "6" THEN
    map$(i%, j%) = "7"
    LOCATE j%, i%
    COLOR 12
    PRINT CHR$(178)
   ELSEIF map$(i%, j%) = "7" THEN
    map$(i%, j%) = "6"
    LOCATE j%, i%
    COLOR 12
    PRINT CHR$(176)
   END IF
  NEXT i%
 NEXT j%
 LOCATE 23, 1
 COLOR 15
 PRINT " You toggled the lazer barriers.        "
 IF soundon% = 1 THEN
  SOUND 40, 1
  SOUND 80, 1
 END IF

'''Touched a gold door
ELSEIF map$(x%, y%) = "9" AND (x% <> xprev% OR y% <> yprev%) THEN
 IF (level% = 7 AND gold% < 50) OR (level% = 8 AND gold% < 60) THEN
  LOCATE 23, 1
  COLOR 15
  IF level% = 7 THEN
   PRINT " You need 50 gold to enter the tower.   "
  ELSE
   PRINT " You need 60 gold to exit the tower.    "
  END IF
  IF soundon% = 1 THEN
   SOUND 80, 2
   SOUND 40, 2
  END IF
 ELSE
  goaltype% = 1
  goal
  jumpstate% = 4
  IF level% = 7 THEN
   level% = 8
  ELSEIF dots% = 8 THEN
   level% = 9
  ELSE
   gamestate% = 2
  END IF
  goldprev% = gold%
  dotsprev% = dots%
 END IF

'''Touched a beam
ELSEIF map$(x%, y%) = "a" THEN
 IF (x% + y% + beamcycle%) MOD 5 > 1 THEN
  die
  jumpstate% = 4
  gold% = goldprev%
  dots% = dotsprev%
 END IF

'''Touch secret dot
ELSEIF map$(x%, y%) = "b" THEN
 map$(x%, y%) = "c"
 dots% = dots% + 1
END IF

'''Near-death quip
IF (map$(x%, y% + 1) = "3" OR map$(x%, y% + 1) = "7") AND map$(x%, y%) <> "5" AND pchr% = 25 AND quipped% = 0 THEN
 quipped% = 1
 LOCATE 23, 1
 COLOR 15
 randline% = INT(RND * 8) + 1
 IF randline% = 1 THEN
  PRINT " What was the plan here, exactly?       "
 ELSEIF randline% = 2 THEN
  PRINT " Oh, the humanity!                      "
 ELSEIF randline% = 3 THEN
  PRINT " Welp.                                  "
 ELSEIF randline% = 4 THEN
  PRINT " Didn't think that one through, huh?    "
 ELSEIF randline% = 5 THEN
  PRINT " Oh. Okay then.                         "
 ELSEIF randline% = 6 THEN
  PRINT " You're not very good at this, are you? "
 ELSEIF randline% = 7 THEN
  PRINT " How did this happen?                   "
 ELSEIF randline% = 8 THEN
  PRINT " You ponder your recent decisions.      "
 END IF
END IF

'''Save previous position
xprev% = x%
yprev% = y%

'''Draw the player
IF jumpstate% <> 4 THEN '''Not dead
 LOCATE y%, x%
 COLOR 10
 PRINT CHR$(pchr%)
END IF

END SUB

SUB supereffect

tempcol% = INT(RND * 3)
IF tempcol% = 0 THEN
 COLOR 0
ELSEIF tempcol% = 2 THEN
 COLOR 11
ELSE
 COLOR 3
END IF
tryx% = INT(RND * 320)
tryy% = INT(RND * 4)
LINE (tryx%, tryy%)-(tryx%, tryy%)
LINE (tryx%, tryy% + 60)-(tryx%, tryy% + 60)
LINE (tryx%, tryy% + 172)-(tryx%, tryy% + 172)
IF (tryx% > 3 AND tryx% < 88) OR (tryx% > 216 AND tryx% < 316) THEN
 LINE (tryx%, tryy% + 128)-(tryx%, tryy% + 148)
END IF
tryx% = INT(RND * 4)
tryy% = INT(RND * 168) + 4
LINE (tryx%, tryy%)-(tryx%, tryy%)
LINE (tryx% + 316, tryy%)-(tryx% + 316, tryy%)

END SUB

