DECLARE SUB PutChar (x%, y%, char%, forecolor%, backcolor%, page%)
DECLARE SUB ClearScreen ()
DECLARE SUB ProcessCollisions ()
DECLARE SUB DeleteEnemy (index%)
DECLARE SUB NewEnemy ()
DECLARE FUNCTION RandVal% (min%, max%)
DECLARE SUB ProcessEnemies ()
DECLARE FUNCTION CalcEnemyRate% (level%)
DECLARE FUNCTION CalcMaxEnemies% (level%)
DECLARE SUB FireShot (x%, y%, mx%, my%, t%)
DECLARE SUB ProcessShots ()
DECLARE SUB DeleteShot (index%)
DECLARE SUB DrawScreen (border%)
DEFINT A-Z
SCREEN 0: WIDTH 80, 50: SCREEN , , 1, 0: COLOR 15, 0: CLS
RANDOMIZE TIMER

CONST MAXSHOTS = 64
CONST MAXENEMYSPRITES = 128

CONST PLAYERMOVERATE = 6
CONST PLAYERFIRERATE = 8
CONST BASEENEMYCOUNT = 5
CONST ENEMIESPERLEVEL = 5
CONST MAXENEMYBASERATE = 80
CONST MINENEMYBASERATE = 15
CONST ENEMYSPAWNBUFFER = 6
CONST PLAYERIMMUNETIME = 210
CONST PLAYERDEADTIME = 210

' Array Constants
DIM boomcolour(0 TO 3) AS INTEGER
boomcolour(0) = 4
boomcolour(1) = 12
boomcolour(2) = 14
boomcolour(3) = 15

DIM boomchar(0 TO 3) AS STRING * 1
boomchar(0) = ""
boomchar(1) = ""
boomchar(2) = ""
boomchar(3) = ""

' Global Variables
DIM score AS LONG, hiscore AS LONG
score = 0: hiscore = 0

' Sprite Handler Variables
TYPE TSHOT
      x AS INTEGER
      y AS INTEGER
      mx AS INTEGER
      my AS INTEGER
      t AS INTEGER
      fc AS INTEGER
      time AS INTEGER
      c AS STRING * 1
END TYPE
DIM SHARED shotcount
DIM SHARED shot(0 TO MAXSHOTS - 1) AS TSHOT

TYPE TENEMY
      x AS INTEGER
      y AS INTEGER
      t AS INTEGER
      md AS INTEGER
      fc AS INTEGER
      bc AS INTEGER
      c AS STRING * 1
END TYPE
DIM SHARED enemycount
DIM SHARED enemy(0 TO MAXENEMYSPRITES - 1) AS TENEMY

TitleScreen:
COLOR 11, 0: ClearScreen
LOCATE 3
PRINT "                  ͻ      ͻ    "
PRINT "                                                          "
PRINT "                   ͻ        ͻ     "
PRINT "                                                      "
PRINT "                                                      "
PRINT "                                                      "
PRINT "                                                      "
PRINT "                                                      "
PRINT "                                        ͼ ͻ"
PRINT "                         /\                             "
PRINT "                         \ \            ͻ "
PRINT "                          \ \                         "
PRINT "                           \ \                        "
PRINT "                            \ \                       "
PRINT "                             \ \                       "
PRINT "                              \ \                      "
PRINT "                    \ \        ͼ "
PRINT "                                 \ \                       "
PRINT "                   \/      ͼ"
PRINT
COLOR 10
PRINT "                          "
PRINT "                                                          "
PRINT "                               "
PRINT "                                                        "
PRINT "                          "
PRINT
COLOR 15
PRINT "   Copyright 2017 Pixelmusement                                          v1.0"
PRINT
PRINT
PRINT
s$ = "Hi-Score This Session: " + LTRIM$(RTRIM$(STR$(hiscore)))
LOCATE , (80 - LEN(s$)) / 2: COLOR 14: PRINT s$
COLOR 15
PRINT
PRINT
PRINT "                Movement Controls                Firing Controls"
PRINT "                -----------------                ---------------"
PRINT
PRINT "                     Q  W  E                         7  8  9"
PRINT "                      \  /                           \  / "
PRINT
PRINT "                     A   D                         4   6"
PRINT
PRINT "                      /  \                           /  \ "
PRINT "                     Z  X  C                         1  2  3"
PRINT
PRINT
COLOR 11
s$ = "----- Press any key to start or ESC to quit -----"
LOCATE , (80 - LEN(s$)) / 2: PRINT s$
PutChar 24, 42, 2, 11, 1, 1
PutChar 56, 42, 2, 11, 1, 1
PCOPY 1, 0
DO: A$ = INKEY$: LOOP WHILE A$ = ""
IF A$ = CHR$(27) THEN GOTO Quit

' Game State Variables
level = 1: score = 0: lives = 2
maxenemies = CalcMaxEnemies(level)
enemiesleft = maxenemies
enemytimerrate = CalcEnemyRate(level)
newenemytimer = enemytimerrate
playerdead = -1

' Player Variables
px = 40: py = 25: pmx = 0: pmy = 0: pfx = 0: pfy = 0
pmd = 0: pfd = 0: pimmune = 0

shotcount = 0: enemycount = 0

GameLoop:
IF playerdead >= 0 THEN
      playerdead = playerdead + 1
      IF playerdead >= PLAYERDEADTIME THEN
            IF lives = 0 THEN GOTO GameOver
            px = RandVal(2, 79)
            py = RandVal(3, 48)
            pfx = 0: pfy = 0: pmx = 0: pmy = 0
            playerdead = -1
            lives = lives - 1
            pimmune = PLAYERIMMUNETIME
      END IF
ELSE
      IF pimmune > 0 THEN pimmune = pimmune - 1
      pmd = pmd - 1
      IF pmd <= 0 THEN
            px = px + pmx: py = py + pmy
            IF px < 2 THEN px = 2
            IF px > 79 THEN px = 79
            IF py < 3 THEN py = 3
            IF py > 48 THEN py = 48
            pmd = PLAYERMOVERATE
      END IF
      pfd = pfd - 1
      IF pfd <= 0 THEN
            IF pfx <> 0 OR pfy <> 0 THEN
                  FireShot px, py, pfx, pfy, 1
                  pfd = PLAYERFIRERATE
            ELSE
                  pfd = 0
            END IF
      END IF
END IF
ProcessShots
ProcessCollisions
IF enemiesleft <= 0 THEN GOTO NextLevel
newenemytimer = newenemytimer - 1
IF (newenemytimer <= 0) THEN
      NewEnemy
      newenemytimer = enemytimerrate
END IF
ProcessEnemies

RenderScreen:
DrawScreen (((level - 1) MOD 6) + 9)
c$ = " Level " + LTRIM$(RTRIM$(STR$(level))) + " "
LOCATE 49, 40 - (LEN(c$) / 2): COLOR 15, 0: PRINT c$;
c$ = LTRIM$(RTRIM$(STR$(score)))
LOCATE 1, 40 - (LEN(c$) / 2): COLOR 11, 0: PRINT c$;
z = 78: zz = lives: COLOR 11, 1
DO WHILE zz > 0
      PutChar z, 0, 2, 11, 1, 1
      z = z - 2
      zz = zz - 1
LOOP
c$ = STRING$(40 * enemiesleft / maxenemies, ">")
LOCATE 50, 41 - LEN(c$): COLOR 14, 4: PRINT c$;
c$ = STRING$(40 * enemiesleft / maxenemies, "<")
LOCATE 50, 41: COLOR 14, 4: PRINT c$;
RenderSprites:
COLOR , 0
FOR z = 0 TO shotcount - 1
      SELECT CASE shot(z).t
            CASE 2
                  FOR x = shot(z).x - 1 TO shot(z).x + 1
                        FOR y = shot(z).y - 1 TO shot(z).y + 1
                              IF RandVal(0, 69) >= shot(z).time THEN
                                    LOCATE y, x
                                    COLOR boomcolour(RandVal(0, 3)), 0
                                    PRINT boomchar(RandVal(0, 3));
                              END IF
                        NEXT y
                  NEXT x
            CASE ELSE
                  LOCATE shot(z).y, shot(z).x: COLOR shot(z).fc: PRINT shot(z).c;
      END SELECT
NEXT z
FOR z = 0 TO enemycount - 1
      LOCATE enemy(z).y, enemy(z).x: COLOR enemy(z).fc, enemy(z).bc: PRINT enemy(z).c;
NEXT z
IF playerdead < 0 AND (pimmune MOD 10) < 5 THEN PutChar px - 1, py - 1, 2, 11, 1, 1
WAIT &H3DA, 8                     ' Wait for vertical retrace!
PCOPY 1, 0

ProcessInput:
A$ = UCASE$(INKEY$)
IF A$ = "Q" THEN pmx = -1: pmy = -1
IF A$ = "W" THEN pmx = 0: pmy = -1
IF A$ = "E" THEN pmx = 1: pmy = -1
IF A$ = "A" THEN pmx = -1: pmy = 0
IF A$ = "S" THEN pmx = 0: pmy = 0
IF A$ = "D" THEN pmx = 1: pmy = 0
IF A$ = "Z" THEN pmx = -1: pmy = 1
IF A$ = "X" THEN pmx = 0: pmy = 1
IF A$ = "C" THEN pmx = 1: pmy = 1
IF A$ = "7" THEN pfx = -1: pfy = -1
IF A$ = "8" THEN pfx = 0: pfy = -1
IF A$ = "9" THEN pfx = 1: pfy = -1
IF A$ = "4" THEN pfx = -1: pfy = 0
IF A$ = "5" THEN pfx = 0: pfy = 0
IF A$ = "6" THEN pfx = 1: pfy = 0
IF A$ = "1" THEN pfx = -1: pfy = 1
IF A$ = "2" THEN pfx = 0: pfy = 1
IF A$ = "3" THEN pfx = 1: pfy = 1
IF A$ = CHR$(27) THEN
      lives = 0
      playerdead = 0
      FireShot px, py, -1, -1, 3
      FireShot px, py, 0, -1, 3
      FireShot px, py, 1, -1, 3
      FireShot px, py, -1, 0, 3
      FireShot px, py, 1, 0, 3
      FireShot px, py, -1, 1, 3
      FireShot px, py, 0, 1, 3
      FireShot px, py, 1, 1, 3
      FireShot px, py, 0, 0, 2
END IF
GOTO GameLoop

NextLevel:
playerdead = -1
c$ = LTRIM$(RTRIM$(STR$(score)))
LOCATE 1, 40 - (LEN(c$) / 2): COLOR 11, 0: PRINT c$;
COLOR 4, 0: LOCATE 50, 1: PRINT "";
nltime = 0: nlfxy1 = 25: nlfxy2 = 25: nlbasecol = RandVal(0, 15)
NextLevel2:
nlbasecol = (nlbasecol + 1) MOD 16
FOR z = nlfxy1 TO 25
      s$ = STRING$(84 - (z * 2), 219)
      IF z > nlfxy2 THEN COLOR 0, 0 ELSE COLOR (nlbasecol + z) MOD 16, 0
      LOCATE z, z - 1: PRINT s$;
      LOCATE 51 - z, z - 1: PRINT s$;
      FOR zz = z + 1 TO 50 - z
            LOCATE zz, z - 1: PRINT "";
            LOCATE zz, 82 - z: PRINT "";
      NEXT zz
NEXT z
nltime = nltime + 1
IF nlfxy1 > 2 THEN nlfxy1 = nlfxy1 - 1
IF nltime > 30 THEN
      IF nlfxy2 > 2 THEN
            nlfxy2 = nlfxy2 - 1
      ELSE
            level = level + 1
            shotcount = 0
            enemycount = 0
            maxenemies = CalcMaxEnemies(level)
            enemiesleft = maxenemies
            enemytimerrate = CalcEnemyRate(level)
            newenemytimer = enemytimerrate
            GOTO GameLoop
      END IF
END IF
WAIT &H3DA, 8                     ' Wait for vertical retrace!
PCOPY 1, 0
GOTO NextLevel2

GameOver:                 
COLOR 15, 4
LOCATE 22, 15: PRINT "                                                    ";
LOCATE 23, 15: PRINT "                  ";
LOCATE 24, 15: PRINT "                                     ";
LOCATE 25, 15: PRINT "                       ";
LOCATE 26, 15: PRINT "                                      ";
LOCATE 27, 15: PRINT "                         ";
LOCATE 28, 15: PRINT "                                                    ";
PCOPY 1, 0
DO: A$ = INKEY$: LOOP WHILE A$ = ""
GOTO TitleScreen

Quit:
SCREEN 0, , 0, 0: WIDTH 80, 25: COLOR 7, 0: CLS
SYSTEM

FUNCTION CalcEnemyRate (level)
z = MAXENEMYBASERATE - ((level - 1) * 5)
IF z < MINENEMYBASERATE THEN z = MINENEMYBASERATE
CalcEnemyRate = z
END FUNCTION

FUNCTION CalcMaxEnemies (level)
CalcMaxEnemies = BASEENEMYCOUNT + ((level - 1) * ENEMIESPERLEVEL)
END FUNCTION

SUB ClearScreen
FOR z = 1 TO 50
      LOCATE z, 1
      PRINT "                                                                                ";
NEXT z
END SUB

SUB DeleteEnemy (index)
IF index = enemycount - 1 THEN
      enemycount = enemycount - 1
ELSE
      enemy(index) = enemy(enemycount - 1)
      enemycount = enemycount - 1
END IF
END SUB

SUB DeleteShot (index)
IF index = shotcount - 1 THEN
      shotcount = shotcount - 1
ELSE
      shot(index) = shot(shotcount - 1)
      shotcount = shotcount - 1
END IF
END SUB

SUB DrawScreen (border)
COLOR 15, 0
LOCATE 1, 1: PRINT " QB DEBUGGER HERO                                                               ";
COLOR border, 0
LOCATE 2, 1: PRINT "";
LOCATE 49, 1: PRINT "";
FOR z = 3 TO 48
      LOCATE z, 1: PRINT "                                                                              ";
NEXT z
COLOR 4, 0: LOCATE 50, 1: PRINT "";
END SUB

SUB FireShot (x, y, mx, my, t)
IF shotcount < MAXSHOTS THEN
      shot(shotcount).x = x
      shot(shotcount).y = y
      shot(shotcount).mx = mx
      shot(shotcount).my = my
      shot(shotcount).t = t
      shot(shotcount).time = 0
      SELECT CASE t
            CASE 1
                  shot(shotcount).fc = 12
                  IF mx = -1 THEN
                        IF my = -1 THEN
                              shot(shotcount).c = "\"
                        ELSEIF my = 1 THEN
                              shot(shotcount).c = "/"
                        ELSE
                              shot(shotcount).c = ""
                        END IF
                  ELSEIF mx = 1 THEN
                        IF my = -1 THEN
                              shot(shotcount).c = "/"
                        ELSEIF my = 1 THEN
                              shot(shotcount).c = "\"
                        ELSE
                              shot(shotcount).c = ""
                        END IF
                  ELSE
                        shot(shotcount).c = ""
                  END IF
            CASE 3
                  shot(shotcount).fc = 11
                  shot(shotcount).c = ""
      END SELECT
      shotcount = shotcount + 1
END IF
END SUB

SUB NewEnemy
SHARED px, py, level
IF enemycount >= MAXENEMYSPRITES THEN EXIT SUB
z = enemycount
DO
      enemy(z).x = RandVal(3, 78)
      enemy(z).y = RandVal(4, 47)
      x = ABS(enemy(z).x - px)
      y = ABS(enemy(z).y - py)
LOOP WHILE (x < ENEMYSPAWNBUFFER OR y < ENEMYSPAWNBUFFER)
zz = (level - 1) / 5 + 1
IF zz > 4 THEN zz = 4
enemy(z).t = (4 - RandVal(1, zz)) * 10 + 15 ' 45,35,25,15
enemy(z).md = 70 + enemy(z).t
enemy(z).fc = 15
enemy(z).bc = 0
enemy(z).c = ""
enemycount = enemycount + 1
END SUB

SUB ProcessCollisions
SHARED score AS LONG, hiscore AS LONG, lives, enemiesleft
SHARED px, py
FOR z = 0 TO shotcount - 1
      SELECT CASE shot(z).t
            CASE 1
                  shothit = 0
                  FOR zz = 0 TO enemycount - 1
                        IF shot(z).x = enemy(zz).x AND shot(z).y = enemy(zz).y THEN
                              prevscore& = score
                              SELECT CASE enemy(zz).t
                                    CASE 45: score = score + 100
                                    CASE 35: score = score + 200
                                    CASE 25: score = score + 300
                                    CASE 15: score = score + 400
                              END SELECT
                              IF prevscore& < 10000 AND score >= 10000 THEN lives = lives + 1
                              IF prevscore& < 100000 AND score >= 100000 THEN lives = lives + 1
                              IF prevscore& < 1000000 AND score >= 1000000 THEN lives = lives + 1
                              IF score > hiscore THEN hiscore = score
                              shothit = 1
                              enemiesleft = enemiesleft - 1
                              DeleteEnemy zz
                              EXIT FOR
                        END IF
                  NEXT zz
      END SELECT
      IF shothit = 1 THEN
            SELECT CASE shot(z).t
                  CASE 1
                        shot(z).t = 2 ' Explosion Type
                        shot(z).mx = 0
                        shot(z).my = 0
                        shot(z).time = 0
            END SELECT
      END IF
NEXT z
END SUB

SUB ProcessEnemies
SHARED px, py, playerdead, pimmune
z = 0
DO WHILE z < enemycount
      enemy(z).md = enemy(z).md - 1
      IF enemy(z).md > enemy(z).t THEN
            enemy(z).fc = RandVal(1, 15)
            enemy(z).bc = RandVal(0, 7)
            enemy(z).c = CHR$(RandVal(128, 255))
      ELSEIF enemy(z).md = enemy(z).t THEN
            SELECT CASE enemy(z).t
                  CASE 45
                        enemy(z).fc = 13
                        enemy(z).bc = 0
                        enemy(z).c = ""
                  CASE 35
                        enemy(z).fc = 14
                        enemy(z).bc = 6
                        enemy(z).c = ""
                  CASE 25
                        enemy(z).fc = 10
                        enemy(z).bc = 0
                        enemy(z).c = ""
                  CASE 15
                        enemy(z).fc = 15
                        enemy(z).bc = 4
                        enemy(z).c = ""
            END SELECT
      ELSEIF enemy(z).md <= 0 THEN
            IF playerdead < 0 THEN
                  IF px < enemy(z).x THEN enemy(z).x = enemy(z).x - 1
                  IF px > enemy(z).x THEN enemy(z).x = enemy(z).x + 1
                  IF py < enemy(z).y THEN enemy(z).y = enemy(z).y - 1
                  IF py > enemy(z).y THEN enemy(z).y = enemy(z).y + 1
            END IF
            enemy(z).md = enemy(z).t
      END IF
      IF pimmune <= 0 THEN
            IF px = enemy(z).x AND py = enemy(z).y AND playerdead < 0 THEN
                  playerdead = 0
                  FireShot px, py, -1, -1, 3
                  FireShot px, py, 0, -1, 3
                  FireShot px, py, 1, -1, 3
                  FireShot px, py, -1, 0, 3
                  FireShot px, py, 1, 0, 3
                  FireShot px, py, -1, 1, 3
                  FireShot px, py, 0, 1, 3
                  FireShot px, py, 1, 1, 3
                  FireShot px, py, 0, 0, 2
            END IF
      END IF
      z = z + 1
LOOP
END SUB

SUB ProcessShots
z = 0
DO WHILE z < shotcount
      shot(z).time = shot(z).time + 1
      shot(z).x = shot(z).x + shot(z).mx
      shot(z).y = shot(z).y + shot(z).my
      SELECT CASE shot(z).t
            CASE 2
                  IF shot(z).time >= 70 THEN
                        DeleteShot z
                        IF z < shotcount THEN z = z - 1
                  END IF
            CASE ELSE
                  IF shot(z).x < 2 OR shot(z).x > 79 OR shot(z).y < 3 OR shot(z).y > 48 THEN
                        DeleteShot z
                        IF z < shotcount THEN z = z - 1
                  END IF
      END SELECT
      z = z + 1
LOOP
END SUB

SUB PutChar (x, y, char, forecolor, backcolor, page)
DEF SEG = &HB800 + (page * 516)
POKE (y * 160) + (x * 2), char
POKE ((y * 160) + (x * 2)) + 1, forecolor + (backcolor * 16)
DEF SEG
END SUB

FUNCTION RandVal (min, max)
RandVal = FIX((RND * .9999999) * CSNG(max - min + 1)) + min
END FUNCTION

