' Santa's Christmas Rescue v1.0
'--------------------------------
'
' Release: 12/25/2017
'
' Thanks for downloading and trying out my little Christmas challenge.
' I hope you enjoy playing this game as much as I have enjoyed making it.
' Let me know of any bugs and I'll work on building future versions of
' the game. (I know there's many)
'
' Happy holidays 2017!
'
'    -Erik Eriksen
'     http://eriks.servehttp.com
'
DECLARE SUB loadLevel (directory AS STRING, levelName AS STRING)
DECLARE SUB setUserLevelName ()
DECLARE SUB runGame (isDebugOn AS INTEGER)
DECLARE SUB addHighscore ()
DECLARE SUB loadHighscores ()
DECLARE SUB saveHighscores ()
DECLARE SUB showHighScores ()
DECLARE SUB loadAssets ()
DECLARE SUB initLevel ()
DECLARE SUB showEndGame ()
DECLARE SUB showPostGame ()
DECLARE SUB showInstructions ()
DECLARE FUNCTION processTitleScreen! ()
DECLARE SUB showGameOver ()
DECLARE SUB moveEnemies ()
DECLARE SUB drawEnemy (enemyNumber AS INTEGER)
DECLARE SUB drawLevel ()
DECLARE FUNCTION checkCollision! (who AS ANY, withWho AS ANY)
DECLARE SUB showDebug (isDebugOn AS INTEGER)
DECLARE SUB showScore ()
DECLARE SUB drawSprite (x AS INTEGER, y AS INTEGER, sprite!())
DECLARE SUB movePlayer (deltaX AS INTEGER, deltaY AS INTEGER)
DECLARE SUB drawSpriteMask (x AS INTEGER, y AS INTEGER)
DECLARE SUB loadSprite (destSprite!())
DECLARE SUB init ()
DECLARE SUB drawPlayer ()
DECLARE SUB loadSpriteData ()

RANDOMIZE TIMER

ON ERROR GOTO ErrorHandler
'ON PLAY(1) GOSUB PlayBackgroundMusic
PLAY ON

CONST spriteWidth = 8
CONST spriteHeight = 16
CONST spriteStep = 2
CONST FORWARD = 1
CONST BACKWARD = 0
CONST TRUE = 1
CONST FALSE = 0
CONST totalLevels = 16
CONST maxJumpHeight = 36
CONST maxX = 300
CONST maxY = 200
CONST maxHorizontalSprites = maxX / spriteWidth
CONST maxPresents = 8
CONST maxEnemies = 8
CONST numHighscores = 5

TYPE spriteInfo
  frame AS INTEGER
  numFrames AS INTEGER
  frameDirection AS INTEGER
END TYPE


TYPE actor
  numLives AS INTEGER
  score AS INTEGER
  startX AS INTEGER
  startY AS INTEGER
  x AS INTEGER
  y AS INTEGER
  isJumping AS INTEGER
  hasJumpLanded AS INTEGER
  hasReachedJumpHeight AS INTEGER
  topJumpY AS INTEGER
  walkingDirection AS INTEGER
  gotFreeLive AS INTEGER
  sprite AS spriteInfo
END TYPE

TYPE levelInfo
  numEnemies AS INTEGER
  numPresents AS INTEGER
  levelDrawn AS INTEGER
  isLevelInit AS INTEGER
END TYPE

TYPE highscore
  pname AS STRING * 10
  score AS INTEGER
END TYPE

SCREEN 7, 0, 0, 1

DIM SHARED p AS actor
DIM SHARED enemies(maxEnemies) AS actor
DIM SHARED present(maxPresents) AS actor
DIM SHARED currentLevel AS INTEGER
DIM SHARED introMusicPlayed AS INTEGER
DIM SHARED highscores(numHighscores) AS highscore
DIM SHARED lvlInfo(totalLevels) AS levelInfo
DIM SHARED maskSprite(spriteWidth, spriteHeight)
DIM SHARED playerSprite1(spriteWidth, spriteHeight)
DIM SHARED playerSprite2(spriteWidth, spriteHeight)
DIM SHARED playerSprite3(spriteWidth, spriteHeight)
DIM SHARED playerSprite4(spriteWidth, spriteHeight)
DIM SHARED enemySprite1(spriteWidth, spriteHeight)
DIM SHARED enemySprite2(spriteWidth, spriteHeight)
DIM SHARED enemySprite3(spriteWidth, spriteHeight)
DIM SHARED enemySprite4(spriteWidth, spriteHeight)
DIM SHARED presentSprite1(spriteWidth, spriteHeight)
DIM SHARED snowSprite(spriteWidth, spriteHeight)

DIM SHARED levelHeight(maxHorizontalSprites) AS INTEGER
DIM SHARED isUserLevel AS INTEGER
DIM SHARED userLevelName AS STRING

DIM isDebugOn AS INTEGER
DIM isRunning AS INTEGER
DIM inGame AS INTEGER

CALL loadAssets

introMusicPlayed = FALSE
isDebugOn = FALSE

restartOnError:

isRunning = TRUE
inGame = FALSE
isUserLevel = FALSE

'main loop

WHILE isRunning = TRUE

  titleScreenChoice% = processTitleScreen

  IF titleScreenChoice% = 1 THEN
    userLevelName = ""
    isUserLevel = FALSE
    CALL init
    CALL runGame(isDebugOn)
  ELSEIF titleScreenChoice% = 2 THEN
    CALL showHighScores
  ELSEIF titleScreenChoice% = 3 THEN
    CALL showInstructions
  ELSEIF titleScreenChoice% = 4 THEN
    isUserLevel = TRUE
    CALL setUserLevelName
    IF isUserLevel = TRUE THEN
      CALL init
      CALL runGame(isDebugOn)
    END IF
  ELSE
    isRunning = FALSE
  END IF

WEND

CALL showPostGame

END



' PLAY event-handling subroutine.
PlayBackgroundMusic:
   
RETURN


ErrorHandler:
 
  LOCATE 10
  COLOR 15
  PRINT
  PRINT "ERROR: "; ERR
 
  SELECT CASE ERR
    CASE 51
      PRINT "Internal error"
    CASE 52
      PRINT "Bad file name or number"
    CASE 53
      PRINT "File not found"
    CASE 54
      PRINT "Bad file mode"
    CASE 57
      PRINT "Device I/O error"
    CASE 58
      PRINT "File already exists"
    CASE 61
      PRINT "Disk full."
    CASE 64
      PRINT "Bad file name"
    CASE 70
      PRINT "Permission denied"
    CASE 71
      PRINT "Disk not ready"
    CASE 72
      PRINT "Disk-media error"
    CASE 73
      PRINT "Feature unavailable."
    CASE 75
      PRINT "Path/file access error"
    CASE 76:
      PRINT "Path not found"
  END SELECT

  LOCATE 15
  COLOR 10
  PRINT "Unfortunately Qbasic will only catch"
  PRINT "this once. So next error will crash out"
  PRINT "and require a restart of the program."
  

  LOCATE 20, 2
  COLOR 12
  PRINT "Press spacebar to go to menu"

  PCOPY 0, 1

  WHILE INP(96) <> 57: WEND

  CLS

  GOSUB restartOnError



'data

'sprite mask
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0


'playerSprite1
DATA  0,  0, 15,  4,  0, 0,  0,  0
DATA  0,  0,  4,  4,  4, 0,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  7,  7,  1,  7,  1, 7,  7,  0
DATA  7,  7,  7, 15,  7, 7,  7,  0
DATA  0, 15, 15,  0, 15,15,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  4,  0, 15, 15, 15, 0,  0,  0
DATA 15,  4,  4, 15,  4, 0,  0,  0
DATA  0, 15,  4, 15,  4, 4,  0,  0
DATA  4,  0,  4, 15,  4,15,  4,  0
DATA 15,  4,  4, 15,  4, 0, 15,  0
DATA  0, 15,  4, 15,  4, 0,  0,  0
DATA  0,  0, 15, 15, 15, 4,  0,  0
DATA  0,  0,  0,  0,  0,15,  4,  0
DATA  0,  0,  0,  0,  0, 0, 15,  0

'playerSprite2
DATA  0,  0,  0, 15,  0, 0,  0,  0
DATA  0,  0,  4,  4,  4, 0,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  7,  7,  1,  7,  1, 7,  7,  0
DATA  7,  7,  7, 15,  7, 7,  7,  0
DATA  0, 15, 15,  0, 15,15,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  0,  0, 15, 15, 15, 0,  0,  0
DATA  4,  4,  4, 15,  4, 0,  0,  0
DATA 15, 15,  4, 15,  4, 4,  4,  0
DATA  0,  0,  4, 15,  4,15, 15,  0
DATA  4,  4,  4, 15,  4, 0,  0,  0
DATA 15, 15,  4, 15,  4, 0,  0,  0
DATA  0,  0, 15, 15, 15, 4,  4,  0
DATA  0,  0,  0,  0,  0,15, 15,  0
DATA  0,  0,  0,  0,  0, 0,  0,  0

'playerSprite3
DATA  0,  0,  0,  4, 15, 0,  0,  0
DATA  0,  0,  4,  4,  4, 0,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  7,  7,  1,  7,  1, 7,  7,  0
DATA  7,  7,  7, 15,  7, 7,  7,  0
DATA  0, 15, 15,  0, 15,15,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  0,  0, 15, 15, 15, 0,  0,  0
DATA  0,  4,  4, 15,  4, 0,  0,  0
DATA  4, 15,  4, 15,  4, 4,  0,  0
DATA 15,  0,  4, 15,  4,15,  4,  0
DATA  0,  0,  4, 15,  4, 0, 15,  0
DATA  0,  4,  4, 15,  4, 4,  4,  0
DATA  4, 15, 15, 15, 15,15, 15,  0
DATA 15,  0,  0,  0,  0, 0,  0,  0
DATA  0,  0,  0,  0,  0, 0,  0,  0

'playerSprite4
DATA  0,  0,  0, 15,  0, 0,  0,  0
DATA  0,  0,  4,  4,  4, 0,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  7,  7,  1,  7,  1, 7,  7,  0
DATA  7,  7,  7, 15,  7, 7,  7,  0
DATA  0, 15, 15,  0, 15,15,  0,  0
DATA  0, 15, 15, 15, 15,15,  0,  0
DATA  0,  0, 15, 15, 15, 0,  0,  0
DATA  0,  0,  4, 15,  4, 0,  0,  0
DATA  0,  4,  4, 15,  4, 4,  0,  0
DATA  4, 15,  4, 15,  4,15,  4,  0
DATA 15,  0,  4, 15,  4, 0, 15,  0
DATA  0,  0,  4, 15,  4, 4, 15,  0
DATA  0,  4,  4, 15, 15,15,  0,  0
DATA  4, 15, 15,  0,  0, 0,  0,  0
DATA 15,  0,  0,  0,  0, 0,  0,  0


'enemy sprite 1
DATA  0,  0,  0,  2,  0,  0,  0,  0
DATA  0,  0,  0, 10,  0,  0,  0,  0
DATA  0,  0, 10, 10, 10,  0,  0,  0
DATA  0, 10, 10, 10, 10, 10,  0,  0
DATA  2, 10, 10, 10, 10, 10,  2,  0
DATA  0,  8,  4,  8,  4,  8,  0,  0
DATA  0,  8,  8,  8,  8,  8,  0,  0
DATA  0,  0,  8,  7,  8,  0,  0,  0
DATA  0,  0,  0,  8,  0,  0,  2,  0
DATA  0,  2,  2, 10,  2,  2,  2,  0
DATA  2,  2,  2, 10,  2,  2,  0,  0
DATA  2,  0,  2, 10,  2,  0,  0,  0
DATA  0,  2,  2, 10,  2,  2,  0,  0
DATA  0,  2,  2,  2,  2,  2,  2,  0
DATA  2,  2,  0,  0,  0,  0,  2,  0
DATA  2,  2,  0,  0,  0,  0,  2,  2

'enemy sprite 2
DATA  0,  0,  0,  2,  0,  0,  0,  0
DATA  0,  0,  0, 10,  0,  0,  0,  0
DATA  0,  0, 10, 10, 10,  0,  0,  0
DATA  0, 10, 10, 10, 10, 10,  0,  0
DATA  2, 10, 10, 10, 10, 10,  2,  0
DATA  0,  8, 12,  8, 12,  8,  0,  0
DATA  0,  8,  8,  8,  8,  8,  0,  0
DATA  0,  0,  8,  7,  8,  0,  0,  0
DATA  0,  0,  0,  8,  0,  0,  0,  0
DATA  2,  2,  0, 10,  0,  2,  2,  2
DATA  2,  2,  2, 10,  2,  2,  2,  2
DATA  0,  0,  2, 10,  2,  0,  0,  0
DATA  0,  2,  2, 10,  2,  2,  0,  0
DATA  2,  2,  2,  2,  2,  2,  2,  2
DATA  2,  0,  0,  0,  0,  0,  0,  2
DATA  0,  0,  0,  0,  0,  0,  0,  0

'enemy sprite 3
DATA  0,  0,  0,  2,  0,  0,  0,  0
DATA  0,  0,  0, 10,  0,  0,  0,  0
DATA  0,  0, 10, 10, 10,  0,  0,  0
DATA  0, 10, 10, 10, 10, 10,  0,  0
DATA  2, 10, 10, 10, 10, 10,  2,  0
DATA  0,  8,  4,  8,  4,  8,  0,  0
DATA  0,  8,  8,  8,  8,  8,  0,  0
DATA  2,  0,  8,  7,  8,  0,  0,  0
DATA  2,  2,  0,  8,  0,  0,  0,  2
DATA  0,  2,  2, 10,  0,  2,  2,  2
DATA  0,  0,  2, 10,  2,  2,  2,  0
DATA  0,  2,  2, 10,  2,  0,  0,  2
DATA  2,  2,  2, 10,  2,  2,  2,  2
DATA  2,  0,  2,  2,  2,  2,  2,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0

'enemy sprite 4
DATA  0,  0,  0,  2,  0,  0,  0,  0
DATA  0,  0,  0, 10,  0,  0,  0,  0
DATA  0,  0, 10, 10, 10,  0,  0,  0
DATA  0, 10, 10, 10, 10, 10,  0,  0
DATA  2, 10, 10, 10, 10, 10,  2,  0
DATA  0,  8, 12,  8, 12,  8,  0,  0
DATA  2,  8,  8,  8,  8,  8,  0,  0
DATA  2,  2,  8,  7,  8,  2,  2,  2
DATA  0,  2,  2,  8,  2,  2,  2,  2
DATA  0,  0,  2, 10,  2,  0,  0,  0
DATA  0,  0,  2, 10,  2,  0,  0,  2
DATA  2,  2,  2, 10,  2,  0,  2,  2
DATA  2,  2,  2, 10,  2,  2,  2,  0
DATA  0,  0,  2,  2,  2,  2,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0


'present sprite
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0, 14,  0
DATA 14, 14,  0,  0,  0, 14,  0, 14
DATA 14,  0, 14,  0, 14,  0,  0, 14
DATA  0, 14,  0, 14,  0, 14, 14,  0
DATA  0,  0, 14, 14, 14,  0,  0,  0
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA 10, 10, 10, 10, 10, 10, 10, 10
DATA 10, 10, 10, 10, 10, 10, 10, 10
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA  4,  4,  4, 10, 10,  4,  4,  4
DATA  4,  4,  4, 10, 10,  4,  4,  4


'snow sprite
DATA 15, 15, 15, 15, 15, 15, 15, 15
DATA 15, 15, 15, 15, 15, 15, 15, 15
DATA 15, 15, 15, 15, 15, 15, 15, 15
DATA 15, 15, 15, 15, 15, 15, 15, 15
DATA  6, 15, 15,  6, 15, 15,  6, 15
DATA  6,  6, 15,  6, 15,  6,  6,  6
DATA  6,  6,  6,  6,  6,  6,  6,  6
DATA  6,  6,  6,  6,  6,  6,  6,  6
DATA  6,  6,  6,  6,  6,  6,  6,  6
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0

SUB addHighscore

  currentHighscore% = 0

  CALL loadHighscores

  FOR i% = numHighscores * 2 TO 1 STEP -1
    IF i% MOD 2 = 0 THEN

      IF p.score >= highscores(i% / 2).score THEN
        currentHighscore% = i% / 2
      END IF
    END IF

  NEXT i%

  IF currentHighscore% > 0 THEN

    'hack so input shows. does not work when pcopy is required.
    SCREEN 13
    CLS

    COLOR 14
    LOCATE 5, 10
    PRINT "YOU GOT A HIGH SCORE!"
    COLOR 15
    LOCATE 6, 13
    PRINT "SCORE: "; p.score

    LOCATE 9, 5
    INPUT ; "Enter your name: ", name$

    'hack, throw screen back into 7
    SCREEN 7, 0, 0, 1

    FOR i% = numHighscores TO currentHighscore% STEP -1
      nexti% = i% + 1
      IF nexti% <= numHighscores THEN
        highscores(nexti%).pname = highscores(i%).pname
        highscores(nexti%).score = highscores(i%).score
      END IF
    NEXT i%

    highscores(currentHighscore%).pname = name$
    highscores(currentHighscore%).score = p.score

  END IF


  CALL saveHighscores


END SUB

FUNCTION checkCollision (who AS actor, withWho AS actor)

'  COLOR 15
'  LOCATE 1, 1
'  PRINT "who.x="; who.x
'  LOCATE 2, 1
'  PRINT "who.y=", who.y
'  LOCATE 3, 1
'  PRINT "withWho.x="; withWho.x
'  LOCATE 4, 1
'  PRINT "withWho.y="; withWho.y


  'IF (who.x + spriteWidth) >= withWho.x AND who.x <= (withWho.x + spriteWidth) AND who.y >= withWho.y AND (who.y + spriteHeight) <= (withWho.y + spriteHeight) THEN
  IF (who.x + spriteWidth) >= withWho.x AND who.x <= (withWho.x + spriteWidth) AND (who.y + spriteHeight) >= withWho.y AND who.y <= (withWho.y + spriteHeight) THEN

    checkCollision = TRUE
  ELSE
    checkCollision = FALSE
  END IF


END FUNCTION

SUB drawEnemy (enemyNumber AS INTEGER)
 
  IF enemyNumber <= maxEnemies THEN

    IF enemies(enemyNumber).x < 0 THEN enemies(enemyNumber).x = 1
    IF enemies(enemyNumber).x > maxX THEN enemies(enemyNumber).x = maxX
    IF enemies(enemyNumber).y < 0 THEN enemies(enemyNumber).y = 1

    IF enemies(enemyNumber).x > 0 AND enemies(enemyNumber).y > 0 AND (enemies(enemyNumber).x + spriteWidth) < maxX AND (enemies(enemyNumber).y + spriteHeight) < maxY THEN

      SELECT CASE enemies(enemyNumber).sprite.frame
  
        CASE 1
          PUT (enemies(enemyNumber).x, enemies(enemyNumber).y), enemySprite1, PSET

        CASE 2
          PUT (enemies(enemyNumber).x, enemies(enemyNumber).y), enemySprite2, PSET
        
        CASE 3
          PUT (enemies(enemyNumber).x, enemies(enemyNumber).y), enemySprite3, PSET

        CASE 4
          PUT (enemies(enemyNumber).x, enemies(enemyNumber).y), enemySprite4, PSET

        CASE ELSE
          PUT (enemies(enemyNumber).x, enemies(enemyNumber).y), enemySprite1, PSET

      END SELECT

      IF enemies(enemyNumber).sprite.frameDirection = FORWARD THEN
        enemies(enemyNumber).sprite.frame = enemies(enemyNumber).sprite.frame + 1
      
        IF enemies(enemyNumber).sprite.frame > enemies(enemyNumber).sprite.numFrames THEN
          enemies(enemyNumber).sprite.frame = enemies(enemyNumber).sprite.numFrames
          enemies(enemyNumber).sprite.frameDirection = BACKWARD
        END IF
      ELSE
        enemies(enemyNumber).sprite.frame = enemies(enemyNumber).sprite.frame - 1
   
        IF enemies(enemyNumber).sprite.frame < 1 THEN
          enemies(enemyNumber).sprite.frame = 1
          enemies(enemyNumber).sprite.frameDirection = FORWARD
        END IF
      END IF

    END IF

  END IF


END SUB

SUB drawLevel

  IF lvlInfo(currentLevel).levelDrawn = FALSE THEN

    'snow background
    FOR i% = 0 TO 250
      x% = ((maxX - 1 + 1) * RND + 1)
      y% = ((maxY - 1 + 1) * RND + 1)
      PSET (x%, y%), 15
    NEXT i%


    'draw floor
    FOR i% = 1 TO maxHorizontalSprites
      CALL drawSprite(i% * spriteWidth, levelHeight(i%), snowSprite())
    NEXT i%

    FOR i% = 1 TO lvlInfo(currentLevel).numEnemies
      CALL drawEnemy(i%)
    NEXT i%

    CALL drawPlayer

    lvlInfo(currentLevel).levelDrawn = TRUE

  END IF

  'draw presents
  FOR i% = 1 TO lvlInfo(currentLevel).numPresents
    CALL drawSprite(present(i%).x, present(i%).y, presentSprite1())
  NEXT i%


END SUB

SUB drawPlayer

  IF p.x < 0 THEN p.x = 1 + spriteWidth
  IF p.x > maxX THEN p.x = maxX
  IF p.y < 0 THEN
    p.y = 1 + spriteHeight
    p.hasReachedJumpHeight = FALSE
    p.isJumping = FALSE
    p.hasJumpLanded = TRUE
  END IF

  IF p.x > 0 AND p.y > 0 AND (p.x + spriteWidth) < maxX AND (p.y + spriteHeight) < maxY THEN

    SELECT CASE p.sprite.frame
   
      CASE 1
        PUT (p.x, p.y), playerSprite1, PSET

      CASE 2
        PUT (p.x, p.y), playerSprite2, PSET
         
      CASE 3
        PUT (p.x, p.y), playerSprite3, PSET

      CASE 4
        PUT (p.x, p.y), playerSprite4, PSET

      CASE ELSE
        PUT (p.x, p.y), playerSprite1, PSET

    END SELECT
 
    IF p.sprite.frameDirection = FORWARD THEN
      p.sprite.frame = p.sprite.frame + 1

      IF p.sprite.frame > p.sprite.numFrames THEN
        p.sprite.frame = p.sprite.numFrames
        p.sprite.frameDirection = BACKWARD
      END IF
    ELSE
      p.sprite.frame = p.sprite.frame - 1
    
      IF p.sprite.frame < 1 THEN
        p.sprite.frame = 1
        p.sprite.frameDirection = FORWARD
      END IF
    END IF

  END IF


END SUB

SUB drawSprite (x AS INTEGER, y AS INTEGER, sprite())
 
  IF x > 0 AND y > 0 AND x < maxX AND y < maxY THEN
    PUT (x, y), sprite, PSET
  END IF

END SUB

SUB drawSpriteMask (x AS INTEGER, y AS INTEGER)

  IF x > 0 AND y > 0 AND (x + spriteWidth) < maxX AND (y + spriteHeight) < maxY THEN

    PUT (x, y), maskSprite, PSET
  END IF


END SUB

SUB init

  currentLevel = 1

  p.numLives = 10
  p.score = 0
  p.startX = 20
  p.startY = 50
  p.x = p.startX
  p.y = p.startY
  p.topJumpY = 255
  p.isJumping = FALSE
  p.hasJumpLanded = TRUE
  p.hasReachedJumpHeight = FALSE
  p.sprite.frame = 1
  p.sprite.numFrames = 4
  p.sprite.frameDirection = FORWARD

  FOR i% = 0 TO totalLevels
    lvlInfo(i%).isLevelInit = FALSE
  NEXT i%

  CLS

END SUB

SUB initLevel
 
  CLS

  lvlInfo(currentLevel).levelDrawn = FALSE

  levelDir$ = "levels"
  levelName$ = ""

  IF isUserLevel = TRUE THEN
    levelDir$ = "."
    levelName$ = "\" + userLevelName
  END IF

  CALL loadLevel(levelDir$, levelName$)

  IF (lvlInfo(currentLevel).numPresents > 0) THEN

    FOR i% = 1 TO lvlInfo(currentLevel).numPresents
      'present(i%).x = ((250 - 100 + 1) * RND + 100)
      present(i%).y = levelHeight(present(i%).x / spriteWidth) - spriteHeight
      present(i%).score = 250
    NEXT i%
  END IF

  IF (lvlInfo(currentLevel).numEnemies > 0) THEN
    FOR i% = 1 TO lvlInfo(currentLevel).numEnemies
      'enemies(i%).x = ((250 - 50 + 1) * RND + 50)
      enemies(i%).y = levelHeight(enemies(i%).x / spriteWidth) - spriteHeight
      enemies(i%).score = 50
      enemies(i%).sprite.frame = 1
      enemies(i%).sprite.numFrames = 4
      enemies(i%).sprite.frameDirection = FORWARD
      enemies(i%).walkingDirection = RND
    NEXT i%
  END IF

  'set start y above level
  p.startY = levelHeight(p.x / spriteWidth) - spriteHeight
  p.y = p.startY

END SUB

SUB loadAssets

  CALL loadSprite(maskSprite())
  CALL loadSprite(playerSprite1())
  CALL loadSprite(playerSprite2())
  CALL loadSprite(playerSprite3())
  CALL loadSprite(playerSprite4())
  CALL loadSprite(enemySprite1())
  CALL loadSprite(enemySprite2())
  CALL loadSprite(enemySprite3())
  CALL loadSprite(enemySprite4())
  CALL loadSprite(presentSprite1())
  CALL loadSprite(snowSprite())

END SUB

SUB loadHighscores

  filename$ = "hscores.dat"

  OPEN filename$ FOR INPUT AS #4

  FOR i% = 1 TO numHighscores
    IF NOT EOF(4) THEN
      INPUT #4, highscores(i%).pname
      INPUT #4, highscores(i%).score
    END IF
  NEXT i%

  CLOSE #4


END SUB

SUB loadLevel (directory AS STRING, levelName AS STRING)

  'not user level
  IF levelName = "" THEN
    levelName = "\LVL" + STR$(currentLevel)
  END IF

 
  'load level height
  filename$ = directory + levelName + ".DAT"

  OPEN filename$ FOR INPUT AS #1
  
  position% = 1
  DO WHILE NOT EOF(1)
    INPUT #1, levelHeight(position%)
    position% = position% + 1
  LOOP

  CLOSE #1


  'load presents
  filename$ = directory + levelName + ".PNT"
 
  OPEN filename$ FOR INPUT AS #2
 
  INPUT #2, lvlInfo(currentLevel).numPresents

  FOR i% = 1 TO lvlInfo(currentLevel).numPresents
    INPUT #2, present(i%).x
  NEXT i%

  CLOSE #2

  'load enemies
  filename$ = directory + levelName + ".ENE"

  OPEN filename$ FOR INPUT AS #3

  INPUT #3, lvlInfo(currentLevel).numEnemies

  FOR i% = 1 TO lvlInfo(currentLevel).numEnemies
    INPUT #3, enemies(i%).x
  NEXT i%

  CLOSE #3

END SUB

SUB loadSprite (destSprite())

  CLS

  FOR y% = 1 TO spriteHeight
    FOR x% = 1 TO spriteWidth
      READ pixelColor
      PSET (x%, y%), pixelColor
    NEXT x%
  NEXT y%
  GET (1, 1)-(spriteWidth, spriteHeight), destSprite


END SUB

SUB moveEnemies

  IF (lvlInfo(currentLevel).numEnemies > 0) THEN
    FOR i% = 1 TO lvlInfo(currentLevel).numEnemies

      'move them
      CALL drawSpriteMask(enemies(i%).x, enemies(i%).y)

      IF enemies(i%).x <= 0 THEN enemies(i%).x = 1

      IF enemies(i%).x + spriteWidth >= maxX THEN
        enemies(i%).x = maxX - spriteWidth - 1
        enemies(i%).walkingDirection = BACKWARD
      END IF


      IF enemies(i%).walkingDirection = BACKWARD THEN
        enemies(i%).x = enemies(i%).x - spriteStep
      ELSE
        enemies(i%).x = enemies(i%).x + spriteStep
      END IF

      IF levelHeight(enemies(i%).x / spriteWidth) > maxY OR levelHeight(enemies(i%).x / spriteWidth) <> enemies(i%).y + spriteHeight THEN
       
        'enemies(i%).y = enemies(i%).y + spriteStep
       
        IF enemies(i%).walkingDirection = BACKWARD THEN
          enemies(i%).walkingDirection = FORWARD
          enemies(i%).x = enemies(i%).x + (spriteStep * 2)
        ELSE
          enemies(i%).walkingDirection = BACKWARD
          enemies(i%).x = enemies(i%).x - (spriteStep * 2)
        END IF


      END IF

      CALL drawEnemy(i%)


      'check collision with player
      IF checkCollision(p, enemies(i%)) = TRUE THEN

        'if player is jumping on enemy
        IF p.isJumping = TRUE AND p.hasReachedJumpHeight = TRUE AND p.hasJumpLanded = FALSE THEN
          PLAY "O3 L48 C D E"
          p.score = p.score + enemies(i%).score
          CALL drawSpriteMask(enemies(i%).x, enemies(i%).y)
          enemies(i%).x = 0
          enemies(i%).y = 0

        'enemy kills player
        ELSE
          PLAY "O3 L48 C B A"
          CALL drawSpriteMask(p.x, p.y)
          p.x = p.startX
          p.y = p.startY
          p.numLives = p.numLives - 1

        END IF
 
      END IF

    NEXT i%
  END IF


END SUB

SUB movePlayer (deltaX AS INTEGER, deltaY AS INTEGER)

  CALL drawSpriteMask(p.x, p.y)

  'check collision with present
  FOR i% = 1 TO lvlInfo(currentLevel).numPresents
    IF checkCollision(p, present(i%)) = TRUE THEN
      PLAY "O3 L48 C B C"
      p.score = p.score + present(i%).score
     
      CALL drawSpriteMask(present(i%).x, present(i%).y)
      present(i%).x = 0
      present(i%).y = 0
    END IF
  NEXT i%

  'if hits side of ground... hey maybe in the next version? :)
  'IF p.y + deltaY + spriteHeight > levelHeight(p.x / spriteWidth) THEN
  '  deltaX = 0
  'END IF

  'update xy
  p.x = p.x + deltaX
  p.y = p.y + deltaY

  'handle level changes... maybe not the best spot
  'also is buggy
  IF p.x >= maxX - spriteWidth THEN
   
    'sort of hackish way to force user levels to finish the game
    IF isUserLevel = TRUE THEN
      currentLevel = totalLevels
    END IF
    p.x = p.startX
    p.y = p.startY
    p.topJumpY = 255
    currentLevel = currentLevel + 1

  END IF
 
  'draw at new location
  CALL drawPlayer

END SUB

FUNCTION processTitleScreen
  
  CLS

  'snow background
  FOR i% = 0 TO 250
    x% = ((maxX - 1 + 1) * RND + 1)
    y% = ((maxY - 1 + 1) * RND + 1)
    PSET (x%, y%), 15
  NEXT i%

  'S
  LINE (20, 20)-STEP(25, 5), 10, BF
  LINE (20, 25)-STEP(5, 25), 10, BF
  LINE (20, 45)-STEP(20, 5), 10, BF
  LINE (40, 45)-STEP(5, 25), 10, BF
  LINE (20, 65)-STEP(25, 5), 10, BF

  'A
  LINE (50, 45)-STEP(25, 5), 10, BF
  LINE (50, 50)-STEP(5, 20), 10, BF
  LINE (70, 50)-STEP(5, 20), 10, BF
  LINE (50, 55)-STEP(25, 5), 10, BF

  'N
  LINE (80, 45)-STEP(5, 25), 10, BF
  LINE (85, 45)-STEP(20, 25), 10
  LINE (85, 50)-STEP(15, 20), 10
  LINE (100, 45)-STEP(5, 25), 10, BF
  PAINT (87, 49), 10

  'T
  LINE (115, 20)-STEP(5, 50), 10, BF
  LINE (110, 35)-STEP(15, 5), 10, BF

  'A
  LINE (130, 45)-STEP(25, 5), 10, BF
  LINE (130, 50)-STEP(5, 20), 10, BF
  LINE (150, 50)-STEP(5, 20), 10, BF
  LINE (130, 55)-STEP(25, 5), 10, BF

  ''
  LINE (160, 35)-STEP(5, 5), 10, BF

  'S
  LINE (170, 45)-STEP(25, 5), 10, BF
  LINE (170, 50)-STEP(5, 5), 10, BF
  LINE (190, 60)-STEP(5, 5), 10, BF
  LINE (170, 55)-STEP(25, 5), 10, BF
  LINE (195, 65)-STEP(-25, 5), 10, BF

  LOCATE 10, 10
  COLOR 12
  PRINT "CHRISTMAS RESCUE"

  CALL drawSprite(220, 55, playerSprite1())
  CALL drawSprite(250, 55, presentSprite1())

  LOCATE 23, 7
  COLOR 7
  PRINT "(C) 2017 Nukem Enterprises"

  PCOPY 0, 1

  IF introMusicPlayed = FALSE THEN
    PLAY "O2 L16 E E L8 E L16 E E L8 E L16 E G C D L8 E"
    introMusicPlayed = TRUE
  END IF

  selectionMade% = FALSE
  current% = 1
  maxOptions% = 5

  WHILE selectionMade% = FALSE

    a$ = INKEY$

 
    LOCATE 15, 15
    IF current% = 1 THEN
      COLOR 15
    ELSE
      COLOR 8
    END IF
    PRINT "Play Game"

    LOCATE 16, 15
    IF current% = 2 THEN
      COLOR 15
    ELSE
      COLOR 8
    END IF
    PRINT "High Scores"

    LOCATE 17, 15
    IF current% = 3 THEN
      COLOR 15
    ELSE
      COLOR 8
    END IF
    PRINT "Instructions"


    LOCATE 18, 15
    IF current% = 4 THEN
      COLOR 15
    ELSE
      COLOR 8
    END IF
    PRINT "User Level"


    LOCATE 19, 15
    IF current% = 5 THEN
      COLOR 15
    ELSE
      COLOR 8
    END IF
    PRINT "Exit"

    PCOPY 0, 1

    'down
    IF a$ = CHR$(0) + CHR$(80) THEN
      current% = current% + 1
      IF current% > maxOptions% THEN
        current% = maxOptions%
      END IF
    

    'up
    ELSEIF a$ = CHR$(0) + CHR$(72) THEN
      current% = current% - 1
      IF current% < 1 THEN
        current% = 1
      END IF
    

    'enter
    ELSEIF a$ = CHR$(13) THEN
      PLAY "O2 L 48 C B A"
      processTitleScreen = current%
      selectionMade% = TRUE

    END IF


  WEND

 
  CLS

END FUNCTION

SUB runGame (isDebugOn AS INTEGER)

  gameCompleted = FALSE

  WHILE INKEY$ <> "q" AND p.numLives >= 0 AND gameCompleted = FALSE

    start! = TIMER

    CALL moveEnemies
    CALL drawLevel

    CALL showDebug(isDebugOn)
    CALL showScore

    'handle player falling
    IF (p.y + spriteHeight) < levelHeight(p.x / spriteWidth) AND p.isJumping = TRUE AND p.hasJumpLanded = FALSE AND p.hasReachedJumpHeight = TRUE THEN
      CALL movePlayer(0, spriteStep)
    ELSEIF (p.y + spriteHeight) < levelHeight(p.x / spriteWidth) AND p.isJumping = FALSE AND p.hasJumpLanded = TRUE AND p.hasReachedJumpHeight = FALSE THEN
      CALL movePlayer(0, spriteStep)
    END IF

    'set player as landed when they land on a platform
    IF (p.y + spriteHeight) = levelHeight(p.x / spriteWidth) THEN
      'p.y = levelHeight(p.x / spriteWidth) - spriteHeight
      p.isJumping = FALSE
      p.hasJumpLanded = TRUE
      p.hasReachedJumpHeight = FALSE
    END IF

    'if player walked under a higher platform
    IF (p.y + spriteHeight) > levelHeight(p.x / spriteWidth) THEN
      CALL movePlayer(0, spriteStep)
    END IF

    'right arrow
    IF INP(96) = 77 THEN
      CALL movePlayer(spriteStep, 0)
    END IF

    'left arrow
    IF INP(96) = 75 THEN
      CALL movePlayer(-spriteStep, 0)
    END IF


    'space bar
    IF INP(96) = 57 THEN
      IF p.isJumping = FALSE AND p.hasJumpLanded = TRUE AND p.hasReachedJumpHeight = FALSE THEN
    
        PLAY "O1 L48 C E G"

        p.isJumping = TRUE
        p.hasJumpLanded = FALSE
        p.hasReachedJumpHeight = FALSE
        p.topJumpY = p.y - maxJumpHeight
      END IF
    END IF

    'flag if max jump is reached
    IF p.y = p.topJumpY THEN
      p.hasReachedJumpHeight = TRUE
    END IF

    'move player up if they're not max yet
    IF p.y > p.topJumpY AND p.isJumping = TRUE AND p.hasJumpLanded = FALSE AND p.hasReachedJumpHeight = FALSE THEN
      CALL movePlayer(0, -spriteStep)
    END IF

    'player fell in a pit
    IF p.y > maxY THEN
      p.numLives = p.numLives - 1
      p.y = p.startY
      p.x = p.startX
      lvlInfo(currentLevel).levelDrawn = FALSE
    END IF

    'flip screen
    PCOPY 0, 1

    IF currentLevel <= totalLevels THEN
      IF lvlInfo(currentLevel).isLevelInit = FALSE THEN
        CALL initLevel
        lvlInfo(currentLevel).isLevelInit = TRUE
      END IF
    ELSE
      gameCompleted = TRUE
    END IF

    'fps control
    WHILE TIMER - start! < .01: WEND

  WEND

  IF gameCompleted = TRUE THEN
    IF isUserLevel = FALSE THEN
      CALL showEndGame
    END IF
  ELSE
    CALL showGameOver
  END IF

END SUB

SUB saveHighscores

  filename$ = "hscores.dat"
  
  OPEN filename$ FOR OUTPUT AS #5

  FOR i% = 1 TO numHighscores
    PRINT #5, highscores(i%).pname
    PRINT #5, highscores(i%).score
  NEXT i%

  CLOSE #5

END SUB

SUB setUserLevelName

  'hack.
  SCREEN 13

  'snow background
  FOR i% = 0 TO 250
    x% = ((maxX - 1 + 1) * RND + 1)
    y% = ((maxY - 1 + 1) * RND + 1)
    PSET (x%, y%), 15
  NEXT i%

  LOCATE 2, 12
  COLOR 10
  PRINT "LOAD USER LEVEL"
  LINE (80, 18)-STEP(130, 0), 10

  LOCATE 11
  COLOR 12
  PRINT "NOTE:"
  COLOR 7
  PRINT "You can also load regular game levels"
  PRINT "for practice here by specifying their"
  PRINT "location!"
  COLOR 15
  PRINT
  PRINT "  Ex: levels\lvl2"

  LOCATE 7
  COLOR 14
  PRINT "Do not include any file extensions!"
  PRINT "Enter blank value to return to menu."

  COLOR 15
  LOCATE 5
  INPUT "Level name to load: ", levelName$
  

  userLevelName = levelName$

  IF userLevelName = "" THEN
    isUserLevel = FALSE
  END IF

  SCREEN 7, 0, 0, 1

  CLS

END SUB

SUB showDebug (isDebugOn AS INTEGER)

  IF isDebugOn = TRUE THEN
    LOCATE 1, 1
    COLOR 15
    PRINT INP(96)

    LOCATE 2, 1
    PRINT "maxJumpY="; p.topJumpY

    LOCATE 3, 1
    PRINT "x,y="; p.x; ","; p.y

    LOCATE 4, 1
    PRINT "isJumping="; p.isJumping

    LOCATE 5, 1
    PRINT "hasJumpLanded="; p.hasJumpLanded

    LOCATE 6, 1
    PRINT "hasReachedJumpHeight="; p.hasReachedJumpHeight

    LOCATE 7, 1
    PRINT "levelHeight="; levelHeight(p.x / spriteWidth)
  END IF

END SUB

SUB showEndGame

  CLS
  COLOR 10
  LOCATE 2, 5
  PRINT "CONGRATS! SANTA SAVED CHRISTMAS!"
  PRINT "________________________________________"
  
  LOCATE 5, 2
  COLOR 15
  PRINT "  Santa was successfully able to find"
  PRINT "the presents stolen by the robotic Elves"
  PRINT "just in time to save Christmas Day! "
  PRINT "Now make your own custom levels!!!"
  PRINT
  PRINT "        Thanks for playing!"
  PRINT
  PRINT
  COLOR 10
  PRINT "               HAPPY"
  COLOR 12
  PRINT "                 HOLIDAYS!"
  
  COLOR 14
  LOCATE 20, 5
  PRINT "Press ESC to return to the menu."
  PCOPY 0, 1

  WHILE INP(96) <> 1: WEND
END SUB

SUB showGameOver

  color1% = 10
  color2% = 4
  
  WHILE INKEY$ <> CHR$(13)

    start! = TIMER
 
    LOCATE 10, 15
    COLOR color1%
    PRINT "GAME"
    LOCATE 10, 20
    COLOR color2%
    PRINT "OVER"
    LOCATE 11, 10
    COLOR 15
    PRINT "Press Enter to Continue"

    tempColor% = color1%
    color1% = color2%
    color2% = tempColor%

    PCOPY 0, 1

    'fps control
    WHILE TIMER - start! < .3 AND INP(96) <> 28: WEND
    
 
  WEND

  PLAY "O2 L 48 C B A"

  CALL addHighscore

  'un-initialize all levels
  FOR i% = 1 TO totalLevels
    lvlInfo(i%).isLevelInit = FALSE
  NEXT i%

END SUB

SUB showHighScores

  CALL loadHighscores
 
  CLS

  'snow background
  FOR i% = 0 TO 250
    x% = ((maxX - 1 + 1) * RND + 1)
    y% = ((maxY - 1 + 1) * RND + 1)
    PSET (x%, y%), 15
  NEXT i%


  COLOR 10
  LOCATE 2, 12
  PRINT "HIGH SCORES"
  LOCATE 3, 11
  PRINT "_____________"
  PRINT

  COLOR 15
  lineNum% = 5
  'loop through high score file
  FOR i% = 1 TO numHighscores
    LOCATE lineNum% + i%, 10
    PRINT highscores(i%).pname; " "; highscores(i%).score
  NEXT i%

  COLOR 12
  LOCATE 20
  PRINT "   PRESS ANY KEY TO RETURN TO MENU"

  PCOPY 0, 1


  WHILE INKEY$ = "": WEND



END SUB

SUB showInstructions

  CLS

  'snow background
  FOR i% = 0 TO 250
    x% = ((maxX - 1 + 1) * RND + 1)
    y% = ((maxY - 1 + 1) * RND + 1)
    PSET (x%, y%), 15
  NEXT i%

  LOCATE 2, 13
  COLOR 10
  PRINT "INSTRUCTIONS"
  LINE (80, 18)-STEP(130, 0), 10

  COLOR 7
  LOCATE 4, 2
  PRINT "  Everything in the North Pole was"
  PRINT " running on time to deliver presents"
  PRINT " Christmas Eve when the workshop was"
  PRINT " attacked by an army of robot Elves."
  PRINT " These evil Elves stole all the"
  PRINT " presents and scattered them around the"
  PRINT " whole north pole. Santa now must"
  PRINT " collect all the lost presents in"
  PRINT " order to save Christmas!"
  PRINT
  COLOR 14
  PRINT "   CONTROLS:"
  COLOR 15
  PRINT "     Arrow Keys - Move"
  PRINT "      Space Bar - Jump"
  PRINT "        `q` Key - Quit Game"
  PRINT
  PRINT
  PRINT
  COLOR 12
  PRINT "      PRESS ANY KEY FOR NEXT PAGE"

  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  PLAY "O2 L 48 C B A"


  CLS

  'snow background
  FOR i% = 0 TO 250
    x% = ((maxX - 1 + 1) * RND + 1)
    y% = ((maxY - 1 + 1) * RND + 1)
    PSET (x%, y%), 15
  NEXT i%

  LOCATE 2, 13
  COLOR 10
  PRINT "INSTRUCTIONS"
  LINE (80, 18)-STEP(130, 0), 10

  COLOR 14
  LOCATE 5
  PRINT "      YOU:"
  CALL drawSprite(85, 30, playerSprite1())

  LOCATE 9
  PRINT " PRESENTS:         (250 Points)"
  CALL drawSprite(85, 55, presentSprite1())
  CALL drawSprite(105, 55, presentSprite1())
  CALL drawSprite(125, 55, presentSprite1())

  LOCATE 13
  PRINT "  ENEMIES:         (50 Points)"
  CALL drawSprite(85, 90, enemySprite1())
  CALL drawSprite(105, 90, enemySprite2())
  CALL drawSprite(125, 90, enemySprite3())
 
  LOCATE 20
  COLOR 12
  PRINT "      PRESS ANY KEY FOR MAIN MENU"

  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  PLAY "O2 L 48 C B A"


END SUB

SUB showPostGame

  CLS

  LOCATE 2
  COLOR 10
  PRINT "        THANKS FOR PLAYING!"
  PRINT "       _____________________"
  PRINT

  COLOR 7
  PRINT "  This game is a product of me "
  PRINT "challenging myself to complete a full"
  PRINT "Qbasic game in the matter of only a few"
  PRINT "days before the holidays this year. I"
  PRINT "hope you enjoyed playing as much as I"
  PRINT "have enjoyed creatingthis game. If you"
  PRINT "would like to see moreof my `work` (if "
  PRINT "you can call it that) the info is below."
  PRINT
  COLOR 14
  PRINT "           Thanks again!"
  PRINT
  PRINT
  COLOR 15
  PRINT " WEBSITE: http://eriks.servehttp.com"

  PCOPY 0, 1

END SUB

SUB showScore

  COLOR 15
  LOCATE 2, 25
  PRINT "Lives: "; p.numLives
  LOCATE 3, 25
  PRINT "Score: "; p.score
  LOCATE 4, 25
  PRINT "Level: "; currentLevel

END SUB

