' Santa's Christmas Rescue
'     Level Editor Version 1.0
'
' Release date: 12/25/17
'
' This level editor lets you build levels for Santa's Christmas Rescue.
' You can load these levels by using the User Level selection in the
' main menu of the game. By default this levels will save to the current
' directory but you can specify a sub directory while saving the level.
'
' Press F1 for full help information on creating levels.
'
' Happy Holidays 2017!
'   -Erik Eriksen
'    http://eriks.servehttp.com
'

DECLARE SUB init ()
DECLARE SUB loadLevel ()
DECLARE SUB saveLevel ()
DECLARE SUB showHelp ()
DECLARE SUB showRawData ()
DECLARE SUB drawScene ()
DECLARE SUB showDebug ()
DECLARE SUB placeItem (itemType AS INTEGER)
DECLARE SUB drawPointer ()
DECLARE SUB movePointer (deltaX AS INTEGER, deltaY AS INTEGER)

CLS
SCREEN 7

CONST spriteWidth = 8
CONST spriteHeight = 16
CONST spriteStep = 2
CONST FORWARD = 1
CONST BACKWARD = 0
CONST TRUE = 1
CONST FALSE = 0
CONST totalLevels = 2
CONST maxJumpHeight = 36
CONST maxX = 300
CONST maxY = 200
CONST maxHorizontalSprites = maxX / spriteWidth
CONST maxVerticalSprites = maxY / spriteHeight
CONST maxPresents = 8
CONST maxEnemies = 8
CONST numHighscores = 5
CONST GROUND = 7
CONST PRESENT = 4
CONST ENEMY = 2
CONST EMPTY = 0


TYPE pointer
  x AS INTEGER
  y AS INTEGER
END TYPE

DIM SHARED p AS pointer
DIM SHARED screenMatrix(maxHorizontalSprites, maxVerticalSprites) AS INTEGER
DIM SHARED numPresentsPlaced AS INTEGER
DIM SHARED numEnemiesPlaced AS INTEGER

running% = TRUE
numPresentsPlaced = 0
numEnemiesPlaced = 0

CALL init
CALL drawPointer

WHILE running% = TRUE

  k$ = INKEY$

  CALL showDebug
  CALL drawScene

  IF k$ = "q" THEN
    running% = FALSE
  END IF
  
  'down
  IF k$ = CHR$(0) + CHR$(80) THEN
    CALL movePointer(0, 1)
  END IF

  'up
  IF k$ = CHR$(0) + CHR$(72) THEN
    CALL movePointer(0, -1)
  END IF

  'right
  IF k$ = CHR$(0) + CHR$(77) THEN
    CALL movePointer(1, 0)
  END IF

  'left
  IF k$ = CHR$(0) + CHR$(75) THEN
    CALL movePointer(-1, 0)
  END IF
 
  'space bar
  IF INP(96) = 57 THEN
    CALL placeItem(GROUND)
  END IF

  'f1
  IF INP(96) = 59 THEN
    CALL showHelp
  END IF

  IF k$ = "p" THEN
    CALL placeItem(PRESENT)
  END IF

  IF k$ = "e" THEN
    CALL placeItem(ENEMY)
  END IF

  IF k$ = "r" THEN
    CALL showRawData
  END IF

  IF k$ = "s" THEN
    CALL saveLevel
  END IF

  IF k$ = "l" THEN
    LOCATE 10, 5
    COLOR 4
    PRINT "UNSAVED WORK WILL BE LOST"
    LOCATE 11, 5
    COLOR 12
    INPUT "CONTINUE? [y/N] ", choice$

    IF choice$ = "y" THEN
      CALL loadLevel
    ELSE
      CLS
    END IF

  END IF


WEND


END

SUB drawPointer

  'draw pointer
  LINE (p.x * spriteWidth, p.y * spriteHeight)-STEP(5, 5), 10, BF

END SUB

SUB drawScene


  FOR y% = 1 TO maxVerticalSprites
    FOR x% = 1 TO maxHorizontalSprites
      markerColor% = screenMatrix(x%, y%)
      IF markerColor% <> 0 THEN
        LINE (x% * spriteWidth, y% * spriteHeight)-STEP(spriteWidth, spriteHeight), markerColor%, BF
      END IF
    NEXT x%
  NEXT y%

END SUB

SUB init

  'clear screen matrix
  FOR y% = 1 TO maxVerticalSprites
    FOR x% = 1 TO maxHorizontalSprites
      screenMatrix(x%, y%) = EMPTY
    NEXT x%
  NEXT y%

  p.x = 1
  p.y = 1

END SUB

SUB loadLevel

  'reset screen matrix
  CALL init

  CLS

  COLOR 10
  PRINT
  PRINT "LOAD LEVEL"

  COLOR 15
  PRINT
  INPUT "Enter level name: ", levelName$

  'load level dat
  OPEN levelName$ + ".DAT" FOR INPUT AS #1

  FOR x% = 1 TO maxHorizontalSprites

    INPUT #1, tempY%

    IF tempY% > 0 AND tempY% < maxY THEN
      screenMatrix(x%, tempY% / spriteHeight) = GROUND
    END IF


  NEXT x%

  CLOSE #1

  'load present info

  OPEN levelName$ + ".PNT" FOR INPUT AS #2

  INPUT #2, numPresentsPlaced

  FOR i% = 1 TO numPresentsPlaced

    INPUT #2, presentX%

    groundHeight% = maxVerticalSprites + 1

    FOR y% = 1 TO maxVerticalSprites
      IF screenMatrix(presentX% / spriteWidth, y%) = GROUND THEN
        groundHeight% = y%
      END IF
    NEXT y%

    screenMatrix(presentX% / spriteWidth, groundHeight% - 1) = PRESENT

  NEXT i%

  CLOSE #2

  'load enemy info

  OPEN levelName$ + ".ENE" FOR INPUT AS #3

  INPUT #3, numEnemiesPlaced

  FOR i% = 1 TO numEnemiesPlaced

    INPUT #3, enemyX%

    groundHeight% = maxVerticalSprites + 1

    FOR y% = 1 TO maxVerticalSprites
      IF screenMatrix(enemyX% / spriteWidth, y%) = GROUND THEN
        groundHeight% = y%
      END IF
    NEXT y%

    screenMatrix(enemyX% / spriteWidth, groundHeight% - 1) = ENEMY

  NEXT i%

  CLOSE #3


  COLOR 14
  PRINT
  PRINT "LEVEL LOADED!"

  LOCATE 20, 1
  COLOR 15
  PRINT "Press enter to return"

  WHILE INP(96) <> 28: WEND

  CLS


END SUB

SUB movePointer (deltaX AS INTEGER, deltaY AS INTEGER)

 
  'draw pointer mask
  LINE (p.x * spriteWidth, p.y * spriteHeight)-STEP(5, 5), 0, BF

  p.x = p.x + deltaX
  p.y = p.y + deltaY

  IF p.x < 1 THEN p.x = 1
  IF p.x > maxHorizontalSprites THEN p.x = maxHorizontalSprites
  IF p.y < 1 THEN p.y = 1
  IF p.y > maxVerticalSprites THEN p.y = maxVerticalSprites

  CALL drawPointer
  


END SUB

SUB placeItem (itemType AS INTEGER)

  IF itemType = GROUND THEN
    FOR y% = 1 TO maxVerticalSprites
      IF screenMatrix(p.x, y%) = GROUND THEN
        screenMatrix(p.x, y%) = EMPTY
        LINE (p.x * spriteWidth, y% * spriteHeight)-STEP(spriteWidth, spriteHeight), 0, BF
      END IF
    NEXT y%
 
    screenMatrix(p.x, p.y) = itemType

  END IF

  IF itemType = PRESENT THEN
   
    IF screenMatrix(p.x, p.y) = PRESENT THEN
      screenMatrix(p.x, p.y) = EMPTY
      LINE (p.x * spriteWidth, p.y * spriteHeight)-STEP(spriteWidth, spriteHeight), 0, BF
      numPresentsPlaced = numPresentsPlaced - 1
   
    ELSE

      IF numPresentsPlaced < maxPresents THEN
        screenMatrix(p.x, p.y) = itemType
        numPresentsPlaced = numPresentsPlaced + 1


       ELSE
         LOCATE 20, 1
         COLOR 15
         PRINT "MAX PRESENTS PLACED!"
       END IF

    END IF

  END IF

  IF itemType = ENEMY THEN
    IF screenMatrix(p.x, p.y) = ENEMY THEN
      screenMatrix(p.x, p.y) = EMPTY
      LINE (p.x * spriteWidth, p.y * spriteHeight)-STEP(spriteWidth, spriteHeight), 0, BF
      numEnemiesPlaced = numEnemiesPlaced - 1
  
    ELSE

      IF numEnemiesPlaced < maxEnemies THEN
        screenMatrix(p.x, p.y) = itemType
        numEnemiesPlaced = numEnemiesPlaced + 1


       ELSE
         LOCATE 20, 1
         COLOR 15
         PRINT "MAX ENEMIES PLACED!"
       END IF

    END IF
    
  END IF
      


END SUB

SUB saveLevel

  CLS

  COLOR 10
  PRINT
  PRINT "SAVE LEVEL"

  COLOR 15
  PRINT
  INPUT "Enter level name: ", levelName$

  'save level dat
  OPEN levelName$ + ".DAT" FOR OUTPUT AS #1

  FOR x% = 1 TO maxHorizontalSprites
 
    tempItemY% = 255

    FOR y% = 1 TO maxVerticalSprites
   
      tempItem% = screenMatrix(x%, y%)

      IF tempItem% = GROUND THEN
        tempItemY% = y%
      END IF
    NEXT y%

    PRINT #1, tempItemY% * spriteHeight

  NEXT x%

  CLOSE #1

  'save present info

  OPEN levelName$ + ".PNT" FOR OUTPUT AS #2

  PRINT #2, numPresentsPlaced

  FOR x% = 1 TO maxHorizontalSprites

    tempItemX% = 0

    FOR y% = 1 TO maxVerticalSprites
  
      tempItem% = screenMatrix(x%, y%)

      IF tempItem% = PRESENT THEN
        tempItemX% = x%
      END IF
    NEXT y%

    IF tempItemX% <> 0 THEN
      PRINT #2, tempItemX% * spriteWidth
    END IF

  NEXT x%

  CLOSE #2

  'save enemy info

  OPEN levelName$ + ".ENE" FOR OUTPUT AS #3

  PRINT #3, numEnemiesPlaced

  FOR x% = 1 TO maxHorizontalSprites

    tempItemX% = 0

    FOR y% = 1 TO maxVerticalSprites
 
      tempItem% = screenMatrix(x%, y%)

      IF tempItem% = ENEMY THEN
        tempItemX% = x%
      END IF
    NEXT y%

    IF tempItemX% <> 0 THEN
      PRINT #3, tempItemX% * spriteWidth
    END IF
  NEXT x%

  CLOSE #3


  COLOR 14
  PRINT
  PRINT "SAVED!"

  LOCATE 20, 1
  COLOR 15
  PRINT "Press enter to return"

  WHILE INP(96) <> 28: WEND

  CLS

END SUB

SUB showDebug

  COLOR 15
  LOCATE 1, 15
  PRINT "p.x="; p.x * spriteWidth
  LOCATE 2, 15
  PRINT "p.y="; p.y * spriteHeight
  LOCATE 3, 15
  PRINT "presetsLeft:"; maxPresents - numPresentsPlaced
  LOCATE 4, 15
  PRINT "enemiesLeft:"; maxEnemies - numEnemiesPlaced



END SUB

SUB showHelp

  CLS

  COLOR 10
  PRINT
  PRINT " HELP"
  PRINT "______"
  COLOR 15
  PRINT
  PRINT " Arrow Keys - Move cursor"
  PRINT "  Space Bar - Place ground sprite"
  PRINT "    `p` Key - Place present sprite"
  PRINT "    `e` Key - Place enemy sprite"
  PRINT "    `r` Key - Show raw data output"
  PRINT "    `s` Key - Save level"
  PRINT "    `l` KEY - Load level"
  PRINT "    `q` Key - Quit"
  PRINT "         F1 - Help"
  PRINT
  PRINT "Press the corresponding key on a placed"
  PRINT "item to remove it. Ground cannot be "
  PRINT "stacked and others on the same x will "
  PRINT "automatically be removed on new "
  PRINT "placement. Y values on enemies and "
  PRINT "presents will be set to above ground on"
  PRINT "saving."
  COLOR 12
  PRINT
  PRINT "Press enter to return"

  WHILE INP(96) <> 28: WEND

  CLS

END SUB

SUB showRawData

  SCREEN 12
  CLS

  FOR y% = 1 TO maxVerticalSprites

    lineString$ = ""
    FOR x% = 1 TO maxHorizontalSprites
      lineString$ = lineString$ + STR$(screenMatrix(x%, y%))
    NEXT x%
   
    PRINT lineString$
 
  NEXT y%

  LOCATE 20, 1
  COLOR 15
  PRINT "Press enter to return"

  WHILE INP(96) <> 28: WEND

  CLS
  SCREEN 7

END SUB

