DECLARE SUB gameover ()
DECLARE SUB titlescreen ()
DECLARE SUB potion ()
DECLARE FUNCTION randomwall! (orient!)
DECLARE FUNCTION stamproom! (x!, y!, size!)
DECLARE FUNCTION randrow! ()
DECLARE SUB bomb ()
DECLARE SUB updateworld ()
DECLARE SUB updatestatus ()
DECLARE FUNCTION showline! (x$)
DECLARE FUNCTION move! (dx!, dy!)
DECLARE SUB initialize ()
DECLARE SUB playerinput ()
DECLARE SUB buildlevel ()
DECLARE SUB displaylevel ()
DECLARE FUNCTION updatespace! (x!, y!)

' 7HRL -- a 7 hour Roguelike
' Zack Johnson
' 7/6/2018

DIM SHARED level(80, 20)
DIM SHARED textoutput$(4)
DIM SHARED playerx, playery
DIM SHARED playerhp
DIM SHARED playerkeys
DIM SHARED playerbombs
DIM SHARED playerpotions
DIM SHARED playerlevel
DIM SHARED playerpoints
DIM SHARED treasure$(4), treasuresingle$(4)
DIM SHARED treasurechar$(4), treasurecolor(4)
DIM SHARED treasurepoints(4)
DIM SHARED lastdamage$
DIM SHARED exiting
DIM SHARED highscore

CLS

OPEN "hiscore.txt" FOR INPUT AS #1
INPUT #1, highscore
CLOSE #1

titlescreen:

CALL titlescreen

CALL initialize

newlevel:
CALL buildlevel
CALL displaylevel

top:
CALL updatestatus
CALL playerinput
IF bombing = 1 THEN CALL bomb
CALL updateworld
IF playerhp < 1 THEN GOTO gameover

IF exiting = 1 THEN GOTO nextlevel

GOTO top
                                                       
nextlevel:
exiting = 0
dump = showline("Progress!")
playerlevel = playerlevel + 1
GOTO newlevel

gameover:
CALL gameover

GOTO titlescreen
END

DATA magnet,239                     
DATA coin,233
DATA box,254
DATA rope,234
DATA scroll,186
DATA egg,236
DATA ukulele,235
DATA amulet,21
DATA ring,248
DATA book,205
DATA nightstand,227
DATA scepter,231
DATA lantern,232
DATA bracelet,155
DATA dollhouse,127
DATA fish,224
DATA tweezers,234
DATA idol,2
DATA crook,244
DATA jewel,4
DATA statue,4
DATA trinket,145
DATA serpent,159

DATA paper,7
DATA ruby,4
DATA rusty,6
DATA gold,14
DATA jade,2
DATA jasper,10
DATA shiny,15
DATA cool,9
DATA ice,3
DATA fire,4
DATA wood,6
DATA coal,8
DATA frost,3
DATA silver,15
DATA ivy,2
DATA glass,11
DATA obsidian,8
DATA brass,6
DATA ivory,7
DATA coral,10
DATA leather,6
DATA steel,7
DATA purple,5

SUB bomb
' player uses a bomb

IF playerbombs < 1 GOTO nobombs

playerbombs = playerbombs - 1
dump = showline("Kaboom!")

'blow everything up

FOR x = -2 TO 2
  FOR y = -2 TO 2
    checkx = playerx + x
    checky = playery + y
    IF checkx < 2 OR checkx > 79 OR checky < 2 OR checky > 19 THEN GOTO skipcheck
    IF checkx = playerx AND checky = playery GOTO skipcheck
    IF ABS(x) = 2 AND ABS(y) = 2 GOTO skipcheck
    LOCATE checky, checkx
    COLOR 12
    PRINT "*";
    IF (level(checkx, checky) <> 99 AND level(checkx, checky) <> 98) THEN level(checkx, checky) = 0' bombs destroy everything
   
skipcheck:

  NEXT y
NEXT x
                                   
dick = TIMER
WHILE TIMER < dick + .3: WEND

' update display
FOR x = -2 TO 2
  FOR y = -2 TO 2
    checkx = playerx + x
    checky = playery + y
    IF checkx < 2 OR checkx > 79 OR checky < 2 OR checky > 19 THEN GOTO skipcheck2
    IF checkx = playerx AND checky = playery GOTO skipcheck2
    IF ABS(x) = 2 AND ABS(y) = 2 GOTO skipcheck2
    dump = updatespace(checkx, checky)
skipcheck2:
  NEXT y
NEXT x

nobombs:
dump = showline("No bombs!")
GOTO bombdone

bombdone:

END SUB

SUB buildlevel
FOR x = 1 TO 80
  FOR y = 1 TO 20
    level(x, y) = 0' clear the space
    IF x = 1 OR x = 80 OR y = 1 OR y = 20 THEN level(x, y) = 99' outside walls
  NEXT y
NEXT x
                      
' build grid of walls
FOR x = 2 TO 79
  wall = 1
  IF x MOD 8 = 4 THEN wall = 99
  level(x, 7) = wall
  level(x, 14) = wall
  
NEXT x

FOR y = 2 TO 19
  FOR z = 8 TO 72 STEP 8
    wall = 1
    IF y = 4 OR y = 11 OR y = 17 THEN wall = 99
    level(z, y) = wall
  NEXT z
NEXT y

' place player and exit, worm a path
wormx = 4
wormy = randrow
playerx = wormx
playery = wormy

FOR lop = 1 TO 9
  ' go to a random row
  goal = randrow
  IF goal < wormy THEN inc = -1 ELSE inc = 1
  WHILE (wormy <> goal)
  wormy = wormy + inc
  level(wormx, wormy) = 0
  WEND
  FOR lopp = 1 TO 8
  wormx = wormx + 1
  level(wormx, wormy) = 0
  NEXT lopp
NEXT lop
level(79, wormy) = 98' place exit

' now replace other doors with various hazards or openings
FOR x = 2 TO 78
  FOR y = 2 TO 19
    IF (level(x, y) <> 99) THEN GOTO skipdoorway
    roll = INT(RND * 10) + 1
    level(x, y) = 1' default to wall
    IF roll < 7 THEN level(x, y) = 0' opening
    IF roll < 5 THEN level(x, y) = 3' some locked doors
    IF roll < 2 THEN level(x, y) = 4' some spikes

skipdoorway:

  NEXT y
NEXT x

' room stamps
FOR x = 2 TO 80 STEP 8
level(x, 3) = 100     ' small rooms
level(x, 16) = 100
level(x, 9) = 101     ' large rooms
NEXT x

FOR x = 2 TO 78
FOR y = 2 TO 19
IF level(x, y) = 100 THEN dump = stamproom(x, y, 1)
IF level(x, y) = 101 THEN dump = stamproom(x, y, 2)
NEXT y
NEXT x

'wipe out some walls
DIM wipey(11)
DIM wipex(11)
FOR lop = 1 TO 10
wipey(lop) = randomwall(1)
wipex(lop) = 8 * (INT(RND * 9) + 1)
NEXT lop

wipex(11) = 72  ' always wipe at least one right wall
wipey(11) = randomwall(1)

FOR lop = 1 TO 11
  FOR lopp = 1 TO 7
    level(wipex(lop) + lopp, wipey(lop)) = 0
  NEXT lopp
NEXT lop

FOR lop = 1 TO 11
  wipex(lop) = randomwall(2)
  roll = INT(RND * 3) + 1
  IF roll = 1 THEN wipey(lop) = 1
  IF roll = 2 THEN wipey(lop) = 14
  IF roll = 3 THEN wipey(lop) = 7
NEXT lop
wipex(11) = 72 ' always wipe at least one on the right

FOR lop = 1 TO 11
  FOR lopp = 1 TO 5
    level(wipex(lop), wipey(lop) + lopp) = 0
    IF wipey(lop) + lopp = 12 THEN level(wipex(lop), wipey(lop) + 6) = 0
  NEXT lopp
NEXT lop

'clear around the starting space, just in case
FOR x = -1 TO 1
  FOR y = -1 TO 1
    level(playerx + x, playery + y) = 0
  NEXT y
NEXT x


' spawn the initial gloom

numglooms = playerlevel

offset = 5
FOR lop = 1 TO numglooms
  offset = offset + 5
  IF (offset > 70) THEN offset = 70
  x = 80 - INT(RND * offset)
  y = 2 + INT(RND * 17)
  placed = 0
  WHILE placed = 0
  IF level(x, y) = 0 THEN level(x, y) = 2: placed = 1
  x = x - 1
  IF y < 10 THEN y = y + 1
  IF y > 15 THEN y = y - 1
  IF x = 0 THEN placed = 1
  WEND
NEXT lop

' pass some time
FOR lop = 1 TO 5
CALL updateworld
NEXT lop

'1 = wall
'98 = exit to next level
'99 = exterior wall, indestructible

END SUB

SUB displaylevel
CLS
FOR x = 1 TO 80
  FOR y = 1 TO 20
    barf = updatespace(x, y)

  NEXT y
NEXT x
END SUB

SUB gameover
CLS
COLOR 13
FOR x = 1 TO 80
FOR y = 1 TO 23
  IF (x < 20 OR x > 60) OR (y < 7 OR y > 18) THEN
  LOCATE y, x
  PRINT CHR$(176)
  END IF
NEXT y
NEXT x
LOCATE 8, 25
PRINT "The Gloom has taken you."
LOCATE 10, 25
COLOR 7
PRINT lastdamage$
LOCATE 12, 25
PRINT "Thanks for playing."
LOCATE 13, 25
PRINT "You made it to level"; playerlevel;
LOCATE 14, 25
PRINT "Your score was ";
COLOR 14
PRINT playerpoints
COLOR 7
IF playerpoints > highscore THEN
  LOCATE 15, 25
  PRINT "New High Score!"
  highscore = playerpoints
  OPEN "hiscore.txt" FOR OUTPUT AS #1
  PRINT #1, playerpoints
  CLOSE #1
ELSE
  LOCATE 15, 25
  PRINT "Your previous high score was ";
  COLOR 14
  PRINT highscore
  COLOR 7
END IF
LOCATE 17, 25
PRINT "Press any key to continue..."
now = TIMER
WHILE TIMER < now + 2: WEND' try to stop errant input
WHILE INKEY$ = "": WEND

END SUB

SUB initialize
' set the basics up here
CLS
RANDOMIZE TIMER

                   
playerlevel = 1
playerhp = 100
playerkeys = 1
playerbombs = 1
playerpoints = 0

DIM names(30) AS STRING
DIM tchars(30) AS INTEGER
DIM mats(30) AS STRING
DIM colors(30) AS INTEGER

RESTORE
numthings = 23
FOR lop = 1 TO numthings
  READ names$(lop)
  READ tchars(lop)
NEXT lop

nummats = 23
FOR lop = 1 TO nummats
  READ mats$(lop)
  READ colors(lop)
NEXT lop

' lame
roll1 = INT(RND * numthings) + 1
roll2 = roll1
WHILE roll2 = roll1
  roll2 = INT(RND * numthings) + 1
WEND
roll3 = roll1
WHILE roll3 = roll1 OR roll3 = roll2
  roll3 = INT(RND * numthings) + 1
WEND
roll4 = roll1
WHILE roll4 = roll3 OR roll4 = roll2 OR roll4 = roll1
  roll4 = INT(RND * numthings) + 1
WEND

mroll1 = INT(RND * nummats) + 1
mroll2 = mroll1
WHILE mroll2 = mroll1
  mroll2 = INT(RND * nummats) + 1
WEND
mroll3 = mroll1
WHILE mroll3 = mroll1 OR mroll3 = mroll2
  mroll3 = INT(RND * nummats) + 1
WEND
mroll4 = mroll1
WHILE mroll4 = mroll3 OR mroll4 = mroll2 OR mroll4 = mroll1
  mroll4 = INT(RND * nummats) + 1
WEND


treasure$(1) = mats(mroll1) + " " + names$(roll1)
treasurechar$(1) = CHR$(tchars(roll1))
treasurecolor(1) = colors(mroll1)
        
treasure$(2) = mats(mroll2) + " " + names$(roll2)
treasurechar$(2) = CHR$(tchars(roll2))
treasurecolor(2) = colors(mroll2)

treasure$(3) = mats(mroll3) + " " + names$(roll3)
treasurechar$(3) = CHR$(tchars(roll3))
treasurecolor(3) = colors(mroll3)
                                                   
treasure$(4) = mats(mroll4) + " " + names$(roll4)
treasurechar$(4) = CHR$(tchars(roll4))
treasurecolor(4) = colors(mroll4)

treasurepoints(1) = 1
treasurepoints(2) = 3
treasurepoints(3) = 5
treasurepoints(4) = 10

END SUB

FUNCTION move (dx, dy)
 
  moving = 1
  IF level(playerx + dx, playery + dy) = 99 THEN moving = 0
  IF level(playerx + dx, playery + dy) = 1 THEN moving = 0
 
  door = 0
  IF level(playerx + dx, playery + dy) = 3 THEN door = 1

  IF door = 1 THEN moving = 0
  IF door = 1 AND playerkeys > 0 THEN dump = showline("Click.")
  IF door = 1 AND playerkeys > 0 THEN level(playerx + dx, playery + dy) = 0
  IF door = 1 AND playerkeys > 0 THEN dump = updatespace(playerx + dx, playery + dy)
  IF door = 1 AND playerkeys > 0 THEN playerkeys = playerkeys - 1
  IF door = 1 AND playerkeys < 1 THEN dump = showline("No keys!")

  IF moving = 0 GOTO done
 
  ' move the player
  oldx = playerx
  oldy = playery
  playerx = playerx + dx
  playery = playery + dy
  dump = updatespace(oldx, oldy)
  dump = updatespace(playerx, playery)
  
  treasure = 0
  IF level(playerx, playery) = 10 THEN treasure = 1
  IF level(playerx, playery) = 11 THEN treasure = 2
  IF level(playerx, playery) = 12 THEN treasure = 3
  IF level(playerx, playery) = 13 THEN treasure = 4

  IF treasure > 0 THEN level(playerx, playery) = 0
  IF treasure > 0 THEN playerpoints = playerpoints + treasurepoints(treasure)
  IF treasure > 0 THEN dump = showline("Treasure!")

  getkey = 0
  IF level(playerx, playery) = 20 THEN getkey = 1
  IF getkey = 1 THEN level(playerx, playery) = 0
  IF getkey = 1 THEN playerkeys = playerkeys + 1
  IF getkey = 1 THEN dump = showline("Found a key.")

  getbomb = 0
  IF level(playerx, playery) = 21 THEN getbomb = 1
  IF getbomb = 1 THEN level(playerx, playery) = 0
  IF getbomb = 1 THEN playerbombs = playerbombs + 1
  IF getbomb = 1 THEN dump = showline("Found a bomb!")

  getlife = 0
  IF level(playerx, playery) = 22 THEN getlife = 1
  IF getlife = 1 THEN level(playerx, playery) = 0
  IF getlife = 1 THEN playerpotions = playerpotions + 1
  IF getlife = 1 THEN dump = showline("Found a potion.")

  gloom = 0
  IF (level(playerx, playery) = 2) THEN gloom = 1
  IF gloom = 1 THEN dump = showline("The gloom...")
  IF gloom = 1 THEN playerhp = playerhp - 1
  IF gloom = 1 THEN lastdamage$ = "You succumbed to the gloom."
  IF (level(playerx, playery) = 98) THEN exiting = 1' the exit
  spikes = 0
  IF level(playerx, playery) = 4 THEN spikes = 1
  IF spikes = 1 THEN playerhp = playerhp - 5
  IF spikes = 1 THEN dump = showline("Ouch!")
  IF spikes = 1 THEN lastdamage$ = "You were impaled on some spikes."

done:

END FUNCTION

SUB playerinput
'take player input here
bombing = 0' are we droppin' a bomb?

DO
LET k$ = INKEY$
LOOP UNTIL k$ <> ""
k$ = LCASE$(k$)
SELECT CASE k$
  CASE "q"
    playerhp = 0
    lastdamage$ = "You quit the game."
  CASE "w"
    dump = move(0, -1)
  CASE "a"
    dump = move(-1, 0)
  CASE "s"
    dump = move(0, 1)
  CASE "d"
    dump = move(1, 0)
  CASE " "
    dump = move(0, 0)
  CASE "b"
    CALL bomb
  CASE "p"
    CALL potion
END SELECT
LOCATE 21, 1

'show$ = "You pressed " + k$ + "."
'dump = showline(show$)


END SUB

SUB potion
IF playerpotions = 0 GOTO potionno
IF playerhp = 100 GOTO potionfull

playerpotions = playerpotions - 1
playerhp = playerhp + 15
IF playerhp > 100 THEN playerhp = 100
dump = showline("Ahhhh.")
GOTO potiondone

potionfull:
dump = showline("Don't need it.")
GOTO potiondone

potionno:
dump = showline("No potions.")
GOTO potiondone


potiondone:

END SUB

FUNCTION randomwall (orient)

IF orient = 1 GOTO horiz
randomwall = 8 * INT(RND * 9)

GOTO pickedwall

horiz:
roll = INT(RND * 2) + 1
IF roll = 1 THEN randomwall = 7
IF roll = 2 THEN randomwall = 14

pickedwall:

END FUNCTION

FUNCTION randrow
roll = INT(RND * 3) + 1
IF roll = 1 THEN randrow = 4
IF roll = 2 THEN randrow = 11
IF roll = 3 THEN randrow = 17
END FUNCTION

FUNCTION showline (x$)
textoutput$(1) = textoutput$(2)
textoutput$(2) = textoutput$(3)
textoutput$(3) = textoutput$(4)
textoutput$(4) = x$
END FUNCTION

FUNCTION stamproom (x, y, size)

level(x, y) = 0' clear out the tag

roomwidth = 5
roomheight = 3
IF size = 2 THEN roomwidth = 5: roomheight = 4
numsmallrooms = 25
DIM smallrooms$(numsmallrooms)
smallrooms$(1) = "WWWWW..I..WWWWW"
smallrooms$(2) = "W...W..T..W...W"
smallrooms$(3) = "WWWWWW....W...."
smallrooms$(4) = "WwwwW..I..WwwwW"
smallrooms$(5) = ".......T......."
smallrooms$(6) = ".WWW..WTW..WDW."
smallrooms$(7) = "..W....T....W.."
smallrooms$(8) = ".....W.I.W....."
smallrooms$(9) = ".......T......."
smallrooms$(10) = "W...WW.T.WW...W"
smallrooms$(11) = "wwtw..........."
smallrooms$(12) = "..w...i...w...."
smallrooms$(13) = "WWWWWSTITSWWWWW"
smallrooms$(14) = ".....wiiiw....."
smallrooms$(15) = "WWW..tW...WWW.."
smallrooms$(16) = ".SSS..STS..SSS."
smallrooms$(17) = "issssstssssisss"
smallrooms$(18) = "wwwwwwwwwwwwwww"
smallrooms$(19) = "SWWWS.WTW..WWW."
smallrooms$(20) = ".WWW..DTW..WWW."
smallrooms$(21) = ".ww....www..w.."
smallrooms$(22) = "..............."
smallrooms$(23) = ".....sWsWs....."
smallrooms$(24) = "..............."
smallrooms$(25) = "..............."

numbigrooms = 30
DIM bigrooms$(numbigrooms)
bigrooms$(1) = "WWWWW..T....I..WWWWW"
bigrooms$(2) = "W..iW..........W...W"
bigrooms$(3) = "W...W..t.......W...W"
bigrooms$(4) = "www..www....www..www"
bigrooms$(5) = "......t.....i......."
bigrooms$(6) = "..W...W...I..W...W.."
bigrooms$(7) = "wwwwwwTwwwwwwTwwwwww"
bigrooms$(8) = "WWWWWWtitWWitiDWWWWW"
bigrooms$(9) = "..W..WWW...WWW...W.."
bigrooms$(10) = "S.S.S.S.S.S.S.S.S.S."
bigrooms$(11) = "WWWWWSSttWSSttWWWWWW"
bigrooms$(12) = "SSSSSSi.iSS.T.SSSSSS"
bigrooms$(13) = "..W....W....W....W.."
bigrooms$(14) = ".WWW..WTW..W.W..WDW."
bigrooms$(15) = "WWWWW..iWt..W....W.."
bigrooms$(16) = "......WWW..WWW......"
bigrooms$(17) = "W.W.W..........W.W.W"
bigrooms$(18) = ".WwW.wi..WW...w.wWw."
bigrooms$(19) = "WWWWWDtTtWWWWWW....."
bigrooms$(20) = "WWWWWSSTSSWWWWW....."
bigrooms$(21) = "ssssssisssssstssssss"
bigrooms$(22) = "swswswswswswswswswsw"
bigrooms$(23) = "w.w.wwiw.ww.w.ww.w.w"
bigrooms$(24) = ".WSW..WiW...Wtw.WSW."
bigrooms$(25) = ".W....W....WWW..WWW."
bigrooms$(26) = "...................."
bigrooms$(27) = "...................."
bigrooms$(28) = "...................."
bigrooms$(29) = "...................."
bigrooms$(30) = "...................."

' stamp a small room
roomstring$ = smallrooms$(INT(RND * numsmallrooms) + 1)
IF size = 2 THEN roomstring$ = bigrooms$(INT(RND * numbigrooms) + 1)

'adjust these for difficulty later
wallchance = 5
gloomchance = 2
itemchance = 2
spikechance = 2
treasurechance = 2

count = 1
reverse = 0
IF (INT(RND * 2) = 1) THEN reverse = 1
FOR yy = 0 TO roomheight - 1
  FOR xx = 0 TO roomwidth - 1
    thing$ = MID$(roomstring$, count, 1)
    IF reverse = 1 THEN thing$ = MID$(roomstring$, LEN(roomstring$) - count + 1, 1)
    IF thing$ = "W" THEN level(x + xx, y + yy) = 1                 ' wall
    whichitem = 20 + INT(RND * 3)
    IF whichitem = 22 AND INT(RND * 10) < playerlevel + 3 THEN whichitem = 21 ' diminish potions as you get deeper
    IF thing$ = "I" THEN level(x + xx, y + yy) = whichitem' item
    IF thing$ = "i" AND INT(RND * 10) + 1 <= itemchance THEN level(x + xx, y + yy) = whichitem' item
   
    ' better treasures further right
    whichtreasure = INT(RND * 2) + 10
    IF (x + xx > 30 AND INT(RND * 2) = 1) THEN whichtreasure = whichtreasure + 1
    IF (x + xx > 50 AND INT(RND * 2) = 1) THEN whichtreasure = whichtreasure + 1
    IF (INT(RND * 2) = 1) THEN whichtreasure = whichtreasure + 1

    IF whichtreasure > 13 THEN whichtreasure = 13
    IF thing$ = "T" THEN level(x + xx, y + yy) = whichtreasure ' treasure
    IF thing$ = "t" AND INT(RND * 10) <= treasurechance THEN level(x + xx, y + yy) = whichtreasure' treasure
    IF thing$ = "S" THEN level(x + xx, y + yy) = 4   ' spikes
    IF thing$ = "s" AND INT(RND * 10) + 1 <= spikechance THEN level(x + xx, y + yy) = 4' spikes
    IF thing$ = "D" THEN level(x + xx, y + yy) = 3  ' locked door
    IF thing$ = "G" AND INT(RND * 10) + 1 <= gloomchance THEN level(x + xx, y + yy) = 2' gloom
    IF thing$ = "w" AND INT(RND * 10) + 1 <= wallchance THEN level(x + xx, y + yy) = 1' sometimes wall
    count = count + 1
  NEXT xx
NEXT yy

stampdone:

END FUNCTION

SUB titlescreen
CLS
LOCATE 5, 30
COLOR 13
PRINT "      The      "
LOCATE 6, 30
PRINT "  Encroaching  "
LOCATE 7, 30
PRINT "     Gloom     "
                             
COLOR 7
LOCATE 10, 30
PRINT "It's coming, and it"
LOCATE 11, 30
PRINT "can't be stopped."
LOCATE 12, 30
PRINT "Gather treasure until"
LOCATE 13, 30
PRINT "the inevitable end."
LOCATE 16, 35
COLOR 15
PRINT "N";
COLOR 7
PRINT "ew game"
LOCATE 17, 35
COLOR 15
PRINT "Q";
COLOR 7
PRINT "uit"
LOCATE 20, 30:
PRINT "High Score: ";
COLOR 14
PRINT highscore
COLOR 7
LOCATE 23, 50
PRINT "(C) 2018 Zack Johnson"
LOCATE 24, 50
PRINT "         @zapjackson"

nextgloom = TIMER + .3
DIM gloomheight(80)
FOR x = 1 TO 80
  gloomheight(x) = 2
  COLOR 13
  LOCATE 1, x: PRINT CHR$(176)
  LOCATE 2, x: PRINT CHR$(176)
NEXT x

DO
k$ = INKEY$
k$ = UCASE$(k$)

IF TIMER > nextgloom THEN
  nextgloom = TIMER + .1
  propagate = INT(RND * 80) + 1
  IF propagate > 25 AND propagate < 50 GOTO skipprop
  gloomheight(propagate) = gloomheight(propagate) + 1
  IF gloomheight(propagate) > 23 THEN GOTO skipprop
  ' check for the middle
  LOCATE gloomheight(propagate), propagate
  COLOR 13
  PRINT CHR$(176)
skipprop:
END IF
LOOP UNTIL k$ = "N" OR k$ = "Q"

IF k$ = "Q" THEN END

END SUB

FUNCTION updatespace (x, y)
  char$ = " "' default to empty space
  COLOR 15
  LOCATE y, x
  what = level(x, y)
  IF what = 99 THEN char$ = CHR$(219): COLOR 15
  IF what = 1 THEN char$ = CHR$(219): COLOR 15
  IF what = 3 THEN char$ = CHR$(8): COLOR 6
  IF what = 4 THEN char$ = CHR$(24): COLOR 8 ' spikes
  IF what = 98 THEN char$ = ">": COLOR 6
  IF what = 10 THEN char$ = treasurechar$(1): COLOR treasurecolor(1)
  IF what = 11 THEN char$ = treasurechar$(2): COLOR treasurecolor(2)
  IF what = 12 THEN char$ = treasurechar$(3): COLOR treasurecolor(3)
  IF what = 13 THEN char$ = treasurechar$(4): COLOR treasurecolor(4)
  IF what = 20 THEN char$ = CHR$(157): COLOR 14' keys
  IF what = 21 THEN char$ = CHR$(235): COLOR 1' bombs
  IF what = 22 THEN char$ = CHR$(173): COLOR 4' hearts
                                                                 
  IF what = 2 THEN char$ = CHR$(176): COLOR 13
  IF playerx = x AND playery = y THEN char$ = CHR$(1): COLOR 14
  PRINT char$
END FUNCTION

SUB updatestatus
COLOR 7

pointscol = 1
FOR t = 1 TO 4
last = 23 + LEN(treasure$(t)) + 3
IF pointscol < last THEN pointscol = last
NEXT t
FOR t = 1 TO 4
COLOR 7
LOCATE 20 + t, 23
PRINT treasure$(t);
PRINT "(";
COLOR treasurecolor(t)
PRINT treasurechar$(t);
COLOR 7
PRINT ") ";
LOCATE 20 + t, pointscol
PRINT treasurepoints(t);
PRINT "pts.";
NEXT t

COLOR 7
LOCATE 22, 1
COLOR 15
PRINT " P";
COLOR 7
PRINT "otions:";
PRINT playerpotions
LOCATE 21, 1
PRINT "  Health:";
COLOR 4
PRINT playerhp
LOCATE 23, 1
COLOR 7
PRINT "    Keys:";
PRINT playerkeys;
LOCATE 24, 1
COLOR 15
PRINT "   B";
COLOR 7
PRINT "ombs:";
PRINT playerbombs;

LOCATE 22, 15
PRINT "Score:"
LOCATE 23, 16
COLOR 14
PRINT playerpoints
COLOR 7

' treasures

FOR x = 1 TO 4
IF LEN(textoutput$(x)) > 20 THEN textoutput$(x) = LEFT$(textoutput$(x), 20)
NEXT x
LOCATE 21, 60
PRINT textoutput$(1);
PRINT SPACE$(20 - LEN(textoutput$(1)));

LOCATE 22, 60
PRINT textoutput$(2);
PRINT SPACE$(20 - LEN(textoutput$(2)));
LOCATE 23, 60
PRINT textoutput$(3);
PRINT SPACE$(20 - LEN(textoutput$(3)));
LOCATE 24, 60
PRINT textoutput$(4);
PRINT SPACE$(20 - LEN(textoutput$(4)));
END SUB

SUB updateworld
DIM future(80, 20)

FOR x = 2 TO 79
  FOR y = 2 TO 19
    future(x, y) = 0
    IF (level(x, y) <> 0) GOTO skip
    glooms = 0
    IF level(x - 1, y) = 2 THEN glooms = glooms + 1
    IF level(x + 1, y) = 2 THEN glooms = glooms + 1
    IF level(x, y - 1) = 2 THEN glooms = glooms + 1
    IF level(x, y + 1) = 2 THEN glooms = glooms + 1
    IF INT(RND * 30) < glooms THEN future(x, y) = 2
    
    
skip:

  NEXT y
NEXT x

FOR x = 2 TO 79
  FOR y = 2 TO 19
    IF future(x, y) = 0 GOTO skip2
    IF level(x, y) <> 0 GOTO skip2
    IF future(x, y) = 2 THEN level(x, y) = 2
    IF future(x, y) = 2 THEN dump = updatespace(x, y)
skip2:
  NEXT y
NEXT x
END SUB

