--[[
Lyfe - a Ludum Dare 44 Entry
C.Forlines 2019
BUGS:
	The walls are lava
]]

require "short"

--Screen images
logo = lg.newImage("img/swlogo.png")
title = lg.newImage("img/title.png")
grafitti = lg.newImage("img/grafitti.png")
spriteSheet = lg.newImage("img/ssheet.png")

screenWidth = lg.getWidth()
screenHeight = lg.getHeight()
logoWidth = logo:getWidth()
logoHeight = logo:getHeight()

player = lg.newQuad(0,32,16,16)
landlord = lg.newQuad(16,32,16,16)
hobo = lg.newQuad(32,32,16,16)
hooker = lg.newQuad(48,32,16,16)
rich = lg.newQuad(64,32,16,16)
bartender = lg.newQuad(64,0,16,16)
bar = lg.newQuad(48,0,16,16)
wall = lg.newQuad(64,16,16,16)
doorLeft = lg.newQuad(112,16,16,16)
doorRight = lg.newQuad(112,0,16,16)
doorUp = lg.newQuad(96,0,16,16)
doorDown = lg.newQuad(96,16,16,16)
gbag = lg.newQuad(48,16,16,16)
chair = lg.newQuad(32,16,16,16)
tbl = lg.newQuad(32,0,16,16)
bedTop = lg.newQuad(80,0,16,16)
bedBottom = lg.newQuad(80,16,16,16)
barLeft = lg.newQuad(80,32,16,16)
barRight = lg.newQuad(96,32,16,16)
lbUL = lg.newQuad(0,0,16,16)
lbUR = lg.newQuad(16,0,16,16)
lbLL = lg.newQuad(0,16,16,16)
lbLR = lg.newQuad(16,16,16,16)

quadsList = {player,landlord,bartender,hobo,hooker,rich,0,0,0,0,
wall,gbag,tbl,chair,bedTop,bedBottom,bar,lbUL,lbUR,lbLL,
lbLR,barLeft,barRight,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,doorLeft,
doorDown,doorRight,doorUp,0,0,0,0,0,0,0}

--Game images


--Game variables

story = {"In the mid 21st century the source \n of eternal life was discovered.", "It does not come from a well...", "...but from the bodies of the living...", "The LYFE corporation has found a way to \n transfer this energy from one person to \n another.", "For a nominal fee you can live forever \n or sell it all for one fantastic night.", "In your case, however, the rent is due...", "End of Line"}

function love.load()
	reset()
end
--Call to reset the game to base settings
function reset()
	pressedKey = ""
	currentScreen = 0
	logoTime = 5
	grafittiOn = false
	grafittiDelay = 3
	--Intro scene variables
	linePause = 2
	storyLine = 1
	typeTimer = 0.05
	typePosition = 0
	textToPrint = story[storyLine]
	printedText = ""
	--Menu selector variables
	selectorX = 43
	selectorY = 124
	--Player variables
	playerLyfe = 10
	playerMoney = 20
	playerPositionX = 10
	playerPositionY = 5
	playerBump = 0
	intText = ""
	haveBooze = false
	gaveBooze = false
	hoboFollow = false
	deadHobo = false
	gaveMoney = false
	hookerFollow = false
	deadHooker = false
	shockTime = 8
	rentPaid = false
	--Game world variables
	currentRoom = 1
	roomGrid = {}
	staticRoom()
end

function staticRoom()
--Change name to room names make roomGrid = room name based on currentRoom number
	--[[
		1 - player
		2 - landlord
		3 - bartender
		4 - hobo
		5 - hooker
		6 - rich
		11 - wall
		90 - leftDoor
		91 - bottomDoor
		92 - rightDoor
		93 - topDoor
		12 - garbage
		13 - table
		14 - chair
		15 - bedtop
		16 - bedBottom
		17 - bar
		18 - 21 - lyfebooth
		22-23 - bar sign
	]]
	apartment = {
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,11,11,11,11,11,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,11,0,0,0,15,11,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,90,0,0,0,16,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,11,0,13,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,11,11,11,11,11,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	}
	hallway = {
		{0,0,0,0,0,0,0,11,11,11,11,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,2,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,90,0,0,0,92,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,90,0,0,0,92,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,90,0,0,0,92,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,0,0,0,11,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,11,11,91,11,11,0,0,0,0,0,0,0,0}
	}
	street = {
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11,11,11,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,11,12,0,0,11,0,0},
		{11,11,11,93,11,11,11,11,11,11,11,18,19,11,0,0,0,11,11,11},
		{12,12,0,0,0,0,0,0,0,0,0,20,21,0,0,0,0,0,0,12},
		{12,12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12},
		{12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12},
		{12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,12},
		{11,11,11,11,11,11,11,11,11,11,11,11,11,11,91,22,23,11,11,11},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	}
	barRoom = {
		{0,0,0,0,0,11,11,11,11,93,11,11,11,11,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,14,13,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,14,13,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,14,13,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,17,17,3,17,17,17,17,17,11,0,0,0,0,0},
		{0,0,0,0,0,11,0,0,0,0,0,0,0,0,11,0,0,0,0,0},
		{0,0,0,0,0,11,11,11,11,11,11,11,11,11,11,0,0,0,0,0}}
	if currentRoom == 1 then
		roomGrid = apartment
	elseif currentRoom == 2 then
		roomGrid = hallway
	elseif currentRoom == 3 then
		roomGrid = street
	elseif currentRoom == 4 then
		roomGrid = barRoom
	end
end

--Update and draw the splash page
function updateSplash(dt)
	logoTime = logoTime - dt
	if logoTime <= 0 or pressedKey ~= "" then pressedKey = "" currentScreen = 1 end
end

function drawSplash()
	lg.draw(logo, (screenWidth/2)-(logoWidth/2), (screenHeight/2)-(logoHeight/2))
end
--Update and draw the main menu - Screen 1
function updateMenu(dt)
	if  pressedKey == "down" and selectorY == 124 then
		selectorY = 144
		pressedKey = ""
	elseif pressedKey == "down" and selectorY == 144 then
		selectorY = 124
		pressedKey = ""
	elseif  pressedKey == "up" and selectorY == 124 then
		selectorY = 144
		pressedKey = ""
	elseif pressedKey == "up" and selectorY == 144 then
		selectorY = 124
		pressedKey = ""
	end
	if pressedKey == "return" and selectorY == 124 then
		grafittiOn = true
		pressedKey = ""
	elseif pressedKey == "return" and selectorY == 144 then
		love.event.quit()
	end
	
	if grafittiOn == true then
		grafittiDelay = grafittiDelay - dt
	end
	if grafittiDelay <= 0 then
		grafittiDelay = 0
		currentScreen = 2
	end
end

function drawMenu()
	lg.draw(title, 25, 20)
	if grafittiOn == true then
		lg.draw(grafitti,250,65)
	end
	lg.circle("fill",selectorX, selectorY,3)
	lg.print("NEW GAME", 50, 120)
	lg.print("QUIT", 50, 140)
end
--Update and draw the intro sequence - Screen 2
function updateIntro(dt)
	typeTimer = typeTimer - dt
	if typeTimer <= 0 then
		typeTimer = 0.05
		typePosition = typePosition + 1
		printedText = string.sub(textToPrint, 0, typePosition)
	end
	if printedText == story[storyLine] then
		linePause = linePause - dt
	end
	if linePause <= 0 then
		typePosition = 0
		linePause = 2
		if storyLine < #story then
			storyLine = storyLine + 1
			textToPrint = story[storyLine]
		end
		if storyLine == #story then
			printedText = ""
			typePosition = 0
			currentScreen = 3
		end
	end
end

function drawIntro()
	lg.print(printedText,70,60)
end

--Update and draw the game - Screen 3
function updateGame(dt)
	--Crashes if you get too close to the walls...
	playerLeft = roomGrid[playerPositionY][playerPositionX -1]
	playerRight = roomGrid[playerPositionY][playerPositionX +1]
	playerUp = roomGrid[playerPositionY -1][playerPositionX]
	playerDown = roomGrid[playerPositionY +1][playerPositionX]
	--Called staticRoom() first due to order of ops
	staticRoom()
	if pressedKey == "up" and playerUp == 0 then
		playerPositionY = playerPositionY - 1
		pressedKey = ""
	elseif pressedKey == "down" and playerDown == 0 then
		playerPositionY = playerPositionY + 1
		pressedKey = ""
	elseif pressedKey == "left" and playerLeft == 0 then
		playerPositionX = playerPositionX - 1
		pressedKey = ""
	elseif pressedKey == "right" and playerRight == 0 then
		playerPositionX = playerPositionX + 1
		pressedKey = ""
	end
	--Grid movement code for player and cleanup for other sprites
	for y=1, #roomGrid do
		for x=1, #roomGrid[y] do
			if y == playerPositionY and x == playerPositionX then
				roomGrid[y][x] = 1
			end
			if roomGrid[y][x] == 5 and deadHooker == true then
				roomGrid [y][x] = 0
			end
			if roomGrid[y][x] == 4 and deadHobo == true then
				roomGrid [y][x] = 0
			end
		end
	end
	--Interactions
	if playerUp > 0 then
		playerBump = playerUp
	elseif playerDown > 0 then
		playerBump = playerDown
	elseif playerLeft > 0 then
		playerBump = playerLeft
	elseif playerRight > 0 then
		playerBump = playerRight
	else
		playerBump = 0
		intText = ""
	end
	
	--Interaction with different objects for descriptions only right now...
	if pressedKey == "space" then
		--Moving through doors
		if playerBump == 90 and currentRoom == 1 then
			currentRoom = 2
			playerPositionX = 11
			playerPositionY = 3
		elseif currentRoom == 2 and playerPositionX == 11 and playerPositionY == 3 then
			currentRoom = 1
			playerPositionX = 8
			playerPositionY = 6
		elseif currentRoom == 2 and playerBump == 91 then
			currentRoom = 3
			playerPositionX = 4
			playerPositionY = 4
		elseif currentRoom == 3 and playerBump == 93 then
			currentRoom = 2
			playerPositionX = 10
			playerPositionY = 10
		elseif currentRoom == 3 and playerBump == 91 then
			currentRoom = 4
			playerPositionX = 10
			playerPositionY = 2
		elseif currentRoom == 4 and playerBump == 93 then
			currentRoom = 3
			playerPositionX = 15
			playerPositionY = 7
		elseif playerBump == 2 then
			if playerMoney < 1400 then
				intText = "Your rent is due. 1400$"
			elseif playerMoney >= 1400 then
				playerMoney = playerMoney - 1400
				intText = "That covers today's rent. \n I'll be back tomorrow."
				rentPaid = true
			end
		elseif playerBump == 5 and hookerFollow == false and deadHooker == false then
			if playerMoney >= 200 then
				playerMoney = playerMoney - 200
				hookerFollow = true
			else
				intText = "For 200$ I'll follow you anywhere..."
			end
		elseif playerBump == 4 and hoboFollow == false then
			if haveBooze == false then
				intText = "I could sure use a drink..."
			elseif haveBooze == true then
				haveBooze = false
				hoboFollow = true
			end
		elseif playerBump == 3 and haveBooze == false then
			playerMoney = playerMoney - 20
			haveBooze = true
			intText = "You bought a beer."
		elseif playerBump == 20 or playerBump == 21 then
			if hoboFollow == true then
				deadHobo = true
				playerMoney = playerMoney + 600
				hoboFollow = false
			elseif hookerFollow == true then
				deadHooker = true
				playerMoney = playerMoney + 450
				hookerFollow = false
			else
				playerLyfe = playerLyfe - 1
				playerMoney = playerMoney + 100
			end
		end
		pressedKey = ""
	end
	if rentPaid == true then
		shockTime = shockTime - dt
	end
	if shockTime <= 0 or playerLyfe <= 0 then
		shockTime = 0
		currentScreen = 4
	end
end

function drawGame()
	lg.line(0,24,320,24)
	lg.print("LYFE: " .. playerLyfe, 20,8)
	lg.print("$" .. playerMoney, 250,8)
	lg.print(intText, 70, 0)

	--Draw stuff on the grid
	for y=1, #roomGrid do
		for x=1, #roomGrid[y] do
			if roomGrid[y][x] ~= 0 then
				lg.draw(spriteSheet, quadsList[roomGrid[y][x]],-16 + x * 16, 8 + y * 16)
			end
			if currentRoom == 3 then
				if hoboFollow == true and deadHobo == false then
					lg.draw(spriteSheet,hobo,(-16 + playerPositionX * 16) + 16,8 + playerPositionY * 16)
				elseif hoboFollow == false and deadHobo == false then
					roomGrid[2][17] = 4
				end
				if hookerFollow == true and deadHooker == false then
					lg.draw(spriteSheet,hooker,(-16 + playerPositionX * 16) - 16,8 + playerPositionY * 16)
				elseif hookerFollow == false and deadHooker == false then
					roomGrid[7][8] = 5
				end
			end
		end
	end
end

--Show the end screen
function updateEnd(dt)
	if pressedKey ~= "" then
		reset()
		pressedKey = ""
	end
end

function drawEnd()
	if rentPaid == true and playerLyfe > 0 then
		lg.print("You survived today. \n But at what cost..?", screenWidth/2 -50, screenHeight/2 -20)
	else
		lg.print("YOU DIED", screenWidth/2 -30, screenHeight/2 -10)
	end
end

--Update function for all other functions
function love.update(dt)
	if currentScreen == 0 then
		updateSplash(dt)
	elseif currentScreen == 1 then
		updateMenu(dt)
	elseif currentScreen == 2 then
		updateIntro(dt)
	elseif currentScreen == 3 then
		updateGame(dt)
	elseif currentScreen == 4 then
		updateEnd(dt)
	end
	if pressedKey == "escape" then
		if currentScreen == 4 then
			reset()
		else
			love.event.quit()
		end
	end
	--Turn back on after testing
	if pressedKey ~= "" then
		if currentScreen ~= 1 and currentScreen < 3 then
			currentScreen = currentScreen + 1
		end
		pressedKey = ""
	end
	--Turn off after testing
	--[[if pressedKey == "j" then
		currentScreen = 3
		pressedKey = ""
	end]]
end
--Draw function for all other functions
function love.draw()
	if currentScreen == 0 then
		drawSplash()
	elseif currentScreen == 1 then
		drawMenu()
	elseif currentScreen == 2 then
		drawIntro()
	elseif currentScreen == 3 then
		drawGame()
	elseif currentScreen == 4 then
		drawEnd()
	end
end

function love.keypressed(key)
	pressedKey = key
end

function love.keyreleased(key)
	if key == pressedKey then
		pressedKey = ""
	end
end