DECLARE SUB PrintGarbage (x AS LONG, y AS LONG, length AS LONG)
DECLARE SUB AddMessage (newmsg AS STRING, autooff AS LONG)
DECLARE SUB PrepTrackGenData ()
DECLARE SUB ClearTrack ()
DECLARE SUB RenderTrack (camx AS LONG, ppos AS LONG, plane AS LONG, pcar AS LONG, ecar AS LONG)
DECLARE SUB InitCars ()
DECLARE SUB PRINTRIGHT (s AS STRING)
DECLARE SUB PRINTCENTRED (s AS STRING)
DECLARE FUNCTION randVal& (min AS LONG, max AS LONG)
DEFLNG A-Z
RANDOMIZE TIMER
SCREEN 0, , 0, 0: WIDTH 80, 25

TYPE TCar
      carname AS STRING * 8
      maxarmour AS LONG
      maxguns AS LONG
      attack AS LONG
      shieldcap AS LONG
      missilecap AS LONG
      weight AS LONG
END TYPE

TYPE TEnemy
      epos AS LONG
      elane AS LONG
      aistate AS LONG ' 0 = Stay in Lane, 1 = Swerve Up, 2 = Swerve Down
      earmour AS LONG
      ealive AS LONG
END TYPE

CONST tracksize = 500
CONST enemymaxspeed = 6
CONST maxspeed = 8

DIM SHARED track(0 TO tracksize - 1, 0 TO 4) AS LONG
DIM SHARED enemy(1 TO 7) AS TEnemy
DIM SHARED symbol(1 TO 17, 0 TO 1) AS STRING * 3
DIM SHARED symbolcolour(1 TO 17) AS LONG
DIM SHARED carsprite(1 TO 8, 0 TO 1) AS STRING * 5
DIM SHARED defaultcar(1 TO 8) AS TCar
DIM SHARED guncount(1 TO 8) AS LONG
DIM SHARED missiles(1 TO 8) AS LONG
DIM SHARED turnmsg(1 TO 4) AS STRING
DIM SHARED messages AS LONG
DIM SHARED autonow AS LONG
autoadvance = 1

InitCars
FOR z = 1 TO 8: guncount(z) = 1: missiles(z) = 0: NEXT z

carsprite(1, 0) = "-\B\": carsprite(1, 1) = "-/B/"
carsprite(2, 0) = "[#\": carsprite(2, 1) = "[#/"
carsprite(3, 0) = "C=:\": carsprite(3, 1) = "C=:/"
carsprite(4, 0) = "}#=\": carsprite(4, 1) = "}#=/"
carsprite(5, 0) = ")=}\": carsprite(5, 1) = ")=}/"
carsprite(6, 0) = ">[]\": carsprite(6, 1) = ">[]/"
carsprite(7, 0) = "\O\": carsprite(7, 1) = "/O/"
carsprite(8, 0) = "D\": carsprite(8, 1) = "D/"

symbol(1, 0) = "\\\": symbol(1, 1) = "///"    ' Energy Up      Common Sh/Md
symbol(2, 0) = "///": symbol(2, 1) = "\\\"    ' Energy Down    Common Sh/Md
symbol(3, 0) = "--": symbol(3, 1) = "--"    ' Speed Up       Common Single
symbol(4, 0) = "--": symbol(4, 1) = "--"    ' Speed Down     Common Single
symbol(5, 0) = "HHH": symbol(5, 1) = "HHH"    ' Score Up       Common Sh/Ln
symbol(6, 0) = "HHH": symbol(6, 1) = "HHH"    ' Score Down     Common Sh/Ln
symbol(7, 0) = "\X/": symbol(7, 1) = "/X\"    ' Weapon Cancel  ONE ONLY
symbol(8, 0) = "-G-": symbol(8, 1) = "-G-"    ' 1 Gun          Uncom  Single
symbol(9, 0) = "=G=": symbol(9, 1) = "=G="    ' 2 Guns         Uncom  Single
symbol(10, 0) = "G": symbol(10, 1) = "G"  ' 3 Guns         Uncom  Single
symbol(11, 0) = "<M>": symbol(11, 1) = "<M>"  ' Extra Missile  ONE ONLY
symbol(12, 0) = ">?<": symbol(12, 1) = ">?<"  ' Accuracy Down  Uncom  Single
symbol(13, 0) = "(O)": symbol(13, 1) = "(O)"  ' Shields        Rare   Single
symbol(14, 0) = "": symbol(14, 1) = ""  ' Lane Switch    Uncom  Single
symbol(15, 0) = "[]": symbol(15, 1) = "[]"  ' Info Disrupt   Uncom  Single
symbol(16, 0) = "|": symbol(16, 1) = "|"  ' Spikes         Uncom  Single
symbol(17, 0) = "": symbol(17, 1) = ""  ' Finish Line
symbolcolour(1) = 14
symbolcolour(2) = 6
symbolcolour(3) = 11
symbolcolour(4) = 3
symbolcolour(5) = 15
symbolcolour(6) = 7
symbolcolour(7) = 4
symbolcolour(8) = 14
symbolcolour(9) = 14
symbolcolour(10) = 14
symbolcolour(11) = 12
symbolcolour(12) = 5
symbolcolour(13) = 13
symbolcolour(14) = 2
symbolcolour(15) = 6
symbolcolour(16) = 4
symbolcolour(17) = 15

DIM SHARED gangname(1 TO 5) AS STRING
DIM SHARED gangcar(1 TO 5) AS LONG
gangname(1) = "The Vultures": gangcar(1) = 4
gangname(2) = "The Sharks": gangcar(2) = 5
gangname(3) = "The Power Tools": gangcar(3) = 6
gangname(4) = "The Master Class": gangcar(4) = 7
gangname(5) = "The Scabs": gangcar(5) = 8

DIM SHARED trackname(1 TO 14) AS STRING
DIM SHARED trackgang(1 TO 14) AS LONG
DIM SHARED tracksymbolrate(1 TO 14) AS LONG
DIM SHARED tsr(1 TO 14, 0 TO 16) AS LONG
PrepTrackGenData

maxmissiles = 3
playercar = 1
playercarlimit = 3
currenttrack = 1
score = 0

1 COLOR 10, 0: CLS
PRINTCENTRED "Pixelmusement Presents - A Text Mode Remake of..."
COLOR 15, 0
PRINT
PRINT
PRINT "            "
PRINT "                                                 "
PRINT "                            "
PRINT "                                              "
PRINT "                      "
PRINT
COLOR 7, 0
PRINT "The goal of the game is to survive VWBT's 14 amazing, virtual world racetracks"
PRINT "where the action is intense and death isn't real! You'll be going up against"
PRINT "five VICIOUS speed gangs, each with a packleader you don't ever want to meet,"
PRINT "but if you virtually kill them, you get their car!"
PRINT
PRINT "In each race you will be going down a track with the singular goal of taking"
PRINT "out each opponent before completing three laps. On each turn you can switch"
PRINT "lanes, accelerate, decelerate, stay at speed, and fire your weapons if you wish."
PRINT
PRINT "Also, pay very close attention to the track symbols as these can greatly"
PRINT "affect your car's status!"
PRINT
PRINT "Please Note: Pixelmusement is not affiliated with the creators of MegaRace in"
PRINT "any way. This is simply a freeware (and open source) fan game meant mostly as"
PRINT "a programming challenge.";
2 DO
      COLOR randVal(1, 15), 0
      LOCATE 25, 1: PRINTCENTRED "Press any key to begin"
      a$ = INKEY$
LOOP WHILE a$ = ""

3 COLOR 15, 0: CLS
COLOR 14, 1: PRINT "                                                                                ";
LOCATE 1, 1: PRINT " Enforcer's Score ="; score;
PRINTRIGHT trackname(currenttrack) + " "
COLOR 11, 0: LOCATE 4, 1
PRINTCENTRED "It's time to choose your MegaRace machine, Enforcer!"
FOR z = 1 TO 8
      LOCATE z + 6, 10
      IF playercar = z THEN
            COLOR 14, 4
      ELSEIF z <= playercarlimit THEN
            COLOR 15, 0
      ELSE
            COLOR 8, 0
      END IF
      IF z <= playercarlimit THEN
            PRINT " ("; LTRIM$(RTRIM$(STR$(z))); ") "; defaultcar(z).carname; " ";
      ELSE
            PRINT " ("; LTRIM$(RTRIM$(STR$(z))); ") ???";
      END IF
NEXT z
LOCATE 16, 10: COLOR 15, 0: PRINT " (0) BEGIN RACE!                                (T) View Tips!";
COLOR 15, 0: LOCATE 7, 28: PRINT defaultcar(playercar).carname; " - Car Status"
COLOR 7, 0: LOCATE 8, 28: PRINT "--------------------------------------------"
COLOR 15, 0: LOCATE 9, 28: PRINT "Armour Rating     = ";
SELECT CASE defaultcar(playercar).maxarmour
      CASE 10: COLOR 12, 0: PRINT "Light Protection"
      CASE 15: COLOR 14, 0: PRINT "Medium Protection"
      CASE 20: COLOR 10, 0: PRINT "Heavy Protection"
END SELECT
COLOR 15, 0: LOCATE 10, 28: PRINT "Attack Power      = ";
SELECT CASE defaultcar(playercar).attack
      CASE 1: COLOR 12, 0: PRINT "Low Damage"
      CASE 2: COLOR 14, 0: PRINT "Medium Damage"
      CASE 3: COLOR 10, 0: PRINT "High Damage"
END SELECT
COLOR 15, 0: LOCATE 11, 28: PRINT "Guns Installed    =";
COLOR 11, 0: PRINT guncount(playercar); "/"; defaultcar(playercar).maxguns
COLOR 15, 0: LOCATE 12, 28: PRINT "Shield Capability = ";
SELECT CASE defaultcar(playercar).shieldcap
      CASE 1: COLOR 10, 0: PRINT "Yes"
      CASE 0: COLOR 12, 0: PRINT "No"
END SELECT
COLOR 15, 0: LOCATE 13, 28: PRINT "Missiles Loaded   =";
IF defaultcar(playercar).missilecap = 0 THEN
      COLOR 12, 0: PRINT " Not Possible";
ELSE
      IF missiles(playercar) > 0 THEN COLOR 10, 0 ELSE COLOR 14, 0
      PRINT missiles(playercar); "/"; maxmissiles;
END IF
COLOR 15, 0: LOCATE 14, 28: PRINT "Weight Rating     = ";
SELECT CASE defaultcar(playercar).weight
      CASE 1: COLOR 12, 0: PRINT "Light Weight"
      CASE 2: COLOR 14, 0: PRINT "Medium Weight"
      CASE 3: COLOR 10, 0: PRINT "Heavy Weight"
      CASE 4: COLOR 11, 0: PRINT "Ultra Weight"
END SELECT
COLOR 7, 0: LOCATE 19, 11: PRINT "-------------------------------------------------------------";
IF autoadvance = 1 THEN
      COLOR 10, 0: LOCATE 21, 28: PRINT "(A) - Auto Advance is ON";
      COLOR 15, 0: LOCATE 22, 28: PRINTCENTRED "Car movement only is advanced automatically"
ELSE
      COLOR 12, 0: LOCATE 21, 28: PRINT "(A) - Auto Advance is OFF";
      COLOR 15, 0: LOCATE 22, 28: PRINTCENTRED "Car movement only is advanced manually"
END IF
4 DO: a$ = INKEY$: LOOP WHILE a$ = ""
z = 0: z = VAL(a$)
IF UCASE$(a$) = "A" THEN
      IF autoadvance = 1 THEN autoadvance = 0 ELSE autoadvance = 1
      GOTO 3
END IF
IF a$ = "0" THEN GOTO 10
IF UCASE$(a$) = "T" THEN GOTO 5
IF a$ = CHR$(27) THEN GOTO 9999
IF z > 0 THEN
      IF z <= playercarlimit THEN playercar = z
      GOTO 3
END IF
GOTO 4

5 COLOR 15, 0: CLS
COLOR 14, 1: PRINT "                                                                                ";
LOCATE 1, 1: PRINT " Enforcer's Score ="; score;
PRINTRIGHT trackname(currenttrack) + " "
COLOR 11, 0: LOCATE 4, 1
PRINTCENTRED "Tips for New Enforcers!"
COLOR 7, 0: LOCATE 7, 1
PRINT "  * Your natural top speed is two spaces per turn faster than your opponents."
PRINT "    Control of your speed is essential to survival!"
PRINT
PRINT "  * Slamming enemies from the side or having them slam into you from behind"
PRINT "    hurts them. Slamming into THEIR backside hurts you!"
PRINT
PRINT "  * Enemies will shoot you if you let them get behind you! If you're going to"
PRINT "    overtake them unintentionally, stay out of their line of fire!"
PRINT
PRINT "  * Don't recognize the track symbols? Basically, the brighter colours are"
PRINT "    often the better ones! (Though sometimes a speed down can save you from"
PRINT "    rear-ending an opponent!)"
PRINT
PRINT "  * Always remember the order of events: You shoot first, then lane changes,"
PRINT "    then forward movement, then enemy shoots you if you're in front!"
DO
      COLOR randVal(1, 15), 0
      LOCATE 25, 1: PRINTCENTRED "Press any key to continue"
      a$ = INKEY$
LOOP WHILE a$ = ""
GOTO 3

10 ' Set Default Player State
prevscore = score
ct = currenttrack
pmaxarmour = defaultcar(playercar).maxarmour
parmour = pmaxarmour
pspeed = 1
penergy = 90
lap = 1
ppos = 0: plane = 2
maxenemies = 3 + ct
IF maxenemies > 7 THEN maxenemies = 7
enemycount = maxenemies
pshields = 0
pmoves = 0: emoves = 0
accdown = 0: dispint = 0
pgunready = 1
messages = 0: sidewasted = 0
IF autoadvance = 1 THEN autonow = 1 ELSE autonow = 0

11 ' Set Default Enemy State
ecar = gangcar(trackgang(ct))
espeed = 1
FOR z = 1 TO 7
      enemy(z).epos = z * (ct \ 2 + 14) - 6
      enemy(z).elane = randVal(0, 4)
      enemy(z).aistate = 0
      enemy(z).earmour = defaultcar(ecar).maxarmour
      IF z <= maxenemies THEN enemy(z).ealive = 1 ELSE enemy(z).ealive = 0
NEXT z

12 ' Generate the Track
ClearTrack
FOR y = 0 TO 4
      track(0, y) = 17
      FOR x = 7 TO tracksize - 1
            j = randVal(1, tracksymbolrate(ct))
            IF j = 1 THEN
                  DO: j = randVal(1, 16): LOOP WHILE randVal(1, 100) > tsr(ct, j)
                  SELECT CASE j
                        CASE 1 TO 2
                              jj = randVal(1, 3)
                              DO WHILE jj > 0 AND x < tracksize
                                    track(x, y) = j
                                    x = x + 1
                                    jj = jj - 1
                              LOOP
                        CASE 5 TO 6
                              jj = randVal(1, 5)
                              DO WHILE jj > 0 AND x < tracksize
                                    track(x, y) = j
                                    x = x + 1
                                    jj = jj - 1
                              LOOP
                        CASE ELSE
                              track(x, y) = j
                  END SELECT
            END IF
      NEXT x
NEXT y
IF tsr(ct, 7) < 0 THEN
      x = randVal(50, tracksize - 50)
      y = randVal(0, 4)
      track(x, y) = 7
END IF
IF tsr(ct, 11) < 0 THEN
      x = randVal(50, tracksize - 50)
      y = randVal(0, 4)
      track(x, y) = 11
END IF

20 COLOR 15, 0: CLS
COLOR 14, 1: PRINT "                                                                                ";
LOCATE 1, 1: PRINT " Enforcer's Score ="; score;
PRINTRIGHT trackname(currenttrack) + " "
LOCATE 2, 1: COLOR 7, 0
PRINT "================================================================================"
PRINT
PRINT
PRINT "  ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   "
PRINT
PRINT
PRINT "  ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   "
PRINT
PRINT
PRINT "  ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   "
PRINT
PRINT
PRINT "  ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   "
PRINT
PRINT
PRINT "================================================================================"
RenderTrack ppos - 3, ppos, plane, playercar, ecar
LOCATE 18, 1: COLOR 15, 1
PRINT "ARMOUR                                                                          "
PRINT "SPEED  [                ]                    GUNS [                    ]"
PRINT "ENERGY [                              ]                                         "
PRINT "LAP    [             ]   LEFT                                                   "
LOCATE 18, 8: COLOR 15, 1: PRINT "[";
COLOR 12, 1: PRINT STRING$(parmour, 254); : PRINT STRING$(defaultcar(playercar).maxarmour - parmour, 32);
COLOR 15, 1: PRINT "]";
LOCATE 19, 9: COLOR 11, 1: PRINT STRING$(pspeed * 2, 254);
LOCATE 20, 9: COLOR 14, 1: PRINT STRING$(penergy \ 3, 254);
SELECT CASE lap
      CASE 1: LOCATE 21, 10: COLOR 10, 1: PRINT "-1-";
      CASE 2: LOCATE 21, 14: COLOR 10, 1: PRINT "=2=";
      CASE 3: LOCATE 21, 18: COLOR 10, 1: PRINT "3";
END SELECT
LOCATE 21, 31: COLOR 15, 1: PRINT "[";
scanenemy = 0
FOR z = 1 TO maxenemies
      IF enemy(z).ealive > 0 THEN
            COLOR 10, 1: PRINT "";
            IF (enemy(z).epos >= ppos AND enemy(z).epos < ppos + 10) OR (enemy(z).epos + tracksize >= ppos AND enemy(z).epos + tracksize < ppos + 10) THEN
                  scanenemy = z
                  lanecheck = ABS(enemy(z).elane - plane)
                  pgunchance = enemy(z).epos - ppos
                  IF lanecheck > 1 THEN
                        pgunchance = 0
                  ELSEIF pgunchance <> 0 THEN
                        IF pgunchance < 0 THEN pgunchance = pgunchance + tracksize
                        pgunchance = 105 - (pgunchance * 10)
                        IF lanecheck <> 0 THEN pgunchance = pgunchance \ 2
                        IF accdown > 0 THEN pgunchance = pgunchance \ 2
                        IF pgunchance < 5 THEN pgunchance = 5
                  END IF
            END IF
      ELSE
            COLOR 4, 1: PRINT "X";
      END IF
NEXT z
COLOR 15, 1: PRINT "]";
IF scanenemy > 0 THEN
      LOCATE 18, 64 - defaultcar(ecar).maxarmour: COLOR 15, 1: PRINT "ENEMY IN FRONT [";
      COLOR 12, 1: PRINT STRING$(enemy(scanenemy).earmour, 254); : PRINT STRING$(defaultcar(ecar).maxarmour - enemy(scanenemy).earmour, 32);
      COLOR 15, 1: PRINT "]";
END IF
IF accdown > 0 THEN COLOR 12, 1 ELSE COLOR 7, 1
LOCATE 19, 62
SELECT CASE defaultcar(playercar).maxguns
      CASE 1
            PRINT "      (  )      ";
            IF guncount(playercar) >= 1 THEN
                  LOCATE 19, 69: COLOR 10, 1: PRINT "";
            END IF
      CASE 2
            IF guncount(playercar) >= 2 THEN
                  PRINT "(  )   --   (  )";
                  LOCATE 19, 63: COLOR 10, 1: PRINT "";
                  LOCATE 19, 75: COLOR 10, 1: PRINT "";
            ELSE
                  PRINT " --   (  )   -- ";
                  IF guncount(playercar) >= 1 THEN
                        LOCATE 19, 69: COLOR 10, 1: PRINT "";
                  END IF
            END IF
      CASE 3: PRINT "(  )  (  )  (  )";
            IF guncount(playercar) >= 3 THEN
                  LOCATE 19, 63: COLOR 10, 1: PRINT "";
                  LOCATE 19, 69: COLOR 10, 1: PRINT "";
                  LOCATE 19, 75: COLOR 10, 1: PRINT "";
            ELSEIF guncount(playercar) >= 2 THEN
                  LOCATE 19, 63: COLOR 10, 1: PRINT "";
                  LOCATE 19, 75: COLOR 10, 1: PRINT "";
            ELSEIF guncount(playercar) >= 1 THEN
                  LOCATE 19, 69: COLOR 10, 1: PRINT "";
            END IF
END SELECT
IF defaultcar(playercar).missilecap > 0 THEN
      LOCATE 20, 50: COLOR 15, 1: PRINT "MISSILES [                    ]";
      FOR z = 1 TO 3
            LOCATE 20, z * 6 + 56
            IF missiles(playercar) >= z THEN
                  COLOR 12, 1: PRINT ">]=>";
            ELSE
                  COLOR 7, 1: PRINT "----";
            END IF
      NEXT z
END IF
IF defaultcar(playercar).shieldcap > 0 THEN
      LOCATE 21, 51: COLOR 15, 1: PRINT "SHIELDS [";
      IF pshields > 20 THEN z = 20 ELSE z = pshields
      COLOR 13, 1: PRINT STRING$(z, 254); : PRINT STRING$(20 - z, 32);
      COLOR 15, 1: PRINT "]";
END IF
IF dispint > 0 THEN
      PrintGarbage 9, 18, defaultcar(playercar).maxarmour
      PrintGarbage 9, 19, 24
      PrintGarbage 9, 20, 30
      PrintGarbage 9, 21, 13
      PrintGarbage 32, 21, maxenemies
      IF scanenemy > 0 THEN PrintGarbage 80 - defaultcar(ecar).maxarmour, 18, defaultcar(ecar).maxarmour
      PrintGarbage 60, 19, 20
      IF defaultcar(playercar).missilecap > 0 THEN PrintGarbage 60, 20, 20
      IF defaultcar(playercar).shieldcap > 0 THEN PrintGarbage 60, 21, 20
END IF

IF messages > 0 THEN
      COLOR 7, 0
      FOR z = 1 TO messages
            LOCATE 21 + z, 1
            PRINT turnmsg(z);
      NEXT z
      IF autonow = 1 THEN
            f# = TIMER + .1
            DO: LOOP WHILE f# > TIMER
      ELSE
            DO: a$ = INKEY$: LOOP WHILE a$ <> " "
      END IF
      messages = 0: sidewasted = 0
      IF autoadvance = 1 THEN autonow = 1 ELSE autonow = 0
      GOTO 40
END IF

' No messages remaining, obtain player input
COLOR 7, 0
LOCATE 22, 1: PRINT "   Lane Up \ [7]  [8]  [9] / Lane Up                    ";
IF pgunready > 0 AND scanenemy > 0 AND guncount(playercar) > 0 AND penergy > 0 THEN PRINT "Fire Guns = [G]";
LOCATE 23, 1: PRINT "Decelerate  [4] < [5] > [6]  Accelerate            ";
IF pgunready > 0 AND scanenemy > 0 AND penergy > 0 THEN
      IF guncount(playercar) > 0 THEN PRINT "Gun Hit Chance = "; LTRIM$(RTRIM$(STR$(pgunchance))); "% ";
      IF guncount(playercar) > 1 THEN PRINT "x"; LTRIM$(RTRIM$(STR$(guncount(playercar))));
END IF
LOCATE 24, 1: PRINT " Lane Down / [1]  [2]  [3] \ Lane Down               ";
IF pgunready > 0 AND scanenemy > 0 AND missiles(playercar) > 0 THEN PRINT "Fire Missile = [M]";
IF pspeed > 1 AND plane < 4 THEN vc$ = "1" ELSE vc$ = " ": LOCATE 24, 17: PRINT " ";
IF plane < 4 THEN vc$ = vc$ + "2" ELSE vc$ = vc$ + " ": LOCATE 24, 23: PRINT " ";
IF pspeed < maxspeed AND plane < 4 THEN vc$ = vc$ + "3" ELSE vc$ = vc$ + " ": LOCATE 24, 29: PRINT " ";
IF pspeed > 1 THEN vc$ = vc$ + "4" ELSE vc$ = vc$ + " ": LOCATE 23, 17: PRINT " ";
vc$ = vc$ + "5"
IF pspeed < maxspeed THEN vc$ = vc$ + "6" ELSE vc$ = vc$ + " ": LOCATE 23, 29: PRINT " ";
IF pspeed > 1 AND plane > 0 THEN vc$ = vc$ + "7" ELSE vc$ = vc$ + " ": LOCATE 22, 17: PRINT " ";
IF plane > 0 THEN vc$ = vc$ + "8" ELSE vc$ = vc$ + " ": LOCATE 22, 23: PRINT " ";
IF pspeed < maxspeed AND plane > 0 THEN vc$ = vc$ + "9" ELSE vc$ = vc$ + " ": LOCATE 22, 29: PRINT " ";
prevplane = plane
LOCATE 25, 1: PRINT "ENTER COMMAND > ";
DO
      DO: a$ = INKEY$: LOOP WHILE a$ = ""
      SELECT CASE UCASE$(a$)
            CASE "1"
                  IF MID$(vc$, 1, 1) = "1" THEN
                        pspeed = pspeed - 1
                        plane = plane + 1
                        GOTO 30
                  END IF
            CASE "2"
                  IF MID$(vc$, 2, 1) = "2" THEN
                        plane = plane + 1
                        GOTO 30
                  END IF
            CASE "3"
                  IF MID$(vc$, 3, 1) = "3" THEN
                        pspeed = pspeed + 1
                        plane = plane + 1
                        GOTO 30
                  END IF
            CASE "4"
                  IF MID$(vc$, 4, 1) = "4" THEN
                        pspeed = pspeed - 1
                        GOTO 30
                  END IF
            CASE "5"
                  IF MID$(vc$, 5, 1) = "5" THEN GOTO 30
            CASE "6"
                  IF MID$(vc$, 6, 1) = "6" THEN
                        pspeed = pspeed + 1
                        GOTO 30
                  END IF
            CASE "7"
                  IF MID$(vc$, 7, 1) = "7" THEN
                        pspeed = pspeed - 1
                        plane = plane - 1
                        GOTO 30
                  END IF
            CASE "8"
                  IF MID$(vc$, 8, 1) = "8" THEN
                        plane = plane - 1
                        GOTO 30
                  END IF
            CASE "9"
                  IF MID$(vc$, 9, 1) = "9" THEN
                        pspeed = pspeed + 1
                        plane = plane - 1
                        GOTO 30
                  END IF
            CASE "G"
                  IF pgunready > 0 AND scanenemy > 0 AND guncount(playercar) > 0 AND penergy > 0 THEN
                        pgunready = 0
                        GOTO 50
                  END IF
            CASE "M"
                  IF pgunready > 0 AND scanenemy > 0 AND missiles(playercar) > 0 THEN
                        pgunready = 0
                        GOTO 55
                  END IF
      END SELECT
LOOP WHILE a$ <> CHR$(27)
GOTO 9999

30 pmoves = pspeed
IF espeed < enemymaxspeed THEN espeed = espeed + 1
emoves = espeed
FOR z = 1 TO 7
      IF enemy(z).ealive > 0 THEN
            crosscheck = 0
            IF enemy(z).epos = ppos AND enemy(z).elane = plane THEN crosscheck = 1
            IF enemy(z).aistate = 0 AND enemy(z).earmour < defaultcar(ecar).maxarmour THEN
                  IF enemy(z).elane = 0 THEN
                        enemy(z).aistate = 2
                  ELSEIF enemy(z).elane = 4 THEN
                        enemy(z).aistate = 1
                  ELSE
                        enemy(z).aistate = randVal(1, 2)
                  END IF
            END IF
            IF enemy(z).aistate = 1 THEN
                  enemy(z).elane = enemy(z).elane - 1
                  IF enemy(z).elane = 0 THEN enemy(z).aistate = 2
            ELSEIF enemy(z).aistate = 2 THEN
                  enemy(z).elane = enemy(z).elane + 1
                  IF enemy(z).elane = 4 THEN enemy(z).aistate = 1
            END IF
            IF crosscheck = 1 AND enemy(z).elane = prevplane THEN crosscheck = 2
            IF enemy(z).epos = ppos AND (enemy(z).elane = plane OR crosscheck = 2) THEN
                  enemy(z).epos = enemy(z).epos + 1
                  enemy(z).earmour = enemy(z).earmour - (defaultcar(playercar).weight + 2)
                  pspeed = espeed - 1
                  pmoves = pspeed
                  score = score + 400
                  IF enemy(z).earmour <= 0 THEN
                        score = score + 1000
                        enemy(z).ealive = 0
                        enemycount = enemycount - 1
                        sidewasted = 1
                        AddMessage "Enemy Vehicle Wasted!", 1
                  END IF
            END IF
      END IF
NEXT z

40 anymovement = 0: playermoved = 0: enemymoved = 0
IF pmoves > 0 THEN
      ' Player has moves remaining
      anymovement = 1: playermoved = 1
      ppos = ppos + 1
      IF ppos >= tracksize THEN
            ppos = ppos - tracksize
            lap = lap + 1
      END IF
      pmoves = pmoves - 1
      IF emoves > 0 THEN
            ' Enemy also has moves remaining
            enemymoved = 1
            FOR z = 1 TO 7
                  IF enemy(z).ealive > 0 THEN
                        enemy(z).epos = enemy(z).epos + 1
                        IF enemy(z).epos >= tracksize THEN enemy(z).epos = enemy(z).epos - tracksize
                  END IF
            NEXT z
            emoves = emoves - 1
      END IF
      SELECT CASE track(ppos, plane)
            CASE 1      ' Energy Up
                  penergy = penergy + 6
                  IF penergy > 90 THEN penergy = 90
                  AddMessage "Energy Up!", 1
            CASE 2      ' Energy Down
                  penergy = penergy - 6
                  IF penergy < 0 THEN penergy = 0
                  AddMessage "Energy Down!", 1
            CASE 3      ' Speed Up
                  pmoves = pmoves + (12 - pspeed)
                  pspeed = 12
                  AddMessage "Speed Boost!", 1
            CASE 4      ' Speed Down
                  pmoves = 0
                  pspeed = 1
                  AddMessage "Speed Down!", 1
            CASE 5      ' Score Up
                  score = score + 100
                  AddMessage "Bonus Points!", 1
            CASE 6      ' Score Down
                  score = score - 100
                  IF score < 0 THEN score = 0
                  AddMessage "Score Reduced!", 1
            CASE 7      ' Weapon Cancel
                  guncount(playercar) = 0
                  missiles(playercar) = 0
                  penergy = 0
                  AddMessage "All Weapons Deleted!", 1
            CASE 8      ' Single Gun
                  guncount(playercar) = 1
                  penergy = penergy + 30
                  IF penergy > 90 THEN penergy = 90
                  AddMessage "Single Gun Equipped!", 1
            CASE 9      ' Double Gun
                  penergy = penergy + 30
                  IF penergy > 90 THEN penergy = 90
                  IF defaultcar(playercar).maxguns < 2 THEN
                        guncount(playercar) = 1
                        AddMessage "Double Gun Not Available - Single Gun Equipped!", 1
                  ELSE
                        guncount(playercar) = 2
                        AddMessage "Double Gun Equipped!", 1
                  END IF
            CASE 10     ' Triple Gun
                  penergy = penergy + 30
                  IF penergy > 90 THEN penergy = 90
                  IF defaultcar(playercar).maxguns < 3 THEN
                        IF defaultcar(playercar).maxguns < 2 THEN
                              guncount(playercar) = 1
                              AddMessage "Triple Gun Not Available - Single Gun Equipped!", 1
                        ELSE
                              guncount(playercar) = 2
                              AddMessage "Triple Gun Not Available - Double Gun Equipped!", 1
                        END IF
                  ELSE
                        guncount(playercar) = 3
                        AddMessage "Triple Gun Equipped!", 1
                  END IF
            CASE 11     ' Missile
                  IF defaultcar(playercar).missilecap = 0 THEN
                        AddMessage "No Missile Launcher Available!", 1
                  ELSEIF missiles(playercar) >= 3 THEN
                        AddMessage "No Space Remaining for Extra Missile!", 1
                  ELSE
                        missiles(playercar) = missiles(playercar) + 1
                        AddMessage "Missile Acquired!", 1
                  END IF
            CASE 12     ' Accuracy Down
                  accdown = accdown + 6
                  AddMessage "Accuracy Down!", 1
            CASE 13     ' Shields
                  IF defaultcar(playercar).shieldcap = 0 THEN
                        AddMessage "No Shield System Available!", 1
                  ELSE
                        pshields = 21
                        AddMessage "Shields Activated!", 1
                  END IF
            CASE 14     ' Lane Switch
                  IF plane = 0 THEN
                        plane = 1
                  ELSEIF plane = 4 THEN
                        plane = 3
                  ELSE
                        IF randVal(0, 1) = 0 THEN plane = plane - 1 ELSE plane = plane + 1
                  END IF
                  AddMessage "Lane Switched!", 1
                  FOR z = 1 TO 7
                        IF enemy(z).ealive > 0 THEN
                              IF enemy(z).epos = ppos AND enemy(z).elane = plane THEN
                                    enemy(z).epos = enemy(z).epos + 1
                                    enemy(z).earmour = enemy(z).earmour - (defaultcar(playercar).weight + 2)
                                    pspeed = espeed - 1
                                    pmoves = pspeed
                                    score = score + 400
                                    IF enemy(z).earmour <= 0 THEN
                                          score = score + 1000
                                          enemy(z).ealive = 0
                                          enemycount = enemycount - 1
                                          sidewasted = 1
                                          AddMessage "Enemy Vehicle Wasted!", 1
                                    END IF
                              END IF
                        END IF
                  NEXT z
            CASE 15     ' Info Disrupt
                  dispint = dispint + 6
                  AddMessage "Info Display Disrupted!", 1
            CASE 16     ' Spikes
                  IF pshields <= 0 THEN parmour = parmour - 1
                  AddMessage "Spikes!", 1
      END SELECT
ELSEIF emoves > 0 THEN
      ' Player has no moves remaining but enemy does
      anymovement = 1
      enemymoved = 1
      FOR z = 1 TO 7
            IF enemy(z).ealive > 0 THEN
                  enemy(z).epos = enemy(z).epos + 1
                  IF enemy(z).epos >= tracksize THEN enemy(z).epos = enemy(z).epos - tracksize
            END IF
      NEXT z
      emoves = emoves - 1
END IF
IF playermoved > 0 AND enemymoved = 0 THEN
      FOR z = 1 TO 7
            IF enemy(z).ealive > 0 AND enemy(z).epos = ppos AND enemy(z).elane = plane THEN
                  enemy(z).epos = enemy(z).epos + 1
                  pspeed = espeed - 2
                  IF pshields <= 0 THEN parmour = parmour - (defaultcar(ecar).weight + 2)
                  pmoves = 0
            END IF
      NEXT z
ELSEIF enemymoved > 0 AND playermoved = 0 THEN
      FOR z = 1 TO 7
            IF enemy(z).ealive > 0 AND enemy(z).epos = ppos AND enemy(z).elane = plane THEN
                  enemy(z).epos = enemy(z).epos - 1
                  pspeed = espeed + 1
                  enemy(z).earmour = enemy(z).earmour - (defaultcar(playercar).weight + 2)
                  pmoves = emoves + 1
                  score = score + 400
                  IF enemy(z).earmour <= 0 THEN
                        score = score + 1000
                        enemy(z).ealive = 0
                        enemycount = enemycount - 1
                        sidewasted = 1
                        AddMessage "Enemy Vehicle Wasted!", 1
                  END IF
            END IF
      NEXT z
END IF
IF anymovement = 1 THEN
      IF pmoves = 0 AND emoves = 0 THEN
            FOR z = 1 TO 7
                  IF enemy(z).ealive > 0 THEN
                        zz = ppos - enemy(z).epos
                        IF zz < 0 THEN zz = zz + tracksize
                        zzz = ABS(enemy(z).elane - plane)
                        IF zz > 0 AND zz < 4 AND zzz <= 1 THEN
                              IF pshields <= 0 THEN parmour = parmour - defaultcar(ecar).attack
                        END IF
                  END IF
            NEXT z
            IF pspeed > maxspeed THEN pspeed = pspeed - 1
            IF accdown > 0 THEN accdown = accdown - 1
            IF dispint > 0 THEN dispint = dispint - 1
            IF pshields > 0 THEN pshields = pshields - 1
            pgunready = 1
            AddMessage "Movement Complete! Press Spacebar to Advance...", 1
      ELSE
            AddMessage "Moving cars... Press Spacebar to Advance...", 0
      END IF
END IF
IF sidewasted = 0 AND enemycount <= 0 THEN GOTO 100   ' Enemies Destroyed
IF parmour <= 0 THEN GOTO 200                         ' Player Destroyed
IF lap > 3 THEN GOTO 300                              ' 3 Laps Exceeded
GOTO 20

50 hits = 0
FOR z = 1 TO guncount(playercar)
      IF penergy > 0 THEN
            penergy = penergy - defaultcar(playercar).attack
            IF penergy < 0 THEN penergy = 0
            IF randVal(1, 100) <= pgunchance THEN
                  hits = hits + 1
                  score = score + 50
                  enemy(scanenemy).earmour = enemy(scanenemy).earmour - defaultcar(playercar).attack
            END IF
      END IF
NEXT z
SELECT CASE hits
      CASE 0: AddMessage "Firing Guns... MISSED!", 1
      CASE 1
            IF guncount(playercar) = 1 THEN
                  AddMessage "Firing Guns... DIRECT HIT!", 1
            ELSE
                  AddMessage "Firing Guns... ONE HIT!", 1
            END IF
      CASE 2: AddMessage "Firing Guns... TWO HITS!", 1
      CASE 3: AddMessage "Firing Guns... THREE HITS!", 1
END SELECT
IF enemy(scanenemy).earmour <= 0 THEN
      score = score + 1000
      enemy(scanenemy).ealive = 0
      enemycount = enemycount - 1
      AddMessage "Enemy Vehicle Wasted!", 1
END IF
AddMessage "Press Spacebar...", 1
GOTO 20

55 hits = 0
AddMessage "Firing Missile... INSTA-KILL!", 1
missiles(playercar) = missiles(playercar) - 1
enemy(scanenemy).earmour = 0
score = score + 1000
enemy(scanenemy).ealive = 0
enemycount = enemycount - 1
AddMessage "Press Spacebar...", 1
GOTO 20

100 COLOR 15, 0: CLS
LOCATE 2, 1: PRINTCENTRED "----------------------"
COLOR 10, 0: LOCATE 3, 1: PRINTCENTRED "RACE COMPLETE!"
COLOR 15, 0: LOCATE 4, 1: PRINTCENTRED "----------------------"
COLOR 7, 0: LOCATE 6, 1
s$ = gangname(trackgang(ct)) + " have all been wasted!"
PRINTCENTRED s$
IF ct <= 5 THEN
      COLOR 14, 0: LOCATE 8, 1
      playercarlimit = playercarlimit + 1
      s$ = "Congratulations! You are now able to drive their " + RTRIM$(defaultcar(ecar).carname) + " cars!"
      PRINTCENTRED s$
END IF
IF lap = 1 THEN
      score = score + 2500
      COLOR 11, 0: LOCATE 10, 1: PRINTCENTRED "2,500 Point Bonus for 2 Laps Remaining!"
END IF
IF lap = 2 THEN
      score = score + 1000
      COLOR 11, 0: LOCATE 11, 1: PRINTCENTRED "1,000 Point Bonus for 1 Lap Remaining!"
END IF
IF parmour >= defaultcar(playercar).maxarmour THEN
      score = score + 1000
      COLOR 11, 0: LOCATE 12, 1: PRINTCENTRED "1,000 Point Bonus for taking No Damage!"
END IF
IF guncount(playercar) <= 0 AND missiles(playercar) <= 0 THEN
      score = score + 2500
      COLOR 11, 0: LOCATE 13, 1: PRINTCENTRED "2,500 Point Bonus for a No Weapons Clear!"
END IF
COLOR 7, 0
IF ct < 14 THEN
      s$ = "Current Score = " + LTRIM$(RTRIM$(STR$(score)))
      LOCATE 15, 1: PRINTCENTRED s$
ELSE
      LOCATE 15, 1: PRINTCENTRED "Congratulations, Enforcer! You have successfully fought your way through all"
      LOCATE 16, 1: PRINTCENTRED "fourteen of VWBT's virtual speedways and have brought peace and justice to the"
      LOCATE 17, 1: PRINTCENTRED "streets for our law abiding citizens to once again enjoy!"
      s$ = "Final Score = " + LTRIM$(RTRIM$(STR$(score)))
      LOCATE 19, 1: PRINTCENTRED s$
END IF
DO
      COLOR randVal(1, 15), 0
      LOCATE 24, 1: PRINTCENTRED "Press Backspace to Continue"
      a$ = INKEY$
LOOP WHILE a$ <> CHR$(8)
IF ct >= 14 THEN
      currenttrack = 15
      GOTO 9999
END IF
GOTO 1000

200 COLOR 15, 0: CLS
LOCATE 2, 1: PRINTCENTRED "----------------------"
COLOR 12, 0: LOCATE 3, 1: PRINTCENTRED "GAME OVER!"
COLOR 15, 0: LOCATE 4, 1: PRINTCENTRED "----------------------"
COLOR 7, 0: LOCATE 6, 1
s$ = gangname(trackgang(ct)) + " have wasted you!"
PRINTCENTRED s$
s$ = "Final Score = " + LTRIM$(RTRIM$(STR$(score)))
LOCATE 15, 1: PRINTCENTRED s$
IF score >= 20000 THEN GOTO 250
DO
      COLOR randVal(1, 15), 0
      LOCATE 24, 1: PRINTCENTRED "Press Backspace to Continue"
      a$ = INKEY$
LOOP WHILE a$ <> CHR$(8)
GOTO 9999

250 LOCATE 18, 1: COLOR 14, 0
PRINTCENTRED "Spend 20,000 points to try this track again? (y/n)"
DO: a$ = UCASE$(INKEY$): LOOP WHILE a$ <> "Y" AND a$ <> "N"
IF a$ = "Y" THEN
      score = score - 20000
      currenttrack = currenttrack - 1
      GOTO 1000
END IF
GOTO 9999

300 COLOR 15, 0: CLS
IF ct < 14 AND score - prevscore >= 10000 THEN moveon = 1 ELSE moveon = 0
LOCATE 2, 1: PRINTCENTRED "----------------------"
IF moveon = 1 THEN
      COLOR 14, 0: LOCATE 3, 1: PRINTCENTRED "THAT WAS CLOSE!!"
ELSE
      COLOR 12, 0: LOCATE 3, 1: PRINTCENTRED "GAME OVER!"
END IF
COLOR 15, 0: LOCATE 4, 1: PRINTCENTRED "----------------------"
COLOR 7, 0: LOCATE 6, 1
s$ = gangname(trackgang(ct)) + " are still alive after 3 laps!"
PRINTCENTRED s$
IF moveon = 1 THEN
      COLOR 10, 1: LOCATE 8, 1: PRINTCENTRED "Fortunately, you earned enough points to be allowed to advance!"
      s$ = "Current Score = " + LTRIM$(RTRIM$(STR$(score)))
      COLOR 7, 0: LOCATE 15, 1: PRINTCENTRED s$
ELSE
      COLOR 12, 1: LOCATE 8, 1: PRINTCENTRED "Alas, you did not earn enough points to be allowed to advance!"
      s$ = "Final Score = " + LTRIM$(RTRIM$(STR$(score)))
      COLOR 7, 0: LOCATE 15, 1: PRINTCENTRED s$
END IF
IF score >= 20000 THEN GOTO 250
DO
      COLOR randVal(1, 15), 0
      LOCATE 24, 1: PRINTCENTRED "Press Backspace to Continue"
      a$ = INKEY$
LOOP WHILE a$ <> CHR$(8)
IF moveon = 1 THEN GOTO 1000
GOTO 9999

1000 currenttrack = currenttrack + 1
IF guncount(playercar) <= 0 THEN guncount(playercar) = 1
GOTO 3

9999 COLOR 7, 0: CLS
IF currenttrack > 14 THEN
      PRINT "It's time for our Enforcer to take a well deserved rest! Even tough guys need"
      PRINT "their beauty sleep! Tune in next time to MegaRace for more heat pounding,"
      PRINT "adrenaline pumping action!"
ELSEIF playercarlimit >= 8 THEN
      PRINT "Seems our Enforcer needs a bit of break after that last little skirmish. Tune"
      PRINT "in next time to MegaRace where our Enforcer takes it all the way!"
ELSE
      PRINT "Look at that loser crawl to die... I'm sorry people, but that's the end of"
      PRINT "the show. Tune in next time to MegaRace when we'll have a REAL Enforcer we can"
      PRINT "be proud of!"
END IF
PRINT
END

SUB AddMessage (newmsg AS STRING, autooff AS LONG)
messages = messages + 1
turnmsg(messages) = newmsg
IF autooff > 0 THEN autonow = 0
END SUB

SUB ClearTrack
FOR y = 0 TO 4
      FOR x = 0 TO tracksize - 1
            track(x, y) = 0
      NEXT x
NEXT y
END SUB

SUB InitCars
defaultcar(1).carname = "Ouzbel"
defaultcar(1).maxarmour = 10
defaultcar(1).maxguns = 3
defaultcar(1).attack = 3
defaultcar(1).shieldcap = 1
defaultcar(1).missilecap = 1
defaultcar(1).weight = 1

defaultcar(2).carname = "Luis"
defaultcar(2).maxarmour = 15
defaultcar(2).maxguns = 3
defaultcar(2).attack = 2
defaultcar(2).shieldcap = 1
defaultcar(2).missilecap = 0
defaultcar(2).weight = 1

defaultcar(3).carname = "Jose"
defaultcar(3).maxarmour = 20
defaultcar(3).maxguns = 1
defaultcar(3).attack = 1
defaultcar(3).shieldcap = 1
defaultcar(3).missilecap = 1
defaultcar(3).weight = 3

defaultcar(4).carname = "Ramon"
defaultcar(4).maxarmour = 10
defaultcar(4).maxguns = 2
defaultcar(4).attack = 3
defaultcar(4).shieldcap = 1
defaultcar(4).missilecap = 1
defaultcar(4).weight = 2

defaultcar(5).carname = "Maria"
defaultcar(5).maxarmour = 15
defaultcar(5).maxguns = 2
defaultcar(5).attack = 2
defaultcar(5).shieldcap = 1
defaultcar(5).missilecap = 0
defaultcar(5).weight = 4

defaultcar(6).carname = "Hooper"
defaultcar(6).maxarmour = 20
defaultcar(6).maxguns = 2
defaultcar(6).attack = 1
defaultcar(6).shieldcap = 0
defaultcar(6).missilecap = 1
defaultcar(6).weight = 3

defaultcar(7).carname = "Omega"
defaultcar(7).maxarmour = 10
defaultcar(7).maxguns = 3
defaultcar(7).attack = 2
defaultcar(7).shieldcap = 1
defaultcar(7).missilecap = 0
defaultcar(7).weight = 3

defaultcar(8).carname = "Paloma"
defaultcar(8).maxarmour = 20
defaultcar(8).maxguns = 2
defaultcar(8).attack = 3
defaultcar(8).shieldcap = 0
defaultcar(8).missilecap = 0
defaultcar(8).weight = 2
END SUB

SUB PrepTrackGenData
z = 1: trackname(z) = "Uptown Speedway": trackgang(z) = 1
tracksymbolrate(z) = 100
tsr(z, 1) = 10: tsr(z, 2) = 0                      ' Energy Up/Down
tsr(z, 3) = 60: tsr(z, 4) = 60                     ' Speed Up/Down
tsr(z, 5) = 100: tsr(z, 6) = 100                   ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = 0                      ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 0       ' Gun Count 1, 2, 3
tsr(z, 12) = 0: tsr(z, 13) = 0                     ' Acc Down / Shields
tsr(z, 14) = 0: tsr(z, 15) = 0: tsr(z, 16) = 0     ' LaneSw / InfoDis / Spikes

z = 2: trackname(z) = "Atlantis": trackgang(z) = 2
tracksymbolrate(z) = 80
tsr(z, 1) = 20: tsr(z, 2) = 10                     ' Energy Up/Down
tsr(z, 3) = 50: tsr(z, 4) = 50                     ' Speed Up/Down
tsr(z, 5) = 80: tsr(z, 6) = 80                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = 0                      ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 0       ' Gun Count 1, 2, 3
tsr(z, 12) = 0: tsr(z, 13) = 5                     ' Acc Down / Shields
tsr(z, 14) = 100: tsr(z, 15) = 0: tsr(z, 16) = 0   ' LaneSw / InfoDis / Spikes
     
z = 3: trackname(z) = "Industrial Park": trackgang(z) = 3
tracksymbolrate(z) = 65
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 40: tsr(z, 4) = 40                     ' Speed Up/Down
tsr(z, 5) = 80: tsr(z, 6) = 80                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = 0                      ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 0       ' Gun Count 1, 2, 3
tsr(z, 12) = 20: tsr(z, 13) = 5                    ' Acc Down / Shields
tsr(z, 14) = 40: tsr(z, 15) = 0: tsr(z, 16) = 0    ' LaneSw / InfoDis / Spikes

z = 4: trackname(z) = "Belly of the Beast": trackgang(z) = 4
tracksymbolrate(z) = 50
tsr(z, 1) = 40: tsr(z, 2) = 20                     ' Energy Up/Down
tsr(z, 3) = 100: tsr(z, 4) = 100                   ' Speed Up/Down
tsr(z, 5) = 40: tsr(z, 6) = 20                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = 0                      ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 0       ' Gun Count 1, 2, 3
tsr(z, 12) = 40: tsr(z, 13) = 5                    ' Acc Down / Shields
tsr(z, 14) = 0: tsr(z, 15) = 40: tsr(z, 16) = 0    ' LaneSw / InfoDis / Spikes

z = 5: trackname(z) = "Wasteland": trackgang(z) = 5
tracksymbolrate(z) = 40
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 40: tsr(z, 4) = 40                     ' Speed Up/Down
tsr(z, 5) = 20: tsr(z, 6) = 10                     ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = 0                     ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 5       ' Gun Count 1, 2, 3
tsr(z, 12) = 20: tsr(z, 13) = 0                    ' Acc Down / Shields
tsr(z, 14) = 20: tsr(z, 15) = 0: tsr(z, 16) = 0    ' LaneSw / InfoDis / Spikes

z = 6: trackname(z) = "Sunset Boulevard": trackgang(z) = 1
tracksymbolrate(z) = 32
tsr(z, 1) = 30: tsr(z, 2) = 30                     ' Energy Up/Down
tsr(z, 3) = 100: tsr(z, 4) = 60                    ' Speed Up/Down
tsr(z, 5) = 60: tsr(z, 6) = 20                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = 0                      ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 5       ' Gun Count 1, 2, 3
tsr(z, 12) = 0: tsr(z, 13) = 10                    ' Acc Down / Shields
tsr(z, 14) = 0: tsr(z, 15) = 0: tsr(z, 16) = 10    ' LaneSw / InfoDis / Spikes

z = 7: trackname(z) = "Aqualand": trackgang(z) = 2
tracksymbolrate(z) = 26
tsr(z, 1) = 60: tsr(z, 2) = 20                     ' Energy Up/Down
tsr(z, 3) = 50: tsr(z, 4) = 50                     ' Speed Up/Down
tsr(z, 5) = 80: tsr(z, 6) = 60                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = -1                     ' Weapon Cancel / Missiles
tsr(z, 8) = 0: tsr(z, 9) = 0: tsr(z, 10) = 10      ' Gun Count 1, 2, 3
tsr(z, 12) = 30: tsr(z, 13) = 10                   ' Acc Down / Shields
tsr(z, 14) = 100: tsr(z, 15) = 10: tsr(z, 16) = 10 ' LaneSw / InfoDis / Spikes

z = 8: trackname(z) = "The Particle Accelerator": trackgang(z) = 4
tracksymbolrate(z) = 20
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 60: tsr(z, 4) = 10                     ' Speed Up/Down
tsr(z, 5) = 60: tsr(z, 6) = 20                     ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 5: tsr(z, 9) = 5: tsr(z, 10) = 10      ' Gun Count 1, 2, 3
tsr(z, 12) = 10: tsr(z, 13) = 5                    ' Acc Down / Shields
tsr(z, 14) = 10: tsr(z, 15) = 100: tsr(z, 16) = 0  ' LaneSw / InfoDis / Spikes

z = 9: trackname(z) = "The Snake": trackgang(z) = 3
tracksymbolrate(z) = 18
tsr(z, 1) = 60: tsr(z, 2) = 100                    ' Energy Up/Down
tsr(z, 3) = 50: tsr(z, 4) = 50                     ' Speed Up/Down
tsr(z, 5) = 60: tsr(z, 6) = 100                    ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 5: tsr(z, 9) = 5: tsr(z, 10) = 10    ' Gun Count 1, 2, 3
tsr(z, 12) = 100: tsr(z, 13) = 0                   ' Acc Down / Shields
tsr(z, 14) = 10: tsr(z, 15) = 0: tsr(z, 16) = 20   ' LaneSw / InfoDis / Spikes

z = 10: trackname(z) = "Orbital Junkyard": trackgang(z) = 5
tracksymbolrate(z) = 16
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 20: tsr(z, 4) = 40                     ' Speed Up/Down
tsr(z, 5) = 20: tsr(z, 6) = 20                     ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 10: tsr(z, 9) = 10: tsr(z, 10) = 15    ' Gun Count 1, 2, 3
tsr(z, 12) = 40: tsr(z, 13) = 15                   ' Acc Down / Shields
tsr(z, 14) = 20: tsr(z, 15) = 5: tsr(z, 16) = 50   ' LaneSw / InfoDis / Spikes

z = 11: trackname(z) = "Blue Lagoon Funworld": trackgang(z) = 2
tracksymbolrate(z) = 14
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 50: tsr(z, 4) = 50                     ' Speed Up/Down
tsr(z, 5) = 80: tsr(z, 6) = 80                     ' Score Up/Down
tsr(z, 7) = 0: tsr(z, 11) = -1                     ' Weapon Cancel / Missiles
tsr(z, 8) = 5: tsr(z, 9) = 5: tsr(z, 10) = 10      ' Gun Count 1, 2, 3
tsr(z, 12) = 50: tsr(z, 13) = 10                   ' Acc Down / Shields
tsr(z, 14) = 75: tsr(z, 15) = 20: tsr(z, 16) = 20  ' LaneSw / InfoDis / Spikes

z = 12: trackname(z) = "The Big Zero": trackgang(z) = 3
tracksymbolrate(z) = 12
tsr(z, 1) = 60: tsr(z, 2) = 60                     ' Energy Up/Down
tsr(z, 3) = 100: tsr(z, 4) = 100                   ' Speed Up/Down
tsr(z, 5) = 40: tsr(z, 6) = 60                     ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 10: tsr(z, 9) = 10: tsr(z, 10) = 15    ' Gun Count 1, 2, 3
tsr(z, 12) = 60: tsr(z, 13) = 5                    ' Acc Down / Shields
tsr(z, 14) = 40: tsr(z, 15) = 10: tsr(z, 16) = 30  ' LaneSw / InfoDis / Spikes

z = 13: trackname(z) = "Golden Gate Speedway": trackgang(z) = 1
tracksymbolrate(z) = 10
tsr(z, 1) = 40: tsr(z, 2) = 40                     ' Energy Up/Down
tsr(z, 3) = 100: tsr(z, 4) = 20                    ' Speed Up/Down
tsr(z, 5) = 100: tsr(z, 6) = 100                   ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 5: tsr(z, 9) = 5: tsr(z, 10) = 10      ' Gun Count 1, 2, 3
tsr(z, 12) = 20: tsr(z, 13) = 10                   ' Acc Down / Shields
tsr(z, 14) = 20: tsr(z, 15) = 20: tsr(z, 16) = 20  ' LaneSw / InfoDis / Spikes

z = 14: trackname(z) = "Paradise Valley": trackgang(z) = 4
tracksymbolrate(z) = 8
tsr(z, 1) = 100: tsr(z, 2) = 100                   ' Energy Up/Down
tsr(z, 3) = 60: tsr(z, 4) = 60                     ' Speed Up/Down
tsr(z, 5) = 80: tsr(z, 6) = 80                     ' Score Up/Down
tsr(z, 7) = -1: tsr(z, 11) = -1                    ' Weapon Cancel / Missiles
tsr(z, 8) = 10: tsr(z, 9) = 10: tsr(z, 10) = 15    ' Gun Count 1, 2, 3
tsr(z, 12) = 60: tsr(z, 13) = 10                   ' Acc Down / Shields
tsr(z, 14) = 60: tsr(z, 15) = 40: tsr(z, 16) = 40  ' LaneSw / InfoDis / Spikes
END SUB

SUB PRINTCENTRED (s AS STRING)
z = 80 - LEN(s)
LOCATE , z / 2 + 1
PRINT s;
END SUB

SUB PrintGarbage (x AS LONG, y AS LONG, length AS LONG)
LOCATE y, x
FOR z = 1 TO length
      COLOR randVal(0, 15), 1: PRINT CHR$(randVal(33, 254));
NEXT z
END SUB

SUB PRINTRIGHT (s AS STRING)
z = 80 - LEN(s) + 1
LOCATE , z
PRINT s;
END SUB

FUNCTION randVal (min AS LONG, max AS LONG)
randVal = INT(RND * (max - min + 1)) + min
END FUNCTION

SUB RenderTrack (camx AS LONG, ppos AS LONG, plane AS LONG, pcar AS LONG, ecar AS LONG)
x = camx
DO WHILE x < 0: x = x + tracksize: LOOP
DO WHILE x >= tracksize: x = x - tracksize: LOOP
FOR z = 0 TO 12
      FOR y = 0 TO 4
            IF track(x, y) > 0 THEN
                  COLOR symbolcolour(track(x, y))
                  LOCATE y * 3 + 3, z * 6 + 3: PRINT symbol(track(x, y), 0);
                  LOCATE y * 3 + 4, z * 6 + 3: PRINT symbol(track(x, y), 1);
            END IF
      NEXT y
      x = x + 1
      IF x >= tracksize THEN x = x - tracksize
      IF x MOD 10 = 0 THEN
            LOCATE 2, (z * 6) + 4: COLOR 14, 0: PRINT "O";
            LOCATE 17, (z * 6) + 4: COLOR 14, 0: PRINT "O";
      END IF
NEXT z
x = ppos - camx
DO WHILE x < 0: x = x + tracksize: LOOP
DO WHILE x >= tracksize: x = x - tracksize: LOOP
IF x >= 0 AND x < 13 THEN
      COLOR 11, 1
      LOCATE plane * 3 + 3, x * 6 + 2: PRINT carsprite(pcar, 0);
      LOCATE plane * 3 + 4, x * 6 + 2: PRINT carsprite(pcar, 1);
END IF
FOR z = 1 TO 7
      IF enemy(z).ealive > 0 THEN
            x = enemy(z).epos - camx
            DO WHILE x < 0: x = x + tracksize: LOOP
            DO WHILE x >= tracksize: x = x - tracksize: LOOP
            IF x >= 0 AND x < 13 THEN
                  COLOR 14, 4
                  LOCATE enemy(z).elane * 3 + 3, x * 6 + 2: PRINT carsprite(ecar, 0);
                  LOCATE enemy(z).elane * 3 + 4, x * 6 + 2: PRINT carsprite(ecar, 1);
            END IF
      END IF
NEXT z
END SUB

