/*** K E Y B O A R D ***/
#define KBD_INT 0x09

extern volatile unsigned char keybuf[128];
extern volatile char kbd_triggered;

void kbd_init();
void kbd_debounce(); // call once per frame
void kbd_cleanup();
unsigned char kbd_wait();

#define KEY_OFF 0
#define KEY_PRESSED 1
#define KEY_DOWN 2
#define KEY_RELEASED 3
#define KEY_SIGNAL 0x80

#define keyIsDown(k) (keybuf[k] & KEY_SIGNAL)
#define keyWasPressed(k) ((keybuf[k] & 0x0f) == KEY_PRESSED)
#define consumeKey(k) (keybuf[k] = keyWasPressed(k) ? \
  KEY_DOWN | (keybuf[k] & KEY_SIGNAL ) : keybuf[k])
#define keyWasReleased(k) ((keybuf[k] & 0x0f) == KEY_RELEASED)

#define K_ESC   1
#define K_1     2
#define K_2	3
#define K_3	4
#define K_4	5
#define K_5	6
#define K_6	7
#define K_7	8
#define K_8	9
#define K_9	10
#define K_0	11
#define K_MINUS	12
#define K_EQUAL	13
#define K_BKSP	14
#define K_TAB	15
#define K_Q	16
#define K_W	17
#define K_E	18
#define K_R	19
#define K_T	20
#define K_Y	21
#define K_U	22
#define K_I	23
#define K_O	24
#define K_P	25
#define K_LBRK	26
#define K_RBRK	27
#define K_ENTER 28
#define K_CTRL  29
#define K_A	30
#define K_S	31
#define K_D	32
#define K_F	33
#define K_G	34
#define K_H	35
#define K_J	36
#define K_K	37
#define K_L	38
#define K_SEMI	39
#define K_APOS	40
#define K_TILDE	41
#define K_LSHFT 42
#define K_BSLSH 43
#define K_Z	44
#define K_X	45
#define K_C	46
#define K_V	47
#define K_B	48
#define K_N	49
#define K_M	50
#define K_COMMA	51
#define K_DOT	52
#define K_SLASH	53
#define K_RSHFT	54
#define K_PSCRN	55
#define K_ALT	56
#define K_SPACE 57
#define K_CAPS	58
#define K_F1	59
#define K_F2	60
#define K_F3	61
#define K_F4	62
#define K_F5	63
#define K_F6	64
#define K_F7	65
#define K_F8	66
#define K_F9	67
#define K_F10	68
#define K_NUMLK	69
#define K_SCRL	70
#define K_HOME	71
#define K_UP    72
#define K_PGUP	73
#define K_NDASH	74
#define K_LEFT  75
#define K_CENT	76
#define K_RIGHT 77
#define K_NPLUS	78
#define K_END 	79
#define K_DOWN  80
#define K_PGDN	81
#define K_INS	82
#define K_DEL	83
#define K_F11	87
#define K_F12	88

