MODULE SCREENIO

USE DFWINTY,ONLY: &
	FOREGROUND_RED, &		! Add red to foreground color
	FOREGROUND_GREEN, &		! Add green to foreground color
	FOREGROUND_BLUE, &		! Add blue to foreground color
	FOREGROUND_INTENSITY, &		! Add intensity to foreground
	BACKGROUND_RED, &		! Add red to background color
	BACKGROUND_GREEN, &		! Add green to background color
	BACKGROUND_BLUE			! Add blue to background color

! All routines are functions which return .TRUE. if
! successful, .FALSE. if unsuccessful.


INTERFACE
  LOGICAL(4) FUNCTION SCR_SET_BUFFER_MODE (MODE)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_SET_BUFFER_MODE
  !
  ! SCR_SET_BUFFER_MODE (MODE)
  !
  ! Set buffer mode of following operations.  If buffer
  ! mode is .TRUE., operations affect entire buffer (which
  ! may include lines scrolled out of view.)  If mode is
  ! .FALSE., operations affect visible region only.  The
  ! initial mode is .FALSE.
  !
  LOGICAL(4),INTENT(IN) :: MODE  ! Mode for following screen control calls
  END FUNCTION SCR_SET_BUFFER_MODE
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_GET_WIDTH (WIDTH)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_GET_WIDTH
  !
  ! SCR_GET_WIDTH (WIDTH)
  !
  ! Returns the WIDTH in characters of the region or buffer
  !
  INTEGER(4),INTENT(OUT) :: WIDTH  ! Width in characters
  END FUNCTION SCR_GET_WIDTH
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_GET_LENGTH (LENGTH)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_GET_LENGTH
  !
  ! SCR_GET_LENGTH (LENGTH)
  !
  ! Retrieves the LENGTH in characters of the region or buffer
  !
  INTEGER(4),INTENT(OUT) :: LENGTH  ! Length in characters
  END FUNCTION SCR_GET_LENGTH
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_HOME ()
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_HOME
  !
  ! SCR_HOME ()
  !
  ! Sets the current position in the region or buffer to the leftmost
  ! character of the topmost line.
  !
  END FUNCTION SCR_HOME
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_SETPOS (ROW, COLUMN)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_SETPOS
  !
  ! SCR_SETPOS (ROW, COLUMN)
  !
  ! Sets the current position in the region or buffer to the
  ! specified ROW and COLUMN.
  !
  INTEGER(4),INTENT(IN) :: ROW	! Row number
  INTEGER(4),INTENT(IN) :: COLUMN ! Column number
  END FUNCTION SCR_SETPOS
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_GETPOS (ROW, COLUMN)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_GETPOS
  !
  ! SCR_GETPOS (ROW, COLUMN)
  !
  ! Retrieves the current position (ROW, COLUMN) in the region or buffer.
  !
  INTEGER(4),INTENT(OUT) :: ROW	! Row number
  INTEGER(4),INTENT(OUT) :: COLUMN ! Column number
  END FUNCTION SCR_GETPOS
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_CLREOL ()
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_CLREOL
  !
  ! SCR_CLREOL ()
  !
  ! Clears characters from the current position to the end of the current
  ! line.
  !
  END FUNCTION SCR_CLREOL
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_CLREOS ()
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_CLREOS
  !
  ! SCR_CLREOS ()
  !
  ! Clears characters from the current position to last position in the
  ! current region or buffer.
  !
  END FUNCTION SCR_CLREOS
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_CLRALL ()
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_CLRALL
  !
  ! SCR_CLRALL ()
  !
  ! Clears the entire region or buffer.
  !
  END FUNCTION SCR_CLRALL
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_SCROLL (NLINES)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_SCROLL
  !
  ! SCR_SCROLL (NLINES)
  !
  ! Scrolls the current region or buffer the specified number of lines up or
  ! down. If NLINES is positive, the scroll direction is downward (toward the
  ! last line); if negative, the scroll direction is upward (toward the first
  !line).
  !
  INTEGER(4), INTENT(IN) :: NLINES  ! Number of lines to scroll
  END FUNCTION SCR_SCROLL
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_RSCROLL (NCHARS)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_RSCROLL
  !
  ! SCR_RSCROLL (NCHARS)
  !
  ! Scrolls the current region or buffer the specified number of characters
  ! right or left.  If NCHARS is positive, the scroll direction is right;
  ! if negative, the scroll direction is left.
  !
  INTEGER(4), INTENT(IN) :: NCHARS  ! Number of characters to scroll
  END FUNCTION SCR_RSCROLL
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_OUTSTR (STRING)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_OUTSTR
  !
  ! SCR_OUTSTR (STRING)
  !
  ! Outputs the specified STRING to the region or buffer at the current
  ! position.
  !
  CHARACTER(LEN=*), INTENT(IN) :: STRING  ! String to write
  END FUNCTION SCR_OUTSTR
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_OUTATT (STRING, ATTRIBUTES)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_OUTATT
  !
  ! SCR_OUTATT (STRING, ATTRIBUTES)
  !
  ! Outputs the specified STRING to the region or buffer at the current
  ! position with the specified ATTRIBUTES.  ATTRIBUTES is a bitmask
  ! integer which can have one or more of the following values in
  ! combination.
  !
  !	FOREGROUND_RED		! Add red to foreground color
  !	FOREGROUND_GREEN	! Add green to foreground color
  !	FOREGROUND_BLUE		! Add blue to foreground color
  !	FOREGROUND_INTENSITY	! Add intensity to foreground
  !	BACKGROUND_RED		! Add red to background color
  !	BACKGROUND_GREEN	! Add green to background color
  !	BACKGROUND_BLUE		! Add blue to background color
  !
  ! For example, to specify the combination of a green foreground and
  ! a red background, use FOREGROUND_GREEN+BACKGROUND_RED.
  !
  CHARACTER(LEN=*), INTENT(IN) :: STRING  ! String to write
  INTEGER(4), INTENT(IN) :: ATTRIBUTES	  ! Character attributes
  END FUNCTION SCR_OUTATT
END INTERFACE

INTERFACE
  LOGICAL(4) FUNCTION SCR_GETSTR (STRING)
  !DEC$ ATTRIBUTES C,REFERENCE :: SCR_GETSTR
  !
  ! SCR_GETSTR (STRING)
  !
  ! Reads characters from the console input buffer up to the number of
  ! characters determined by the size of the STRING argument.  If fewer
  ! characters are read than will fit in STRING, the result is padded
  ! with blanks.
  !
  CHARACTER(LEN=*), INTENT(OUT) :: STRING  ! String to read
  END FUNCTION SCR_GETSTR
END INTERFACE

END MODULE SCREENIO
