/*
 * @(#)io_md.h	1.14 95/11/16
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

/*
 * Win32 system dependent low level io definitions
 */

#ifndef _WIN32_IO_MD_H_
#define _WIN32_IO_MD_H_

#include <windows.h>
#include <sys/types.h>
#include <ctype.h>
#include <stdlib.h>
#include "dirent.h"

#define R_OK	4
#define W_OK	2
#define X_OK	1
#define F_OK	0

#define	MAXPATHLEN _MAX_PATH

#define S_ISFIFO(mode)	(((mode) & _S_IFIFO) == _S_IFIFO)
#define S_ISCHR(mode)	(((mode) & _S_IFCHR) == _S_IFCHR)
#define S_ISDIR(mode)	(((mode) & _S_IFDIR) == _S_IFDIR)
#define S_ISREG(mode)	(((mode) & _S_IFREG) == _S_IFREG)

#define sysIsAbsolute(s) \
	(*(s) == '/' || *(s) == '\\' || isalpha(*(s)) && *((s)+1) == ':')

int sysOpen(const char *, int, int);
int sysAccess(const char *, int);
int sysStat(const char *, struct stat *);
int sysMkdir(const char *, int);
int sysUnlink(const char *);
int sysAvailable(int fd, long *bytes);
DIR *sysOpenDir(const char *);

#define sysRead(fd, buf, n)	read(fd, buf, n)
#define sysWrite(fd, buf, n)	write(fd, buf, n)
#define sysClose(fd)		close(fd)
#define sysReadDir(dirp)	readdir(dirp)
#define sysCloseDir(dirp)	closedir(dirp)

#endif /* !_WIN32_IO_MD_H_ */
