/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994
                         Auto Example

    FILE:       autoc.c
    
    USAGE:      autoc 

    PURPOSE:    Client side of RPC distributed application
    
    FUNCTIONS:  main() - binds to server and calls remote procedure
    
    COMMENTS:   This distributed application (time stamp) is implemented 
                using an auto handle.  The client side of the application 
                does not care which server provides the time stamp; it 
                merely wants to get the time from any available server.

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "auto.h"    // header file generated by MIDL compiler

#define PURPOSE \
"This Microsoft RPC Version 2.0 sample program demonstrates\n\
the use of the [auto_handle] attribute. For more information\n\
about attributes and RPC API functions, see the RPC programming\n\
guide and reference.\n\n"

void Usage(char * pszProgramName)
{
    fprintf(stderr, "%s", PURPOSE);
    fprintf(stderr, "Usage:  %s\n", pszProgramName);
    exit(1);
}

void _CRTAPI1 main(int argc, char **argv)
{
    time_t t1;
    time_t t2;
    char * pszTime;
    int i;

    /* allow the user to override settings with command line switches */
    for (i = 1; i < argc; i++) {
        if ((*argv[i] == '-') || (*argv[i] == '/')) {
            switch (tolower(*(argv[i]+1))) {
            case 'h':
            case '?':
            default:
                Usage(argv[0]);
            }
        }
        else
            Usage(argv[0]);
    }

    RpcTryExcept {
        GetTime(&t1);  // GetTime is a remote procedure
        GetTime(&t2);

        pszTime = ctime(&t1);
        printf("time 1= %s\n", pszTime);

        pszTime = ctime(&t2);
        printf("time 2= %s\n", pszTime);

        Shutdown();    // Shutdown is a remote procedure
    }
    RpcExcept(1) {
        printf("The RPC runtime library raised an exception.\n");
        printf("Please verify that the server application and \n");
        printf("the locator service have been started.");
    }
    RpcEndExcept

    exit(0);

}  // end main()


/*********************************************************************/
/*                 MIDL allocate and free                            */
/*********************************************************************/

void __RPC_FAR * __RPC_USER midl_user_allocate(size_t len)
{
    return(malloc(len));
}

void __RPC_USER midl_user_free(void __RPC_FAR * ptr)
{
    free(ptr);
}

/* end file autoc.c */
