/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994
                       nhello Example

    FILE:       nhellop.c
    
    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application
    
    FUNCTIONS:  TimeProc() - obtains the time from the server
    
    COMMENTS:

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>   
#include <time.h>
#include "nhello.h"    // header file generated by MIDL compiler

void HelloProc(handle_t hHello, unsigned char *pszString)
{
    printf("%s\n", pszString);
    return;
}

void Shutdown(handle_t hHello)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtIsServerListening\n");
    status = RpcMgmtIsServerListening(NULL);
    printf("RpcMgmtIsServerListening returned: 0x%x\n", status);

    if ( status == RPC_S_OK )
    {
        printf("Calling RpcMgmtStopServerListening\n");
        status = RpcMgmtStopServerListening(NULL);
        printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    }

}

/* end file nhellop.c */

