//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	BasicButton.h++,v 1.1.1.1 1996/08/21 08:27:04 prb Exp
//
#if	!defined(_Cvo_BasicButton_)
#define	_Cvo_BasicButton_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif

class Cvo_BasicButton : public Cvo_Window {
protected:
	int		cnt;		// Count of times depressed
	BOOL		flat:1;		// This is set on a "flat" button
	BOOL		leftjustify:1;	// Should left justify the button
	BOOL		rightjustify:1;	// Should left justify the button

private:
	void _Init();
protected:
	void Bind();
public:
	CONSTRUCDECL(Cvo_BasicButton)

	void Down(XEvent *, int, char **);
	void Up(XEvent *, int, char **);
	void ForceDown();
	void ForceUp(BOOL v = True);
	void ForceRelease()		{ cnt = 0; }
	void LeftJustify()		{ leftjustify = 1; rightjustify = 0; }
	void RightJustify()		{ leftjustify = 0; rightjustify = 1; }
	void Center()			{ leftjustify = 0; rightjustify = 0; }
	virtual void LocalDown(XEvent *, int, char **);
	virtual void LocalUp(XEvent *, int, char **);
        CARD16 CalculateWidth()		{ return(10); }
        CARD16 CalculateHeight()	{ return(10); }

	void Flash();
};

#define	CvoButtonDownEvent	(Cvo_ButtonEventType + InternalEvent0)
#define	CvoButtonUpEvent	(Cvo_ButtonEventType + InternalEvent1)

struct Cvo_ButtonEvent : Cvo_AnyEvent {
	int		button;		// The button pressed
        int             value;          // The new value of the button
	unsigned int	state;		// X State when button pressed/released
};

typedef Cvo_ButtonEvent Cvo_ButtonDownEvent;
typedef Cvo_ButtonEvent Cvo_ButtonUpEvent;
#endif
