//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	BasicObject.h++,v 1.1.1.1 1996/08/21 08:27:08 prb Exp
//
#if	!defined(_Cvo_BasicObject_)
#define	_Cvo_BasicObject_

#include <Cvo/_Includes.h++>

#define	Cvo_MAINWINDOW			((Display *)0)

#define	_CVO_BASIC_OBJECT		0
#define	_CVO_BASIC_WINDOW		(_CVO_BASIC_OBJECT + 1)
#define	_CVO_LAYOUT_WINDOW		(_CVO_BASIC_WINDOW + 1)
#define	_CVO_STANDARD_WINDOW		(_CVO_LAYOUT_WINDOW + 1)

#define Cvo_MAGIC	(('C'<<24)|('v'<<16)|('o'<<8)|'+')

extern FILE *_printoptimize;

class Cvo_OptimizeObjectCreation {
    static size_t       total;
    static int          count;
    static int		maxcnt;
    static size_t       blocks[256];
public:
    Cvo_OptimizeObjectCreation(int);
    void CreateBlocks();
};

class Cvo_BasicObject {
    friend Cvo_LayoutWindow;
    friend Cvo_Window;
    friend Cvo_Object;
    friend Cvo_Registration;
    friend Cvo_OptimizeObjectCreation;
    friend Cvo_DisplayList;
    //
    // STATIC members (one per application)
    //
private:
    static Cvo_BasicObject	*freelist;// List of windows available
protected:
    static int			_serial;// To generate serial numbers
public:
    static Cvo_BasicObject	*base;	// List of windows in use
    static Cvo_DisplayList 	*defdpy;// Default display;
    //
    // STANDARD members (one per instance)
    //
private:
    long		magic;		// Must be set to Cvo_MAGIC
    size_t		size;		// Size of this object

protected:
    long		type;		// Unique to each derived class
private:
    long		serial;		// Unique serial number for this window

    Cvo_BasicObject	*next;		// next window of any type
    Cvo_BasicObject	*prev;		// previous window of any type

    Cvo_DisplayList 	*display;	// Default display;
protected:
    Drawable		window;		// Actual X window ID

    short		width;		// Usable width of window in pixels
    short		height;		// Usable height of window in pixels
    short		depth;		// Depth of this window
    Cvo_AssociatedData  associatedData;

    //
    // Most of these flags are used by higher level objects.  Currently
    // they are all packed together here, though eventually they must
    // be split out
    unsigned		cvo_level:2;	// Level of this window
    BOOL		mapped:1;	// 1 -> mapped, 0 -> not mapped
    BOOL		monochrome:1;	// 1 -> monochrome, 0 -> color
    BOOL		incopy:1;	// 1 -> if in a copyarea request
    BOOL		exposed:1;	// 1 -> after first expose event
    BOOL		configured:1;	// 1 -> after first configuration
    BOOL		flattened:1;	// 1 -> if no chamfer should be drawn
    BOOL		sunken:1;	// 1 -> draw sunken
    BOOL		unsensitive:1;	// 1 -> not sensitive
    BOOL		etched:1;	// 1 -> etch this window
    BOOL		frame:1;	// 1 -> This is a frame, no background
    BOOL		oldconfigured:1;// Used by the Configure routines.
    BOOL		positioned:1;	// 1 -> after initial positioning
    BOOL		dontmap:1;	// 1 -> Dont automap this window
    BOOL		override:1;	// This is an override window
    BOOL		inputonly:1;	// True if an input only window
    BOOL		ispixmap:1;	// True if window -> a pixmap
    BOOL		dokeytext:1;	// need to generate keytext events?
    BOOL		newchildren:1;	// Set when children are added/moved
    BOOL		infocus:1;	// True if this object is in focus
    BOOL		registeredfocus:1;
    BOOL		amlayingout:1;	// True when in layout code
    BOOL		sentmoved:1;	// True after CvoMovedEvent sent
    BOOL		sentresize:1;	// True after CvoResizeEvent sent
    BOOL		printevents:1;	// 1 -> Print events for me
    BOOL		selectnotify:1;	// True after a SelectionNotify event
    BOOL		selectregistered:1;// True if SelectionNotify registered
    BOOL		locksize:1;	// Set if we should lock our size
    BOOL		notranslations:1;
    BOOL		deleted:1;
    BOOL		deleting:1;
    BOOL		dontsink:1;	// True if we should not draw sunken
    BOOL		reverse:1;
    BOOL		hidemoat:1;
    BOOL		haveoutline:1;
    BOOL		drawoutline:1;

    //
    // Constructors/Destructors
    //
private:
    Cvo_BasicObject(Cvo_BasicObject &);			// DO NOT USE!!!
    Cvo_BasicObject &operator =(Cvo_BasicObject &);	// DO NOT USE!!!
public:
    Cvo_BasicObject(Cvo_BasicObject *_parent);
    Cvo_BasicObject(Display *_display);
    virtual ~Cvo_BasicObject();

    BOOL IsValid()
	{ return(magic == Cvo_MAGIC && serial > 0 && serial <= _serial); }
    Cvo_Object *ToObject()	
	{ return(cvo_level >= _CVO_BASIC_WINDOW ? (Cvo_Object *)this : 0); }
    Cvo_Window *ToWindow()	
	{ return(cvo_level >= _CVO_STANDARD_WINDOW ? (Cvo_Window *)this : 0); }
    Cvo_LayoutWindow *ToLayoutWindow()	
	{ return(cvo_level >= _CVO_LAYOUT_WINDOW ? (Cvo_LayoutWindow *)this : 0); }
    Cvo_Pixmap *ToPixmap()	
	{ return(ispixmap ? (Cvo_Pixmap *)this : 0); }

    Cvo_BasicObject *RootObject();

private:
    void _Init();
protected:
    void FinishedCopy()			// Indicate the copyarea is done
	{ incopy = False; }
    int InCopy()			// Check to see if we are in a copyarea
	{ return(incopy); }
public:
    void *operator new(size_t);
    void operator delete(void *);

    long Type()				// Unique to each derived class
	{ return(type); }
    long Serial()			// Unique serial number for this window
	{ return(serial); }
    Cvo_BasicObject *Next()		// next window of any type
	{ return(next); }
    Cvo_BasicObject *Prev()		// previous window of any type
	{ return(prev); }

    Display *Dpy()			// Actual X display
	{ return(display->Dpy()); }
    Cvo_DisplayList *DisplayList()
	{ return(display); }
    BOOL InEventLoop()     { return(display->ineventloop); }

    int	XScreen()			// Screen for this window
	{ return(DefaultScreen(Dpy())); }
    Window Root()			// RootWindow for this window
	{ return(DefaultRootWindow(Dpy())); }

    CARD32 White()
	{ return(reverse ? BlackPixel(Dpy(), XScreen())
			 : WhitePixel(Dpy(), XScreen())); }
    CARD32 Black()
	{ return(reverse ? WhitePixel(Dpy(), XScreen())
			 : BlackPixel(Dpy(), XScreen())); }

    Window Win()			// Actual X window ID
	{ return(ispixmap ? 0 : Window(window)); }
    Drawable Object()			// Actual X window ID
	{ return(window); }
    Pixmap Pix()			// Actual X window ID
	{ return(ispixmap ? Pixmap(window) : 0); }
    short Depth()
	{ return(depth); }

    Colormap Cmap()			// Colormap for this window
	{ return(DefaultColormap(display->Dpy(), XScreen())); }

    short Width()			// Usable width of window in pixels
	{ return(width); }
    short Height()			// Usable height of window in pixels
	{ return(height); }

    void _SetSize(int w, int h)		{ width = w; height = h; }

    void LockSize(BOOL v = True)	{ locksize = v; }

    Cvo_AssociatedData &Data()		{ return(associatedData); }
    Cvo_AssociatedData &DisplayData()	{ return(display->associatedData); }

    BOOL Mapped()			// True if we are mapped
	{ return(mapped); }
    BOOL Configured()			// True if we are configured
	{ return(configured); }
    BOOL Unmapped()			// True if we are not mapped
	{ return(!mapped); }
    BOOL Monochrome()			// True if we are monochrome
	{ return(monochrome); }
    BOOL Color()				// True if we are color
	{ return(!monochrome); }
    BOOL Exposed()			// True if have been exposed
	{ return(exposed); }
    BOOL Sensitive()			// True if visual class is sensitive
	{ return(!unsensitive); }
    BOOL Sunken()			// True if the background is sunken
	{ return(sunken); }
    BOOL DontSink()			// True if the background is sunken
	{ return(dontsink); }
    BOOL Inputonly()			// XXX -- depricate
	{ return(inputonly); }
    BOOL Positioned()
	{ return(positioned); }
    void _PrintMyEvents(BOOL v = True)	{ printevents = v; }
};

#endif
