//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//      Buffer.h++,v 1.2 2000/02/10 22:17:25 prb Exp
//
#if	!defined(_Cvo_Buffer_)
#define	_Cvo_Buffer_

class Cvo_Window;
class Cvo_KeyTextEvent;
#if !defined(_XLIB_H_)
struct XKeyEvent;
#endif

class Cvo_CharacterBuffer {
public:
    Cvo_CharacterBuffer();
    Cvo_CharacterBuffer(const char *);
    Cvo_CharacterBuffer(const char *, int);
    Cvo_CharacterBuffer(const wchar_t *, int = -1);
    ~Cvo_CharacterBuffer();

    Cvo_CharacterBuffer & operator = (const char *);
    Cvo_CharacterBuffer & operator = (const wchar_t *);
    Cvo_CharacterBuffer & operator = (const Cvo_CharacterBuffer &);

    void Set(const char *s, int len = -1);
    void Set(const wchar_t *s, int len = -1);
    void Append(const char *s, int len = -1);
    void Append(const wchar_t *s, int len = -1);
    void Insert(int, const char *s, int len = -1);
    void Insert(int, const wchar_t *s, int len = -1);
    void Truncate(int);
    void Delete(int, int = 1);
    wchar_t *wcValue();
    operator wchar_t *();
    char * mbValue();
    operator char *();
    int wcLength();
    int mbLength();

    void LookupString(Cvo_Window *, XKeyEvent *, Cvo_KeyTextEvent *);
private:
    class Narrow {
    public:
	Narrow();
	~Narrow()				{ delete [] value; }
	void Set(const char *s, int len = -1);
	void Set(const wchar_t *s, int len = -1);
	void Append(const char *s, int len = -1);
	void Append(const wchar_t *s, int len = -1);
	void Insert(int, const char *s, int len = -1);
	void Truncate(int);
	void Delete(int, int = 1);
	operator char *();
	char *Value() const;
	int Length() const;

    private:
	friend class Cvo_CharacterBuffer;
	static char null;
	char	*value;
	int	maxlen;
	int	length;
    };

    class Wide {
    public:
	Wide();
	~Wide()					{ delete [] value; }
	void Set(const char *s, int len = -1);
	void Set(const wchar_t *s, int len = -1);
	void Append(const char *s, int len = -1);
	void Append(const wchar_t *s, int len = -1);
	void Insert(int, const wchar_t *s, int len = -1);
	void Truncate(int);
	void Delete(int, int = 1);
	operator wchar_t *();
	wchar_t *Value() const;
	int Length() const;

    private:
	friend class Cvo_CharacterBuffer;
	static wchar_t null;
	wchar_t	*value;
	int	maxlen;
	int	length;
    };

    Narrow		narrow;
    Wide		wide;
    unsigned		usenarrow:1;
    unsigned		usewide:1;
};
inline
Cvo_CharacterBuffer::Narrow::Narrow()
{
    value = 0;
    maxlen = 0;
    length = 0;
}

inline
Cvo_CharacterBuffer::Narrow::operator char *()
{
    return(length ? value : &null);
}

inline char *
Cvo_CharacterBuffer::Narrow::Value() const
{
    return(length ? value : &null);
}

inline int
Cvo_CharacterBuffer::Narrow::Length() const
{
    return(length);
}

inline void
Cvo_CharacterBuffer::Narrow::Truncate(int nlen)
{
    if (nlen >= 0 && nlen < length)
	value[length = nlen] = 0;
}

inline
Cvo_CharacterBuffer::Wide::Wide()
{
    value = 0;
    maxlen = 0;
    length = 0;
}

inline
Cvo_CharacterBuffer::Wide::operator wchar_t *()
{
    return(length ? value : &null);
}

inline wchar_t *
Cvo_CharacterBuffer::Wide::Value() const
{
    return(length ? value : &null);
}

inline int
Cvo_CharacterBuffer::Wide::Length() const
{
    return(length);
}

inline void
Cvo_CharacterBuffer::Wide::Truncate(int nlen)
{
    if (nlen >= 0 && nlen < length)
	value[length = nlen] = 0;
}

inline void
Cvo_CharacterBuffer::Set(const char *s, int len)
{
    narrow.Set(s, len);
    usenarrow = 1;
    usewide = 0;
}

inline void
Cvo_CharacterBuffer::Set(const wchar_t *s, int len)
{
    wide.Set(s, len);
    usewide = 1;
    usenarrow = 0;
}

inline void
Cvo_CharacterBuffer::Truncate(int nlen)
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    usewide = 1;
    wide.Truncate(nlen);
}

inline void
Cvo_CharacterBuffer::Delete(int col, int len)
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    usewide = 1;
    wide.Delete(col, len);
}

inline void
Cvo_CharacterBuffer::Append(const char *s, int len)
{
    if (usewide) {
        narrow.Set(wide.Value(), wide.Length());
	usewide = 0;
    }
    usenarrow = 1;
    narrow.Append(s, len);
}

inline void
Cvo_CharacterBuffer::Append(const wchar_t *s, int len)
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    usewide = 1;
    wide.Append(s, len);
}

inline void
Cvo_CharacterBuffer::Insert(int col, const char *s, int len)
{
    if (usewide) {
        narrow.Set(wide.Value(), wide.Length());
	usewide = 0;
    }
    usenarrow = 1;
    narrow.Insert(col, s, len);
}

inline void
Cvo_CharacterBuffer::Insert(int col, const wchar_t *s, int len)
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    usewide = 1;
    wide.Insert(col, s, len);
}

inline wchar_t *
Cvo_CharacterBuffer::wcValue()
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    return(wide);
}

inline
Cvo_CharacterBuffer:: operator wchar_t *()
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    return(wide);
}

inline char *
Cvo_CharacterBuffer::mbValue()
{
    if (usewide) {
        narrow.Set(wide.Value(), wide.Length());
	usewide = 0;
    }
    return(narrow);
}

inline
Cvo_CharacterBuffer:: operator char *()
{
    if (usewide) {
        narrow.Set(wide.Value(), wide.Length());
	usewide = 0;
    }
    return(narrow);
}

inline int
Cvo_CharacterBuffer::wcLength()
{
    if (usenarrow) {
        wide.Set(narrow.Value(), narrow.Length());
	usenarrow = 0;
    }
    return(wide.Length());
}

inline int
Cvo_CharacterBuffer::mbLength()
{
    if (usewide) {
        narrow.Set(wide.Value(), wide.Length());
	usewide = 0;
    }
    return(narrow.Length());
}

#endif
