//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	CONSTRUC.h++,v 1.1.1.1 1996/08/21 08:27:05 prb Exp
//
//
// The following macros are used to create the required constructor functions
// for a Cvo.  In general they are used as follows:
//
// class Cvo_NewType : public Cvo_BaseType {
// private:
//	void _Init();
// public:
//	CONSTRUCDECL(Cvo_NewType)
// };
//
// CONSTRUCTORS(Cvo_NewType, Cvo_BaseType, "NewType")
//
// void
// Cvo_NewType::_Init()
// {
//	// Constructor code goes here.
// }
//

#define	CVO_CREATE_REGISTER_FUNCTIONS(nc) \
nc::myregister::myregister(nc *win, \
			   CARD32 _type, \
			   CARD16 _mask, \
			   KeySym _key, \
			   void (nc::*_func)(XEvent *, void *), \
			   void *_data) \
	: Cvo_Registration(win, _type, _mask, _key) \
{ \
    func = _func; \
    data = _data; \
} \
void \
nc::myregister::function() \
{ \
    (((nc *)object)->*func)(event, data); \
}


#define	CVO_DEFINE_REGISTER_FUNCTIONS(nc) \
    class myregister : public Cvo_Registration { \
	typedef void (nc::*_Ev##nc)(XEvent *, void *); \
        _Ev##nc func; \
	void	*data; \
	void	function(); \
    public: \
	myregister(nc *, CARD32, CARD16, KeySym, _Ev##nc, void *); \
    }; \
    typedef void (nc::*_Ev##nc)(XEvent *, void *); \
    Cvo_Registration *Register(CARD32  _e, \
			       CARD16  _m, \
                               _Ev##nc _f, \
			       void *  _d = 0, \
			       KeySym  _k = XK_VoidSymbol) \
    	{ return(new myregister(this, _e, _m, _k, _f, _d)); } \
    Cvo_Registration *Register(CARD32  _e, \
                               _Ev##nc _f, \
			       void *  _d = 0, \
			       KeySym  _k = XK_VoidSymbol) \
    	{ return(new myregister(this, _e, 0, _k, _f, _d)); } \
    Cvo_Registration *RegisterKey(KeySym  _k, \
				  CARD16  _m, \
                                  _Ev##nc _f, \
				  void *  _d = 0) \
    	{ return(new myregister(this, KeyPress, _m, _k, _f, _d)); } \
    Cvo_Registration *RegisterKey(KeySym  _k, \
                                  _Ev##nc _f, \
				  void * _d = 0) \
    	{ return(new myregister(this, KeyPress, 0, _k, _f, _d)); } \
    public: \
    Cvo_Registration *Register(CARD32 _e, \
                               CARD16 _m, \
                               Cvo_ExtEvFunc _f, \
                               void *_d = 0, \
                               KeySym _k = XK_VoidSymbol) \
    	{ return(Cvo_Object::Register(_e, _m, _f, _d, _k)); } \
    Cvo_Registration *Register(CARD32 _e, \
                               Cvo_ExtEvFunc _f, \
                               void *_d = 0, \
                               KeySym _k = XK_VoidSymbol) \
        { return(Cvo_Object::Register(_e, 0, _f, _d, _k)); }  \
    Cvo_Registration *RegisterKey(KeySym _k, \
                                  CARD16 _m, \
                                  Cvo_ExtEvFunc _f, \
                                  void *_d = 0) \
        { return(Cvo_Object::RegisterKey(_k, _m, _f, _d)); }  \
    Cvo_Registration *RegisterKey(KeySym _k, \
                                  Cvo_ExtEvFunc _f, \
                                  void *_d = 0) \
        { return(Cvo_Object::RegisterKey(_k, 0, _f, _d)); } \
    protected:


#define	CONSTRUCTORS(nc, bc, cn) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent) \
		 : bc(_name, _class, _parent) { _Init(); } \
	nc::nc(char *_name, char *_class, Display *_display) \
		 : bc(_name, _class, _display) { _Init(); } \
	nc::nc(char *_name, Cvo_Object *_parent) \
		 : bc(_name, cn, _parent) { _Init(); } \
	nc::nc(char *_name, Display *_display) \
		 : bc(_name, cn, _display) { _Init(); } \
	nc::nc(Cvo_Object *_parent) \
		 : bc(_Cvo_GenerateName(), cn, _parent) { _Init(); } \
	nc::nc(Display *_display) \
		 : bc(_Cvo_GenerateName(), cn, _display) { _Init(); }

#define	CONSTRUCDECL(nc) \
        nc(Cvo_Object *_parent); \
        nc(Display *_display); \
        nc(char *_name, Cvo_Object *_parent); \
        nc(char *_name, Display *_display); \
        nc(char *_name, char *_class, Cvo_Object *_parent); \
        nc(char *_name, char *_class, Display *_display);

#define	CONSTRUCTORS_1ARG(nc, bc, cn, t) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t a) \
		 : bc(_name, _class, _parent) { _Init(a); } \
	nc::nc(char *_name, char *_class, Display *_display, t a) \
		 : bc(_name, _class, _display) { _Init(a); } \
	nc::nc(char *_name, Cvo_Object *_parent, t a) \
		 : bc(_name, cn, _parent) { _Init(a); } \
	nc::nc(char *_name, Display *_display, t a) \
		 : bc(_name, cn, _display) { _Init(a); }

#define	CONSTRUCTORS_1ARG_PASS(nc, bc, cn, t) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t a) \
		 : bc(_name, _class, _parent, a) { _Init(a); } \
	nc::nc(char *_name, char *_class, Display *_display, t a) \
		 : bc(_name, _class, _display, a) { _Init(a); } \
	nc::nc(char *_name, Cvo_Object *_parent, t a) \
		 : bc(_name, cn, _parent, a) { _Init(a); } \
	nc::nc(char *_name, Display *_display, t a) \
		 : bc(_name, cn, _display, a) { _Init(a); }

#define	CONSTRUCDECL_1ARG(nc, arg) \
        nc(char *_name, Cvo_Object *_parent, arg); \
        nc(char *_name, Display *_display, arg); \
        nc(char *_name, char *_class, Cvo_Object *_parent, arg); \
        nc(char *_name, char *_class, Display *_display, arg);

#define	CONSTRUCTORS_2ARG(nc, bc, cn, t1, t2) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, _class, _parent) { _Init(a1, a2); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, _class, _display) { _Init(a1, a2); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, cn, _parent) { _Init(a1, a2); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, cn, _display) { _Init(a1, a2); }

#define	CONSTRUCTORS_2ARG_PASS(nc, bc, cn, t1, t2) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, _class, _parent, a1, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, _class, _display, a1, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, cn, _parent, a1, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, cn, _display, a1, a2) { _Init(a1, a2); }

#define	CONSTRUCTORS_2ARG_PASS1(nc, bc, cn, t1, t2) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, _class, _parent, a1) { _Init(a1, a2); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, _class, _display, a1) { _Init(a1, a2); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, cn, _parent, a1) { _Init(a1, a2); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, cn, _display, a1) { _Init(a1, a2); }

#define	CONSTRUCTORS_2ARG_PASS2(nc, bc, cn, t1, t2) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, _class, _parent, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, _class, _display, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2) \
		 : bc(_name, cn, _parent, a2) { _Init(a1, a2); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2) \
		 : bc(_name, cn, _display, a2) { _Init(a1, a2); }

#define	CONSTRUCDECL_2ARG(nc, a1, a2) \
        nc(char *_name, Cvo_Object *_parent, a1, a2); \
        nc(char *_name, Display *_display, a1, a2); \
        nc(char *_name, char *_class, Cvo_Object *_parent, a1, a2); \
        nc(char *_name, char *_class, Display *_display, a1, a2);

#define	CONSTRUCTORS_3ARG(nc, bc, cn, t1, t2, t3) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3) \
		 : bc(_name, _class, _parent) { _Init(a1, a2, a3); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2, t3 a3) \
		 : bc(_name, _class, _display) { _Init(a1, a2, a3); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3) \
		 : bc(_name, cn, _parent) { _Init(a1, a2, a3); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2, t3 a3) \
		 : bc(_name, cn, _display) { _Init(a1, a2, a3); }

#define	CONSTRUCDECL_3ARG(nc, a1, a2, a3) \
        nc(char *_name, Cvo_Object *_parent, a1, a2, a3); \
        nc(char *_name, Display *_display, a1, a2, a3); \
        nc(char *_name, char *_class, Cvo_Object *_parent, a1, a2, a3); \
        nc(char *_name, char *_class, Display *_display, a1, a2, a3);

#define	CONSTRUCTORS_4ARG(nc, bc, cn, t1, t2, t3, t4) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4) \
		 : bc(_name, _class, _parent) { _Init(a1, a2, a3, a4); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4) \
		 : bc(_name, _class, _display) { _Init(a1, a2, a3, a4); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4) \
		 : bc(_name, cn, _parent) { _Init(a1, a2, a3, a4); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4) \
		 : bc(_name, cn, _display) { _Init(a1, a2, a3, a4); }

#define	CONSTRUCDECL_4ARG(nc, a1, a2, a3, a4) \
        nc(char *_name, Cvo_Object *_parent, a1, a2, a3, a4); \
        nc(char *_name, Display *_display, a1, a2, a3, a4); \
        nc(char *_name, char *_class, Cvo_Object *_parent, a1, a2, a3, a4); \
        nc(char *_name, char *_class, Display *_display, a1, a2, a3, a4);

#define	CONSTRUCTORS_5ARG(nc, bc, cn, t1, t2, t3, t4, t5) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5) \
		 : bc(_name, _class, _parent) { _Init(a1, a2, a3, a4, a5); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5) \
		 : bc(_name, _class, _display) { _Init(a1, a2, a3, a4, a5); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5) \
		 : bc(_name, cn, _parent) { _Init(a1, a2, a3, a4, a5); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5) \
		 : bc(_name, cn, _display) { _Init(a1, a2, a3, a4, a5); }

#define	CONSTRUCDECL_5ARG(nc, a1, a2, a3, a4, a5) \
        nc(char *_name, Cvo_Object *_parent, a1, a2, a3, a4, a5); \
        nc(char *_name, Display *_display, a1, a2, a3, a4, a5); \
        nc(char *_name, char *_class, Cvo_Object *_parent, a1, a2, a3, a4, a5); \
        nc(char *_name, char *_class, Display *_display, a1, a2, a3, a4, a5);

#define	CONSTRUCTORS_6ARG(nc, bc, cn, t1, t2, t3, t4, t5, t6) \
	nc::nc(char *_name, char *_class, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5, t6 a6) \
		 : bc(_name, _class, _parent) { _Init(a1, a2, a3, a4, a5, a6); } \
	nc::nc(char *_name, char *_class, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5, t6 a6) \
		 : bc(_name, _class, _display) { _Init(a1, a2, a3, a4, a5, a6); } \
	nc::nc(char *_name, Cvo_Object *_parent, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5, t6 a6) \
		 : bc(_name, cn, _parent) { _Init(a1, a2, a3, a4, a5, a6); } \
	nc::nc(char *_name, Display *_display, t1 a1, t2 a2, t3 a3, t4 a4, t5 a5, t6 a6) \
		 : bc(_name, cn, _display) { _Init(a1, a2, a3, a4, a5, a6); }

#define	CONSTRUCDECL_6ARG(nc, a1, a2, a3, a4, a5, a6) \
        nc(char *_name, Cvo_Object *_parent, a1, a2, a3, a4, a5, a6); \
        nc(char *_name, Display *_display, a1, a2, a3, a4, a5, a6); \
        nc(char *_name, char *_class, Cvo_Object *_parent, a1, a2, a3, a4, a5, a6); \
        nc(char *_name, char *_class, Display *_display, a1, a2, a3, a4, a5, a6);
