//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	CRT.h++,v 1.1.1.1 1996/08/21 08:27:05 prb Exp
//
#if	!defined(_Cvo_CRT_)
#define	_Cvo_CRT_

#if	!defined(_Cvo_TextLine_)
#include <Cvo/TextLine.h++>
#endif

class Cvo_CRT;

#define	Cvo_HL_MAX_COLUMN	0x7fff

class Cvo_CRT_Highlight : public Cvo_RootedList {
    Cvo_RootedList	**myroot;
    Cvo_CRT		*win;
    Cvo_CharacterBuffer text;
    INT16		start_row;
    INT16		start_col;
    INT16		end_row;
    INT16		end_col;
    Cvo_Color		foreground;
    Cvo_Color		background;
    BOOL		reverse:1;	// ONLY reverse the colors
    BOOL		underline:1;	// underline the data
    BOOL		enbolden:1;	// enbolden the data
    BOOL		unset:1;	// True if highlight is not visible

    Cvo_TextAttribute *_Highlight(Cvo_TextAttribute *);
    Cvo_TextAttribute *Highlight(Cvo_TextAttribute *old)
	{ return(reverse ? old->Reverse() : _Highlight(old)); }
    INT32 ToIndex(INT32 r, INT32 c)	{ return(r >= 0 ? ((r<<16) + c + 0x8000) : -1); }
public:
    Cvo_CRT_Highlight(Cvo_CRT_Highlight **, Cvo_CRT *);
    ~Cvo_CRT_Highlight()		{ Unlink(myroot); }

    Cvo_CRT_Highlight *Next()           { return((Cvo_CRT_Highlight *)next); }
    Cvo_CRT_Highlight *Prev()           { return((Cvo_CRT_Highlight *)prev); }
    Cvo_TextAttribute *Modify(int row, int col, Cvo_TextAttribute *);
    void Redraw();
    void ResetRange(int, int, int, int);
    void ResetRange()			{ ResetRange(0, 0, 0, 0);
					  unset = True; Redraw(); }
    void TurnOff()			{ unset = True; Redraw(); }
    void TurnOn()			{ unset = False; Redraw(); }
    void ExtendRange(int r, int c);
    void SetReverse()			{ reverse = True; }
    void SetUnderline(BOOL x = True)	{ reverse = False; underline = x; }
    void SetEnbolden(BOOL x = True)	{ reverse = False; enbolden = x; }
    void SetForeground(const Cvo_Color &c)	{ reverse = False;
					  foreground = c; }
    void SetBackground(const Cvo_Color &c)	{ reverse = False;
					  background = c; }
    void DeleteAt(int line, int col, int cnt);
    void InsertAt(int line, int col, int cnt);
    void InsertLines(int line, int cnt);
    void DeleteLines(int line, int cnt);
    void GetText();
    Cvo_CharacterBuffer &GetTextBuffer() { return(text); }
    int GetText(char **);
    int GetText(wchar_t **);
    void SelectionRange(int *br,int *bc,int *er,int *ec)	
					{ *br = (int) start_row;
					  *bc = (int) start_col;
					  *er = (int) end_row;
					  *ec = (int) end_col; }
    BOOL Empty()                        { return(start_row == end_row &&
                                                 start_col == end_col); }
};

typedef enum {
    Cvo_CRT_CycleLog = 1,	//
    Cvo_CRT_SetExtraPad,	// pad
    Cvo_CRT_ShowCursor,		//
    Cvo_CRT_FocusInEvent,	//
    Cvo_CRT_FocusOutEvent,	//
    Cvo_CRT_HideCursor,		//
    Cvo_CRT_MoveCursor,		// line, column
    Cvo_CRT_InsertLine,		// line, count
    Cvo_CRT_DeleteLine,		// line, count
    Cvo_CRT_InsertBlanksAt,	// line, column, count
    Cvo_CRT_InsertAt,		// line, column, count, string
    Cvo_CRT_InsertAtAttr,	// line, column, count, attrs, string
    Cvo_CRT_ReplaceAt,		// line, column, count, string
    Cvo_CRT_ReplaceAtAttr,	// line, column, count, attrs, string
    Cvo_CRT_DeleteAt,		// line, column, count
    Cvo_CRT_AppendTo,		// line, count, string
    Cvo_CRT_AppendToAttr,	// line, count, attrs, string
    Cvo_CRT_ChangeOrigin,	// origin
    Cvo_CRT_SetState,		// Cvo_TextAttribute *
    Cvo_CRT_MaxOperand		// MUST BE LAST!!!
} Cvo_CRT_LogTypes;

#define	Cvo_CRT_LOGMAX		1024

typedef int Cvo_CRT_LogType;

class Cvo_CRT : public Cvo_Window {
    friend Cvo_TextLine;
    friend Cvo_CRT_Highlight;

protected:
    Cvo_CharacterBuffer tbuf;
    Cvo_CRT_LogType	datalog[Cvo_CRT_LOGMAX];
    int			logTail;
    int			logHead;

    CARD16            	tabstop;	// Size of a tab
    CARD16            	tabsize;	// Size of a tab
    int             	origin;		// How may pixels to skip
    int	            	extrapad;	// Extra pad between lines
    Cvo_TextLine    	**lines;	// Array of text lines
    int            	maxlines;	// maximum number of lines
    int		    	rows;		// Number of lines displayed
    Cvo_TextAttribute	*currentstate;	// The current attribute for insertion
    Cvo_CRT_Highlight	*highlights;	// List of highlights 
    Cvo_TextAttribute	*highlightattr;	// Attributes used for highlights

    CARD16		cursory;
    CARD16 		cursorx;
    INT16         	anchor_row;     // Where the selection is anchored
    INT16         	anchor_col;

    BOOL                showcursor:1;	// True if cursor is displayed
    BOOL	        fixedwidth:1;	// True if trying to do fixed width
					// cursor positioning.
    BOOL		dontdraw:1;	// True when catching up
    BOOL		scrolled:1;	// True when scroll was needed
    BOOL		jumpscroll:1;	// What it says, jump scroll
    BOOL		needunflat:1;	// True if we need to unflatten lines
    BOOL		wordmode:1;
    BOOL		linemode:1;
    BOOL		charmode:1;

    Cvo_CRT_Highlight *selection;       // The current selection

    void Bind();
    void _Init();
    void InitTabs();
    int FH()				{ return(TextAttribute()->MHeight() + extrapad); }
    INT32 ToIndex(INT32 r, INT32 c)	{ return(r >= 0 ? ((r<<16) + c + 0x8000) : -1); }
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_CRT)
    void ComputeUserSizes(Cvo_FrameSize &, Cvo_FrameSize &);
    void DoResize(XEvent *, void *);
    void DoExpose(XEvent *, void *);
    void DoGraphicsExpose(XEvent *, void *);
    void Exposure(XExposeEvent *);

    void SelectClear(XEvent * = 0, void * = 0);
    void FindCoordinates(XEvent *, int *, int *);

public:
    void SelectStart(XEvent *, int, char **);
    void SelectExtend(XEvent *, int, char **);
    void StartExtend(XEvent *, int, char **);
    void SelectEnd(XEvent *, int, char **);

protected:
    int ComputeRows();
    int ComputeY(int r)			{ return(((r > 0) ? lines[r-1]->NextY()
						        : 0) + extrapad); }
    void RecalculateYs(BOOL = True);
    BOOL SetStateFor(int line)	{ if (line >= 0 && line < rows) {
				    int olh = lines[line]->LineHeight();
				    lines[line]->SetState(currentstate);
				    if (olh != lines[line]->LineHeight())
				      RecalculateYs();
				  }
				  return(line >= 0 && line < rows);
				}
    void FocusInEvent(XEvent *, void *);
    void FocusOutEvent(XEvent *, void *);

    Cvo_CRT_LogType *NeedLog(int);
    Cvo_CRT_LogType *NeedLog(int, char *, int);
    Cvo_CRT_LogType *NeedLog(int, wchar_t *, int);
    Cvo_CRT_LogType *NeedLog(int, char *, Cvo_TextAttribute **, int);
    Cvo_CRT_LogType *NeedLog(int, wchar_t *, Cvo_TextAttribute **, int);
    Cvo_CRT_LogType *ProduceLog(int);
    int LogSize()				{ return(Cvo_CRT_LOGMAX-1); }
    void ClearLog()				{ logTail = logHead = 0; }
    void CopyDoneEvent(XEvent *, void *);
    void AdjustSelection(int &, int &, int &, int &);

public:
    CONSTRUCDECL(Cvo_CRT)
    void _Create();
    void Flush(int r = 0);
    void InsertLine(int line, int cnt = 1);
    void DeleteLine(int line, int cnt = 1);
    void DeleteAt(int line, int col, int cnt = 1);
    void InsertAt(int line, int col, int cnt = 1);
    void InsertAt(int line, int col, wchar_t *str, int cnt = -1);
    void InsertAt(int line, int col, char *str, int cnt = -1);
    void ReplaceAt(int line, int col, wchar_t *str, int cnt = -1);
    void ReplaceAt(int line, int col, char *str, int cnt = -1);
    void AppendTo(int line, char *str, int cnt = -1);
    void AppendTo(int line, wchar_t *str, int cnt = -1);
    void AppendTo(int line, char *str, Cvo_TextAttribute **, int cnt = -1);
    void AppendTo(int line, wchar_t *str, Cvo_TextAttribute **, int cnt = -1);
    virtual void MoveCursor(int line, int col);
    virtual void ShowCursor();
    virtual void HideCursor();
    BOOL OverFlowed(int line);
    void AllocateLines(int nm);
    void ClearWindow();
    void ChangeOrigin(int org);
    void FixedWidth(BOOL v = True)	{ fixedwidth = v; }
    void JumpScroll(BOOL v = True)	{ jumpscroll = v; }
    int Rows()				{ return(rows); }
    int Cols()			{ return(width / TextAttribute()->MWidth()); }
    CARD16 CalculateHeight();
    CARD16 CalculateWidth();
    int TabWidth()			{ return(tabsize); }
    int PixelLengthOf(int i)		{ if (i >= 0 && i < rows)
					    return(lines[i]->PixelLength());
					  else
					    return(0); }
    int PixelHeightOf(int i)		{ if (i >= 0 && i < rows)
					    return(lines[i]->LineHeight());
					  else
					    return(0); }
    int PixelIndex(int i, int c)	{ if (i >= 0 && i < rows)
                                            return(lines[i]->PixelIndex(c));
                                          else 
                                            return(0); }
    void SetExtraPad(int p);
    void RaiseLine(int i)		{ if (i >= 0 && i < rows)
					    lines[i]->MakeRaised(); }
    void FlattenLine(int i)		{ if (i >= 0 && i < rows)
					    lines[i]->MakeFlat(); }
    void DirtyLine(int i)		{ if (i >= 0 && i < rows)
					    lines[i]->MakeDirty(); }
    BOOL WillFit(int i, Cvo_TextAttribute *);
    BOOL WillFit(int i, Cvo_TextAttribute **, int);
    int FindLine(int y);
    int FindColumn(int line, int x);
    void PixelToCharacter(int *y, int *x) { *y = FindLine(*y);
					    *x = FindColumn(*y, *x); }
    Cvo_TextAttribute *SetState(Cvo_TextAttribute *s);
//	{ Cvo_TextAttribute *os = currentstate; currentstate = s; return(os); }
    Cvo_TextAttribute *InHighlight(int, int, Cvo_TextAttribute *);
    Cvo_CRT_Highlight *NewHighlight()
	{ return(new Cvo_CRT_Highlight(&highlights, this)); }
    void ClearSelection() { if (selection) selection->ResetRange(); }
    Cvo_CRT_Highlight	*Selection()	{ return(selection);	}
};

inline void
_memwcpy(wchar_t *d, wchar_t *s, int n)
{
	if (d < s) while (n-- > 0) *d++ = *s++;
	else if (d > s) while (n-- > 0) d[n] = s[n];
}

#define CvoTextChangedSizeEvent          (Cvo_TextEventType + InternalEvent0)

struct Cvo_TextChangedSizeEvent : Cvo_AnyEvent {
	int		rows;		// number of rows visible
	int		width;		// average # of character visible
	int		oldrows;
	int		oldwidth;
};

#endif
