//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Default.h++,v 1.1.1.1 1996/08/21 08:27:06 prb Exp
//
#if	!defined(_Cvo_Default_)
#define	_Cvo_Default_

//
// Used to declare built in XDefaults.  These are overridden by the users
// defaults.
// Usage:
//
//	static Cvo_Default defs[] = {
//	    "*resource: value",
//	    "*resource: value",
//	    ...
//	};
// or
//	static Cvo_Default def = "*resource: value";
//
class Cvo_Default {
	static Cvo_Default	*root;
	char			*res;
	Cvo_Default		*next;
public:
	Cvo_Default(char *);
	Cvo_Default(Cvo_Default const &);
	static void Dump();
	friend void Cvo_Parse(int *, char ***);

};

//
// Used to declare the class name instead of having it be the program name
// with the first character toupper()ed.
//
// Usage:
//
//	static Cvo_ClassName cname = "Classname";
//
class Cvo_ClassName {
	friend void Cvo_Parse(int *, char ***);
	static char *string;
public:
	Cvo_ClassName(char *s)		{ string = s; }
};

//
// Used to declare the resource name instead of having it be the program name
// Note that this is over-ridden by the environment variable RESOURCE_NAME
// This is the default instance name.
//
// Usage:
//
//	static Cvo_ResourceName rname = "Resourcename";
//
class Cvo_ResourceName {
	friend void Cvo_Parse(int *, char ***);
	static char *string;
public:
	Cvo_ResourceName(char *s)	{ string = s; }
};

//
// Used to declare the instance name instead of having it be the resource name
//
// Usage:
//
//	static Cvo_InstanceName rname = "Instancename";
//
class Cvo_InstanceName {
	friend void Cvo_Parse(int *, char ***);
	static char *string;
public:
	Cvo_InstanceName(char *s)	{ string = s; }
};

//
// These are used to add user defined options to the argument parsing.
// The Cvo_OptionTable structure should not be directly used.
//
struct Cvo_OptionTable {
    char		*option;
    char		*resource;
    char		*value;
    char		*help;
    int			type;
    void		*result;
    Cvo_OptionTable	*next;
};

#define Cvo_OPT_NUMERIC         1
#define Cvo_OPT_STRING          2
#define Cvo_OPT_BOOLEAN         3
#define Cvo_OPT_SET		4

#define	Cvo_OPT_USED		0x4000	// OR in to say we have done it

//
// To decal
class Cvo_NumericOption : public Cvo_OptionTable {
public:
    Cvo_NumericOption(char *, char *, char *, INT * = 0);
};

class Cvo_StringOption : public Cvo_OptionTable {
public:
    Cvo_StringOption(char *, char *, char *, char ** = 0);
};

class Cvo_SetOption : public Cvo_OptionTable {
public:
    Cvo_SetOption(char *, char *, char *, char *, char ** = 0);
};

class Cvo_BooleanOption : public Cvo_OptionTable {
public:
    Cvo_BooleanOption(char *, char *, char *, BOOL * = 0, char *def = 0);
};

#endif
