//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	FdSet.h++,v 1.1.1.1 1996/08/21 08:27:06 prb Exp
//
//
// This code was initially contributed by Jim Nowicki 10-92
//
#if	!defined(_Cvo_FdSet_)
#define _Cvo_FdSet_

#if !defined(__MACHINE_H__)
#include <Cvo/_Machine.h++>
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#if defined(__NEED_BSTRING__)
#include <bstring.h>
#endif
#if defined(__NEED_SELECT__)
#include <sys/select.h>
#endif

class EvFdSet {
 public:
    EvFdSet();
    EvFdSet(EvFdSet *set);
    EvFdSet(const EvFdSet &);
    ~EvFdSet();

    inline EvFdSet &operator=(const EvFdSet &);

    operator fd_set *() const;

    void  Set(int fd);
    void  Clr(int fd);
    int   IsSet(int fd) const;
    int   NbrSet() const;

    static int NbrFds();

 private:
    void Zero();
    void Copy(const fd_set *);
    static void InitFdSetSize();
    struct fd_set *fdset;
    static int fd_set_size;
    static int fd_array_size;
};

// Inlined Methods:
inline void
EvFdSet::Copy(const fd_set *f)
{
    memcpy(fdset, f, fd_array_size * sizeof(fd_mask));
}

inline EvFdSet &
EvFdSet::operator=(const EvFdSet &x)
{
    Copy(x.fdset);
    return *this;
}

inline EvFdSet::EvFdSet(EvFdSet *set)           { *this = *set; }
inline EvFdSet::~EvFdSet()                      { delete [] (fd_mask *) fdset; }
inline EvFdSet::operator fd_set *() const       { return fdset; }
inline void EvFdSet::Set(int fd)                { FD_SET(fd, fdset); }
inline void EvFdSet::Clr(int fd)                { FD_CLR(fd, fdset); }
inline int  EvFdSet::IsSet(int fd) const        { return FD_ISSET(fd, fdset); }

inline void
EvFdSet::Zero()
{
    memset(fdset, 0, fd_array_size * sizeof(fd_mask));
}

inline int
EvFdSet::NbrFds()
{
    if (fd_set_size == 0)
	InitFdSetSize();
    return fd_set_size;
}

#endif
