//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	FileProto.h++,v 1.1.1.1 1996/08/21 08:27:07 prb Exp
//
/*****************************************************************************/
/*  FileProto.h - FileList protocol built on top of all known filelist protos*/
/*  Date of origin: August 93 						     */
/*                                                                           */
/*  History:                                                                 */
/*     Author       Date    Comments                                         */
/*     ------       ----    --------                                         */
/*     Paul Algren   8-93   Initial implementation 			     */
/*                                                                           */
/*  Portions of this software may still be in development.  The existence of */
/*  the software still in development is not a commitment of actual release  */
/*  or support by Cray Research, Inc.  If it is released, the final form of  */
/*  the product and the time of official release is at the discretion of     */
/*  Cray Research, Inc.                                                      */
/*                                                                           */
/*****************************************************************************/
#ifndef __FILEPROTO_H_DEFINED__
#  define __FILEPROTO_H_DEFINED__ 1
#include <Cvo/RootedList.h++>
#include <Cvo/Protocols.h++>

class Cvo_FileList_Protocol;

class Cvo_CddDrop_FLP : public Cvo_CddDrop_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

  public:
    Cvo_CddDrop_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_CddDrop_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_IXI_FLP : public Cvo_IXI_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

  public:
    Cvo_IXI_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_IXI_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
};

class Cvo_HostAndFile_FLP : public Cvo_HostAndFile_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

  public:
    Cvo_HostAndFile_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_HostAndFile_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
};

class Cvo_SunMvFiles_FLP : public Cvo_SunMvFiles_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

   public:
    Cvo_SunMvFiles_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_SunMvFiles_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_SunCpFiles_FLP : public Cvo_SunCpFiles_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

   public:
    Cvo_SunCpFiles_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_SunCpFiles_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_SunLdFiles_FLP : public Cvo_SunLdFiles_Protocol {
    Cvo_FileList_Protocol* flp;

  protected:
    virtual void Process(XEvent*);

   public:
    Cvo_SunLdFiles_FLP(Cvo_FileList_Protocol* f, Cvo_Object* obj=0)
	: Cvo_SunLdFiles_Protocol(obj) { flp = f; }
    virtual BOOL Send(Display*, Window to);
}; 

class Cvo_FileItem : public Cvo_RootedList {
    Cvo_FileItem**	root;
    CARD16		x;
    CARD16		y;
    char*		hostname;
    char*		filename;

  public:
    Cvo_FileItem(Cvo_FileItem **, char *filename, char* hostname, int x, int y);
    ~Cvo_FileItem();
    int	X()				{ return(x);			}
    int	Y()				{ return(y);			}
    char* Hostname()			{ return (hostname);            }
    char* Filename()			{ return (filename);            }
    Cvo_FileItem *Next()		{ return((Cvo_FileItem *)next); }
    Cvo_FileItem *Prev()		{ return((Cvo_FileItem *)prev); }
};
    
class Cvo_FileList_Protocol {
    friend Cvo_CddDrop_FLP;
    friend Cvo_IXI_FLP;
    friend Cvo_HostAndFile_FLP;
    friend Cvo_SunLdFiles_FLP;
    friend Cvo_SunCpFiles_FLP;
    friend Cvo_SunMvFiles_FLP;

    Cvo_CddDrop_FLP*		cdd;
    Cvo_IXI_FLP* 		ixi;
    Cvo_HostAndFile_FLP*	haf;
    Cvo_SunMvFiles_FLP*		sunmv;
    Cvo_SunCpFiles_FLP*		suncp;
    Cvo_SunLdFiles_FLP*		sunld;

    Object      obj;

  protected:
    virtual void Process()=0;

  public:
    Cvo_FileList_Protocol(Cvo_Object* obj=0);
    ~Cvo_FileList_Protocol();
    virtual BOOL Send(Display*);

    Cvo_FileItem* files;
    Window	sendor;
    CARD16	x;			// Root coordinates of drop
    CARD16	y;			// Root coordinates of drop
    CARD16	key;
    Time	time;
};

#endif /* __FILEPROTO_H_DEFINED__ */
