//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Font.h++,v 1.1.1.1 1996/08/21 08:27:07 prb Exp
//
#if	!defined(_Cvo_Font_)
#define	_Cvo_Font_

class Cvo_Window;
class Cvo_Pixmap;

#if defined(X11R4) && (XlibSpecificationRelease < 5)
struct XFontSetExtents {
    XRectangle      max_logical_extent;
};
#endif

class _Cvo_Font;
class Cvo_TextAttribute;

class Cvo_Font {
    friend Cvo_Font Cvo_DisplayList::Font();
    friend _Cvo_Font;
    _Cvo_Font  *realfont;
    inline Cvo_Font(_Cvo_Font *rc)    { realfont = rc; }
public:
    Cvo_Font(Cvo_Object *);
    Cvo_Font(Cvo_DisplayList *, char *);
    Cvo_Font(Cvo_BasicObject *, XrmQuark);
    inline Cvo_Font(Cvo_BasicObject *, char *);

    inline Cvo_Font()			{ realfont = 0; }
    inline ~Cvo_Font();
    inline Cvo_Font(const Cvo_Font &);
    inline Cvo_Font &operator=(const Cvo_Font &);

    _Cvo_Font *operator->() const	{ return(realfont); }

    BOOL Empty() const			{ return(realfont ? False : True); }
    BOOL Full() const			{ return(realfont ? True : False); }
    int operator ==(const Cvo_Font &cc) const
					{ return(cc.realfont == realfont); }
    int operator !=(const Cvo_Font &cc) const
					{ return(cc.realfont != realfont); }
};

class _Cvo_Font {
    friend Cvo_TextAttribute;
    friend Cvo_Font;
    friend Cvo_Font Cvo_DisplayList::Font();

    _Cvo_Font		*next;
    _Cvo_Font		*prev;
    char		*name;

    XFontStruct		*font;
#if !defined(X11R4)
    XFontSet		fontset;
#endif
    XFontSetExtents	*extents;
    XFontSetExtents	_extents;	// For X11R4 style fonts
    char		**missing_charsets;
    int			num_missing_charsets;
    char		*default_string;
    Cvo_DisplayList	*display;	// Display this font is opened on
    XRectangle		Mink;		// 'M' space ink rectangle
    XRectangle		Mlogical;	// 'M' space logical rectangle
    int 		refcnt;
private:
    _Cvo_Font(Cvo_DisplayList *, char *_name);
    ~_Cvo_Font();
    _Cvo_Font* Copy()		{ ++refcnt; return(this); }
    void Release()		{ if (--refcnt <= 0) delete this; }
public:

//  int Height()	{ return(font->ascent + font->descent); }
//  int Ascent()	{ return(font->ascent); }
//  int Descent()	{ return(font->descent); }
//  int Width()		{ return(font->max_bounds.rbearing -
//		     font->min_bounds.lbearing); }
#if !defined(X11R4)
    XFontSet Fontset()	{ return(fontset); }
#endif
    int Width()		{ return(extents->max_logical_extent.width); }
    int Height()	{ return(extents->max_logical_extent.height); }
    int Ascent()	{ return(-extents->max_logical_extent.y); }
    int Descent()	{ return(extents->max_logical_extent.height +
				 extents->max_logical_extent.y); }
    int MWidth()	{ return(Mlogical.width); }
//  int MHeight()	{ return(Mlogical.height); }
    int MHeight()	{ return(Height()); }
};
//
// Inlines for Cvo_Font
//
inline
Cvo_Font::Cvo_Font(const Cvo_Font &cc)
{
    if (cc.realfont)
        realfont = cc->Copy();
    else
        realfont = 0;
}

inline Cvo_Font &
Cvo_Font::operator=(const Cvo_Font &cc)
{
    if (realfont != cc.realfont) {
        if (realfont)
            realfont->Release();
        if (cc.realfont)
            realfont = cc->Copy();
        else
            realfont = 0;
    }
    return(*this);
}

inline
Cvo_Font::~Cvo_Font()
{
    if (realfont)
        realfont->Release();
}

inline
Cvo_Font::Cvo_Font(Cvo_BasicObject *win, char *font)
{
    realfont = new _Cvo_Font(win->DisplayList(), font);
}

inline Cvo_Font
Cvo_DisplayList::Font()
{
    return(Cvo_Font(fonts->Copy()));
}

//  friend Cvo_Font *Cvo_LoadFont(Cvo_Object *);
//  friend Cvo_Font *Cvo_LoadFont(Cvo_BasicObject *, char *);
//  friend Cvo_Font *Cvo_LoadFont(Cvo_DisplayList *, char *);
//  friend Cvo_Font *Cvo_LoadFontFromResource(Cvo_BasicObject *, char *);
//  friend Cvo_Font *Cvo_LoadFontFromResource(Cvo_BasicObject *, XrmQuark);
#endif
