//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	HelpDisplay.h++,v 1.1.1.1 1996/08/21 08:27:07 prb Exp
//

#if	!defined(_Cvo_HelpDisplay_)
#define	_Cvo_HelpDisplay_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if	!defined(_Cvo_TextViewPort_)
#include <Cvo/TextViewPort.h++>
#endif
#if	!defined(_Cvo_TextPage_)
#include <Cvo/TextPage.h++>
#endif
#if	!defined(_Cvo_HelpParse_)
#include <Cvo/HelpParse.h++>
#endif
#include <string.h>

	//------------------------------//
	//	HELP_MARK class		//
	//------------------------------//

class	HelpMark {
public:
    char	*tag;
    char 	*filename;
    int		line;
    HelpMark	*prev;
    HelpMark	*next;

    HelpMark(char *t,char *fn,int n);
    ~HelpMark()		{ delete [] filename; delete [] tag; };
};

	//------------------------------//
	//	HELP_DISPLAY class	//
	//------------------------------//

class Cvo_HelpDisplay : public Cvo_TextViewPort {
private:
    HelpUnit		*help;
    char		*RootDir;
    Cvo_TextAttribute	*hitext;
    Cvo_TextAttribute	*lotext;
    Cvo_TextAttribute	*title_text;
    BOOL		use_markup:1;

    void		_Init();
public:
    CONSTRUCDECL(Cvo_HelpDisplay)
    Cvo_TextPage *TextPage()		{ return((Cvo_TextPage *)page); }
    HelpUnit *HelpData()		{ return(help);		}
    void SetHelpData(HelpUnit *hu)	{ help = hu;		}
    void ForceRedisplay();
    int	ReadHelpFile(char*,char*,int);
    void SetRootDir(char *);
    int GotoTag(char *);
    void SetNoMarkup()			{ use_markup = False;	}
    void SetMarkup()			{ use_markup = True;	}
    int	Markup()			{ return(use_markup);	}
    HelpMark *GetMark(char* = NULL);
};

inline void
Cvo_HelpDisplay::SetRootDir(char *dn)
{
    if (dn) {
	RootDir = new char[strlen(dn) +1];
	strcpy(RootDir,dn);
    }
}

#define	CvoHelpTagsEvent	(Cvo_HelpEventType + InternalEvent0)
#define	CvoHelpHistoryEvent	(Cvo_HelpEventType + InternalEvent1)
#define CvoHelpTitleEvent       (Cvo_HelpEventType + InternalEvent2)
#define CvoHelpSelectionEvent   (Cvo_HelpEventType + InternalEvent3)

struct Cvo_HelpDisplayEvent : Cvo_AnyEvent {
    void	*data;
};

struct Cvo_HelpDisplaySelectionEvent : Cvo_AnyEvent {
    int		start_row;
    int		start_column;
    int		end_row;
    int		end_column;
};
#endif
