//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	HelpParse.h++,v 1.1.1.1 1996/08/21 08:27:07 prb Exp
//

#if     !defined(_Cvo_HelpParse_)
#define _Cvo_HelpParse_

#include <string.h>

enum HelpCommandType {
    HelpUnknown,
    HelpComment,
    HelpXref,
    HelpPopup,
    HelpGraphic,
    HelpTag,
    HelpHiddenTag,
    HelpExec,
    HelpIndex,
    HelpTitle,
    HelpBookmark
};

class HelpItem {
private:
    char		*file;
    char		*tag;
    int			location;
    int			length;
    int			line;
    int			column;
    HelpCommandType	type;
    HelpItem		*next;
public:
    HelpItem(char *, HelpCommandType, int, int, int, int, char *);
    ~HelpItem()			{}
    HelpItem *Next()		{ return(next);		}
    void SetNext(HelpItem *nxt)	{ next = nxt;	}
    char *File()		{ return(file);		}
    char *Tag()			{ return(tag);		}
    HelpCommandType Type()	{ return(type);		}
    int	Location()		{ return(location);	}
    int	Length()		{ return(length);	}
    int	Line()			{ return(line);		}
    int	Column()		{ return(column);	}
    int	Match(int pos)		{ return((pos >= location &&
					 pos < location + length) ? 1 : 0); }
};


class HelpUnit {
private:
    char	*buffer;		// buffer with the clear text
    int		length;			// length of the buffer
    int		max_lines;
    HelpItem	*xref_table;
    char	*file_name;
    char	*title;
    HelpItem 	*last_item;
public:
    HelpUnit(char *filename,int = 1);
    ~HelpUnit();
    void AddToTable(char *, HelpCommandType, int, int, int, int, char * = NULL);
    void PrintTable();
    void DeleteRange(int, int);
    int Write(char *);
    char *Title()		{ return(title);	}
    int	Length()		{ return(length);	}
    char *Buffer()		{ return(buffer);	}
    char *FileName()		{ return(file_name);	}
    HelpItem *Xref()		{ return(xref_table);	}
    int	MaxLines()		{ return(max_lines);	}
};

#endif
