//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	InputRing.h++,v 1.2 1997/09/07 06:53:14 prb Exp
//
#if	!defined(_Cvo_InputRing_)
#define	_Cvo_InputRing_

#include <Cvo/Object.h++>

class Cvo_InputRing;
class Cvo_InputRingElement {
    Cvo_InputRing		*root;
    Cvo_Object			*object;
    Cvo_Registration		*tabreg;
    Cvo_Registration		*focusreg;
    Cvo_InputRingElement	*next;
    Cvo_InputRingElement	*prev;
    BOOL			skip:1;
public:
    Cvo_InputRingElement(Cvo_InputRing *, Cvo_Object *);
    ~Cvo_InputRingElement();

    Cvo_InputRingElement *Next() { return(next); }
    Cvo_InputRingElement *Prev() { return(prev); }
    void Tab();
    void BackTab();
    void Skip(BOOL v = True)	{ skip = v; }
    friend void _Cvo_InputRingElementNext(Cvo_Object *, XEvent *, void *);
    friend void _Cvo_InputRingElementIn(Cvo_Object *, XEvent *, void *);
    friend void _Cvo_InputRingElementDestroyed(Cvo_Object *, XEvent *, void *);
};

class Cvo_InputRing {
    friend Cvo_InputRingElement;
    Cvo_InputRingElement	*ring;
    Cvo_InputRingElement	*current;
public:
    Cvo_InputRing()		{ ring = 0; current = 0; }
    ~Cvo_InputRing();

    Cvo_InputRingElement *AddElement(Cvo_Object *obj)
			    { return(new Cvo_InputRingElement(this, obj)); }
    Cvo_InputRingElement *Current()	{ return(current); }
    void MakeCurrentRoot()		{ if (current) ring = current; }
    friend void _Cvo_InputRingElementIn(Cvo_Object *, XEvent *, void *);
};
#endif
