//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	InputViewPort.h++,v 1.2 2000/02/10 22:17:25 prb Exp
//
#if	!defined(_Cvo_InputViewPort_)
#define	_Cvo_InputViewPort_

#include <Cvo/TextViewPort.h++>
#include <Cvo/TextPage.h++>

class Cvo_InputViewPort : public Cvo_TextViewPort {
public:
    CONSTRUCDECL(Cvo_InputViewPort)
    void Clear();
    void Enter(Cvo_CharacterBuffer &);
    void Enter(wchar_t *);
    void Enter(char *);
    void GetText(Cvo_CharacterBuffer *);
    void GetText(char **);
    void GetText(wchar_t **);
    void MoveCursor(int r, int c);

protected:
    void _Init();
    void Bind();

    static int Input(Cvo_Object *, XEvent *ev, void *);

    Cvo_TextPage	tpage;
    int			row;
    int			col;
    int			ssrow;
    int			sscol;
    int			serow;
    int			secol;
    int			orow;
    int			ocol;
    Cvo_CharacterBuffer	tbuf;
    Cvo_TextAttribute	*sel;
    BOOL		charmode:1;
    BOOL		wordmode:1;
    BOOL		linemode:1;

    void AdjustSelection(int &, int &, int &, int &);

public:
    void FocusInEvent(XEvent *, void *);
    void FocusOutEvent(XEvent *, void *);

    void Insert(XEvent *, int, char **);
    void InsertLine(XEvent *, int, char **);
    void Delete(XEvent *, int, char **);
    void Forward(XEvent *, int, char **);
    void Backward(XEvent *, int, char **);
    void Upward(XEvent *, int, char **);
    void Downward(XEvent *, int, char **);
    void Return(XEvent *, int, char **);
    void ClearKey(XEvent *, int, char **);
    void Home(XEvent *, int, char **);
    void DeleteLine(XEvent *, int, char **);
    void KillLine(XEvent *, int, char **);
    void SelectInsert(XEvent *, int, char **);
    void SelectStart(XEvent *, int, char **);
    void SelectExtend(XEvent *, int, char **);
    void StartExtend(XEvent *, int, char **);
    void SelectEnd(XEvent *, int, char **);
    void SelectKill(XEvent *, int, char **);

protected:
    void Preset();
    void Update();
    void SelectClear(XEvent * = 0, void * = 0);
    void DrawSelection();
    void ClearSelection();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_InputViewPort) 
};

inline void
Cvo_InputViewPort::Clear()
{
    ClearKey(0, 0, 0);
}
#endif
