//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	LabelMatrixViewPort.h++,v 1.1.1.1 1996/08/21 08:27:17 prb Exp
//
//
// This code was initially contributed by Paul Algren 11-92
//
#if	!defined(_Cvo_LabelMatrixViewPort_)
#define _Cvo_LabelMatrixViewPort_

#if	!defined(_Cvo_Frame_)
#include <Cvo/Frame.h++>
#endif
#if	!defined(_Cvo_MatrixViewPort_)
#include <Cvo/MatrixViewPort.h++>
#endif

class Cvo_LabelMatrixViewPort : public Cvo_Window {
    int			row_width;
    int			col_height;

    class LabelFrame : public Cvo_Window {
    public:
	LabelFrame(char *, Cvo_Object *);
	BOOL SetMapped(BOOL = True);
    };
    LabelFrame	 	*rlw;
    Cvo_Frame 		*rlf;

    LabelFrame 		*clw;
    Cvo_Frame 		*clf;

    Cvo_MatrixViewPort	*mvp;

    void Pan_Labels();
    void _Init();
public:
    CONSTRUCDECL(Cvo_LabelMatrixViewPort)

    Cvo_Matrix *Matrix()			{ return(mvp->Matrix()); }

    void AddHorizontal();
    void AddVertical();

    void AddLabel(Cvo_Window *, Cvo_MatrixSlice *);

    Cvo_Frame *RowFrame()			{ return(rlf); }
    Cvo_Frame *ColFrame()			{ return(clf); }

    Cvo_MatrixViewPort *MatrixViewPort()	{ return(mvp);}

    int Col_Height() const			{ return(col_height); }
    int Row_Width() const			{ return(row_width); }

    void StandardLayoutChildren(int force, int olay);
    int StandardComputeLayoutSize(int force);

    friend void Cvo_LMVP_LabelMoveHandler(Cvo_Object *, XEvent *, void *);
};

#endif
