//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Layout.h++,v 1.1.1.1 1996/08/21 08:27:17 prb Exp
//
#if	!defined(_Cvo_Layout_)
#define	_Cvo_Layout_

//
// A Frame layout consists of two levels.  The first level, the frame,
// is not an actual window, but simply something to determine how much space
// to provide the actual window.  The window may or may not use all of the
// space, depending on the value of fill.  If fill is set, the window and
// the frame take up the same space, otherwise the window will sit in the
// frame according to the value of location.
//
// The second level is the actual window.  As discussed above, the window can
// either be placed at some point within the frame, or it can fill the frame.
//
// Frames are organized either in a horizontal or vertical fashion, depending
// on the value of the vertical flag in the PARENTS frame.  I.e. the value
// of vertical in a FrameLayout explains which direction to layout the children
// frames within this frame.  The opposite flag simply says that this frame
// is going from the right or the bottom, depending on the value of the parents
// veritcal flag.
//
// The two size structures, minimum and maximum, determine how big or how
// small the frame can become.  A maximum of 0 indicates no maximum size.
//

struct Cvo_FrameSize {
    CARD16        width;
    CARD16        height;
};

#define	Cvo_CENTER	0x00
#define	Cvo_NORTH	0x01
#define	Cvo_SOUTH	0x02
#define	Cvo_EAST	0x04
#define	Cvo_WEST	0x08
#define	Cvo_NORTHEAST	(Cvo_NORTH|Cvo_EAST)
#define	Cvo_NORTHWEST	(Cvo_NORTH|Cvo_WEST)
#define	Cvo_SOUTHEAST	(Cvo_SOUTH|Cvo_EAST)
#define	Cvo_SOUTHWEST	(Cvo_SOUTH|Cvo_WEST)
#define	Cvo_HORIZONTAL	0x10
#define	Cvo_VERTICAL	0x20

#define	Cvo_FORCE_MINIMUM_WIDTH		0x40
#define	Cvo_FORCE_MINIMUM_HEIGHT	0x80
#define	Cvo_FORCE_MINIMUM (Cvo_FORCE_MINIMUM_WIDTH|Cvo_FORCE_MINIMUM_HEIGHT)

#define	Cvo_LEFT_JUSTIFY	0x100
#define	Cvo_RIGHT_JUSTIFY	0x200

#define	Cvo_FORCE_DESIRED_WIDTH		0x400
#define	Cvo_FORCE_DESIRED_HEIGHT	0x800
#define	Cvo_FORCE_DESIRED (Cvo_FORCE_DESIRED_WIDTH|Cvo_FORCE_DESIRED_HEIGHT)

#define	Cvo_NOVERLAYS		4	// Allow up to 4 overlays

class Cvo_LayoutWindow;

struct Cvo_FrameLayout {
    unsigned		gravity:4;	// where window is in frame
    BOOL                opposite:1;	// Load from bottom/right side
    BOOL                fillh:1;	// window fills the "frame"
    BOOL                fillw:1;	// window fills the "frame"
    BOOL                vertical:1;	// line up children vertically
    BOOL                ignoreshadow:1;	// Dont leave space between for shadows
    BOOL		dontresize:1;	// Dont resize this window
    BOOL		dontposition:1;	// Dont move this window

    BOOL		usecharpos:1;	// Use the funny syntax
    BOOL		xnegative:1;	// X is from right
    BOOL		ynegative:1;	// Y is from bottom

    CARD32              expand;		// Expand to fill avail space
    CARD8		overlay;	// Overlay index
    CARD16              verticalPad;	// Pixels to pad in vertical
    CARD16              horizontalPad;	// Pixels to pad in horizontal
    CARD16              internalPad;	// Pixels to pad between elements
    CARD16		haspect;	// horizontal part of aspect ratio
    CARD16		vaspect;	// vertical part of aspect ratio
    INT16		x;		// X location to move to
    INT16		y;		// Y location to move to
    INT16		xchars;		// X location in characters to move to
    INT16		ychars;		// Y location in characters to move to
    Cvo_FrameSize       minimum;	// Minimum amount of space
    Cvo_FrameSize       desired;	// Desired amount of space
    Cvo_FrameSize       maximum;	// Maximum amount of space
    Cvo_LayoutWindow	*matchWidth;	// Window to match width with
    Cvo_LayoutWindow	*matchHeight;	// Window to match height with
    Cvo_LayoutWindow	*matchX;	// Window to match X with
    Cvo_LayoutWindow	*matchY;	// Window to match Y with
};
#endif
