//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	LayoutWindow.h++,v 1.1.1.1 1996/08/21 08:27:11 prb Exp
//
#if	!defined(_Cvo_LayoutWindow_)
#define	_Cvo_LayoutWindow_

#if	!defined(_Cvo_Object_)
#include <Cvo/Object.h++>
#endif
#if	!defined(_Cvo_Layout_)
#include <Cvo/Layout.h++>
#endif
#if	!defined(_Cvo_Cursor_)
#include <Cvo/Cursor.h++>
#endif

#define	CvoL_FOREWARD	0x0001		// Layout children too
#define	CvoL_BACKWARD	0x0002		// child change -> parent change

class Cvo_Location {
public:
    short	xchars;			// X position in characters
    short	xpixel;			// + X position in pixels
    short	ychars;			// Y position in characters
    short	ypixel;			// + Y position in pixels
    BOOL	xnegative:1;		// X is from right
    BOOL	ynegative:1;		// Y is from bottom
    BOOL	xcenter:1;		// X is from parents center
    BOOL	ycenter:1;		// Y is from parents center
    BOOL	xmycenter:1;		// X is realative to my center
    BOOL	ymycenter:1;		// Y is realative to my center
};

struct Cvo_Size {
    short	wchars;			// Width in characters
    short	wpixel;			// + Width in pixels
    short	hchars;			// Height in characters
    short	hpixel;			// + Height in pixels
};

class Cvo_LayoutWindow : public Cvo_Object {
    friend Cvo_Window;
    friend Cvo_Object;
protected:
    Cvo_Cursor		cursor;		// The cursor for this window

    Cvo_Size		minSize;	// Minimum size allowable
    Cvo_Size		defSize;	// The default size
    Cvo_Size		maxSize;	// The maximum size allowable

    Cvo_FrameLayout	layout;		// Layout of this window.

    short		horizontalPad;	// # of pixels padded horizontally
    short		verticalPad;	// # of pixels padded vertically
    short               raise;          // # of pixels shadow is below window

    Cvo_Object		*transient;	// parent window if transient

    //
    // Constructors/Destructors
    //
public:
    CONSTRUCDECL(Cvo_LayoutWindow)
    ~Cvo_LayoutWindow();
    //
    // Virtual Functions
    //
protected:
    void ComputeLocation();

public:
    virtual void _Create() = 0;		// Call the actual X creation functions
    void Create();			// Call the actual X creation functions

    //
    // The LayoutFunction is called to place a window within the area
    // allocated for it.  Note that the window need not use all the area
    // allocated for it if it does not want to.
    // It returns !0 if this window shoud be layed out, 0 if it should not be.
    // Calling this with force == -1 only gives a return value, it does not
    // actually lay the window out.
    //
    // StandardLayoutFunction() should be overridden for any special
    // requirements a class might have.  Normally this is the function which
    // is installed.
    //
    // TopLevelLayoutFunction() is installed when the Object is a Top Level
    // object.
    //
    // PopupLayoutFunction() is nearly the same as TopLevelLayoutFunction(),
    // but it tries to keep the window on the viewable part of the screen.
    //
    // NullLayoutFunction() is installed when the window is not supposed to
    // be layed out, that is, it will lay itself out due to some other event.
    //
    // A class defiend layout function can also be installed, but it must be
    // designed to work even when it is a Top Level object.
    //

    int (Cvo_LayoutWindow::*_LayoutFunction)(int, int, int, int);
    virtual int StandardLayoutFunction(int, int, int, int);
    int TopLevelLayoutFunction(int, int, int, int);
    int PopupLayoutFunction(int, int, int, int);
    int NullLayoutFunction(int, int, int, int);

    int CheckLayout()
	{ return((this->*_LayoutFunction)(-1, 0, 0, 0)); }
    int LayoutForeward()
	{ return(CheckLayout() & CvoL_FOREWARD); }
    int LayoutBackward()
	{ return(CheckLayout() & CvoL_BACKWARD); }
    int ReLayout(int r = 0)
	{ return((this->*_LayoutFunction)(r, 0, XWidth(), XHeight())); }
    int NewLayout(int r = 0)
	{ return((this->*_LayoutFunction)(r, 0, 0, 0)); }
    int LayoutFunction(int force, int chld, int w, int h)
	{ return((this->*_LayoutFunction)(force, chld, w, h)); }

    //
    // The LayoutChildren() function is called to lay out all the children
    // in a given overlay.
    //
    // StandardLayoutChildren() can be overridden to provide a new layout
    // policy.
    //
    // NullLayoutChildren() can be installed to cause none of the children
    // to be layed out.
    //
    void (Cvo_LayoutWindow::*_LayoutChildren)(int force, int olay);
    virtual void StandardLayoutChildren(int, int);
    void NullLayoutChildren(int, int);

    void LayoutChildren(int force, int olay)
	{ (this->*_LayoutChildren)(force,olay); }

    //
    // ComputeLayoutSize() is called to compute the possible sizes of the
    // current object.  It is recursive in nature.
    // It returns 0 when this window should not be included in calculations
    // and !0 otherwise.
    //
    // StandardComputeLayoutSize() is the standard mechanism.  If 
    // StandardLayoutChildren() is overridden, this function probably needs
    // to be overridden as well.
    //
    // SelfComputeLayoutSize() can be installed to break recursion, but the
    // space required for the window itself (not including children) will
    // still be calculated.
    //
    // NullComputeLayoutSize() breaks recursion and sets all the requirements
    // for window size to it's current size.
    //
    int (Cvo_LayoutWindow::*_ComputeLayoutSize)(int = 0);
    virtual int StandardComputeLayoutSize(int);
    int SelfComputeLayoutSize(int);
    int NullComputeLayoutSize(int);

    int ComputeLayoutSize(int force)
	{ return((this->*_ComputeLayoutSize)(force)); }

    //
    // ComputeUserSizes() computes the default size of a window according
    // to the values passed in to the SetMinSize, SetDefSize, etc functions.
    //
    virtual void ComputeUserSizes(Cvo_FrameSize &, Cvo_FrameSize &);

    //
    // These functions are used to caculate layout
    //
    virtual CARD16 CalculateWidth();	// Return minimum width required
    virtual CARD16 CalculateHeight();	// Return minimum height required

    //
    // Member Functions
    //
private:
    void _Init();

public:

    Window PWin()			// X window ID of parent (if any)
	{ return(parent ? 0 : pwindow); }
    Cvo_Cursor GetCursor()		// The cursor for this window
	{ return(cursor); }

    short HorizontalPad()		// # of pixels padded horizontally
	{ return(horizontalPad); }
    short VerticalPad()			// # of pixels padded vertically
	{ return(verticalPad); }
    short Raise()                       // # of pixels shadow is below window
        { return(raise); }

    void SetDefSize(int w, int h)
	{ defSize.wchars = w; defSize.hchars = h; }
    void SetDefPixelSize(int w, int h)
	{ defSize.wpixel = w; defSize.hpixel = h; }
    void SetMinSize(int w, int h)
	{ minSize.wchars = w; minSize.hchars = h; }
    void SetMinPixelSize(int w, int h)
	{ minSize.wpixel = w; minSize.hpixel = h; }
    void SetMaxSize(int w, int h)
	{ maxSize.wchars = w; maxSize.hchars = h; }
    void SetMaxPixelSize(int w, int h)
	{ maxSize.wpixel = w; maxSize.hpixel = h; }

    void VerticalChildren()		// Children layout vertically
	{ layout.vertical = 1; }
    void HorizontalChildren()		// Children layout horizontally
	{ layout.vertical = 0; }
    void ExpandFrame(CARD32 e = 1000)	// frame should expand to avail space
	{ layout.expand = e; }
    void FillFrame(BOOL v = True)	// window should fill the frame
	{ layout.fillw = layout.fillh = v; }
    void FillFrameVertically(BOOL v = True)	// window should fill the frame
	{ layout.fillh = v; }
    void FillFrameHorizontally(BOOL v = True)	// window should fill the frame
	{ layout.fillw = v; }
    Cvo_FrameLayout *Layout()
	{ return(&layout); }

    void DoLayout();
    void DontLayout();			// this window should not be managed

    void DoLayoutChildren();
    void DontLayoutChildren();		// children should not be managed

    void DoComputeSize();
    void DontComputeMySize();
    void DontComputeChildrenSize();

    void DontPosition(BOOL v = True)	// this window should not be moved
	{ layout.dontposition = v; }
    void DontResize(BOOL v = True)	// this window should be resized
	{ layout.dontresize = v; }
    void MakeOverlay(unsigned olay = 1)	// This window is an overlay
	{ layout.overlay = olay; }

    void MatchWidth(Cvo_LayoutWindow *w)	// Match width to w
	{ layout.fillw = 0; layout.matchWidth = w; }
    void MatchHeight(Cvo_LayoutWindow *w)	// Match height to w
	{ layout.fillh = 0; layout.matchHeight = w; }

    void MatchX(Cvo_LayoutWindow *w)	// Match x to w
	{ layout.matchX = w; }
    void MatchY(Cvo_LayoutWindow *w)	// Match y to w
	{ layout.matchY = w; }

    void AspectRatio(int h, int v)	// Set aspect ration of window
	{ layout.haspect = h; layout.vaspect = v; }
    void FrameVerticalPad(CARD16 i)	// vertical pad in frame
	{ if (parent) layout.verticalPad = i; }
    void FrameHorizontalPad(CARD16 i)	// horizontal pad in frame
	{ if (parent) layout.horizontalPad = i; }
    void FrameInternalPad(CARD16 i)	// horizontal pad in frame
	{ layout.internalPad = i; }
    void SetGravity(unsigned i)	// Set location for window within frame
	{ layout.gravity = i; }
    void LayOpposite(BOOL v = True)	// lay this window on the opposite side
	{ layout.opposite = v; }
    BOOL GetLayOpposite()
	{ return(layout.opposite); }
    void DontMap(BOOL v = True)
	{ dontmap = v; }
    void MakeTransient(Cvo_Object *o)	// Make this window a transient
	{ transient = o; }
    void MakePopup()			// Make this window a popup
	{ if (_LayoutFunction == &Cvo_LayoutWindow::TopLevelLayoutFunction)
	    _LayoutFunction = &Cvo_LayoutWindow::PopupLayoutFunction;
	  override = 1; }

    int XWidth()			// Width of window for X Lib
	{ return(width + 2 * horizontalPad); }
    int XHeight()			// Height of window for X Lib
	{ return(height + 2 * verticalPad); }
    int FullWidth()
	{ return(XWidth() + 2 * borderWidth); }
    int FullHeight()
	{ return(XHeight() + 2 * borderWidth); }
    int InternalPad()
	{ return(layout.internalPad); }

    void XOrigin(int *x, int *y)	// Origin of window for X Lib
	{ *x = position.x - horizontalPad; *y = position.y - verticalPad; }
    void XOrigin(short *x, short *y)	// Origin of window for X Lib
	{ *x = position.x - horizontalPad; *y = position.y - verticalPad; }

    void GetXOrigin(int *x, int *y);	// Origin of window from XGetGeometry
    void GetXOrigin(short *x, short *y);// Origin of window from XGetGeometry

    void ToXCoord(int *x, int *y)
	{ *x += horizontalPad; *y += verticalPad; }
    void ToXCoord(short *x, short *y)
	{ *x += horizontalPad; *y += verticalPad; }
    void FromXCoord(int *x, int *y)
	{ *x -= horizontalPad; *y -= verticalPad; }
    void FromXCoord(short *x, short *y)
	{ *x -= horizontalPad; *y -= verticalPad; }

    void ToXExtCoord(int *x, int *y);
    void FromXExtCoord(int *x, int *y);
#if !defined(cray) || defined(X11R4)
    void ToXExtCoord(INT16 *x, INT16 *y);
    void FromXExtCoord(INT16 *x, INT16 *y);
#endif

    void SetCursor(unsigned curs);	// Set the cursor
    void SetCursor(char *curs);
    void SetCursor(const Cvo_Cursor &c);
	
    Cvo_Object *DiscoverWindow(int x, int y, int upokay = 1);

    //
    // Below are helper functions to standard X Lib calls.  They will
    // do coordinate translation for you.
    //
    void SetWindowBorderWidth(unsigned int w)
	{ borderWidth = w; XSetWindowBorderWidth(Dpy(), Win(), w); }

    void MoveResizeWindow(int x, int y, int w, int h, int tag = 0);
    void ResizeWindow(int w, int h, int tag = 0);
    void MoveWindow(int x, int y, int tag = 0);
    virtual void MoveWindow(int xc, int yc, int x, int y, int flags = 0, int tag = 0);

    //
    // These are used to force moving and resizing of windows that
    // claim they can't be.
    //
    void ForceMoveForceResizeWindow(int x, int y, int w, int h, int tag = 0);
    void ForceMoveResizeWindow(int x, int y, int w, int h, int tag = 0);
    void MoveForceResizeWindow(int x, int y, int w, int h, int tag = 0);
    void ForceResizeWindow(int w, int h, int tag = 0);
    void ForceMoveWindow(int x, int y, int tag = 0);
    void ForceMoveWindow(int xc, int yc, int x, int y, int flags = 0, int tag = 0);
};
#endif
