//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Matrix.h++,v 1.1.1.1 1996/08/21 08:27:17 prb Exp
//
//
// This code was initially contributed by Paul Algren 11-92
//
#if	!defined(_Cvo_Matrix_)
#define _Cvo_Matrix_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif

//
// Cvo_Matrix Cell - Common cell information
//

class Cvo_MatrixSlice;
class Cvo_Matrix;

class Cvo_MatrixCell {
    Cvo_MatrixCell	*east;
    Cvo_MatrixCell	*west;
    Cvo_MatrixCell	*north;
    Cvo_MatrixCell	*south;

    Cvo_MatrixSlice	*row;
    Cvo_MatrixSlice	*col;

    Cvo_Object		*theObject;
    void 		*client_data;

    BOOL		label:1;
public:
    Cvo_MatrixCell(Cvo_Object *, Cvo_MatrixSlice *, Cvo_MatrixSlice *);
    ~Cvo_MatrixCell();

    Cvo_MatrixCell *East() const		{ return(east); }
    Cvo_MatrixCell *West() const		{ return(west); }
    Cvo_MatrixCell *North() const		{ return(north); }
    Cvo_MatrixCell *South() const		{ return(south); }

    Cvo_MatrixSlice *Row() const		{ return(row); }
    Cvo_MatrixSlice *Col() const		{ return(col); }

    Cvo_Object *CellObj() const			{ return(theObject); }

    int Org_x() const;
    int Org_y() const;

    int Ext_x() const;
    int Ext_y() const;

    void  *Client_data()			{ return (client_data); }
    void   SetClient_data(void *data)		{ client_data = data; }
};

class Cvo_MatrixSlice {
    friend Cvo_Matrix;
    friend Cvo_MatrixCell;
    Cvo_MatrixSlice*	prev;
    Cvo_MatrixSlice*	next;

    Cvo_MatrixCell	*cells;

    Cvo_Matrix		*matrix;

    Cvo_Window		*label;

    int			min;		// Min width or height
    int			des;
    int			max;

    int			origin;		// X or Y coordinate

    int			index;		// Subscript for this row/colum

    int			expand;

    BOOL		horizontal:1;

    BOOL Horizontal()			{ return(horizontal); }
    BOOL Vertical()			{ return(horizontal ? False : True); }
public:
    Cvo_MatrixSlice(Cvo_Matrix *, BOOL, int index);
    ~Cvo_MatrixSlice();

    Cvo_MatrixSlice *Prev() const	{ return(prev); }
    Cvo_MatrixSlice *Next() const	{ return(next); }

    Cvo_MatrixCell *Cells() const	{ return(cells); }

    Cvo_Matrix *Matrix() const		{ return(matrix); }

    Cvo_Window *Label() 		{ return label; }
    void SetLabel(Cvo_Window *b)	{ delete label; label = b; }

    int Org()				{ return(origin); }

    int Min() const			{ return(min); }
    int Des() const			{ return(des); }
    int Max() const			{ return(max); }

    int Index() const			{ return(index); }
};

class Cvo_Matrix : public Cvo_Window {
    friend Cvo_MatrixSlice;
    Cvo_MatrixSlice	*rows;
    Cvo_MatrixSlice	*cols;

    short		horz_sep;
    short		vert_sep;

    CARD16		deswidth;
    CARD16		desheight;

    Cvo_MatrixSlice *Search(Cvo_MatrixSlice *, int) const;
    void LayoutSlice(Cvo_MatrixSlice *, int base, int min, int des, int pad);
    void _Init();
public:
    CONSTRUCDECL(Cvo_Matrix)
    ~Cvo_Matrix();

    Cvo_MatrixSlice *Row(int = -1) const;
    Cvo_MatrixSlice *Col(int = -1) const;

    Cvo_MatrixSlice *AddRow(int);
    Cvo_MatrixSlice *AddCol(int);

    Cvo_MatrixCell *AddCell(Cvo_Object *, int x, int y);
    Cvo_MatrixCell *AddCell(Cvo_Object *, Cvo_MatrixSlice *, Cvo_MatrixSlice *);

    Cvo_MatrixCell *GetCell(Cvo_MatrixSlice *, Cvo_MatrixSlice *);

    void Set_horz_sep(int s)			{ if (s >= 0) horz_sep = s; }
    void Set_vert_sep(int s)			{ if (s >= 0) vert_sep = s; }

    int Horz_sep() const			{ return(horz_sep); }
    int Vert_sep() const			{ return(vert_sep); }

    void StandardLayoutChildren(int force, int olay);
    int StandardComputeLayoutSize(int force);
};

inline int
Cvo_MatrixCell::Org_x() const
{
    return(col->Org());
}

inline int
Cvo_MatrixCell::Org_y() const
{
    return(row->Org());
}

inline int
Cvo_MatrixCell::Ext_x() const
{
    return(col->Des());
}

inline int
Cvo_MatrixCell::Ext_y() const
{
    return(row->Des());
}
#endif
