//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	MenuLabel.h++,v 1.1.1.1 1996/08/21 08:27:09 prb Exp
//
#if	!defined(_Cvo_MenuLabel_)
#define	_Cvo_MenuLabel_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if	!defined(_Cvo_InputOnly_)
#include <Cvo/InputOnly.h++>
#endif

class Cvo_MenuLabel : public Cvo_Window {
    wchar_t		*part1;		// Stuff before the _
    wchar_t		*part2;		// Text with an _
    wchar_t		*part3;		// Stuff after the _
    wchar_t		*part4;		// Accelerator stuff on right side
    Cvo_TextAttribute	*uattr;
    Cvo_TextAttribute	*nattr;
    int			gap;
    BOOL		toggle:1;	// True if this is a toggle
    BOOL		state:1;	// Toggle state
    BOOL		cascade:1;	// True if a cascade button
    BOOL		compact:1;	// True if we should compact label
    Cvo_InputOnly	*arrow;
protected:
    KeyCode		accel;

    void		_Init(char *, int);
    void		_Init(wchar_t *, int);
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_MenuLabel)
    void ExposureHandler(XEvent * = 0, void * = 0);
    BOOL set()				{ return(part1 || part2 ||
						 part3 || part4); }
public:
    CONSTRUCDECL_2ARG(Cvo_MenuLabel, char * = 0, int = 0)
    CONSTRUCDECL_2ARG(Cvo_MenuLabel, wchar_t *, int = 0)
    ~Cvo_MenuLabel()		{ delete [] part1; delete [] part2;
				  delete [] part3; delete [] part4; }
    void SetText(char *s);
    void SetText(wchar_t *s);
    void SetDefaultText(char *s)	{ if (!set()) SetText(s); }
    void SetDefaultText(wchar_t *s)	{ if (!set()) SetText(s); }
    void Selected();
    void ForceOn();
    void ForceOff();
    BOOL State()			{ return(state); }
    void GetText(Cvo_CharacterBuffer &);

    Cvo_InputOnly *Arrow()		{ return(arrow); }

    CARD16 CalculateWidth();
    CARD16 CalculateHeight();
    void Compact(BOOL v = True)		{ compact = v; }

    wchar_t Accelerator()		{ return(accel); }

    wchar_t *QuickKey() { return(part4); }
};
#endif
