//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Object.h++,v 1.1.1.1 1996/08/21 08:27:09 prb Exp
//
#if	!defined(_Cvo_Object_)
#define	_Cvo_Object_

#if	!defined(_Cvo_BasicObject_)
#include <Cvo/BasicObject.h++>
#endif

typedef void (Cvo_Object::*Cvo_EvFunc)(XEvent *, void *);
typedef void (*Cvo_ExtEvFunc)(Cvo_Object *, XEvent *, void *);

#if	!defined(_Cvo_Errors_)
#include <Cvo/Errors.h++>
#endif
#if	!defined(_Cvo_Registration_)
#include <Cvo/Registration.h++>
#endif
#if	!defined(_Cvo_Default_)
#include <Cvo/Default.h++>
#endif
#if	!defined(_Cvo_Debug_)
#include <Cvo/Debug.h++>
#endif
#if	!defined(_Cvo_Help_)
#include <Cvo/Help.h++>
#endif

#define XLATE_REPLACE   0x00
#define XLATE_OVERRIDE  0x01
#define XLATE_AUGMENT   0x02
#define	XLATE_MASK	0x0f
#define	XLATE_PREPEND	0x10		// Prepend this table

extern char *_Cvo_GenerateName();
#include <Cvo/CONSTRUC.h++>

#define	Cvo_HASHSIZE	(1<<8)		// Must be power of two

class Cvo_Translation;
class Cvo_InputContext;

struct Cvo_Position {
    short       x;                      // X position in pixels
    short       y;                      // Y position in pixels
};

class Cvo_Object : public Cvo_BasicObject {
    static Cvo_Object	*hashList[Cvo_HASHSIZE];
    friend Cvo_Registration;
    friend Cvo_LayoutWindow;
    friend Cvo_Window;
    friend Cvo_OptimizeObjectCreation;
    friend Cvo_InputContext;
    friend void Cvo_Exit(int);
    //
    // STANDARD members (one per instance)
    //
protected:
    static Cvo_Object	*selectOwner;	// Who owns the selection
    static Cvo_Registration *selectRe;	// The registration on the selection
    static Cvo_CharacterBuffer selectBuf; // The actual selection
    XrmQuark		qname;		// Quark for this name
    XrmQuark		qclass;		// Quark for this class

    Cvo_Object		*parent;	// parent window
    Cvo_Object		*sibling;	// next sibling window
    Cvo_Object		*elder;		// my older sibling.
    Cvo_Object		*children;	// first of the child windows
    Cvo_Object		*nextObject;	// next object in Hash list

    Cvo_InputContext	*input_context;	// Window for editing
public:
    Cvo_Object		*holder;	// Hold window who is stealing focus

protected:
    Window		pwindow;	// X window ID of parent window
					// Only used if parent == NULL
    CARD32		selectMask;	// Mask of events being selected
    Cvo_Translation	*translations;	// The translation table

    short		borderWidth;	// Width of border in pixels
    Cvo_Position        position;       // Location on parent of local origin

    unsigned long	debug_flags;	// Flags for debugging trace
    Cvo_CharacterBuffer	lookupbuf;	// For XwcLookupString

    Cvo_Registration	*focusreg;
    Cvo_Registration	*enterreg;

public:
    Cvo_Object		*focus;
    Cvo_Registration	**registration;	// Registration array for events
    Cvo_RegReferences	*regreferences;	// Registrations that depend on us
    void		*accelerators;	// Place holder for accelerators
    int			maxbuttoncnt;	// Maximum # of clicks needed

    //
    // Constructors/Destructors
    //
public:
    Cvo_Object(char *_name, char *_class, Cvo_Object *_parent);
    Cvo_Object(char *_name, char *_class, Display *_display);
    virtual ~Cvo_Object();
    //
    // Virtual Functions
    //
protected:
    virtual void Reparent(XReparentEvent *);

    virtual void Bind();		// Bind the translations
public:
    virtual void Flush(int r = 0);	// Flush any unsent requests
    virtual void HelpHandler(XEvent *, int, char **);	// Help Action Handler
    void NullHandler(XEvent *, int, char **);	// Ignore handler

    //
    // The three configure routines are called in the following order:
    //
    //  PreConfigure()
    //  Configure()
    //  -- UsersHandler --
    //  PostConfigure()
    //
    void PreConfigure(XConfigureEvent *);
    void Configure(XConfigureEvent *);
    void PostConfigure(XConfigureEvent *);

    //
    // Member Functions
    //
private:
    void _Init(char *_name, char *_class);
    void EventHandler(XEvent *ev);		// Internal to handle events
    void FocusInHandler(XEvent *, void *);
    char *BuildName(char *_name);
    char *BuildClass(char *_class);
public:
    XrmQuarkList BuildName(XrmQuark _name, XrmQuark = 0);
    XrmQuarkList BuildClass(XrmQuark _class, XrmQuark = 0);
private:
    char *Get(char *_name, char *_class,
	      char *colorMode = 0, char *ColorMode = 0);
    char *Get(XrmQuarkList _name, XrmQuarkList _class,
	      XrmQuark colorMode = 0, XrmQuark ColorMode = 0)
	{ return(DisplayList()->Get(_name , _class, colorMode, ColorMode)); }
    char *Get(XrmQuark _name, XrmQuark _class,
	      XrmQuark colorMode = 0, XrmQuark ColorMode = 0);

protected:
    friend void _cvo_debug(unsigned long , Cvo_Object * , char *, ...);
    friend void _cvo_setdebug(unsigned long, Cvo_Object *);

    friend XEvent * _Cvo_event(XEvent *event);
    friend Cvo_Object *Cvo_FindWindow(Display *_display, Window _window);

    void _PassOnSelectMask(CARD32);	// Grumbleness
    void InsertIntoHashList();

    virtual void InitializeFocus();
public:
    void TakeFocus()			{ display->GiveFocus(this); }
    void FakeFocus(BOOL v = True)	{ infocus = v; }
    BOOL ClickToType()			{ return(display->ClickToType()); }

    virtual void SelectClear(XEvent * = 0, void * = 0);
    void SelectorGone(XEvent *, void *);
    void SetSelection(const Cvo_CharacterBuffer &cb);
    virtual void SelectRequest(XEvent *, void *);


protected:
    void RootEnterHandler(XEvent *, void *);
    void RootLeaveHandler(XEvent *, void *);
    void SelectNotify(XEvent *, void *);
    void MappedEvent(XEvent *, void *);
    void UnmappedEvent(XEvent *, void *);

public:
    void Map(int r = 0);		// Cause the window to be mapped
    void CreateAll(int r = 0);		// Like map, but doesn't actually map
    void Unmap();			// Cause the window to be unmapped
    void _AddSelectMask(CARD32);

    void Iconify(XEvent * = 0, int = 0, char ** = 0);
    void Deiconify(XEvent * = 0, int = 0, char ** = 0);
    void Dismiss(XEvent * = 0, int = 0, char ** = 0);
    void Quit(XEvent * = 0, int = 0, char ** = 0);
    void UnmapHandle(XEvent * = 0, int = 0, char ** = 0);

    char *Name()
	{ return(XrmQuarkToString(qname)); }
    char *Class()
	{ return(XrmQuarkToString(qclass)); }
    XrmQuark QName()
	{ return(qname); }
    XrmQuark QClass()
	{ return(qclass); }
    char *FullName()
	{ return(BuildName((char *)0)); }

    Cvo_Object *Parent()                // parent window
        { return(parent); }
    Cvo_Object *Sibling()               // next sibling window
        { return(sibling); }
    Cvo_Object *Elder()                 // elder sibling window
        { return(elder); }
    Cvo_Object *Children()              // first of the child windows
        { return(children); }
    Cvo_Object *NextObject()            // next object in hash list
        { return(nextObject); }
    Cvo_Object *RootObject();
    void SetFocus(Cvo_Object *);        // Set focus
    void LoseFocus();			// Should not be called by user
    BOOL InFocus()			// Return if we have focus or not
	{ return (DisplayList()->Focus() == this); }
    BOOL IsMain()			// Return if we have focus or not
	{ return (DisplayList()->IsMain(this)); }

    Window PWin()			// X window ID of parent (if any)
	{ return(parent ? 0 : pwindow); }
    CARD32 SelectMask()			// Mask of events being selected
	{ return(selectMask); }

    short BorderWidth()			// Width of border in pixels
	{ return(borderWidth); }
    void Origin(int *x, int *y)         // Origin of window
        { *x = position.x; *y = position.y; }
    void SetPosition(int x, int y)	// Internal use only  Use SetLocation
	{ position.x = x; position.y = y; } // to give a hint where you want it
    void SetNormalHints()
        { SetNormalHints(width, height); }
    void SetNormalHints(int, int);

    void ComputeOriginAtRoot(int *, int *);
    void ComputeOriginFromRoot(int *, int *);

    void QueryMouseLocation(int *x, int *y, int *rx = 0, int *ry = 0);

    void SetTitle(char *);		// Set windows title
    void SetIconTitle(char *);		// Set icons title

    void Reparent(Cvo_Object *);	// Reparent window... risky...
    void PlaceBefore(Cvo_Object *);	// Place before specified window
    void PlaceAfter(Cvo_Object *);	// Place after specified window

    //
    // GetResrouce(name, class, [default])
    //	Get the value of the resource, returning [default] if not
    //	found.
    // GetNewResource returns a new'd string
    //
    char *GetResource(char *_name, char *_class, char *_default = 0);
    char *GetNewResource(char *_name, char *_class, char *_default = 0);
    int GetResourceInt(char *_name, char *_class, int _default = 0);
    BOOL GetResourceTruth(char *_name, char *_class, BOOL _default = False);

    char *GetResource(XrmQuark _name, XrmQuark _class, char *_default = 0,
		      XrmQuark = 0, XrmQuark = 0);
    char *GetNewResource(XrmQuark _name, XrmQuark _class, char *_default = 0);
    int GetResourceInt(XrmQuark _name, XrmQuark _class, int _default = 0);
    BOOL GetResourceTruth(XrmQuark _name, XrmQuark _class, BOOL _def = False);

    //
    // Register(event, mask, func)
    // Request that func be called when ``event'' happens.
    //
    Cvo_Registration *Register(CARD32 event,
			       CARD16 mask,
			       Cvo_EvFunc func,
			       void *_data = 0,
			       KeySym key = XK_VoidSymbol);
    Cvo_Registration *Register(CARD32 event,
			       Cvo_EvFunc func,
			       void *_data = 0,
			       KeySym key = XK_VoidSymbol)
	{ return(Register(event, 0, func, _data, key)); }

    Cvo_Registration *RegisterKey(KeySym key,
				  CARD16 mask,
				  Cvo_EvFunc func,
				  void *_data = 0);

    Cvo_Registration *RegisterKey(KeySym key,
				  Cvo_EvFunc func,
				  void *_data = 0)
	{ return(RegisterKey(key, 0, func, _data)); }

    Cvo_Registration *Register(CARD32 event,
			       CARD16 mask,
			       Cvo_ExtEvFunc func,
			       void *_data = 0,
			       KeySym key = XK_VoidSymbol);
    Cvo_Registration *Register(CARD32 event,
			       Cvo_ExtEvFunc func,
			       void *_data = 0,
			       KeySym key = XK_VoidSymbol)
	{ return(Register(event, 0, func, _data, key)); }

    Cvo_Registration *RegisterKey(KeySym key,
				  CARD16 mask,
				  Cvo_ExtEvFunc func,
				  void *_data = 0);

    Cvo_Registration *RegisterKey(KeySym key,
				  Cvo_ExtEvFunc func,
				  void *_data = 0)
	{ return(RegisterKey(key, 0, func, _data)); }



    void RemoveRegistrationReference(Cvo_Registration *);
    void AddRegistrationReference(Cvo_Registration *);

    virtual Cvo_Object *DiscoverWindow(int x, int y, int upokay = 1);

    void SendEvent(Cvo_AnyEvent *);
    void SendXEvent(XEvent *);
    void SendEvent(int type, Cvo_AnyEvent *);

    Cvo_CharacterBuffer *GetSelection(Cvo_CharacterBuffer *);

    void ScanEvents();			// Process events on this dpy
    void _WaitForCopy();		// Wait for copy to complete
    void WaitForCopy()			{ if (InCopy()) _WaitForCopy(); }

    inline int GrabKeyboard();
    inline int GrabPointer(CARD32 mask = 0, Cursor curs = None);

    inline int GrabKeyboardForSelf();
    inline int GrabPointerForSelf(CARD32 mask = 0, Cursor curs = None);

    inline void UngrabKeyboard();
    inline void UngrabPointer();

    inline BOOL KeyboardGrabbed()	{ return(DisplayList()->kbdgrabbed); }
    inline BOOL PointerGrabbed()	{ return(DisplayList()->mousegrabbed); }

    inline BOOL ExclusiveGrabbed()
	{ return (PointerGrabbed() || KeyboardGrabbed() ||
	          Cvo_ExclusiveEventFilter()); }

    virtual void MoveResizeWindow(int x, int y, int w, int h, int tag = 0);
    virtual void MoveWindow(int x, int y, int tag = 0);
    virtual void ResizeWindow(int w, int h, int tag = 0);
    virtual void RaiseWindow();
    virtual void LowerWindow();
    void FocusInput();
    Cvo_InputContext *InputContext()	{ return(input_context); }
    virtual void NeedInputContext();
    char *ExpandName(char *);
    void Beep(int p = 0)		{ XBell(Dpy(), p); }
    void AddTranslations(char *, int = XLATE_OVERRIDE|XLATE_PREPEND);
    void NoTranslations(BOOL v = True);
    virtual void ForceOn()		{ ; }
    virtual void ForceOff()		{ ; }

    friend void _Cvo_ObjectAddBinding(Cvo_Object *, XEvent *, void *);

    //
    // These next 4 friend routines are depricated.  They should be
    // removed, but lots of code currently uses them.
    //
    friend Cvo_Registration *Cvo_Register(Cvo_Object *,
					  CARD32 event,
					  CARD16 mask,
					  Cvo_ExtEvFunc func,
					  void *_data = 0,
					  KeySym key = XK_VoidSymbol);

    friend Cvo_Registration *Cvo_RegisterKey(Cvo_Object *,
					  KeySym key,
					  CARD16 mask,
					  Cvo_ExtEvFunc func,
					  void *_data = 0);

    friend Cvo_Registration *Cvo_Register(Cvo_Object *w,
					  CARD32 event,
					  Cvo_ExtEvFunc func,
					  void *_data = 0,
					  KeySym key = XK_VoidSymbol);
		
    friend Cvo_Registration *Cvo_RegisterKey(Cvo_Object *w,
					     KeySym key,
					     Cvo_ExtEvFunc func,
					     void *_data = 0);
};

#if	!defined(_Cvo_Translation_)
#include <Cvo/Translation.h++>
#endif

inline void
Cvo_Object::NoTranslations(BOOL v)
{
    if ((notranslations = v) == True)
	translations = 0;
}

inline int
Cvo_Object::GrabKeyboard()
{
    int r = XGrabKeyboard(Dpy(), Win(), True,
		    	  GrabModeAsync, GrabModeAsync, CurrentTime);
    if (r == GrabSuccess)
	DisplayList()->kbdgrabbed = True;
    return(r);
}

inline int
Cvo_Object::GrabPointer(CARD32 mask, Cursor curs)
{
    mask |= ButtonPressMask|ButtonReleaseMask;
    int r = XGrabPointer(Dpy(), Win(), True, (unsigned int)mask,
			 GrabModeAsync, GrabModeAsync, None, curs, CurrentTime);
    if (r == GrabSuccess)
	DisplayList()->mousegrabbed = True;
    return(r);
}

inline int
Cvo_Object::GrabKeyboardForSelf()
{
    int r = XGrabKeyboard(Dpy(), Win(), False,
                          GrabModeAsync, GrabModeAsync, CurrentTime);
    if (r == GrabSuccess)
	DisplayList()->kbdgrabbed = True;
    return(r);
}

inline int
Cvo_Object::GrabPointerForSelf(CARD32 mask, Cursor curs)
{
    mask |= ButtonPressMask|ButtonReleaseMask;
    int r = XGrabPointer(Dpy(), Win(), False, (unsigned int)mask,
                         GrabModeAsync, GrabModeAsync, None, curs, CurrentTime);
    if (r == GrabSuccess)
	DisplayList()->mousegrabbed = True;
    return(r);
}

inline void
Cvo_Object::UngrabKeyboard()
{
    DisplayList()->kbdgrabbed = 0;
    XUngrabKeyboard(Dpy(), CurrentTime);
}

inline void
Cvo_Object::UngrabPointer()
{
    DisplayList()->mousegrabbed = 0;
    XUngrabPointer(Dpy(), CurrentTime);
}

void _Cvo_QueueConfigure(Cvo_Object *, int, int);
int _Cvo_QueueDeConfigure(Cvo_Object *, int, int);


//
// The following macro make creating the Bind function much
// easier:
// class Cvo_NewType : public Cvo_BaseType {
// protected:
//	void Bind();
// }
//
// CVO_BIND(Cvo_NewType, Cvo_BaseType, Cvo_HandleMap map)
//
#if defined(__DONT_TYPECAST_ZERO__)
#define __ZHF(nc)       0
#else
#define __ZHF(nc)       (void (nc::*)(XEvent *, int, char **))0
#endif

#define	CVO_INIT_BIND(nc) \
    struct nc##_HandleFunction : Cvo_HandleFunction { \
	void        function(Cvo_Object *, XEvent *, int, char **); \
	void        (nc::*handler)(XEvent *, int, char **); \
	nc##_HandleFunction(char *s, void (nc::*h)(XEvent *, int, char **)); \
    }; \
    nc##_HandleFunction::nc##_HandleFunction( \
	    char *s, void (nc::*h)(XEvent *, int, char **)) { \
	symbol = s; \
	handler = h; \
    } \
    void \
    nc##_HandleFunction::function(Cvo_Object *o, XEvent *e, int c, char **v) { \
	if (handler != __ZHF(nc)) \
		(((nc *)o)->*(handler))(e, c, v); \
    }
#define CVO_DECL_BIND(nc, f, s, h) \
    static nc##_HandleFunction f(s, &nc::h);

#define	CVO_START_BIND(nc) \
    void nc::Bind() { \
	if (!translations) \
	    return;

#define	CVO_BIND(_f) \
	translations->Bind(&_f);

#define	CVO_BEGIN_BIND(nc) \
    CVO_INIT_BIND(nc); \
    CVO_START_BIND(nc);

#define	CVO_DOBIND(nc, s, h) { \
    static nc##_HandleFunction _f(s, &nc::h); \
    translations->Bind(&_f); \
}

#define	CVO_END_BIND(nc, bc) \
	bc::Bind(); \
    }
#endif
