//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	OpenFile.h++,v 1.1.1.1 1996/08/21 08:27:09 prb Exp
//
#if	!defined(_Cvo_OpenFile_)
#define	_Cvo_OpenFile_

#if	!defined(_Cvo_Pin_)
#include <Cvo/Pin.h++>
#endif
#if	!defined(_Cvo_Input_)
#include <Cvo/Input.h++>
#endif
#if	!defined(_Cvo_TextPage_)
#include <Cvo/TextPage.h++>
#endif
#if	!defined(_Cvo_List_)
#include <Cvo/List.h++>
#endif
#include <sys/param.h>
#include <sys/stat.h>

#if	!defined(MAXPATHLEN)
#define	MAXPATHLEN	1024		// UNICOS does not have this defined
#endif

class Cvo__OpenFile : public Cvo_Window {
    friend void Cvo_OpenFile(Cvo_Object *, XEvent *, void *);
    friend void Cvo_SaveFile(Cvo_Object *, XEvent *, void *);
    char		directory[MAXPATHLEN];
    struct stat		dirstat;		// Cray C++ wants the struct...
    char		*filename;
    char		*accept;
    void		*data;
    int			acceptlen;
    Cvo_Pin		*pin;
    Cvo_Input		*file;
    Cvo_Input		*filter;
    Cvo_List		*dirs;
    Cvo_List		*files;
    Cvo_TextPage	*dirpage;
    Cvo_TextPage	*filepage;
    Cvo_TextAttribute	*dirgray;
    Cvo_TextAttribute	*filegray;
    BOOL		savefile:1;
    BOOL		dirtydir:1;
    void _Init(void *, BOOL);
    void NewFilter();
    int NewDirectory(char * = 0);
public:
    CONSTRUCDECL_2ARG(Cvo__OpenFile, void * = 0, BOOL = False)
    void RereadDirectory()		{ NewDirectory(directory); }
    void SetFilename(char *);
    int SetDirectory(char *s)		{ return(NewDirectory(s)); }
    void SetFullName(char *);
    void SetFilter(char *);
    void SetData(void *d)		{ data = d; }
    friend void Cvo__OpenFile_NewFilter(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFile_Cancel(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFile_Okay(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFile_UseFile(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFile_NewDir(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFile_NewFile(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFileCreatedDirectory(Cvo_Object *, XEvent *, void *);
    friend void Cvo__OpenFileCreatedFiles(Cvo_Object *, XEvent *, void *);
};

class Cvo__SaveFile : public Cvo__OpenFile {
    void _Init(void *, BOOL)		{ ; }
public:
    CONSTRUCDECL_2ARG(Cvo__SaveFile, void * = 0, BOOL = True)
};

#define	CvoOpenFileEvent		(Cvo_OpenFileEventType + InternalEvent0)
#define	CvoSaveFileEvent		(Cvo_OpenFileEventType + InternalEvent1)

struct Cvo_OpenFileEvent : Cvo_AnyEvent {
    char	    *filename;
    void	    *data;
};

typedef Cvo_OpenFileEvent Cvo_SaveFileEvent;

class Cvo_OpenFileInfo {
    friend void Cvo_OpenFile(Cvo_Object *, XEvent *, void *);
    friend void Cvo_OpenFileDestroyed(Cvo_Object *, XEvent *, void *);
    Cvo__OpenFile	*of;
    char		*name;
    void		*data;
    char		*file;
    char		*filter;
public:
    Cvo_OpenFileInfo(char *n)	{ data = 0; of = 0; name = n; file = 0;
				  filter = 0;}
    void SetData(void *d)	{ data = d; if(of) of->SetData(data); }
    void SetEntry(char *s)	{ if (of) of->SetFullName(s);
				  else {
				    delete [] file;
				    file = new char [strlen(s)+1];
				    strcpy(file, s);
				  }
				}
    void SetFilter(char *s)	{ if (of) of->SetFilter(s);
				  else {
				    delete [] filter;
				    filter = new char [strlen(s)+1];
				    strcpy(filter, s);
				  }
				}

};

class Cvo_SaveFileInfo {
    friend void Cvo_SaveFile(Cvo_Object *, XEvent *, void *);
    friend void Cvo_SaveFileDestroyed(Cvo_Object *, XEvent *, void *);
    Cvo__SaveFile 	*sf;
    char		*name;
    void		*data;
    char		*file;
public:
    Cvo_SaveFileInfo(char *n)	{ data = 0; sf = 0; name = n; }
    void SetData(void *d)	{ data = d;  if(sf) sf->SetData(data); }
    void SetEntry(char *s)	{ if (sf) sf->SetFullName(s);
				  else {
				    delete [] file;
				    file = new char [strlen(s)+1];
				    strcpy(file, s);
				  }
				}
};
#endif
