//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	PeelOff.h++,v 1.1.1.1 1996/08/21 08:27:10 prb Exp
//
#if     !defined(_Cvo_PeelOff_)
#define _Cvo_PeelOff_

#if     !defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if     !defined(_Cvo_Image_)
#include <Cvo/Image.h++>
#endif

class Cvo_PeelOff : public Cvo_Window {
    BOOL	active:1;	// True if the box is currently active
    BOOL	local:1;	// True if the pixmap is local

    int		bx, by;		// Where the mouse was pressed on the root
    int		lx, ly;		// Last place a box was drawn
    int		 w,  h;		// Width/Height of the new box
    Cvo_Window	*peelwin;	// Window to use as basis for size
    GC		boxGC;		// GC used when drawing on the root
    Cvo_Image	*image;		// The peel-off image

    void _Init(Cvo_Window *);
protected:
    void Bind();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_PeelOff)
    void ExposureHandler(XEvent * = 0, void * = 0);
public:
    CONSTRUCDECL_1ARG(Cvo_PeelOff, Cvo_Window *)
    ~Cvo_PeelOff();

    void DragBoxInit(XEvent *ev, int , char **);
    void DragBox(XEvent *ev, int , char **);
    void DragBoxDone(XEvent *ev, int , char **);

    CARD16 CalculateWidth()         { return(image->Width()); }
    CARD16 CalculateHeight()        { return(image->Height()); }
};

#define CvoPeelOffEvent      	(Cvo_PeelOffEventType + InternalEvent0)

//
// Side note, the CvoPeelOffEvent is sent to both the PeelOff object and
// the peelwin object.
//

struct Cvo_PeelOffEvent : Cvo_AnyEvent {
    int		x;		// X Location of where the thing was dropped
    int		y;		// Y Location of where the thing was dropped
    Cvo_Window	*peelwin;	// Window being peeled off
};
#endif
