//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	Pixmap.h++,v 1.1.1.1 1996/08/21 08:27:11 prb Exp
//
#if	!defined(_Cvo_Pixmap_)
#define	_Cvo_Pixmap_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif

class Cvo_Pixmap : public Cvo_BasicObject {
    friend	Cvo_TextAttribute;
    GC		gc;
    CARD32	lbp;		// Last background pixel
    Cvo_Color	background;
    Cvo_Color	foreground;
    Cvo_TextAttribute	*textAttribute;
    short	awidth;		// Actual width
    short	aheight;	// Actual height
public:
    Cvo_Pixmap(Cvo_Window *, int width, int height, int depth = 0);
    Cvo_Pixmap(Cvo_Pixmap *, int width, int height, int depth = 0);

    void Resize(int nw, int nh, BOOL copy = True);
    void AllowPartials();

    Cvo_Color Background()		// background color for window
	{ return(background); }
    Cvo_Color Foreground()		// background color for window
	{ return(foreground); }
    Cvo_Color CurrentBackground()	// background color for window
	{ return(background); }
    Cvo_Color CurrentForeground()      // background color for window
        { return(foreground); }
    Cvo_TextAttribute *TextAttribute()		// The basic text attribute
	{ return(textAttribute); }
    void SetGC(Cvo_Color const &bg, Cvo_Color const &fg)
        { TextAttribute()->ModifyGC(bg, fg); }
    Cvo_TextAttribute *NewTextAttribute()
        { return(TextAttribute()->Copy(&textAttribute)); }
    GC Gc()				// default GC
	{ return(gc); }
    GC SaveGC();			// Save a copy of the GC
    void RestoreGC(GC);			// Restore from saved copy (and free)

    //
    // DrawString(x, y, string, [length])
    //	Draw only the text
    // ImageString(x, y, string, [length])
    //	Draw text and background
    //
    //	x, y:	Origin of where to draw the string
    //	string:	What to draw
    //	length: Optional length of string
    //
    void DrawString(int x, int y, char *str, int len = -1)
	{ TextAttribute()->Draw(x, y, str, len); }
    void ImageString(int x, int y, char *str, int len = -1)
	{ TextAttribute()->Image(x, y, str, len); }
    void DrawString(int x, int y, wchar_t *str, int len)
	{ TextAttribute()->Draw(x, y, str, len); }
    void ImageString(int x, int y, wchar_t *str, int len)
	{ TextAttribute()->Image(x, y, str, len); }

    void DrawStrings(int mode, int x, int y, int w, int h,
                     char *str, int len = -1)
        { TextAttribute()->DrawStrings(mode, x, y, w, h, str, len); }
    void DrawStrings(int mode, int x, int y, int w, int h,
                     wchar_t *str, int len = -1)
        { TextAttribute()->DrawStrings(mode, x, y, w, h, str, len); }

    int StringsExtents(char *s, int n, XRectangle &log);
    int StringsExtents(wchar_t *s, int n, XRectangle &log);

    //
    // StringWidth(string, [length])
    //	Return number of pixels wide the string will be
    // StringExtents(string, [lenght], ink, [log])
    //	Return size of the string in ink and log
    //
    //	string:	What to measure
    //	length: Optional length of string
    //	ink:	The box that will contain everything that is drawn
    //	log:	The box which you should not write within
    //
    int StringWidth(char *s, int n = -1);
    int StringWidth(wchar_t *s, int n = -1);
    int StringHeight(char *s, int n = -1);
    int StringHeight(wchar_t *s, int n = -1);
    void StringExtents(char *s, int n, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, n, ink, log); }
    void StringExtents(char *s, int n, XRectangle &ink)
	{ TextAttribute()->Extents(s, n, ink); }
    void StringExtents(char *s, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, ink, log); }
    void StringExtents(char *s, XRectangle &ink)
	{ TextAttribute()->Extents(s, ink); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, n, ink, log); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink)
	{ TextAttribute()->Extents(s, n, ink); }
    void StringExtents(wchar_t *s, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, ink, log); }
    void StringExtents(wchar_t *s, XRectangle &ink)
	{ TextAttribute()->Extents(s, ink); }

    void DrawArrow(int dir, int x, int y, int w, int h = -1);
    void DrawUpArrow(int x, int y, int w, int h = -1);
    void DrawDownArrow(int x, int y, int w, int h = -1);
    void DrawLeftArrow(int x, int y, int w, int h = -1);
    void DrawRightArrow(int x, int y, int w, int h = -1);

    //
    // Below are helper functions to standard X Lib calls.  They will
    // do coordinate translation for you.
    //
    void DrawLine(int x1, int y1, int x2, int y2)
	{ XDrawLine(Dpy(), Object(), gc, x1, y1, x2, y2); }
    void DrawPoint(int x, int y)
	{ XDrawPoint(Dpy(), Object(), gc, x, y); }
    void DrawArc(int x, int y, int w, int h, int ang1, int ang2)
	{ XDrawArc(Dpy(), Object(), gc, x, y, w, h, ang1, ang2); }
    void DrawRectangle(int x, int y, int w, int h)
	{ XDrawRectangle(Dpy(), Object(), gc, x, y, w, h); }
    void FillArc(int x, int y, int w, int h, int ang1, int ang2)
	{ XFillArc(Dpy(), Object(), gc, x, y, w, h, ang1, ang2); }
    void FillRectangle(int x, int y, int w, int h)
	{ XFillRectangle(Dpy(), Object(), gc, x, y, w, h); }
    void ClearArea(int x, int y, int w, int h)
	{ SetForeground(lbp);
	  FillRectangle(x, y, w, h); }
    void ClearWindow()
	{ SetForeground(lbp);
	  FillRectangle(0, 0, Width(), Height()); }

    void CopyArea(int x, int y, int w, int h, int dx, int dy)
	{ XCopyArea(Dpy(), Object(), Object(), gc, x, y, w, h, dx, dy); }
    void CopyAreaTo(Cvo_Pixmap *dst, int x, int y, int w, int h, int dx, int dy)
	{ XCopyArea(Dpy(), Object(), dst->Object(), gc, x, y, w, h, dx, dy); }
    void CopyAreaTo(Cvo_Window *dst, int x, int y, int w, int h, int dx, int dy)
	{ if (dx < 0) { w += dx; x -= dx; dx = 0; }
	  if (dy < 0) { h += dy; y -= dy; dy = 0; }
	  if (dx + w > dst->Width()) w = dst->Width() - dx;
	  if (dy + h > dst->Height()) h = dst->Height() - dy;
	  if (w > 0 && h > 0) {
	    dst->ToXCoord(&dx, &dy);
	    XCopyArea(Dpy(), Object(), dst->Object(), gc, x, y, w, h, dx, dy);
	  }
	}
    void CopyAreaFrom(Cvo_Pixmap *src, int x, int y, int w, int h, int dx, int dy)
	{ XCopyArea(Dpy(), src->Object(), Object(), gc, x, y, w, h, dx, dy); }
    void CopyTo(Cvo_Pixmap *dst)
	{ XCopyArea(Dpy(), Object(), dst->Object(), gc, 0,0,Width(),Height(),0,0); }
    void CopyFrom(Cvo_Pixmap *src)
	{ XCopyArea(Dpy(), src->Object(), Object(), gc,
		    0, 0, src->Width(), src->Height(), 0, 0); }
    void CopyTo(Cvo_Window *dst)
	{ int x, y;
          dst->XOrigin(&x, &y);
          int w = dst->Width() > Width() ? Width() : dst->Width();
          int h = dst->Height() > Height() ? Height() : dst->Height();
	  XCopyArea(Dpy(), Object(), dst->Object(), gc, 0,0,Width(),Height(),w,h); }
    void CopyFrom(Cvo_Window *src)
	{ int x, y;
          src->XOrigin(&x, &y);
	  XCopyArea(Dpy(), src->Object(), Object(), gc,
		    x, y, src->Width(), src->Height(), 0, 0); }
    void CopyAreaFrom(Cvo_Window *src, int x, int y, int w, int h, int dx, int dy)
	{ src->ToXCoord(&x, &y);
	  XCopyArea(Dpy(), src->Object(), Object(), gc, x, y, w, h, dx, dy); }

    void CopyInPixmap(Pixmap p, int x, int y, int w, int h)
	{ XCopyArea(Dpy(), p, Object(), gc, 0, 0, w, h, x, y); }


    void PutImage(XImage *im, int x, int y, int dx, int dy, int w, int h)
	{ XPutImage(Dpy(), Object(), gc, im, x, y, dx, dy, w, h); }
    void PutImage(XImage *im, int dx, int dy, int w, int h)
	{ XPutImage(Dpy(), Object(), gc, im, 0, 0, dx, dy, w, h); }

    void ResizeWindow(int w, int h);
    //
    // The following helper functions are used to adjust values in the
    // default GC
    //
    void SetArcMode(int arc_mode)
	{ XSetArcMode(Dpy(), gc, arc_mode); }
    void SetBackground(const Cvo_Color &c)
	{ XGCValues v;
	  lbp = v.background = c->Pixel();
	  XChangeGC(Dpy(), gc, GCBackground, &v); }
    void SetBackground(CARD32 p)
	{ XGCValues v;
	  lbp = v.background = p;
	  XChangeGC(Dpy(), gc, GCBackground, &v); }
    void SetClipMask(Pixmap mask)
	{ XSetClipMask(Dpy(), gc, mask); }
    void SetClipOrigin(int x, int y)
	{ XSetClipOrigin(Dpy(), gc, x, y); }
    void SetClipRectangles(int x, int y, XRectangle rect[], int n, int o)
	{ XSetClipRectangles(Dpy(), gc, x, y, rect, n, o); }
    void SetDashes(int off, char list[], int n)
	{ XSetDashes(Dpy(), gc, off, list, n); }
    void SetFillRule(int rule)
	{ XSetFillRule(Dpy(), gc, rule); }
    void SetFillStyle(int style)
	{ XSetFillStyle(Dpy(), gc, style); }
    void SetForeground(const Cvo_Color &c)
	{ XGCValues v;
	  CARD32 mask = GCForeground|GCFillStyle;
	  v.foreground = c->Pixel();
	  if (c->UsePixmap()) {
	    v.stipple = c->GetPixmap(1);
	    mask |= GCStipple;
	    v.fill_style = FillOpaqueStippled;
	  } else
	    v.fill_style = FillSolid;
	  XChangeGC(Dpy(), gc, mask, &v); }
    void SetForegroundOnly(const Cvo_Color &c)
        { XGCValues v;
          v.foreground = c->Pixel();
          XChangeGC(Dpy(), gc, GCForeground, &v); }
    void SetForeground(CARD32 p)
	{ XGCValues v;
	  CARD32 mask = GCForeground|GCFillStyle;
	  v.foreground = p;
	  v.fill_style = FillSolid;
	  XChangeGC(Dpy(), gc, mask, &v); }
    void SetFunction(int func)
	{ XSetFunction(Dpy(), gc, func); }
    void SetGraphicsExposures(Bool exp)
	{ XSetGraphicsExposures(Dpy(), gc, exp); }
    void SetLineAttributes(unsigned int w, int line, int cap, int join)
	{ XSetLineAttributes(Dpy(), gc, w, line, cap, join); }
    void SetPlaneMask(unsigned long mask)
	{ XSetPlaneMask(Dpy(), gc, mask); }
    void SetRegion(Region r)
	{ XSetRegion(Dpy(), gc, r); }
    void SetStipple(Pixmap stipple)
	{ XSetStipple(Dpy(), gc, stipple); }
    void SetSubwindowMode(int mode)
	{ XSetSubwindowMode(Dpy(), gc, mode); }
    void SetTile(Pixmap tile)
	{ XSetTile(Dpy(), gc, tile); }
    void SetTSOrigin(int x, int y)
	{ XSetTSOrigin(Dpy(), gc, x, y); }

    //
    // XXX - Warning, the definition of these routines is subject to
    // change.  Currently they are used in:
    //	Cvo_Paint
    //
    void DrawSegments(XSegment *seg, int nseg)
	{ XDrawSegments(Dpy(), Object(), gc, seg, nseg); }

    //
    // Below are the chamfer routines
    //
private:
    void _sdraw(const Cvo_Color &, int r, XSegment *s, int t,
                int sx = 0, int sy = 0, int w = 0, int h = 0);
    void _edraw(const Cvo_Color &, int r, XSegment *s, int t,
                int sx = 0, int sy = 0, int w = 0, int h = 0);
public:

    void DrawRaisedChamfer(int, int, int, int, int, const Cvo_Color &);
    void DrawLoweredChamfer(int, int, int, int, int, const Cvo_Color &);
    void DrawEtchedChamfer(int, int, int, int, int, const Cvo_Color &);
    void ClearChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0);

    void DrawRaisedChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
        { DrawRaisedChamfer(r, x, y, w, h, background); }
    void DrawLoweredChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
        { DrawLoweredChamfer(r, x, y, w, h, background); }
    void DrawEtchedChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
        { DrawEtchedChamfer(r, x, y, w, h, background); }
};
#endif
