//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	ScrollBar.h++,v 1.1.1.1 1996/08/21 08:27:12 prb Exp
//
#if	!defined(_Cvo_ScrollBar_)
#define	_Cvo_ScrollBar_

#include <sys/time.h>
#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif

class Cvo_SBBase : public Cvo_Window {
	void _Init()			{ type = CvoT_SBBase; }
public:
	CONSTRUCDECL(Cvo_SBBase)
};

class Cvo_SBThumb : public Cvo_SBBase {
	void _Init();
protected:
	void Bind();
public:
	int StandardLayoutFunction(int, int, int, int);
	CONSTRUCDECL(Cvo_SBThumb)
	virtual void Motion(XEvent *, int, char **);
};

class Cvo_SBAccessory : public Cvo_SBBase {
	int dir;
	void _Init(int);
	int Delay(timeval &delay);
protected:
	CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_SBAccessory)
	void ExposureHandler(XEvent * = 0, void * = 0);
	void Bind();
public:
	int StandardLayoutFunction(int, int, int, int);
	int StandardComputeLayoutSize(int);
	CONSTRUCDECL_1ARG(Cvo_SBAccessory, int)
        virtual void Down(XEvent *, int, char **);
};

class Cvo_ScrollBar : public Cvo_SBBase {
	friend Cvo_SBAccessory;
	friend Cvo_SBThumb;
	Cvo_SBAccessory	*up;		// Window for the down arrow
	Cvo_SBAccessory	*down;		// Window for the down arrow
	Cvo_SBThumb	*thumb;		// Window for the thumb
	BOOL		horiz:1;	// True if horizontal scrollbar
	BOOL		scrolling:1;	// True when scrolling;
	BOOL		compress:1;	// True if events are compressed
	BOOL		scrolled:1;	// True if scrolling was ever set
	void _Init(int);
	int		min;		// Minimum value allowed
	int		max;		// Maximum value allowed
	int		current;	// Current value
	int		last;		// last value
	int		visible;	// Number of values visable on screen
	timeval		delay;		// Delay till second scroll
	timeval		rate;		// Rate to display for accel lines
	int		accel;		// After this many, go full speed
	unsigned	jump;		// Amount to jump by when scrolling
protected:
	void SendScrollEvent();
	void Bind();
public:
	CONSTRUCDECL_1ARG(Cvo_ScrollBar, int)
	~Cvo_ScrollBar();
	void SetMaximum(int x)		{ max = x; thumb->ReLayout(); }
	void SetMinimum(int x)		{ min = x; thumb->ReLayout(); }
	void SetCurrent(int x)		{ current = x; thumb->ReLayout(); }
	void SetVisible(int x)		{ visible = x; thumb->ReLayout(); }
	void SetJump(unsigned x)	{ if (x > 0) jump = x; }
	int GetMaximum()		{ return(max); }
	int GetMinimum()		{ return(min); }
	int GetCurrent()		{ return(current); }
	int GetVisible()		{ return(visible); }
	void SetValues(int n, int x, int c, int v)
					{ min = n; max = x; current = c;
					  visible = v; thumb->ReLayout(); }
        CARD16 CalculateWidth();
        CARD16 CalculateHeight();
	void CompressEvents(BOOL v = True) { compress = v; }
	int StandardComputeLayoutSize(int);
        virtual void MoveTo(XEvent *, int, char **);
        virtual void PageUp(XEvent *, int, char **);
        virtual void PageDown(XEvent *, int, char **);
        virtual void MotifMove(XEvent *, int, char **);

	friend void _Cvo_SB_CatchPressRelease(Cvo_Object *, XEvent *, void *);
};

#define	CvoScrollBarEvent	(Cvo_ScrollBarEventType + InternalEvent0)

struct Cvo_ScrollBarEvent : Cvo_AnyEvent {
        int             value;          // The new value of the scrollbar
	BOOL		scrolling:1;	// True while scrolling
};
#endif
