//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	TextAttribute.h++,v 1.1.1.1 1996/08/21 08:27:13 prb Exp
//
#if	!defined(_Cvo_TextAttribute_)
#define	_Cvo_TextAttribute_

#if	!defined(_Cvo_Font_)
#include <Cvo/Font.h++>
#endif
#if	!defined(_Cvo_RootedList_)
#include <Cvo/RootedList.h++>
#endif

class Cvo_TextAttribute : public Cvo_RootedList {
    Cvo_Font		font;
    GC			gc;
    Cvo_Color		foreground;		// Might be a stipple fill
    Cvo_Color		background;
    Cvo_BasicObject	*drawable;
    BOOL		enbolden:1;		// True if enbolden needed
    BOOL		underline:1;		// True if underline font
    BOOL		secondary:1;
    BOOL		iswindow:1;
    unsigned		underlineat:16;		// Where to underline
    Cvo_TextAttribute	*reverse;
    void _SetGC();
    BOOL SetGC()	{ if (!gc && drawable->Object()) _SetGC();
			 return(gc ? True : False); }
    Cvo_TextAttribute *NukeLink();
public:
    Cvo_TextAttribute(Cvo_TextAttribute **, Cvo_Window *, const Cvo_Font &);
    Cvo_TextAttribute(Cvo_TextAttribute **, Cvo_Pixmap *, const Cvo_Font &);
    Cvo_TextAttribute(Cvo_TextAttribute **, Cvo_TextAttribute *);
    ~Cvo_TextAttribute();
    Cvo_TextAttribute *Next()		{ return((Cvo_TextAttribute *)next); }
    Cvo_TextAttribute *Prev()		{ return((Cvo_TextAttribute *)prev); }

    Cvo_Font Font()			   { return(font); }
    Cvo_Color Foreground()		   { if (foreground.Empty() &&
						  drawable->Object()) {
						    _SetGC();
						    reverse->_SetGC();
					     }
					     return(foreground); }
    Cvo_Color Background()		   { if (background.Empty() &&
						  drawable->Object()) {
						    _SetGC();
						    reverse->_SetGC();
					     }
					     return(background); }
    Cvo_Font SetFont(char *name)	   { Cvo_Font of = font;
					     font = Cvo_Font(drawable, name);
					     reverse->font = font;
					     return(of);
					   }
    Cvo_Font SetFont(XrmQuark q)
					   { Cvo_Font of = font;
					     font = Cvo_Font(drawable, q);
					     reverse->font = font;
					     return(of);
					   }
    Cvo_Font SetFontFromResource(char *name)
				   { return(SetFont(XrmStringToQuark(name))); }
    Cvo_Font SetFont(const Cvo_Font &nf)   { Cvo_Font of = font;
					     font = nf;
					     reverse->font = font;
					     return(of);
					   }
    Cvo_Color SetForeground(const Cvo_Color &c) { Cvo_Color oc = foreground;
					     foreground = c;
					     reverse->background = c;
					     if (gc || reverse->gc) {
						_SetGC();
						reverse->_SetGC();
					     }
					     return(oc); }
    Cvo_Color SetBackground(const Cvo_Color &c) { Cvo_Color oc = background;
					     background = c;
					     reverse->foreground = c;
					     if (gc || reverse->gc) {
						_SetGC();
						reverse->_SetGC();
					     }
					     return(oc); }
    void ModifyGC(const Cvo_Color &b, const Cvo_Color &f);
    void SetUnderlineAt(unsigned x = 0)	{ underlineat = x; }

    void ResetDrawable(Cvo_Window *w);
    void ResetDrawable(Cvo_Pixmap *w);

    BOOL Underline(BOOL v = True)	   { BOOL ov = underline;
					     underline = v;
					     reverse->underline = v;
					     return(ov); }
    BOOL Enbolden(BOOL v = True)	   { BOOL ov = enbolden;
					     enbolden = v;
					     reverse->enbolden = v;
					     return(ov); }
    BOOL IsUnderline()			   { return(underline); }
    BOOL IsEnbolden()			   { return(enbolden); }
    Cvo_TextAttribute *Copy(Cvo_TextAttribute **r)
				{ return(new Cvo_TextAttribute(r, this)); }
    Cvo_TextAttribute *Reverse()	   { return(reverse); }
    Cvo_TextAttribute *Unsensitive();

    //
    // DrawString(x, y, string, [length])
    //  Draw only the text
    // ImageString(x, y, string, [length])
    //  Draw text and background
    //
    //  x, y:   Origin of where to draw the string
    //  string: What to draw
    //  length: Optional length of string
    //
    void Draw(int x, int y, char *str, int len = -1);
    void Draw(int x, int y, wchar_t *str, int len = -1);
    void Image(int x, int y, char *str, int len = -1);
    void Image(int x, int y, wchar_t *str, int len = -1);
    void DrawStrings(int mode, int x, int y, int w, int h, char *, int = -1);
    void DrawStrings(int mode, int x, int y, int w, int h, wchar_t *, int = -1);

    int StringsExtents(char *s, int n, XRectangle &log);
    int StringsExtents(wchar_t *s, int n, XRectangle &log);

    // StringWidth(string, [length])
    //  Return number of pixels wide the string will be
    // StringExtents(string, [lenght], ink, [log])
    //  Return size of the string in ink and log
    //
    //  string: What to measure
    //  length: Optional length of string
    //  ink:    The box that will contain everything that is drawn
    //  log:    The box which you should not write within
    //
    int StringWidth(char *s, int n = -1);
    int StringWidth(wchar_t *s, int n = -1);
    int StringHeight(char *s, int n = -1);
    int StringHeight(wchar_t *s, int n = -1);

    void Extents(char *s, int n, XRectangle &ink, XRectangle &log);
    void Extents(char *s, int n, XRectangle &ink);
    void Extents(char *s, XRectangle &ink, XRectangle &log);
    void Extents(char *s, XRectangle &ink);
    void Extents(wchar_t *s, int n, XRectangle &ink, XRectangle &log);
    void Extents(wchar_t *s, int n, XRectangle &ink);
    void Extents(wchar_t *s, XRectangle &ink, XRectangle &log);
    void Extents(wchar_t *s, XRectangle &ink);

    int MHeight() { return(font->MHeight()); } 
    int MWidth() { return(font->MWidth()); } 
    //
    // The following helper functions are used to adjust values in the
    // default GC
    //
    void SetArcMode(int arc_mode)
	{ XSetArcMode(drawable->Dpy(), gc, arc_mode); }
    void SetClipMask(Pixmap mask)
	{ XSetClipMask(drawable->Dpy(), gc, mask); }
    void SetClipOrigin(int x, int y);
    void SetClipRectangles(int x, int y, const XRectangle rect[], int n, int o);
    void SetDashes(int off, char list[], int n)
	{ XSetDashes(drawable->Dpy(), gc, off, list, n); }
    void SetFillRule(int rule)
	{ XSetFillRule(drawable->Dpy(), gc, rule); }
    void SetFillStyle(int style)
	{ XSetFillStyle(drawable->Dpy(), gc, style); }
    void SetFunction(int func)
	{ XSetFunction(drawable->Dpy(), gc, func); }
    void SetGraphicsExposures(Bool exp)
	{ XSetGraphicsExposures(drawable->Dpy(), gc, exp); }
    void SetLineAttributes(unsigned int w, int line, int cap, int join)
	{ XSetLineAttributes(drawable->Dpy(), gc, w, line, cap, join); }
    void SetPlaneMask(unsigned long mask)
	{ XSetPlaneMask(drawable->Dpy(), gc, mask); }
    void SetRegion(Region r)
	{ XSetRegion(drawable->Dpy(), gc, r); }
    void SetStipple(Pixmap stipple)
	{ XSetStipple(drawable->Dpy(), gc, stipple); }
    void SetSubwindowMode(int mode)
	{ XSetSubwindowMode(drawable->Dpy(), gc, mode); }
    void SetTile(Pixmap tile)
	{ XSetTile(drawable->Dpy(), gc, tile); }
    void SetTSOrigin(int x, int y);
};
#endif
