//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	TextLine.h++,v 1.1.1.1 1996/08/21 08:27:13 prb Exp
//
#if	!defined(_Cvo_TextLine_)
#define	_Cvo_TextLine_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if	!defined(_Cvo_Pixmap_)
#include <Cvo/Pixmap.h++>
#endif

class Cvo_CRT;

class Cvo_TextLine {
    wchar_t   		*text;		// The actual data to be displayed
    Cvo_TextAttribute	**state;	// State information to go with it
    Cvo_TextAttribute	*currentstate;	// Curent state
    int       		maxlen;		// How big those arrays are
    int       		lastglyph;	// Number of valid glyphs of data
    INT16		ascent;		// Maximum ascent for this line
    INT16		descent;	// Maximum descent for this line
    Cvo_CRT   		*win;		// The window this is displayed in
    int       		lx;		// Last horz location for this text
    int       		lw;		// Last width for this text
    int       		ly;		// Last vert location for this text
    int       		rx;		// Where we drew it raised...
    int       		ry;		// ...
    int       		rw;		// ...
    int       		rh;		// ...
    int       		rr;		// How much we raised it
    CARD16		cursorx;	// Where the cursor actually is
    CARD16		myrow;		// What row I am
    BOOL      		dirty:1;	// Set if we must be redisplayed.
    BOOL      		wasdirty:1;	// Set if we were dirty on last draw
    BOOL      		raised:1;	// Set if we should raise this line
    BOOL      		wasraised:1;	// Set if it used to be raised
    BOOL      		hascursor:1;	// Set if this line has the cursor
    BOOL      		fixedwidth:1;	// Set if cursor is to be fixedwidth
    BOOL		tmpflatten:1;	// Set if flattened during scroll
    void _ChangeY(int y);
public:
    Cvo_TextLine(Cvo_CRT *_Win, int _width);
    ~Cvo_TextLine();
    void Append(wchar_t *str, int len = -1);
    void Append(wchar_t *str, Cvo_TextAttribute **attrs, int len = -1);
    void Insert(int x, wchar_t *str = 0, int len = -1);
    void Replace(int x, wchar_t *str, int len = -1);
    void Insert(int x, int len = -1)	{ Insert(x, 0, len); }
    void Delete(int x, int len = -1);
    void ResetLineheight();
    void Clear();
    int GetText(wchar_t **, int = 0, int = -1);
    int CursorX()			{ return(hascursor ? cursorx : -1); }
    int Y()				{ return(ly); }
    int NextY()				{ return(ly+LineHeight()); }
    int PixelIndex(int where);
    int PixelLength();
    int Draw(int x, int wid);
    void ReDraw();
    int Extra(int wid, wchar_t **pstr = 0, Cvo_TextAttribute ***pstate = 0);
    BOOL ChangeY(int y, int r)		{ myrow = r;
					  return ((ly != y) ?
					    (_ChangeY(y), True) : False); }
    void MakeDirty()			{ dirty = 1; }
    BOOL IsDirty()			{ return(dirty); }
    BOOL WasDirty()			{ return(wasdirty); }
    void SetCursor(unsigned x, BOOL f)	{ hascursor = True; cursorx = x;
					  dirty = True; fixedwidth = f; }
    Cvo_TextAttribute *SetState(Cvo_TextAttribute *s)
			{ Cvo_TextAttribute *os = currentstate;
			  currentstate = s;
			  if (currentstate->Font()->Ascent() > ascent)
			      ascent = currentstate->Font()->Ascent();
			  if (currentstate->Font()->Descent() > descent)
			      descent = currentstate->Font()->Descent();
			  return(os); }
    void UnsetCursor()			{ hascursor = False; dirty = True; }
    void MakeRaised();
    void MakeFlat();
    int Raised()			{ return(raised ? rr : 0); }
    int LineHeight()			{ return(ascent+descent); }

    int TmpFlatten()			{ tmpflatten = raised; raised = 0;
					  if (dirty |= tmpflatten)
					      Draw(lx, lw);
					  return(tmpflatten); }
    void TmpUnflatten()			{ if (tmpflatten) {
					    raised = dirty = 1;
					    tmpflatten = 0;
					    Draw(lx, lw);
					  }
					}
    void BeginWord(int &);
    void EndWord(int &);
};
#endif
