//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	TextPage.h++,v 1.1.1.1 1996/08/21 08:27:13 prb Exp
//
#if	!defined(_Cvo_TextPage_)
#define	_Cvo_TextPage_

#if	!defined(_Cvo_Page_)
#include <Cvo/Page.h++>
#endif
#if	!defined(_Cvo_TextAttribute_)
#include <Cvo/TextAttribute.h++>
#endif

class Cvo_TextPageLine {
    static wchar_t	nullstring[1];
protected:

    void		*data;
    wchar_t		*text;
    Cvo_TextAttribute	**attrs;
    CARD		length;
    BOOL		multiple:1;	// True if multiple attributes;
    BOOL		modified:1;
public:
    Cvo_TextPageLine()	{ data = 0; text = 0; attrs = 0; multiple = False; length = 0; modified = False; }
    ~Cvo_TextPageLine()	{ delete [] text; if (multiple) delete [] attrs; }
    void Clear();
    void Zap();
    Cvo_TextAttribute *Attribute(CARD x)
			{ return(multiple ? (x < length ? attrs[x] : 0)
					  : (Cvo_TextAttribute *)attrs); }
    Cvo_TextAttribute *Attribute()
			{ return(multiple ? 0 : (Cvo_TextAttribute *)attrs); }
    Cvo_TextAttribute **Attributes()	{ return(multiple ? attrs : 0); }
    BOOL Multiple()	{ return(multiple); }
    BOOL Modified()	{ return(modified); }
    void ClearModified()	{ modified = False; }
    int Length()	{ return(length); }
    wchar_t *Text()	{ return(text ? text : nullstring); }
    void SetText(wchar_t *, int, Cvo_TextAttribute *);
    void AppendText(wchar_t *, int, Cvo_TextAttribute *);

    void InsertAt(int, int = 1, Cvo_TextAttribute * = 0);
    void DeleteAt(int, int = 1);
    void ReplaceAt(int, wchar_t *, int = -1);

    void SetAttribute(Cvo_TextAttribute *, CARD, CARD);
    void SetAttribute(Cvo_TextAttribute *);

    void SetAssociatedData(void *d)     { data = d; }
    void *AssociatedData()              { return(data); }

    int operator < (Cvo_TextPageLine &);
    int operator > (Cvo_TextPageLine &);
    int operator == (Cvo_TextPageLine &);
};

class Cvo_TextPage : public Cvo_Page {
protected:
    Cvo_CharacterBuffer	charbuf;
    Cvo_TextPageLine	*lines;
    Cvo_TextAttribute	*attr;		// Current Attribute;
    int			start;
    int			maxlines;
    int			absolutemax;
    int			nlines;
    virtual int AppendLine(wchar_t *, int);
    virtual int InsertLine(wchar_t *, int);
    BOOL output : 1;
    BOOL newlines : 1;
    BOOL changedlines : 1;
    BOOL removedlines : 1;

    void SendPageEvent();
    Cvo_TextPageLine &Line(int i)	{ i += start;
					  return(lines[i % maxlines]); }
public:
    Cvo_TextPage();
    ~Cvo_TextPage();
    int NumberLines()			{ return(nlines); }
    void *GetLine(CARD);
    void *GetLine(CARD, Cvo_CharacterBuffer *);
    void Draw(CARD, const XRectangle &clip, int x = 0, int y = 0);
    CARD Height(CARD);
    CARD Width(CARD);
    void *GetAssociatedData(CARD);
    void SetAssociatedData(CARD, void *);

    Cvo_TextAttribute *GetAttribute(CARD i)
			{ return( i < nlines ? Line(i).Attribute() : 0); }
    Cvo_TextAttribute **GetAttributes(CARD i)
			{ return( i < nlines ? Line(i).Attributes() : 0); }
    int Length(CARD i)	{ return( i < nlines ? Line(i).Length() : 0); }

    void ClearLines(int inform = 1);
    void DeleteEntry(int index = -1, int inform = 1);
    void AddEntry(int index, int inform = 1);

    void SetAbsoluteMax(int x)		{ if (x >= 0) absolutemax = x; }

    int InsertText(wchar_t *, void *, int inform = 1);
    int InsertText(char *, void *, int inform = 1);

    int AppendText(wchar_t *, void *, int inform = 1);
    int AppendText(char *, void *, int inform = 1);

    int InsertText(wchar_t *s, int inform = 1)
	{ return(InsertText(s, 0, inform)); }
    int InsertText(char *s, int inform = 1)
	{ return(InsertText(s, 0, inform)); }

    int AppendText(wchar_t *s, int inform = 1)
	{ return(AppendText(s, 0, inform)); }
    int AppendText(char *s, int inform = 1)
	{ return(AppendText(s, 0, inform)); }

    void ReplaceLine(wchar_t *, int line, int inform = 1);
    void ReplaceLine(char *, int line, int inform = 1);

    void AppendToLine(char *, int line, int inform = 1);
    void AppendToLine(wchar_t *, int line, int inform = 1);

    void InsertAt(int line, int col, int len = 1, int inform = 1);
    void DeleteAt(int line, int col, int len = 1, int inform = 1);
    void ReplaceAt(int line, int col, wchar_t *, int len = -1, int inform = 1);

    Cvo_TextAttribute *SetAttribute(Cvo_TextAttribute *a)
				    { Cvo_TextAttribute *oa = attr;
				      attr = a;
				      return(oa); }
    void SetAttributes(CARD i, CARD f, CARD t, Cvo_TextAttribute *);
    void SetAttributes(CARD i, Cvo_TextAttribute *);

    void Notify();
    void DisableDisplay()		{ output = 0; 		}
    void EnableDisplay()		{ output = 1; Notify();	}

    BOOL Modified(CARD i)		{ return(Line(i).Modified()); }
};

inline void
Cvo_TextPageLine::Clear()
{
    data = 0;
    delete [] text;
    text = 0;
    length = 0;
    multiple = False;
    if (multiple)
        delete [] attrs;
    attrs = 0;
}

inline void
Cvo_TextPageLine::Zap()
{
    data = 0;
    text = 0;
    attrs = 0;
    length = 0;
    multiple = False;
}

#endif
