//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	_Machine.h++,v 1.1.1.1 1996/08/21 08:27:06 prb Exp
//

#if	!defined(__MACHINE_H__)
//
// We use sys/time.h to determine if we are on Solaris or not.
// There is no harm including this for every module since every
// module basically ends up with it anyhow.
//
#if	defined(__hpux)
#define	select	__bad_select
#endif

#include <sys/time.h>

#if	defined(select)
#undef	select
#endif

//
// First figure out varients.  This is really only needed for Sun.
//
#if	defined(sun) && !defined(__STDC__) && !defined(__OLD_SUN_CC__)
#define	__OLD_SUN_CC__
#endif

#if defined(sun) && defined(sparc) && defined(NANOSEC) && !defined(_Solaris_)
#define _Solaris_
#endif

//
// Now go through and define the machine specific flags
//
// Note that _xfree_t should be what you must typecast the
// value passed to XFree().  It can be defined to nothing, which
// is the normal case for X11R5
//
// EvVolatile should be defined to either nothing or volatile
//

#if	defined(sun)
#define	__NEED_MALLOC__

#define	__HAVE_VHANGUP__
#define	EvVolatile

#if	defined(_Solaris_)
#define	__NEED_GETTIMEOFDAY_DEF__
#define	__NEED_GETHOSTNAME_DEF__

#define	__SYSV_GETTIMEOFDAY__
#define	__SIGNAL_RETURN_INT__
#define	__USE_SYSINFO__
#define	__USE_STREAMS__

#define	_xfree_t	(unsigned char *)
#else
typedef int sig_atomic_t;
#define	__NEED_SYSENT__
extern "C" void *memmove(void *, const void *, size_t);
#if defined(X11R4)
#define	_xfree_t	(char *)
#endif
#endif

//
// Sun doesn't define the strerror function, so we make it available here
// for those who need it...
// 
extern "C" char *strerror(int);

#if     defined(sparc) && defined(__GNUC__) && !defined(__svr4__)
#define	__NEED_SELECT_DEF__
#define	__NEED_GETHOSTNAME_DEF__
#define	__NEED_CASECMP_DEFS__
#define	__NEED_BZERO_DEF__
#define	__NEED_IOCTL_DEF__
#define	__NEED_PUTENV_DEF__
#define	__NEED_GETTIMEOFDAY_DEF__

#define	__SIGNAL_RETURN_UNKNOWN__

extern "C" void vhangup(void);
#endif
#endif

#if	defined(__GNUC__)
#define	__DONT_TYPECAST_ZERO__
#define	__BROKEN_CHAR__
#endif

#if	defined(__rs6000__)
#define	__NEED_CASECMP_DEFS__
#define	__NEED_GETHOSTNAME_DEF__
#define	__SIGNAL_RETURN_INT__

#define	__NEED_SELECT__

#define	__BROKEN_EXECVP__
#define	__BROKEN_CHAR__

#define	EvVolatile
#define	_xfree_t	(char *)
#endif

#if	defined(__alpha)
#define	__NEED_BZERO_DEF__
#define	__NEED_GETDTABLESIZE_DEF__
#define	__NEED_GETHOSTNAME_DEF__
#define	__NEED_IOCTL_DEF__
#define	__NEED_SELECT_DEF__

#define	__NEED_STRINGS__

#define	__NO_XDEFAULTS__
#define	__REF_POINTER_BUG__
#define __SIGNAL_RETURN_INT__

#define	EvVolatile
#endif

#if	defined(__hpux)
#define	__NEED_SELECT_DEF__
#define	__NO_XDEFAULTS__
#define	__SIGNAL_RETURN_INT__
#define	EvVolatile
#endif

#if	defined(sgi)
#define	__NEED_BSTRING__
#define	__NEED_SYSENT__
#define	__NEED_OSFCN__

#define	__NO_GETDTABLESIZE__
#define	__DONT_TYPECAST_ZERO__
#define	__IRIX_IS_BRAINDEAD__

#define	_xfree_t	(char *)

#define	EvVolatile
#endif

#if	defined(cray)
#define	EvVolatile
#define __SIGNAL_RETURN_INT__
#endif

#if	defined(__bsdi__)
#define	__SIGNAL_RETURN_INT__
#define	__NEED_SYS_IOCTL__
#endif

#if    defined(__FreeBSD__)
#define __SIGNAL_RETURN_INT__
#define __NEED_SELECT_DEF__
#define __NEED_SYS_IOCTL__
#endif

#if	defined(__linux__)
#define __SIGNAL_RETURN_INT__
#endif

#if	defined(__GNUC__) && !defined(EvVolatile)
#define	EvVolatile
#endif

#if	!defined(EvVolatile)
#define	EvVolatile	volatile
#endif

#if	!defined(_xfree_t)
#if	defined(X11R4)
#define	_xfree_t	(unsigned char *)
#else
#define	_xfree_t	
#endif
#endif

#if	defined(__NEED_CASECMP_DEFS__)
extern "C" int strcasecmp(char *, char *);
extern "C" int strncasecmp(char *, char *, size_t);
#endif

#if	(!defined(__NO_XDEFAULTS__) && (XlibSpecificationRelease > 5))
#define	__NO_XDEFAULTS__
#endif

#endif
