# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI Comment.pm,v 1.2 1996/08/05 16:53:21 sanders Exp
#
# Object-Oriented HTML

package HTML::Markup::Comment;

BEGIN {
    require DataType::Linkable;
    @ISA = qw(DataType::Linkable);
}

# =============================================================================
# Methods

# Called by Create and Clone to initialize the new object.
sub Initialize {
    my $self = shift;
    $self->DataType::Linkable::Initialize;
    $self->append(@_) if scalar(@_);
    $self;
}

# $dest_object->Copy(I<source_object>)
# Copy the contents of I<$source_object> into I<$dest_object>.
sub Copy {
    my $self = shift;
    my $from = shift;
    $self->{'children'} = [ $from->all_children ];
    $self;
}

sub realize {
    my $self = shift;
    join('', "<--\n", $self->all_children, "\n-->\n");
}

1;
