# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI Element.pm,v 1.3 1996/08/07 22:05:55 sanders Exp
#
# Object-Oriented HTML

package HTML::Markup::Element;

BEGIN {
    require DataType::Linkable;
    @ISA = qw(DataType::Linkable);
}

# =============================================================================
# Methods

sub Initialize {
    my $self = shift;
    $self->{'element'} = shift || 'HTML';       # tag rendering
    $self->{'minimized'} = 0;                   # is this tag minimized?
    $self->{'attributes'} = [ ];                # object attributes
    $self->DataType::Linkable::Initialize(@_);
    $self;
}

sub Copy {
    my $self = shift;
    my $from = shift;
    $self->{'element'} = $from->{'element'};
    $self->{'minimized'} = $from->{'minimized'};
    $self->{'attributes'} = [ @{$from->{'attributes'}} ];
    $self->DataType::Linkable::Copy($from);
    $self;
}

sub element {
    my $self = shift;
    my $otag = $self->{'element'};
    $self->{'element'} = shift if scalar(@_);
    $otag;
}

sub attributes {
    my $self = shift;
    $self->{'attributes'};
}

sub attribute {
    my ($self, $attr, @value) = @_;
    $attr =~ y/a-z/A-Z/;
    push(@{$self->{'attributes'}}, $attr . '="' . join(' ', @value) . '"');
    $self;
}

sub string_attributes {
    my ($self, $string) = @_;
    push(@{$self->{'attributes'}}, $string) if defined $string;
    $self;
}

sub minimized {
    my $self = shift;
    $self->{'minimized'} = defined $_[0] ? $_[0] : 1;
    $self;
}

sub realize {
    my $self = shift;
    my $child;
    my @rendering;

    # tag and attributes
    push(@rendering, '<' . $self->element .
        join(' ', '', @{$self->{'attributes'}}) . ">\n");

    # children
    $self->first;

    # that's it for minimized elements unless they have some content
    return @rendering if ! defined $self->child && $self->{'minimized'};

    while ($child = $self->child) {
	push(@rendering, $child->realize);
	$self->next;
    }

    # end tag
    push(@rendering, join('', "</", $self->element, ">\n"));

    @rendering;
}

1;
