# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI Eval.pm,v 1.1 1996/04/17 20:47:04 sanders Exp
#
# Object-Oriented HTML

package HTML::Markup::Eval;
use Carp;

BEGIN {
    require DataType::Linkable;
    @ISA = qw(DataType::Linkable);
}

# =============================================================================
# Methods

sub Initialize {
    my $self = shift;
    $self->DataType::Linkable::Initialize;
    $self->append(@_);
    $self;
}

sub Copy {
    my $self = shift;
    my $from = shift;
    $self->{'children'} = [ $from->all_children ];
    $self;
}

sub realize {
    my $self = shift;
    my ($child, $realized);

    $self->first;
    while ($child = $self->child) {
	$realized .= eval $child;
	croak "$child\n$@" if $@;
	$self->next;
    }
    $realized;
}

1;
