# HTML::Markup::HTML2 -- w/dynamic tags and attributes via AUTOLOAD
# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
#
package HTML::Markup::HTML2;

BEGIN {
    require HTML::Markup::Element;
    @ISA = qw(HTML::Markup::Element);

    # Tags that should be minimized
    %minimize = (
	'AREA' => 1,
	'BASE' => 1,
	'BASEFONT' => 1,
	'BGSOUND' => 1,
	'BR' => 1,
	'HR' => 1,
	'IMG' => 1,
	'INPUT' => 1,
	'ISINDEX' => 1,
	'LINK' => 1,
	'META' => 1,
	'NEXTID' => 1,
	'RANGE' => 1,
	'ROOT' => 1,
	'SPOT' => 1,
	'TAB' => 1,
	'TABSTOP' => 1,
	'WBR' => 1,
    );
}

BEGIN { require HTML::Markup::Eval; }
sub Eval {
    my $self = shift; my $child;
    $self->append($child = Create HTML::Markup::Eval @_);
    $child;
}

BEGIN { require HTML::Markup::Comment; }
sub Comment {
    my $self = shift; my $child;
    $self->append($child = Create HTML::Markup::Comment @_);
    $child;
}

BEGIN { require HTML::Markup::Literal; }
sub Literal {
    my $self = shift; my $child;
    $self->append($child = Create HTML::Markup::Literal @_);
    $child;
}

BEGIN { require HTML::Markup::Text; }
sub Text {
    my $self = shift; my $child;
    $self->append($child = Create HTML::Markup::Text @_);
    $child;
}

# prevent calling AUTOLOAD for DESTROY
sub DESTROY {
    1;
}

sub AUTOLOAD {
    my $self = shift;
    my ($idhash, $id) = @_;	# optional args
    $AUTOLOAD =~ m/::([^:]+)$/;
    my $name = uc $1;

    if ($name eq $1) {
	### Element
	my $child = Create HTML::Markup::HTML2 ($name);
	$self->append($child);
	$child->minimized if exists $minimize{$name};
	# store objects by name in the given hash
	$idhash->{$id} = $child if defined $idhash && defined $id;
	return $child;
    }
    else {
	### Attribute
	$self->attribute($name, @_);
	return $self;
    }
}

1;
