# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI Literal.pm,v 1.1 1996/04/17 20:47:07 sanders Exp
#
# Object-Oriented HTML

package HTML::Markup::Literal;
use HTML::Markup::Entities;

BEGIN {
    require DataType::Linkable;
    @ISA = qw(DataType::Linkable);
}

# =============================================================================
# Methods

sub Initialize {
    my $self = shift;
    $self->DataType::Linkable::Initialize;
    $self->append(@_);
    $self;
}

sub realize {
    my $self = shift;
    join('', $self->all_children, "\n");
}

sub entity {
    my $self = shift;
    $self->append(@_);
}

1;
