# Copyright (c) 1995, 1996 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#       BSDI Text.pm,v 1.2 1996/08/06 23:21:37 sanders Exp
#
# Object-Oriented HTML

package HTML::Markup::Text;
use HTML::Markup::Entities;

BEGIN {
    require DataType::Linkable;
    @ISA = qw(DataType::Linkable);
}

# =============================================================================
# Methods

sub Initialize {
    my $self = shift;
    $self->DataType::Linkable::Initialize;
    $self->append(@_);
    $self;
}

sub Copy {
    my $self = shift;
    my $from = shift;
    $self->{'children'} = [ $from->all_children ];
    $self;
}

sub realize {
    my $self = shift;
    join('', $self->all_children, "\n");
}

sub entity {
    my $self = shift;
    $self->DataType::Linkable::append(@_);
}

sub append {
    my $self = shift;
    $self->DataType::Linkable::append(_escape(@_));
}

sub prefix {
    my $self = shift;
    $self->DataType::Linkable::prefix(_escape(@_));
}

sub before {
    my $self = shift;
    $self->DataType::Linkable::before(_escape(@_));
}

sub after {
    my $self = shift;
    $self->DataType::Linkable::after(_escape(@_));
}

sub replace {
    my $self = shift;
    $self->DataType::Linkable::replace(_escape(@_));
}


# =============================================================================
# Private Methods

sub _escape {
    my @args = @_;
    map { s/\&/\&amp\;/g; s/\</\&lt\;/g; s/\>/\&gt\;/g } @args;
    @args;
}

1;
