# NOTE: Derived from blib/lib/Net/Gen.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::Gen;

#line 2037 "blib/lib/Net/Gen.pm (autosplit into blib/lib/auto/Net/Gen/_findxopt.al)"
# socket-option routines

sub _findxopt			# $self, $realp, @args ;
{				# returns ($aref,@subargs)
    my($self,$realp,@args) = @_;
    my($aref,$level,$what);
    $level = shift @args;	# try input arg as level first
    if ($level =~ /^(0x[\da-f]+|0[0-7]*|[1-9]\d*)$/si) {
	# if numeric, it had better be the level
	$level = ((substr($level, 0, 1) eq '0') ? oct($level) : $level+0);
    }
    $aref = $$self{Sockopts}{$level};
    if (!$aref) {
	# here, we have to search for the ruddy thing by keyword
	# if level was numeric, punt by trying to force EINVAL
	until ($level =~ /\D/) {
	    # numeric level, check for realp and numeric what
	    last unless $realp;
	    $what = shift @args;
	    last unless $what =~ /^(0x[\da-f]+|0[0-7]*|[1-9]\d*)$/si;
	    $what = ((substr($what, 0, 1) eq '0') ? oct($what) : $what+0);
	    $aref = ['h*', $what, $level, 0+@args];
	    unshift(@args, $aref);
	    return @args;
	}
	return getsockopt($$self{fhref},-1,-1) unless $level =~ /\D/;
	$what = $level;
	foreach $level (keys %{$$self{Sockopts}}) {
	    next unless ref($$self{Sockopts}{$level}) eq 'HASH';
	    last if $aref = $$self{Sockopts}{$level}{$what};
	}
	$$self{Sockopts}{$what} = $aref if ref $aref eq 'ARRAY';
    }
    elsif (ref $aref eq 'HASH') {
	$what = shift @args;
	if ($what =~ /^(0x[\da-f]+|0[0-7]*|[1-9]\d*)$/si) {
	    $what = ((substr($what, 0, 1) eq '0') ? oct($what) : $what+0);
	}
	$aref = $$aref{$what};
    }
    # force EINVAL (I hope) if unrecognized value
    return getsockopt($$self{fhref},-1,-1) unless ref $aref eq 'ARRAY';
    ($aref,@args);
}

# end of Net::Gen::_findxopt
1;
