# NOTE: Derived from ../blib/lib/Tk/Scale.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Tk::Scale;

#line 43 "../blib/lib/Tk/Scale.pm (autosplit into ../blib/lib/auto/Tk/Scale/ClassInit.al)"
#
# Bind --
# This procedure below invoked the first time the mouse enters a
# scale widget or a scale widget receives the input focus. It creates
# all of the class bindings for scales.
#
# Arguments:
# event - Indicates which event caused the procedure to be invoked
# (Enter or FocusIn). It is used so that we can carry out
# the functions of that event in addition to setting up
# bindings.
sub ClassInit
{
 my ($class,$mw) = @_;
 $mw->bind($class,"<Enter>",
	     sub
	     {
	      my $w = shift;
	      my $Ev = $w->XEvent;
	      if ($Tk::strictMotif)
	       {
		$Tk::activeBg = $w->cget("-activebackground");
		$w->configure("-activebackground",$w->cget("-background"))
	       }
	      Activate($w,$Ev->x,$Ev->y)
	     }
	    )
 ;
 $mw->bind($class,"<Motion>",['Activate',Ev('x'),Ev('y')]);
 $mw->bind($class,"<Leave>",
	     sub
	     {
	      my $w = shift;
	      my $Ev = $w->XEvent;
	      if ($Tk::strictMotif)
	       {
		$w->configure("-activebackground",$Tk::activeBg)
	       }
	      if ($w->cget("-state") eq "active")
	       {
		$w->configure("-state","normal")
	       }
	     }
	    )
 ;
 $mw->bind($class,"<1>",['ButtonDown',Ev('x'),Ev('y')]);
 $mw->bind($class,"<B1-Motion>",['Drag',Ev('x'),Ev('y')]);
 $mw->bind($class,"<B1-Leave>",'NoOp');
 $mw->bind($class,"<B1-Enter>",'NoOp');
 $mw->bind($class,"<ButtonRelease-1>",
	     sub
	     {
	      my $w = shift;
	      my $Ev = $w->XEvent;
	      $w->CancelRepeat();
	      EndDrag($w);
	      Activate($w,$Ev->x,$Ev->y)
	     }
	    )
 ;
 $mw->bind($class,"<2>",['ButtonDown',Ev('x'),Ev('y')]);
 $mw->bind($class,"<B2-Motion>",['Drag',Ev('x'),Ev('y')]);
 $mw->bind($class,"<B2-Leave>",'NoOp');
 $mw->bind($class,"<B2-Enter>",'NoOp');
 $mw->bind($class,"<ButtonRelease-2>",
	     sub
	     {
	      my $w = shift;
	      my $Ev = $w->XEvent;
	      $w->CancelRepeat();
	      EndDrag($w);
	      Activate($w,$Ev->x,$Ev->y)
	     }
	    )
 ;
 $mw->bind($class,"<Control-1>",['ControlPress',Ev('x'),Ev('y')]);
 $mw->bind($class,"<Up>",['Increment',"up","little","noRepeat"]);
 $mw->bind($class,"<Down>",['Increment',"down","little","noRepeat"]);
 $mw->bind($class,"<Left>",['Increment',"up","little","noRepeat"]);
 $mw->bind($class,"<Right>",['Increment',"down","little","noRepeat"]);
 $mw->bind($class,"<Control-Up>",['Increment',"up","big","noRepeat"]);
 $mw->bind($class,"<Control-Down>",['Increment',"down","big","noRepeat"]);
 $mw->bind($class,"<Control-Left>",['Increment',"up","big","noRepeat"]);
 $mw->bind($class,"<Control-Right>",['Increment',"down","big","noRepeat"]);
 $mw->bind($class,"<Home>",["set",Ev("cget","-from")]);
 $mw->bind($class,"<End>",["set",Ev("cget","-to")]);
 return $class;
}

# end of Tk::Scale::ClassInit
1;
