require '_h2ph_pre.ph';

unless(defined(&_MPS_APIC_H)) {
    eval 'sub _MPS_APIC_H () {1;}' unless defined(&_MPS_APIC_H);
    unless(defined(&LOCORE)) {
	eval 'sub ia_select () { ($u->{io_register}->{ir_select});}' unless defined(&ia_select);
	eval 'sub ia_window () { ($u->{io_register}->{ir_window});}' unless defined(&ia_window);
	eval 'sub APIC_IO_UNIT_ID () {0x00;}' unless defined(&APIC_IO_UNIT_ID);
	eval 'sub APIC_IO_VERSION () {0x01;}' unless defined(&APIC_IO_VERSION);
	eval 'sub APIC_IO_ARB () {0x02;}' unless defined(&APIC_IO_ARB);
	eval 'sub APIC_IO_REDIR_LOW {
	    local($int_pin) = @_;
    	    eval q((0x10+($int_pin)*2));
	}' unless defined(&APIC_IO_REDIR_LOW);
	eval 'sub APIC_IO_REDIR_HIGH {
	    local($int_pin) = @_;
    	    eval q((0x11+($int_pin)*2));
	}' unless defined(&APIC_IO_REDIR_HIGH);
	eval 'sub APIC_IO_ID_SHFT () {24;}' unless defined(&APIC_IO_ID_SHFT);
	eval 'sub APIC_IO_ID_MASK () {0xf;}' unless defined(&APIC_IO_ID_MASK);
	eval 'sub APIC_IO_VER_MASK () {0xff;}' unless defined(&APIC_IO_VER_MASK);
	eval 'sub APIC_IO_MRE_MASK () {0xff;}' unless defined(&APIC_IO_MRE_MASK);
	eval 'sub APIC_IO_MRE_SHFT () {16;}' unless defined(&APIC_IO_MRE_SHFT);
    }
    eval 'sub APIC_REG_ID () {0x20;}' unless defined(&APIC_REG_ID);
    eval 'sub APIC_REG_VER () {0x30;}' unless defined(&APIC_REG_VER);
    eval 'sub APIC_REG_TPR () {0x80;}' unless defined(&APIC_REG_TPR);
    eval 'sub APIC_REG_APR () {0x90;}' unless defined(&APIC_REG_APR);
    eval 'sub APIC_REG_PPR () {0xa0;}' unless defined(&APIC_REG_PPR);
    eval 'sub APIC_REG_EOI () {0xb0;}' unless defined(&APIC_REG_EOI);
    eval 'sub APIC_REG_RRR () {0xc0;}' unless defined(&APIC_REG_RRR);
    eval 'sub APIC_REG_LDR () {0xd0;}' unless defined(&APIC_REG_LDR);
    eval 'sub APIC_REG_DFR () {0xe0;}' unless defined(&APIC_REG_DFR);
    eval 'sub APIC_REG_SIVR () {0xf0;}' unless defined(&APIC_REG_SIVR);
    eval 'sub APIC_REG_ISR () {0x100;}' unless defined(&APIC_REG_ISR);
    eval 'sub APIC_REG_TMR () {0x180;}' unless defined(&APIC_REG_TMR);
    eval 'sub APIC_REG_IRR () {0x200;}' unless defined(&APIC_REG_IRR);
    eval 'sub APIC_REG_ERR () {0x280;}' unless defined(&APIC_REG_ERR);
    eval 'sub APIC_REG_ICRL () {0x300;}' unless defined(&APIC_REG_ICRL);
    eval 'sub APIC_REG_ICRH () {0x310;}' unless defined(&APIC_REG_ICRH);
    eval 'sub APIC_REG_LVT_T () {0x320;}' unless defined(&APIC_REG_LVT_T);
    eval 'sub APIC_REG_LVT_P () {0x340;}' unless defined(&APIC_REG_LVT_P);
    eval 'sub APIC_REG_LVT_0 () {0x350;}' unless defined(&APIC_REG_LVT_0);
    eval 'sub APIC_REG_LVT_1 () {0x360;}' unless defined(&APIC_REG_LVT_1);
    eval 'sub APIC_REG_LVT_E () {0x370;}' unless defined(&APIC_REG_LVT_E);
    eval 'sub APIC_REG_ICNT () {0x380;}' unless defined(&APIC_REG_ICNT);
    eval 'sub APIC_REG_CCNT () {0x390;}' unless defined(&APIC_REG_CCNT);
    eval 'sub APIC_REG_TDIV () {0x3e0;}' unless defined(&APIC_REG_TDIV);
    eval 'sub IMCR_ADDR () {0x22;}' unless defined(&IMCR_ADDR);
    eval 'sub IMCR_DATA () {0x23;}' unless defined(&IMCR_DATA);
    eval 'sub IMCR_REGSEL () {0x70;}' unless defined(&IMCR_REGSEL);
    eval 'sub IMCR_APIC_OFF () {0x00;}' unless defined(&IMCR_APIC_OFF);
    eval 'sub IMCR_APIC_ON () {0x01;}' unless defined(&IMCR_APIC_ON);
    eval 'sub APIC_ID_SHFT () {24;}' unless defined(&APIC_ID_SHFT);
    eval 'sub APIC_ID_MASK () {0xf;}' unless defined(&APIC_ID_MASK);
    eval 'sub APIC_VC_MASK () {0x000000ff;}' unless defined(&APIC_VC_MASK);
    eval 'sub APIC_DL_FIXED () {0x00000000;}' unless defined(&APIC_DL_FIXED);
    eval 'sub APIC_DL_LOWPR () {0x00000100;}' unless defined(&APIC_DL_LOWPR);
    eval 'sub APIC_DL_SMI () {0x00000200;}' unless defined(&APIC_DL_SMI);
    eval 'sub APIC_DL_RR () {0x00000300;}' unless defined(&APIC_DL_RR);
    eval 'sub APIC_DL_NMI () {0x00000400;}' unless defined(&APIC_DL_NMI);
    eval 'sub APIC_DL_INIT () {0x00000500;}' unless defined(&APIC_DL_INIT);
    eval 'sub APIC_DL_START () {0x00000600;}' unless defined(&APIC_DL_START);
    eval 'sub APIC_DL_EXTINT () {0x00000700;}' unless defined(&APIC_DL_EXTINT);
    eval 'sub APIC_DL_MASK () {0x00000700;}' unless defined(&APIC_DL_MASK);
    eval 'sub APIC_DM_PHYS () {0x00000000;}' unless defined(&APIC_DM_PHYS);
    eval 'sub APIC_DM_LOGI () {0x00000800;}' unless defined(&APIC_DM_LOGI);
    eval 'sub APIC_DS_IDLE () {0x00000000;}' unless defined(&APIC_DS_IDLE);
    eval 'sub APIC_DS_BUSY () {0x00001000;}' unless defined(&APIC_DS_BUSY);
    eval 'sub APIC_PL_HIGH () {0x00000000 *  &Input  &polarity  &active  &high */;}' unless defined(&APIC_PL_HIGH);
    eval 'sub APIC_PL_LOW () {0x00002000;}' unless defined(&APIC_PL_LOW);
    eval 'sub APIC_RIRR () {0x00004000;}' unless defined(&APIC_RIRR);
    eval 'sub APIC_LV_MASK () {0x00004000;}' unless defined(&APIC_LV_MASK);
    eval 'sub APIC_TM_EDGE () {0x00000000;}' unless defined(&APIC_TM_EDGE);
    eval 'sub APIC_TM_LEVEL () {0x00008000;}' unless defined(&APIC_TM_LEVEL);
    eval 'sub APIC_MS_ENABLE () {0x00000000;}' unless defined(&APIC_MS_ENABLE);
    eval 'sub APIC_MS_DISABLE () {0x00010000;}' unless defined(&APIC_MS_DISABLE);
    eval 'sub APIC_DH_DSTF () {0x00000000;}' unless defined(&APIC_DH_DSTF);
    eval 'sub APIC_DH_SELF () {0x00040000;}' unless defined(&APIC_DH_SELF);
    eval 'sub APIC_DH_ALLS () {0x00080000;}' unless defined(&APIC_DH_ALLS);
    eval 'sub APIC_DH_ALLE () {0x000c0000;}' unless defined(&APIC_DH_ALLE);
    eval 'sub APIC_DH_MASK () {0x000c0000;}' unless defined(&APIC_DH_MASK);
    eval 'sub APIC_DF_MASK () {0xff000000;}' unless defined(&APIC_DF_MASK);
    eval 'sub APIC_DF_SHFT () {24;}' unless defined(&APIC_DF_SHFT);
    eval 'sub APIC_DF_BCAST () {0x0f000000;}' unless defined(&APIC_DF_BCAST);
    eval 'sub APIC_SV_MASK () {0x000000f0;}' unless defined(&APIC_SV_MASK);
    eval 'sub APIC_SV_ENABLE () {0x00000100;}' unless defined(&APIC_SV_ENABLE);
    eval 'sub APIC_ESR_SCS () {0x00000001;}' unless defined(&APIC_ESR_SCS);
    eval 'sub APIC_ESR_RCS () {0x00000002;}' unless defined(&APIC_ESR_RCS);
    eval 'sub APIC_ESR_SAE () {0x00000004;}' unless defined(&APIC_ESR_SAE);
    eval 'sub APIC_ESR_RAE () {0x00000008;}' unless defined(&APIC_ESR_RAE);
    eval 'sub APIC_ESR_SIV () {0x00000020;}' unless defined(&APIC_ESR_SIV);
    eval 'sub APIC_ESR_RIV () {0x00000040;}' unless defined(&APIC_ESR_RIV);
    eval 'sub APIC_ESR_IRS () {0x00000080;}' unless defined(&APIC_ESR_IRS);
    eval 'sub ICR_VEC_MASK () {0x000000ff;}' unless defined(&ICR_VEC_MASK);
    eval 'sub ICR_DM_FIXED () {0x00000000;}' unless defined(&ICR_DM_FIXED);
    eval 'sub ICR_DM_LOWPR () {0x00000100;}' unless defined(&ICR_DM_LOWPR);
    eval 'sub ICR_DM_SMI () {0x00000200;}' unless defined(&ICR_DM_SMI);
    eval 'sub ICR_DM_RR () {0x00000300;}' unless defined(&ICR_DM_RR);
    eval 'sub ICR_DM_NMI () {0x00000400;}' unless defined(&ICR_DM_NMI);
    eval 'sub ICR_DM_INIT () {0x00000500;}' unless defined(&ICR_DM_INIT);
    eval 'sub ICR_DM_START () {0x00000600;}' unless defined(&ICR_DM_START);
    eval 'sub ICR_DM_MASK () {0x00000700;}' unless defined(&ICR_DM_MASK);
    eval 'sub ICR_DEST_LOGICAL () {0x00000800;}' unless defined(&ICR_DEST_LOGICAL);
    eval 'sub ICR_BUSY () {0x00001000;}' unless defined(&ICR_BUSY);
    eval 'sub ICR_LEVEL_ASSERT () {0x00004000;}' unless defined(&ICR_LEVEL_ASSERT);
    eval 'sub ICR_TRIG_MODE () {0x00008000;}' unless defined(&ICR_TRIG_MODE);
    eval 'sub ICR_RRS_INVALID () {0x00000000;}' unless defined(&ICR_RRS_INVALID);
    eval 'sub ICR_RRS_IN_PROG () {0x00010000;}' unless defined(&ICR_RRS_IN_PROG);
    eval 'sub ICR_RRS_VALID () {0x00020000;}' unless defined(&ICR_RRS_VALID);
    eval 'sub ICR_RRS_MASK () {0x00030000;}' unless defined(&ICR_RRS_MASK);
    eval 'sub ICR_DH_MASK () {0x000c0000;}' unless defined(&ICR_DH_MASK);
    eval 'sub ICR_DH_DEST () {0x00000000;}' unless defined(&ICR_DH_DEST);
    eval 'sub ICR_DH_SELF () {0x00040000;}' unless defined(&ICR_DH_SELF);
    eval 'sub ICR_DH_ALLS () {0x00080000;}' unless defined(&ICR_DH_ALLS);
    eval 'sub ICR_DH_ALLE () {0x000c0000;}' unless defined(&ICR_DH_ALLE);
    eval 'sub ICRH_DST_SHFT () {24;}' unless defined(&ICRH_DST_SHFT);
    eval 'sub ICRH_DST_MASK () {0xf0000000;}' unless defined(&ICRH_DST_MASK);
    if(defined(&KERNEL)) {
	unless(defined(&LOCORE)) {
	    require 'sys/systm.ph';
	    eval 'sub APIC_ICR_REG () { ($apic->{la_int_command[0]}->{r});}' unless defined(&APIC_ICR_REG);
	    eval 'sub i386_apic_waitbusy () {
	        eval q( &do { \'int\'  &__cnt;  &if ( &APIC_ICR_REG &  &ICR_BUSY) {  &CTR0( &KTR_SMP,  &apic_busy);  &__cnt = 1000000;  &while (-- &__cnt) {  &if (( &APIC_ICR_REG &  &ICR_BUSY) == 0)  &break;  &DELAY(1); }  &if ( &__cnt <= 0)  &panic( &waitbusy_panic); } }  &while (0));
	    }' unless defined(&i386_apic_waitbusy);
	    eval 'sub i386_ipi {
	        local($t, $i) = @_;
    		eval q( &_i386_ipi($t, $i, \\"send ipi->%x icr=%x \\"  &__WHERE__));
	    }' unless defined(&i386_ipi);
	    eval 'sub i386_ipi_short {
	        local($i) = @_;
    		eval q( &_i386_ipi_short($i, \\"send short ipi icr=%x \\"  &__WHERE__));
	    }' unless defined(&i386_ipi_short);
	    eval 'sub _i386_ipi {
	        local($targ, $icr, $trace) = @_;
    		eval q( &do {  &CTR2( &KTR_SMP, $trace, $targ, $icr);  &i386_apic_waitbusy();  ($apic->{la_int_command[1]}->{r}) = ($targ) <<  &ICRH_DST_SHFT;  &APIC_ICR_REG = ($icr); }  &while (0));
	    }' unless defined(&_i386_ipi);
	    eval 'sub _i386_ipi_short {
	        local($icr, $trace) = @_;
    		eval q( &do {  &CTR1( &KTR_SMP, $trace, $icr);  &i386_apic_waitbusy();  &APIC_ICR_REG = ($icr); }  &while (0));
	    }' unless defined(&_i386_ipi_short);
	    eval 'sub i386_apic_rdreg {
	        local($id, $i, $val) = @_;
    		eval q(({ \'int\'  &__cnt; \'int\'  &__rv = 0; \'int\' * &__val = ($val);  &CTR2( &KTR_SMP,  &apic_rdreg_tr, $id, $i);  &i386_apic_waitbusy();  &_i386_ipi($id,  &ICR_DM_RR |  &ICR_LEVEL_ASSERT | ($i),  &apic_rripi);  &__cnt = 1000000;  &while (-- &__cnt  && ( &APIC_ICR_REG &  &ICR_RRS_MASK) ==  &ICR_RRS_IN_PROG)  &delay(1);  &if (( &APIC_ICR_REG &  &ICR_RRS_MASK) ==  &ICR_RRS_VALID) {  &if ( &__val !=  &NULL) * &__val =  ($apic->{la_remote}->{r});  &__rv = 1; }  &__rv; }));
	    }' unless defined(&i386_apic_rdreg);
	}
    }
    eval 'sub APIC_LOCAL_PA () {0xfee00000;}' unless defined(&APIC_LOCAL_PA);
    eval 'sub APIC_IO_PA () {0xfec00000;}' unless defined(&APIC_IO_PA);
    eval 'sub TPR_KERNEL () {0x10;}' unless defined(&TPR_KERNEL);
    eval 'sub TPR_IDLE () {0x12;}' unless defined(&TPR_IDLE);
    eval 'sub TPR_USER () {0x14;}' unless defined(&TPR_USER);
}
1;
